﻿/*  This is mada by Kent    
 *  This source is made by Funms Team
 *  功能：BOSS 乌鲁斯
 *  @Author Kent 
 */

//自定义复活次数
var reviveCount = 5;
function init() {
    em.setProperty("state", "0");
    em.setProperty("leader", "true");
}

function setup(level, leaderid) {
    em.setProperty("state", "1");
    em.setProperty("leader", "true");
    em.setProperty("summon", "0");
    var eim = em.newInstance("UrusBOSS");
    eim.setProperty("knightsummon", "0");
    eim.setProperty("mapEffect", "0");
    var map1 = eim.setInstanceMap(970072000);
    //eim.setInstanceMap(271040210);//退出
    eim.setInstanceMap(970072100);
    var map2 = eim.setInstanceMap(970072400);
    map1.resetFully();
    map2.resetFully();
    map1.killAllMonsters(false);
    map2.killAllMonsters(false);
    eim.startEventTimer(3600000); // 1 hr
    return eim;
}

function playerEntry(eim, player) {
    var map = eim.getMapInstance(0);
    player.setReviveCount(reviveCount);
    player.changeMap(map, map.getPortal(0));
}

function playerRevive(eim, player) {
    if (player.getReviveCount() > 0) {
        player.addHP(50);
        var map = eim.getMapFactoryMap(970072000);
        player.eventRevive();
        player.changeMap(map, map.getPortal(0));
        return true;
    }
    player.addHP(50);
    var map = eim.getMapFactoryMap(970072000);
    player.changeMap(map, map.getPortal(0));
    return true;
}

function scheduledTimeout(eim) {
    eim.disposeIfPlayerBelow(100, 970072200);
    em.setProperty("state", "0");
    em.setProperty("leader", "true");
}

function changedMap(eim, player, mapid) {
    var mob;
    switch (mapid) {
        case 970072000:
        {
            if (em.getProperty("state").equals("1") && em.getProperty("summon").equals("0")) {
                em.setProperty("summon", "1");
                mob = em.getMonster(8881000);
                //mob.getStats().setChange(true);
                mob.changeLevel(200);
                mob.getChangedStats().setOHp(2000000000000);
                mob.setHp(2000000000000);
                eim.registerMonster(mob);
                eim.getMapInstance(0).spawnMonsterOnGroundBelow(mob, new java.awt.Point(13, 85));
            }
            break;
        }
    }
    if (mapid != 970072000 && mapid != 970072100 && mapid != 970072400) {
        eim.unregisterPlayer(player);
        if (eim.disposeIfPlayerBelow(0, 0)) {
            em.setProperty("state", "0");
            em.setProperty("leader", "true");
        }
    }
}

function playerDisconnected(eim, player) {
    return 0;
}

function monsterValue(eim, mobId) {
    return 1;
}

function playerExit(eim, player) {
    eim.unregisterPlayer(player);
    player.restReviveCount();
    if (eim.disposeIfPlayerBelow(0, 0)) {
        em.setProperty("state", "0");
        em.setProperty("leader", "true");
    }
}
function allMonstersDead(eim) {
    var map =  eim.getMapInstance(0);
    em.broadcastYellowMsg("[剿灭乌鲁斯] - 已被击败乌鲁斯，勇士们解放了！");
    map.startMapEffect("[后勤部长]已被解放，请在10秒内点击NPC获得贡献点奖励。NPC在入场时乌鲁斯出现的地方", 5120092);
    eim.startEventTimer(1000 * 10); //10 min
    map.spawnNpc(2400006, new java.awt.Point(13, 85));
}

function end(eim){

    var map =  eim.getMapInstance(0);
    em.broadcastYellowMsg("[剿灭乌鲁斯] - 已被击败乌鲁斯，勇士们解放了！");
    map.startMapEffect("[后勤部长]已被解放，请在10秒内点击NPC获得贡献点奖励。NPC在入场时乌鲁斯出现的地方", 5120092);
    eim.startEventTimer(1000 * 10); //10 min
   // map.spawnNpc(2400006, new java.awt.Point(13, 85));
	
}

function clearPQ(eim) {
    end(eim);
}



function leftParty(eim, player) {
}
function disbandParty(eim) {
}
function playerDead(eim, player) {
}
function cancelSchedule() {
}
function pickUpItem(eim, player, itemID) {
}