﻿var mapIds = [450008150, 450008250, 450008350];

//自定义复活次数
var reviveCount = 5;
var random = new java.util.Random();

function init() {
    em.setProperty("state", "0");
    em.setProperty("state1", "0");
    em.setProperty("leader", "true");
}

function setup(level, leaderid) {
    em.setProperty("state", "1");
    var eim = em.newInstance("BossWeiEr_HARD");
    for (var i = 0; i < mapIds.length; i++) {
        var map = eim.setInstanceMap(mapIds[i]);
        map.resetPQ(level);
        map.resetFully();
        map.killAllMonsters(true);
    }
    //  eim.schedule("summonFall", 5000);
    eim.startEventTimer(60 * 1000 * 60);//60分钟
    startOnePart(eim);
    return eim;
}

function playerEntry(eim, player) {
    var map = eim.getMapInstance(0);
    player.setReviveCount(reviveCount);//地图复活次数
    player.changeMap(map, map.getPortal(0));
}

function playerRevive(eim, player) {
    if (player.getReviveCount() > 0) {
        var map = player.getMap();
        player.eventRevive();//扣除复活次数
        player.changeMap(map, map.getPortal(0));
        return true;
    }
    player.addHP(50);
    var map = eim.getMapFactoryMap(450007240);
    player.changeMap(map, map.getPortal(0));
    return true;
}

function scheduledTimeout(eim) {
    end(eim);
}

function changedMap(eim, player, mapid) {
    if (mapid != mapIds[0] && mapid != mapIds[1] && mapid != mapIds[2]) {
        eim.unregisterPlayer(player);
        if (eim.disposeIfPlayerBelow(0, 0)) {
            em.setProperty("state", "0");
            em.setProperty("state1", "0");
            em.setProperty("leader", "true");
        }
    }
}

function playerDisconnected(eim, player) {
    return 0;
}

function monsterValue(eim, mobId) {
    return 1;
}

function playerExit(eim, player) {
    eim.unregisterPlayer(player);
    if (eim.disposeIfPlayerBelow(0, 0)) {
        em.setProperty("state", "0");
        em.setProperty("leader", "true");
    }
}


function allMonstersDead(eim) {


    var state = em.getProperty("state");
    switch (state) {
        case "1":
            var map2 = eim.getMapInstance(mapIds[1]);
            for (var i = 0; i < eim.getPlayerCount(); i++) {
                eim.getPlayers().get(i).changeMap(map2, map2.getPortal(0));
            }
            startTwoPart(eim);
            break;
        case "2":
            var map3 = eim.getMapInstance(mapIds[2]);
            for (var i = 0; i < eim.getPlayerCount(); i++) {
                eim.getPlayers().get(i).changeMap(map3, map3.getPortal(0));
            }
            startThreePart(eim);
            break;

    }

}

function showTopMapOne(eim) {//
    var state = em.getProperty("state");
    if (state == "1") {
        eim.showMapEventEffect(mapIds[0], 9, 1);
    }
}

function showTopMapOneB(eim) {//
    var state = em.getProperty("state");
    var time = 15000;
    if (state == "1") {
        eim.showMapEventEffect(mapIds[0], 10, 4);
        eim.schedule("showTopMapOneB", time);
    }
}

var eye = 0;

function showTopMapOneC(eim) {//
    var state = em.getProperty("state");
    var time = 20000;
    if (state == "1") {
        if (eye != 0) {
            eim.showMapEventEffect(mapIds[0], 12, 1);
        }
        eim.schedule("showTopMapOneC", time);
        eye++;
    }
}


function showTopMapTwoA(eim) {//
    var state = em.getProperty("state");
    if (state == "2") {
        eim.showMapEventEffect(mapIds[1], 9, 1);
    }
}

function showTopMapTwoB(eim) {//
    var state = em.getProperty("state");
    var time = 25000;
    if (state == "2") {
        if (eye != 0) {
            eim.showMapEventEffect(mapIds[1], 12, 1);
        }
        eim.schedule("showTopMapTwoB", time);
        eye++;
    }
}

function showTopMapTwoC(eim) {//
    var state = em.getProperty("state");
    if (state == "2") {
        var time = 20000;
        var count = random.nextInt(2) + 1;
        eim.showMapEventEffect(mapIds[1], 11, count);
        eim.schedule("showTopMapTwoC", time);
    }
}

function showTopMapTwoD(eim) {//
    var state = em.getProperty("state");
    var time = 20000;
    if (state == "2") {
        eim.showMapEventEffect(mapIds[1], 10, 4);
        eim.schedule("showTopMapTwoD", time);
    }
}


function showTopMapThreeA(eim) {//
    var state = em.getProperty("state");
    if (state == "3") {
        eim.showMapEventEffect(mapIds[2], 9, 1);
    }
}

function showTopMapThreeB(eim) {//
    var state = em.getProperty("state");
    var time = 15000;
    if (state == "3") {
        eim.showMapEventEffect(mapIds[2], 5, 8);
        eim.schedule("showTopMapThreeB", time);
    }
}

function leftParty(eim, player) {
}

function disbandParty(eim) {
}

function playerDead(eim, player) {
}

function cancelSchedule() {
}

function monsterDrop(eim, player, mob) {
}

function pickUpItem(eim, player, itemID) {
}


function startOnePart(eim) {
    var mapForMob = eim.getMapInstance(mapIds[0]);
    var mobid = 8880303;//威尔
    var mob = em.getMonster(mobid);
    var modified = em.newMonsterStats();
    modified.setOHp(2000000000000000);//200万亿
    modified.setOMp(mob.getMobMaxMp() * 2);
    mob.getStats().setPhysicalAttack(499999999);//物理伤害
    mob.getStats().setMagicAttack(499999999);//魔攻伤害
    mob.getStats().setAcc(500000);
    mob.getStats().setPDRate(50);
    mob.getStats().setMDRate(50);
    mob.getStats().setLevel(220);
    mob.setOverrideStats(modified);
    mob.disableSpawnRevives();
    eim.registerMonster(mob);
    mapForMob.spawnMonsterOnGroundBelow(mob, new java.awt.Point(30, 59));
    showTopMapOne(eim);
    showTopMapOneB(eim);
    eye = 0;
    showTopMapOneC(eim);
}

function startTwoPart(eim) {
    em.setProperty("state", "2");
    var mapForMob = eim.getMapInstance(mapIds[1]);
    var mobid = 8880301;//威尔2
    var mob = em.getMonster(mobid);
    var modified = em.newMonsterStats();
    modified.setOHp(1000000000000000);//1000万亿
    modified.setOMp(mob.getMobMaxMp() * 2);
    mob.getStats().setPhysicalAttack(499999999);//物理伤害
    mob.getStats().setMagicAttack(499999999);//魔攻伤害
    mob.getStats().setAcc(500000);
    mob.getStats().setPDRate(50);
    mob.getStats().setMDRate(50);
    mob.getStats().setLevel(220);
    mob.setOverrideStats(modified);
    mob.disableSpawnRevives();
    eim.registerMonster(mob);
    mapForMob.spawnMonsterOnGroundBelow(mob, new java.awt.Point(20, 85));
    eye = 0;
    showTopMapTwoA(eim);
    showTopMapTwoB(eim);
    showTopMapTwoC(eim);
    showTopMapTwoD(eim);
}

function startThreePart(eim) {
    em.setProperty("state", "3");
    var mapForMob = eim.getMapInstance(mapIds[2]);
    var mobid = 8880302;//
    var mob = em.getMonster(mobid);
    var modified = em.newMonsterStats();
    modified.setOHp(1000000000000000);//1000万亿1000000000000000
    modified.setOMp(mob.getMobMaxMp() * 2);
    mob.getStats().setPhysicalAttack(499999999);//物理伤害
    mob.getStats().setMagicAttack(499999999);//魔攻伤害
    mob.getStats().setAcc(500000);
    mob.getStats().setPDRate(50);
    mob.getStats().setMDRate(50);
    mob.getStats().setLevel(220);
    mob.setOverrideStats(modified);
    mob.disableSpawnRevives();
    eim.registerMonster(mob);
    mapForMob.spawnMonsterOnGroundBelow(mob, new java.awt.Point(100, 85));
    showTopMapThreeA(eim);
    showTopMapThreeB(eim);
}

