﻿/* 
 * 天狗
 */

function init() {
    em.setProperty("state", "0");
    em.setProperty("leader", "true");
}

function setup(eim, leaderid) {
    em.setProperty("state", "1");
    em.setProperty("leader", "true");
    var eim = em.newInstance("BossDog");
    var map = eim.setInstanceMap(209000012);
    map.resetFully();
    eim.getMapFactoryMap(209000012).killAllMonsters(false);
    var mob = em.getMonster(9400080);
    var modified = em.newMonsterStats();
    modified.setOHp(5000000000000);
    modified.setOMp(mob.getMobMaxMp() * 3000);
    mob.setOverrideStats(modified);
    eim.registerMonster(mob);
    map.spawnMonsterOnGroundBelow(mob, new java.awt.Point(-420, -27));
    var mob1 = em.getMonster(8880101);
    var modified1 = em.newMonsterStats();
    modified1.setOHp(mob.getMobMaxHp());
    modified1.setOMp(mob.getMobMaxMp() * 500);
    mob1.setOverrideStats(modified1);
    eim.registerMonster(mob1);
    map.spawnMonsterOnGroundBelow(mob1, new java.awt.Point(-121, 153));
    eim.startEventTimer(1000 * 60 * 60); // 30 min
    return eim;
}

function playerEntry(eim, player) {
    var map = eim.getMapInstance(0);
    player.changeMap(map, map.getPortal(0));
    map.startMapEffect("[阵营BOSS——天狗] 来吧！让我看看你的实力", 5120026);
}

function playerRevive(eim, player) {
    return false;
}

function changedMap(eim, player, mapid) {
    if (mapid != 209000012) {
        eim.unregisterPlayer(player);
        if (eim.disposeIfPlayerBelow(0, 0)) {
            em.setProperty("state", "0");
            em.setProperty("leader", "true");
        }
    }
}

function playerDisconnected(eim, player) {
    eim.disposeIfPlayerBelow(100, 910000000);
    em.setProperty("state", "0");
    em.setProperty("leader", "true");
    return 0;
}

function monsterValue(eim, mobId) {
    return 1;
}

function playerExit(eim, player) {
    eim.unregisterPlayer(player);
    if (eim.disposeIfPlayerBelow(0, 0)) {
        em.setProperty("state", "0");
        em.setProperty("leader", "true");
    }
}

function scheduledTimeout(eim) {
    eim.disposeIfPlayerBelow(100, 910000000);
    em.setProperty("state", "0");
    em.setProperty("leader", "true");
}

function clearPQ(eim) {
    scheduledTimeout(eim);
}


function allMonstersDead(eim) {
    eim.schedule("end", 1000 * 0);
}

function end(eim, player) {
    var mapId = 209000012
    var map = eim.setInstanceMap(mapId);
    em.broadcastYellowMsg("[剿灭天狗] - 已被击败天狗，勇士们解放了！");
    map.startMapEffect("[后勤部长]已被解放，请在10秒内点击NPC获得贡献点奖励。", 5120092);
    eim.startEventTimer(1000 * 10); //10 秒
    map.spawnNpc(2400006, new java.awt.Point(-437, -27));

}

function leftParty(eim, player) {
}

function disbandParty(eim) {
}

function playerDead(eim, player) {
}

function cancelSchedule() {
}

function monsterDrop(eim, player, mob) {
}

function pickUpItem(eim, player, itemID) {
}