/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import java.security.InvalidParameterException;
import java.util.regex.PatternSyntaxException;
import sun.security.action.GetPropertyAction;
import sun.security.util.Debug;

public final class SecurityProviderConstants {
    private static final Debug debug;
    public static final int DEF_DSA_KEY_SIZE;
    public static final int DEF_RSA_KEY_SIZE;
    public static final int DEF_DH_KEY_SIZE;
    public static final int DEF_EC_KEY_SIZE;
    private static final String KEY_LENGTH_PROP = "jdk.security.defaultKeySize";

    private SecurityProviderConstants() {
    }

    public static final int getDefDSASubprimeSize(int n) {
        if (n <= 1024) {
            return 160;
        }
        if (n == 2048) {
            return 224;
        }
        if (n == 3072) {
            return 256;
        }
        throw new InvalidParameterException("Invalid DSA Prime Size: " + n);
    }

    static {
        int n;
        int n2;
        int n3;
        int n4;
        block15: {
            debug = Debug.getInstance("jca", "ProviderConfig");
            String string = GetPropertyAction.privilegedGetProperty(KEY_LENGTH_PROP);
            n4 = 1024;
            n3 = 1024;
            n2 = 1024;
            n = 256;
            if (string != null) {
                try {
                    String[] stringArray;
                    for (String string2 : stringArray = string.split(",")) {
                        String[] stringArray2 = string2.split(":");
                        if (stringArray2.length != 2) {
                            if (debug == null) continue;
                            debug.println("Ignoring invalid pair in jdk.security.defaultKeySize property: " + string2);
                            continue;
                        }
                        String string3 = stringArray2[0].trim().toUpperCase();
                        int n5 = -1;
                        try {
                            n5 = Integer.parseInt(stringArray2[1].trim());
                        }
                        catch (NumberFormatException numberFormatException) {
                            if (debug == null) continue;
                            debug.println("Ignoring invalid value in jdk.security.defaultKeySize property: " + string2);
                            continue;
                        }
                        if (string3.equals("DSA")) {
                            n4 = n5;
                        } else if (string3.equals("RSA")) {
                            n3 = n5;
                        } else if (string3.equals("DH")) {
                            n2 = n5;
                        } else if (string3.equals("EC")) {
                            n = n5;
                        } else {
                            if (debug == null) continue;
                            debug.println("Ignoring unsupported algo in jdk.security.defaultKeySize property: " + string2);
                            continue;
                        }
                        if (debug == null) continue;
                        debug.println("Overriding default " + string3 + " keysize with value from " + KEY_LENGTH_PROP + " property: " + n5);
                    }
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    if (debug == null) break block15;
                    debug.println("Unexpected exception while parsing jdk.security.defaultKeySize property: " + patternSyntaxException);
                }
            }
        }
        DEF_DSA_KEY_SIZE = n4;
        DEF_RSA_KEY_SIZE = n3;
        DEF_DH_KEY_SIZE = n2;
        DEF_EC_KEY_SIZE = n;
    }
}

