#!/system/bin/sh
umask 002
set +e
set +x
MODDIR=${0%/*}
#------------------------------------------------------------------------
# CuprumTurbo Adjustment . Ver 1.6
# Author : Chenzyadb @ Coolapk,xda,gitee,github
# E-Mail : chenzyadb@qq.com
# Copyright (C) Chenzyadb All RIGHTS Reserved.
#------------------------------------------------------------------------
# [Necessary Binary Chmod]
chmod 7777 /system/bin/setlog
chmod 7777 /system/bin/cu
chmod 7777 /system/bin/set_hmp_cgroup
chmod 7777 /system/bin/set_eas_cgroup
function chwrite() {
 if [ -e $2 ] ; then
  chmod 0666 $2 2>/dev/null
  echo $1 > $2 2>/dev/null
  chmod 0444 $2 2>/dev/null
 fi
}
function write() {
 if [ -e $2 ] ; then
  chmod 0666 $2 2>/dev/null
  echo $1 > $2 2>/dev/null
 fi
}
# [Get Core_num ]
if [ -e /sys/devices/system/cpu/kernel_max ] ; then
 core_num=$(cat /sys/devices/system/cpu/kernel_max)
elif [ -d /sys/devices/system/cpu/cpu9/ ] ; then
 core_num="9"
elif [ -d /sys/devices/system/cpu/cpu7/ ] ; then
 core_num="7"
elif [ -d /sys/devices/system/cpu/cpu5/ ] ; then
 core_num="5"
elif [ -d /sys/devices/system/cpu/cpu3/ ] ; then
 core_num="3"
fi
# [First-Run Fix] 
echo "$(date) service.sh start" > "/data/Cuprum_Log.txt"
#Stop Thermal
su -c stop "perfd" 2>/dev/null
su -c stop "mpdecision" 2>/dev/null
su -c stop "perf-hal-1-0" 2>/dev/null
#Stop MTK Perfservices
SOC=$(getprop ro.board.platform)
case $SOC in "mt"*)
 setprop ro.mtk_perfservice_support 0
 if [ -e /proc/hps/enabled ] ; then
  chwrite 0 "/proc/hps/enabled"
 fi
 if [ -e /proc/ppm/enabled ] ; then
  write 0 "/proc/ppm/enabled"
 fi
esac
#Stop Qualcomm BCL
if [ -e /sys/devices/qcom,bcl.39/mode ] ; then
 chwrite "disabled" /sys/devices/qcom,bcl.39/mode
fi
#Stop MSM_BOOSTER
if [ -e /system/vendor/etc/perf/perfboostsconfig.xml ] ; then
 chmod 7777 /system/vendor/etc/perf/perfboostsconfig.xml
 rm -rf /system/vendor/etc/perf/perfboostsconfig.xml
 touch /system/vendor/etc/perf/perfboostsconfig.xml
 chmod 0000 /system/vendor/etc/perf/perfboostsconfig.xml
fi
#Bring Cores online
if [ $core_num = "9" ] ; then
 chwrite 1 /sys/devices/system/cpu/cpu0/online 
 chwrite 1 /sys/devices/system/cpu/cpu1/online 
 chwrite 1 /sys/devices/system/cpu/cpu2/online 
 chwrite 1 /sys/devices/system/cpu/cpu3/online 
 chwrite 1 /sys/devices/system/cpu/cpu4/online 
 chwrite 1 /sys/devices/system/cpu/cpu5/online 
 chwrite 1 /sys/devices/system/cpu/cpu6/online 
 chwrite 1 /sys/devices/system/cpu/cpu7/online 
 chwrite 1 /sys/devices/system/cpu/cpu8/online 
 chwrite 1 /sys/devices/system/cpu/cpu9/online 
elif [ $core_num = "7" ] ; then
 chwrite 1 /sys/devices/system/cpu/cpu0/online 
 chwrite 1 /sys/devices/system/cpu/cpu1/online 
 chwrite 1 /sys/devices/system/cpu/cpu2/online 
 chwrite 1 /sys/devices/system/cpu/cpu3/online 
 chwrite 1 /sys/devices/system/cpu/cpu4/online 
 chwrite 1 /sys/devices/system/cpu/cpu5/online 
 chwrite 1 /sys/devices/system/cpu/cpu6/online 
 chwrite 1 /sys/devices/system/cpu/cpu7/online 
elif [ $core_num = "5" ] ; then
 chwrite 1 /sys/devices/system/cpu/cpu0/online 
 chwrite 1 /sys/devices/system/cpu/cpu1/online  
 chwrite 1 /sys/devices/system/cpu/cpu2/online 
 chwrite 1 /sys/devices/system/cpu/cpu3/online 
 chwrite 1 /sys/devices/system/cpu/cpu4/online 
 chwrite 1 /sys/devices/system/cpu/cpu5/online 
elif [ $core_num = "3" ] ; then
 chwrite 1 /sys/devices/system/cpu/cpu0/online 
 chwrite 1 /sys/devices/system/cpu/cpu1/online 
 chwrite 1 /sys/devices/system/cpu/cpu2/online 
 chwrite 1 /sys/devices/system/cpu/cpu3/online 
fi
sleep 1 
# [Get Freq Information ] 
if [ -e /sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_max_freq ] ; then
 freq0=$(cat /sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_max_freq)
elif [ -e /sys/devices/system/cpu/cpu0/cpufreq/scaling_max_freq ] ; then
 freq0=$(cat /sys/devices/system/cpu/cpu0/cpufreq/scaling_max_freq)
fi
if [ -e /sys/devices/system/cpu/cpu1/cpufreq/cpuinfo_max_freq ] ; then
 freq1=$(cat /sys/devices/system/cpu/cpu1/cpufreq/cpuinfo_max_freq)
elif [ -e /sys/devices/system/cpu/cpu1/cpufreq/scaling_max_freq ] ; then
 freq1=$(cat /sys/devices/system/cpu/cpu1/cpufreq/scaling_max_freq)
fi
if [ -e /sys/devices/system/cpu/cpu2/cpufreq/cpuinfo_max_freq ] ; then
 freq2=$(cat /sys/devices/system/cpu/cpu2/cpufreq/cpuinfo_max_freq)
elif [ -e /sys/devices/system/cpu/cpu2/cpufreq/scaling_max_freq ] ; then
 freq2=$(cat /sys/devices/system/cpu/cpu2/cpufreq/scaling_max_freq)
fi
if [ -e /sys/devices/system/cpu/cpu3/cpufreq/cpuinfo_max_freq ] ; then
 freq3=$(cat /sys/devices/system/cpu/cpu3/cpufreq/cpuinfo_max_freq)
elif [ -e /sys/devices/system/cpu/cpu3/cpufreq/scaling_max_freq ] ; then
 freq3=$(cat /sys/devices/system/cpu/cpu3/cpufreq/scaling_max_freq)
fi
if [ -e /sys/devices/system/cpu/cpu4/cpufreq/cpuinfo_max_freq ] ; then
 freq4=$(cat /sys/devices/system/cpu/cpu4/cpufreq/cpuinfo_max_freq)
elif [ -e /sys/devices/system/cpu/cpu4/cpufreq/scaling_max_freq ] ; then
 freq4=$(cat /sys/devices/system/cpu/cpu4/cpufreq/scaling_max_freq)
fi
if [ -e /sys/devices/system/cpu/cpu5/cpufreq/cpuinfo_max_freq ] ; then
 freq5=$(cat /sys/devices/system/cpu/cpu5/cpufreq/cpuinfo_max_freq)
elif [ -e /sys/devices/system/cpu/cpu5/cpufreq/scaling_max_freq ] ; then
 freq5=$(cat /sys/devices/system/cpu/cpu5/cpufreq/scaling_max_freq)
fi
if [ -e /sys/devices/system/cpu/cpu6/cpufreq/cpuinfo_max_freq ] ; then
 freq6=$(cat /sys/devices/system/cpu/cpu6/cpufreq/cpuinfo_max_freq)
elif [ -e /sys/devices/system/cpu/cpu6/cpufreq/scaling_max_freq ] ; then
 freq6=$(cat /sys/devices/system/cpu/cpu6/cpufreq/scaling_max_freq)
fi
if [ -e /sys/devices/system/cpu/cpu7/cpufreq/cpuinfo_max_freq ] ; then
 freq7=$(cat /sys/devices/system/cpu/cpu7/cpufreq/cpuinfo_max_freq)
elif [ -e /sys/devices/system/cpu/cpu7/cpufreq/scaling_max_freq ] ; then
 freq7=$(cat /sys/devices/system/cpu/cpu7/cpufreq/scaling_max_freq)
fi
if [ -e /sys/devices/system/cpu/cpu8/cpufreq/cpuinfo_max_freq ] ; then
 freq8=$(cat /sys/devices/system/cpu/cpu8/cpufreq/cpuinfo_max_freq)
elif [ -e /sys/devices/system/cpu/cpu8/cpufreq/scaling_max_freq ] ; then
 freq8=$(cat /sys/devices/system/cpu/cpu8/cpufreq/scaling_max_freq)
fi
if [ -e /sys/devices/system/cpu/cpu9/cpufreq/cpuinfo_max_freq ] ; then 
 freq9=$(cat /sys/devices/system/cpu/cpu9/cpufreq/cpuinfo_max_freq)
elif [ -e /sys/devices/system/cpu/cpu9/cpufreq/scaling_max_freq ] ; then
 freq9=$(cat /sys/devices/system/cpu/cpu9/cpufreq/scaling_max_freq)
fi
if [ ! -d /data/Cuprum_Info/ ] ; then
 mkdir -p /data/Cuprum_Info/
fi
if [ $core_num = "9" ] ; then
 echo "$freq0" > /data/Cuprum_Info/cpu_freq0 
 echo "$freq1" > /data/Cuprum_Info/cpu_freq1 
 echo "$freq2" > /data/Cuprum_Info/cpu_freq2 
 echo "$freq3" > /data/Cuprum_Info/cpu_freq3 
 echo "$freq4" > /data/Cuprum_Info/cpu_freq4 
 echo "$freq5" > /data/Cuprum_Info/cpu_freq5 
 echo "$freq6" > /data/Cuprum_Info/cpu_freq6 
 echo "$freq7" > /data/Cuprum_Info/cpu_freq7 
 echo "$freq8" > /data/Cuprum_Info/cpu_freq8 
 echo "$freq9" > /data/Cuprum_Info/cpu_freq9 
elif [ $core_num = "7" ] ; then
 echo "$freq0" > /data/Cuprum_Info/cpu_freq0 
 echo "$freq1" > /data/Cuprum_Info/cpu_freq1 
 echo "$freq2" > /data/Cuprum_Info/cpu_freq2 
 echo "$freq3" > /data/Cuprum_Info/cpu_freq3 
 echo "$freq4" > /data/Cuprum_Info/cpu_freq4 
 echo "$freq5" > /data/Cuprum_Info/cpu_freq5 
 echo "$freq6" > /data/Cuprum_Info/cpu_freq6 
 echo "$freq7" > /data/Cuprum_Info/cpu_freq7 
elif [ $core_num = "5" ] ; then
 echo "$freq0" > /data/Cuprum_Info/cpu_freq0 
 echo "$freq1" > /data/Cuprum_Info/cpu_freq1 
 echo "$freq2" > /data/Cuprum_Info/cpu_freq2 
 echo "$freq3" > /data/Cuprum_Info/cpu_freq3 
 echo "$freq4" > /data/Cuprum_Info/cpu_freq4 
 echo "$freq5" > /data/Cuprum_Info/cpu_freq5 
elif [ $core_num = "3" ] ; then
 echo "$freq0" > /data/Cuprum_Info/cpu_freq0 
 echo "$freq1" > /data/Cuprum_Info/cpu_freq1 
 echo "$freq2" > /data/Cuprum_Info/cpu_freq2 
 echo "$freq3" > /data/Cuprum_Info/cpu_freq3 
fi
#I/O Performance Fix
if [ -e /sys/block/mmcblk0/queue/scheduler ] ; then
 IO_mode="deadline"
 MMC=$(ls -d /sys/block/mmc*)
 DM=$(ls -d /sys/block/dm-*)
 SD=$(ls -d /sys/block/sd*)
 LOOP=$(ls -d /sys/block/loop*)
 RAM=$(ls -d /sys/block/ram*)
 KB=512
 NR=128
 READ_EXPIRE=500
 WRITE_EXPIRE=5000
 for IO_DIR in $MMC $SD $DM $LOOP $RAM $ZR ; do
  chwrite "$IO_mode" $IO_DIR/queue/scheduler 
  chwrite "$NR" $IO_DIR/queue/nr_requests 
  chwrite "$NR" $IO_DIR/queue/read_ahead_kb  
  chwrite "2" $IO_DIR/queue/iosched/fifo_batch 
  chwrite "3" $IO_DIR/queue/iosched/writes_starved  
  chwrite "$READ_EXPIRE" $IO_DIR/queue/iosched/read_expire  
  chwrite "$WRITE_EXPIRE" $IO_DIR/queue/iosched/write_expire  
  chwrite "$READ_EXPIRE" $IO_DIR/queue/iosched/sync_read_expire  
  chwrite "$WRITE_EXPIRE" $IO_DIR/queue/iosched/sync_write_expire  
  chwrite "$READ_EXPIRE" $IO_DIR/queue/iosched/async_read_expire 
  chwrite "$WRITE_EXPIRE" $IO_DIR/queue/iosched/async_write_expire 
 done
 if [ "`ls /sys/devices/virtual/bdi/179*/read_ahead_kb`" ]; then
  for RDAH_DIR in /sys/devices/virtual/bdi/179*/read_ahead_kb ; do
   chwrite "$KB" $RDAH_DIR
  done
 fi
fi
#Disable Boosts
if [ -e /sys/kernel/fp_boost/enabled ] ; then
 chwrite "0" /sys/kernel/fp_boost/enabled 
fi
if [ -e /sys/module/cpu_boost/parameters/input_boost_enabled ] ; then
 chwrite "0" /sys/module/cpu_boost/parameters/input_boost_enabled
fi
if [ -e /sys/module/cpu_boost/parameters/sched_boost_on_input ] ; then
 chwrite "N" /sys/module/cpu_boost/parameters/sched_boost_on_input
fi
if [ -e "/sys/kernel/cpu_input_boost/enabled" ] ; then
 chwrite "0" /sys/kernel/cpu_input_boost/enabled
fi
if [ -e "/sys/module/msm_performance/parameters/touchboost" ] ; then
 chwrite "0" /sys/module/msm_performance/parameters/touchboost
fi
if [ -e /sys/power/pnpmgr/touch_boost ] ; then
 chwrite "0" /sys/power/pnpmgr/touch_boost
fi
if [ -e "/sys/module/cpu_boost/parameters/boost_ms" ] ; then
 chwrite "0" /sys/module/cpu_boost/parameters/boost_ms
fi
# [Start MainService]
setlog "service.sh: Get Device Information."
#初始化PerfMonitor
echo "0" > "/data/Cuprum_Info/run_bench"
echo "0" > "/data/Cuprum_Info/cpu_score"
chmod 7777 /data/CuprumTurbo_Lib/get_udclk_freq
su -c /data/CuprumTurbo_Lib/get_udclk_freq 2>/dev/null 
chmod 7777 /system/bin/busybox
chmod 7777 /data/CuprumTurbo_Lib/perf_monitor
su -c /data/CuprumTurbo_Lib/perf_monitor 2>/dev/null
su -c /data/CuprumTurbo_Lib/perf_monitor 2>/dev/null
setlog "service.sh: Start MainService."
echo "1" > /data/Cuprum_Info/cu_service_working
chmod 7777 /data/CuprumTurbo_Lib/cuprum_daemon.sh
su -c /data/CuprumTurbo_Lib/cuprum_daemon.sh 2>&1 > /dev/null &
chmod 7777 /data/CuprumTurbo_Lib/cuprum_serviced
su -c /data/CuprumTurbo_Lib/cuprum_serviced 2>&1 > /dev/null &
exit 0





