/*
 * Decompiled with CFR 0.152.
 */
package tools.packet;

import client.ISkill;
import client.MapleCharacter;
import client.MapleClient;
import client.SkillEntry;
import client.inventory.IItem;
import client.inventory.Item;
import client.inventory.MapleInventory;
import client.inventory.MapleInventoryType;
import constants.ServerConstants;
import database.DatabaseConnection;
import handling.MaplePacket;
import handling.SendPacketOpcode;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import server.CashItemFactory;
import server.CashItemInfo;
import server.CashShop;
import server.MTSStorage;
import tools.HexTool;
import tools.KoreanDateUtil;
import tools.Pair;
import tools.data.output.MaplePacketLittleEndianWriter;
import tools.packet.PacketHelper;

public class MTSCSPacket {
    private static final byte[] warpCS = HexTool.getByteArrayFromHexString("00 00 00 63 00 74 00 65 00 64 00 2F 00 32 00 00 00 00 00 02 00 11 00 AD 01 08 06 02 00 00 00 33 00 00 00 05 00 13 00 AF 00 08 06 A0 01 14 00 30 E1 7B 01 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 02 00 18 00 B2 01 08 06 02 00 00 00 33 00 00 00 08 00 1A 00 B4 00 0A 06 B8 01 14 00 A8 10 88 06 69 00 6C 00 6C 00 2F 00 39 00 30 00 30 00 31 00");
    private static final byte[] CHAR_INFO_MAGIC = new byte[]{-1, -55, -102, 59};

    /*
     * WARNING - void declaration
     */
    public static MaplePacket warpCS(MapleClient c) {
        void var7_24;
        MaplePacketLittleEndianWriter mplew = new MaplePacketLittleEndianWriter();
        MapleCharacter chr = c.getPlayer();
        if (ServerConstants.\u8c03\u8bd5\u8f93\u51fa\u5c01\u5305) {
            System.out.println("warpCS--------------------");
        }
        mplew.writeShort(SendPacketOpcode.CS_OPEN.getValue());
        mplew.writeLong(-1L);
        mplew.write(0);
        PacketHelper.addCharStats(mplew, chr);
        mplew.write(20);
        mplew.write(0);
        mplew.writeInt(chr.getMeso());
        mplew.writeInt(chr.getId());
        mplew.writeInt(0);
        mplew.writeInt(0);
        mplew.write(chr.getInventory(MapleInventoryType.EQUIP).getSlotLimit());
        mplew.write(chr.getInventory(MapleInventoryType.USE).getSlotLimit());
        mplew.write(chr.getInventory(MapleInventoryType.SETUP).getSlotLimit());
        mplew.write(chr.getInventory(MapleInventoryType.ETC).getSlotLimit());
        mplew.write(chr.getInventory(MapleInventoryType.CASH).getSlotLimit());
        mplew.writeLong(PacketHelper.getTime(System.currentTimeMillis()));
        MapleInventory iv = chr.getInventory(MapleInventoryType.EQUIPPED);
        Collection<IItem> equippedC = iv.list();
        ArrayList<Item> equipped = new ArrayList<Item>(equippedC.size());
        for (IItem iItem : equippedC) {
            equipped.add((Item)iItem);
        }
        Collections.sort(equipped);
        for (Item item : equipped) {
            if (item.getPosition() >= 0 || item.getPosition() <= -100) continue;
            PacketHelper.addItemInfo(mplew, item, false, false);
        }
        mplew.write(0);
        for (Item item : equipped) {
            if (item.getPosition() > -100 || item.getPosition() <= -1000) continue;
            PacketHelper.addItemInfo(mplew, item, false, false);
        }
        mplew.write(0);
        iv = chr.getInventory(MapleInventoryType.EQUIP);
        for (IItem iItem : iv.list()) {
            PacketHelper.addItemInfo(mplew, iItem, false, false);
        }
        mplew.write(0);
        iv = chr.getInventory(MapleInventoryType.USE);
        for (IItem iItem : iv.list()) {
            PacketHelper.addItemInfo(mplew, iItem, false, false);
        }
        mplew.write(0);
        iv = chr.getInventory(MapleInventoryType.SETUP);
        for (IItem iItem : iv.list()) {
            PacketHelper.addItemInfo(mplew, iItem, false, false);
        }
        mplew.write(0);
        iv = chr.getInventory(MapleInventoryType.ETC);
        for (IItem iItem : iv.list()) {
            PacketHelper.addItemInfo(mplew, iItem, false, false);
        }
        mplew.write(0);
        iv = chr.getInventory(MapleInventoryType.CASH);
        for (IItem iItem : iv.list()) {
            PacketHelper.addItemInfo(mplew, iItem, false, false);
        }
        mplew.write(0);
        Map<ISkill, SkillEntry> skills = chr.getSkills();
        mplew.writeShort(skills.size());
        for (Map.Entry<ISkill, SkillEntry> skill : skills.entrySet()) {
            mplew.writeInt(skill.getKey().getId());
            mplew.writeInt(skill.getValue().skillevel);
            if (!skill.getKey().isFourthJob()) continue;
            mplew.writeInt(skill.getValue().masterlevel);
        }
        mplew.writeShort(0);
        mplew.writeShort(3);
        mplew.writeInt(662990);
        mplew.write(HexTool.getByteArrayFromHexString("5A 5A 5A 5A 45 46 47 48 49 5A B0 1D 01 00 34 95 08 00 00 11 00 F0 03 00 4D CE 43 44 63 CA 01 08 04 00 05 05 49 70 FD C9 01 F1 03 00 07 0B 20 44 63 CA 01 09 04 00 E6 FA 4E 70 FD C9 01 F2 03 80 F7 05 23 44 63 CA 01 0A 04 00 F4 21 56 70 FD C9 01 F3 03 80 51 68 25 44 63 CA 01 0B 04 00 F0 C7 CB E1 00 CA 01 39 20 00 7D C1 6D C3 5A CA 01 F4 03 80 AB CA 27 44 63 CA 01 0C 04 00 DD 95 0A 44 63 CA 01 FC 03 80 6A FA 47 44 63 CA 01 B0 1D 80 28 6F 6F 80 63 CA 01 F5 03 00 9C C5 2A 44 63 CA 01 F6 03 00 F6 27 2D 44 63 CA 01 98 12 80 C4 5C 4A 44 63 CA 01 F7 03 80 40 85 32 44 63 CA 01"));
        mplew.writeLong(0L);
        boolean bl = false;
        while (var7_24 < 15) {
            mplew.write(CHAR_INFO_MAGIC);
            ++var7_24;
        }
        mplew.write(HexTool.getByteArrayFromHexString("00 00 00 00 00 00 00 00 00 00 00 00 00 00 00"));
        mplew.writeMapleAsciiString(chr.getClient().getAccountName());
        mplew.write(HexTool.getByteArrayFromHexString("46 00 00 00 07 A5 9B 00 08 A5 9B 00 09 A5 9B 00 0A A5 9B 00 0B A5 9B 00 0C A5 9B 00 0D A5 9B 00 0E A5 9B 00 0F A5 9B 00 10 A5 9B 00 11 A5 9B 00 12 A5 9B 00 13 A5 9B 00 14 A5 9B 00 15 A5 9B 00 16 A5 9B 00 17 A5 9B 00 18 A5 9B 00 19 A5 9B 00 1A A5 9B 00 1B A5 9B 00 1C A5 9B 00 1D A5 9B 00 1E A5 9B 00 1F A5 9B 00 20 A5 9B 00 21 A5 9B 00 22 A5 9B 00 23 A5 9B 00 24 A5 9B 00 25 A5 9B 00 26 A5 9B 00 27 A5 9B 00 28 A5 9B 00 29 A5 9B 00 2A A5 9B 00 2B A5 9B 00 2C A5 9B 00 2D A5 9B 00 2E A5 9B 00 2F A5 9B 00 30 A5 9B 00 31 A5 9B 00 32 A5 9B 00 33 A5 9B 00 34 A5 9B 00 35 A5 9B 00 36 A5 9B 00 37 A5 9B 00 38 A5 9B 00 39 A5 9B 00 3A A5 9B 00 3B A5 9B 00 3C A5 9B 00 3D A5 9B 00 3E A5 9B 00 3F A5 9B 00 40 A5 9B 00 41 A5 9B 00 42 A5 9B 00 43 A5 9B 00 44 A5 9B 00 45 A5 9B 00 46 A5 9B 00 47 A5 9B 00 48 A5 9B 00 49 A5 9B 00 4A A5 9B 00 4B A5 9B 00 4C A5 9B 00 56 0B AC 96 98 00 00 04 00 00 01 A5 97 98 00 00 08 00 00 02 FE 98 98 00 00 04 00 00 01 FF 99 98 00 00 04 00 00 01 27 9B 98 00 00 04 00 00 01 49 9B 98 00 00 04 00 00 01 95 9B 98 00 00 08 00 00 02 9D 9B 98 00 00 08 00 00 02 9F 9B 98 00 04 00 00 00 DC 05 00 00 FC 9B 98 00 00 08 00 00 02 15 9C 98 00 00 08 00 00 02 17 9C 98 00 00 08 00 00 03 18 9C 98 00 00 08 00 00 03 19 9C 98 00 00 08 00 00 03 1A 9C 98 00 00 08 00 00 03 1B 9C 98 00 00 08 00 00 02 5B 9C 98 00 00 04 00 00 01 97 9C 98 00 00 04 00 00 01 BC 9C 98 00 00 04 00 00 01 C6 9C 98 00 00 08 00 00 02 C7 9C 98 00 00 08 00 00 02 C8 9C 98 00 00 0C 00 00 01 02 CC 9C 98 00 00 08 00 00 00 CD 9C 98 00 00 08 00 00 00 CE 9C 98 00 10 0C 00 00 62 01 02 CF 9C 98 00 00 04 00 00 01 D3 9C 98 00 10 00 00 00 62 DB 9C 98 00 00 08 00 00 02 F0 9C 98 00 00 04 00 00 01 F8 9C 98 00 00 08 00 00 00 07 9D 98 00 02 08 00 00 01 00 00 08 9D 98 00 02 08 00 00 01 00 00 0A 9D 98 00 00 0C 00 00 01 02 0C 9D 98 00 00 08 00 00 00 1A 9D 98 00 00 08 00 00 00 20 9D 98 00 00 08 00 00 00 26 9D 98 00 00 04 00 00 01 29 9D 98 00 00 04 00 00 01 2D 9D 98 00 00 04 00 00 01 2E 9D 98 00 00 08 00 00 00 2F 9D 98 00 00 08 00 00 00 30 9D 98 00 00 08 00 00 00 31 9D 98 00 00 08 00 00 00 32 9D 98 00 00 08 00 00 00 33 9D 98 00 00 08 00 00 00 34 9D 98 00 00 08 00 00 00 35 9D 98 00 00 08 00 00 00 37 9D 98 00 00 08 00 00 00 3E 9D 98 00 00 08 00 00 00 49 9D 98 00 00 0C 00 00 01 02 4A 9D 98 00 00 08 00 00 00 4B 9D 98 00 00 08 00 00 00 4C 9D 98 00 00 04 00 00 01 52 9D 98 00 04 08 00 00 E0 01 00 00 00 53 9D 98 00 04 0C 00 00 C0 03 00 00 01 01 54 9D 98 00 04 08 00 00 C0 12 00 00 00 55 9D 98 00 00 04 00 00 01 56 9D 98 00 00 08 00 00 00 57 9D 98 00 00 08 00 00 00 59 9D 98 00 00 08 00 00 00 5A 9D 98 00 00 08 00 00 00 5C 9D 98 00 00 08 00 00 00 5D 9D 98 00 00 08 00 00 00 5E 9D 98 00 00 04 00 00 01 5F 9D 98 00 00 08 00 00 00 60 9D 98 00 00 08 00 00 00 64 9D 98 00 00 08 00 00 00 65 9D 98 00 00 08 00 00 00 67 9D 98 00 00 08 00 00 03 68 9D 98 00 00 08 00 00 03 69 9D 98 00 00 08 00 00 03 6D 9D 98 00 10 0C 00 00 61 01 02 73 9D 98 00 00 08 00 00 00 77 9D 98 00 00 0C 00 00 01 02 7A 9D 98 00 00 08 00 00 00 7B 9D 98 00 00 08 00 00 00 7E 9D 98 00 00 08 00 00 00 80 9D 98 00 10 0C 00 00 63 01 02 82 9D 98 00 00 08 00 00 00 83 9D 98 00 00 04 00 00 01 85 9D 98 00 10 0C 00 00 63 01 02 86 9D 98 00 00 04 00 00 01 88 9D 98 00 00 08 00 00 00 89 9D 98 00 00 08 00 00 00 8A 9D 98 00 00 08 00 00 00 8B 9D 98 00 00 08 00 00 02 8C 9D 98 00 00 08 00 00 02 8D 9D 98 00 00 08 00 00 02 8E 9D 98 00 10 04 00 00 62 01 90 9D 98 00 10 00 00 00 62 91 9D 98 00 10 00 00 00 62 92 9D 98 00 00 08 00 00 00 93 9D 98 00 10 00 00 00 62 94 9D 98 00 10 00 00 00 62 95 9D 98 00 10 08 00 00 63 00 96 9D 98 00 00 08 00 00 02 97 9D 98 00 10 04 00 00 62 01 98 9D 98 00 10 00 00 00 62 99 9D 98 00 10 04 00 00 62 01 9A 9D 98 00 00 04 00 00 01 9B 9D 98 00 10 08 00 00 63 00 9C 9D 98 00 00 08 00 00 02 9D 9D 98 00 00 0C 00 00 01 02 9E 9D 98 00 00 08 00 00 02 9F 9D 98 00 10 08 00 00 63 00 A0 9D 98 00 10 04 00 00 62 01 A1 9D 98 00 10 00 00 00 62 A2 9D 98 00 10 08 00 00 63 00 A3 9D 98 00 10 04 00 00 62 01 A4 9D 98 00 10 08 00 00 62 02 A5 9D 98 00 10 00 00 00 62 A6 9D 98 00 10 00 00 00 62 A7 9D 98 00 10 00 00 00 62 A8 9D 98 00 10 04 00 00 62 01 A9 9D 98 00 00 08 00 00 00 AA 9D 98 00 10 08 00 00 62 02 AB 9D 98 00 00 08 00 00 00 AC 9D 98 00 10 04 00 00 62 01 AD 9D 98 00 00 08 00 00 00 AE 9D 98 00 00 08 00 00 02 AF 9D 98 00 10 08 00 00 63 00 B0 9D 98 00 10 08 00 00 62 02 B1 9D 98 00 10 08 00 00 63 00 B2 9D 98 00 10 0C 00 00 63 01 02 C4 9D 98 00 00 0C 00 00 01 00 C9 9D 98 00 00 0C 00 00 01 00 CD 9D 98 00 00 0C 00 00 01 00 D1 9D 98 00 00 0C 00 00 01 00 6D 1D 9A 00 00 04 00 00 01 B4 1D 9A 00 00 08 00 00 03 28 1E 9A 00 00 04 00 00 01 5F 1E 9A 00 00 04 00 00 01 95 1E 9A 00 00 04 00 00 01 99 1E 9A 00 00 04 00 00 01 BF 1E 9A 00 00 04 00 00 01 C0 1E 9A 00 00 04 00 00 01 C1 1E 9A 00 00 04 00 00 01 48 1F 9A 00 00 04 00 00 01 49 1F 9A 00 00 04 00 00 01 50 1F 9A 00 00 04 00 00 01 66 1F 9A 00 00 04 00 00 01 6A 1F 9A 00 00 04 00 00 01 83 1F 9A 00 00 04 00 00 01 96 1F 9A 00 00 04 00 00 01 99 1F 9A 00 00 04 00 00 01 9A 1F 9A 00 00 04 00 00 01 9B 1F 9A 00 00 04 00 00 01 9C 1F 9A 00 00 04 00 00 01 9D 1F 9A 00 00 04 00 00 01 9E 1F 9A 00 00 04 00 00 01 9F 1F 9A 00 00 04 00 00 01 A0 1F 9A 00 00 04 00 00 01 A1 1F 9A 00 00 04 00 00 01 A2 1F 9A 00 00 04 00 00 01 A3 1F 9A 00 00 04 00 00 01 A4 1F 9A 00 00 04 00 00 01 A5 1F 9A 00 00 04 00 00 01 A6 1F 9A 00 00 04 00 00 01 A7 1F 9A 00 00 04 00 00 01 A8 1F 9A 00 00 04 00 00 01 A9 1F 9A 00 00 04 00 00 01 AA 1F 9A 00 00 04 00 00 01 AB 1F 9A 00 00 04 00 00 01 C0 A3 9B 00 00 08 00 00 04 C1 A3 9B 00 00 08 00 00 04 C2 A3 9B 00 00 08 00 00 04 C3 A3 9B 00 00 08 00 00 04 C4 A3 9B 00 00 08 00 00 04 C5 A3 9B 00 00 08 00 00 04 C6 A3 9B 00 00 08 00 00 04 C7 A3 9B 00 00 08 00 00 04 C8 A3 9B 00 00 08 00 00 04 C9 A3 9B 00 00 08 00 00 04 CA A3 9B 00 00 08 00 00 04 CB A3 9B 00 00 08 00 00 04 CC A3 9B 00 00 08 00 00 04 CD A3 9B 00 00 08 00 00 04 CE A3 9B 00 00 08 00 00 04 CF A3 9B 00 00 08 00 00 04 D0 A3 9B 00 00 08 00 00 04 D1 A3 9B 00 00 08 00 00 04 D2 A3 9B 00 00 08 00 00 04 D3 A3 9B 00 00 08 00 00 04 D4 A3 9B 00 00 08 00 00 04 D5 A3 9B 00 00 08 00 00 04 D6 A3 9B 00 00 08 00 00 04 D7 A3 9B 00 00 08 00 00 04 D8 A3 9B 00 00 08 00 00 04 D9 A3 9B 00 00 08 00 00 04 DA A3 9B 00 00 08 00 00 04 DB A3 9B 00 00 08 00 00 04 DC A3 9B 00 00 08 00 00 04 DD A3 9B 00 00 08 00 00 04 DE A3 9B 00 00 08 00 00 04 DF A3 9B 00 00 08 00 00 04 E0 A3 9B 00 00 08 00 00 04 E1 A3 9B 00 00 08 00 00 04 E2 A3 9B 00 00 08 00 00 04 E3 A3 9B 00 00 08 00 00 04 E4 A3 9B 00 00 08 00 00 04 E5 A3 9B 00 00 08 00 00 04 E6 A3 9B 00 00 08 00 00 04 E7 A3 9B 00 00 08 00 00 04 E8 A3 9B 00 00 08 00 00 04 E9 A3 9B 00 00 08 00 00 04 EA A3 9B 00 00 08 00 00 04 EB A3 9B 00 00 08 00 00 04 EC A3 9B 00 00 08 00 00 04 ED A3 9B 00 00 08 00 00 04 EE A3 9B 00 00 08 00 00 04 EF A3 9B 00 00 08 00 00 04 F0 A3 9B 00 00 08 00 00 04 F1 A3 9B 00 00 08 00 00 04 F2 A3 9B 00 00 08 00 00 04 F3 A3 9B 00 00 08 00 00 04 F4 A3 9B 00 00 08 00 00 04 F5 A3 9B 00 00 08 00 00 04 F6 A3 9B 00 00 08 00 00 04 F7 A3 9B 00 00 08 00 00 04 F8 A3 9B 00 00 08 00 00 04 F9 A3 9B 00 00 08 00 00 04 FA A3 9B 00 00 08 00 00 04 FB A3 9B 00 00 08 00 00 04 FC A3 9B 00 00 08 00 00 04 FD A3 9B 00 00 08 00 00 04 FE A3 9B 00 00 08 00 00 04 FF A3 9B 00 00 08 00 00 04 00 A4 9B 00 00 08 00 00 04 01 A4 9B 00 00 08 00 00 04 02 A4 9B 00 00 08 00 00 04 03 A4 9B 00 00 08 00 00 04 04 A4 9B 00 00 08 00 00 04 05 A4 9B 00 00 08 00 00 04 06 A4 9B 00 00 08 00 00 04 07 A4 9B 00 00 08 00 00 04 08 A4 9B 00 00 08 00 00 04 09 A4 9B 00 00 08 00 00 04 0A A4 9B 00 00 08 00 00 04 0B A4 9B 00 00 08 00 00 04 0C A4 9B 00 00 08 00 00 04 0D A4 9B 00 00 08 00 00 04 0E A4 9B 00 00 08 00 00 04 0F A4 9B 00 00 08 00 00 04 10 A4 9B 00 00 08 00 00 04 11 A4 9B 00 00 08 00 00 04 12 A4 9B 00 00 08 00 00 04 13 A4 9B 00 00 08 00 00 04 14 A4 9B 00 00 08 00 00 04 15 A4 9B 00 00 08 00 00 04 16 A4 9B 00 00 08 00 00 04 17 A4 9B 00 00 08 00 00 04 18 A4 9B 00 00 08 00 00 04 19 A4 9B 00 00 08 00 00 04 1A A4 9B 00 00 08 00 00 04 1B A4 9B 00 00 08 00 00 04 1C A4 9B 00 00 08 00 00 04 1D A4 9B 00 00 08 00 00 04 1E A4 9B 00 00 08 00 00 04 1F A4 9B 00 00 08 00 00 04 20 A4 9B 00 00 08 00 00 04 21 A4 9B 00 00 08 00 00 04 22 A4 9B 00 00 08 00 00 04 23 A4 9B 00 00 08 00 00 04 24 A4 9B 00 00 08 00 00 04 25 A4 9B 00 00 08 00 00 04 26 A4 9B 00 00 08 00 00 04 27 A4 9B 00 00 08 00 00 04 28 A4 9B 00 00 08 00 00 04 29 A4 9B 00 00 08 00 00 04 2A A4 9B 00 00 08 00 00 04 2B A4 9B 00 00 08 00 00 04 2C A4 9B 00 00 08 00 00 04 2D A4 9B 00 00 08 00 00 04 2E A4 9B 00 00 08 00 00 04 2F A4 9B 00 00 08 00 00 04 30 A4 9B 00 00 08 00 00 04 31 A4 9B 00 00 08 00 00 04 32 A4 9B 00 00 08 00 00 04 33 A4 9B 00 00 08 00 00 04 34 A4 9B 00 00 08 00 00 04 35 A4 9B 00 00 08 00 00 04 36 A4 9B 00 00 08 00 00 04 37 A4 9B 00 00 08 00 00 04 38 A4 9B 00 00 08 00 00 04 39 A4 9B 00 00 08 00 00 04 3A A4 9B 00 00 08 00 00 04 3B A4 9B 00 00 08 00 00 04 3C A4 9B 00 00 08 00 00 04 3D A4 9B 00 00 08 00 00 04 3E A4 9B 00 00 08 00 00 04 3F A4 9B 00 00 08 00 00 04 40 A4 9B 00 00 08 00 00 04 41 A4 9B 00 00 08 00 00 04 42 A4 9B 00 00 08 00 00 04 43 A4 9B 00 00 08 00 00 04 44 A4 9B 00 00 08 00 00 04 45 A4 9B 00 00 08 00 00 04 46 A4 9B 00 00 08 00 00 04 47 A4 9B 00 00 08 00 00 04 48 A4 9B 00 00 08 00 00 04 49 A4 9B 00 00 08 00 00 04 4A A4 9B 00 00 08 00 00 04 4B A4 9B 00 00 08 00 00 04 4C A4 9B 00 00 08 00 00 04 4D A4 9B 00 00 08 00 00 04 4E A4 9B 00 00 08 00 00 04 4F A4 9B 00 00 08 00 00 04 50 A4 9B 00 00 08 00 00 04 51 A4 9B 00 00 08 00 00 04 52 A4 9B 00 00 08 00 00 04 53 A4 9B 00 00 08 00 00 04 54 A4 9B 00 00 08 00 00 04 55 A4 9B 00 00 08 00 00 04 56 A4 9B 00 00 08 00 00 04 57 A4 9B 00 00 08 00 00 04 58 A4 9B 00 00 08 00 00 04 59 A4 9B 00 00 08 00 00 04 5A A4 9B 00 00 08 00 00 04 5B A4 9B 00 00 08 00 00 04 5C A4 9B 00 00 08 00 00 04 5D A4 9B 00 00 08 00 00 04 5E A4 9B 00 00 08 00 00 04 5F A4 9B 00 00 08 00 00 04 60 A4 9B 00 00 08 00 00 04 61 A4 9B 00 00 08 00 00 04 62 A4 9B 00 00 08 00 00 04 63 A4 9B 00 00 08 00 00 04 64 A4 9B 00 00 08 00 00 04 65 A4 9B 00 00 08 00 00 04 66 A4 9B 00 00 08 00 00 04 67 A4 9B 00 00 08 00 00 04 68 A4 9B 00 00 08 00 00 04 69 A4 9B 00 00 08 00 00 04 6A A4 9B 00 00 08 00 00 04 6B A4 9B 00 00 08 00 00 04 6C A4 9B 00 00 08 00 00 04 6D A4 9B 00 00 08 00 00 04 6E A4 9B 00 00 08 00 00 04 6F A4 9B 00 00 08 00 00 04 70 A4 9B 00 00 08 00 00 04 71 A4 9B 00 00 08 00 00 04 72 A4 9B 00 00 08 00 00 04 73 A4 9B 00 00 08 00 00 04 74 A4 9B 00 00 08 00 00 04 75 A4 9B 00 00 08 00 00 04 76 A4 9B 00 00 08 00 00 04 77 A4 9B 00 00 08 00 00 04 78 A4 9B 00 00 08 00 00 04 79 A4 9B 00 00 08 00 00 04 7A A4 9B 00 00 08 00 00 04 7B A4 9B 00 00 08 00 00 04 7C A4 9B 00 00 08 00 00 04 7D A4 9B 00 00 08 00 00 04 7E A4 9B 00 00 08 00 00 04 7F A4 9B 00 00 08 00 00 04 80 A4 9B 00 00 08 00 00 04 81 A4 9B 00 00 08 00 00 04 82 A4 9B 00 00 08 00 00 04 83 A4 9B 00 00 08 00 00 04 84 A4 9B 00 00 08 00 00 04 85 A4 9B 00 00 08 00 00 04 86 A4 9B 00 00 08 00 00 04 87 A4 9B 00 00 08 00 00 04 88 A4 9B 00 00 08 00 00 04 89 A4 9B 00 00 08 00 00 04 8A A4 9B 00 00 08 00 00 04 8B A4 9B 00 00 08 00 00 04 8C A4 9B 00 00 08 00 00 04 8D A4 9B 00 00 08 00 00 04 8E A4 9B 00 00 08 00 00 04 8F A4 9B 00 00 08 00 00 04 90 A4 9B 00 00 08 00 00 04 91 A4 9B 00 00 08 00 00 04 92 A4 9B 00 00 08 00 00 04 93 A4 9B 00 00 08 00 00 04 94 A4 9B 00 00 08 00 00 04 95 A4 9B 00 00 08 00 00 04 96 A4 9B 00 00 08 00 00 04 97 A4 9B 00 00 08 00 00 04 98 A4 9B 00 00 08 00 00 04 99 A4 9B 00 00 08 00 00 04 9A A4 9B 00 04 08 00 00 70 02 00 00 04 9B A4 9B 00 04 08 00 00 20 02 00 00 04 9C A4 9B 00 04 08 00 00 70 02 00 00 04 9D A4 9B 00 04 08 00 00 00 04 00 00 04 9E A4 9B 00 04 08 00 00 00 04 00 00 04 9F A4 9B 00 04 08 00 00 70 02 00 00 04 A0 A4 9B 00 04 08 00 00 20 02 00 00 04 A1 A4 9B 00 04 08 00 00 10 03 00 00 04 A2 A4 9B 00 04 08 00 00 A0 04 00 00 04 A3 A4 9B 00 04 08 00 00 C0 02 00 00 04 A4 A4 9B 00 04 08 00 00 E4 11 00 00 04 A5 A4 9B 00 04 08 00 00 10 03 00 00 04 A6 A4 9B 00 04 08 00 00 10 03 00 00 04 A7 A4 9B 00 04 08 00 00 00 04 00 00 04 A8 A4 9B 00 04 08 00 00 C0 02 00 00 04 A9 A4 9B 00 04 08 00 00 C0 02 00 00 04 AA A4 9B 00 04 08 00 00 C0 02 00 00 04 AB A4 9B 00 04 08 00 00 A0 05 00 00 04 AC A4 9B 00 04 08 00 00 30 06 00 00 04 AD A4 9B 00 04 08 00 00 00 04 00 00 04 AE A4 9B 00 04 08 00 00 E0 05 00 00 04 AF A4 9B 00 04 08 00 00 98 0D 00 00 04 B0 A4 9B 00 04 08 00 00 60 03 00 00 04 B1 A4 9B 00 04 08 00 00 10 03 00 00 04 B2 A4 9B 00 04 08 00 00 70 02 00 00 04 B3 A4 9B 00 04 08 00 00 70 02 00 00 04 B4 A4 9B 00 04 08 00 00 10 03 00 00 04 B5 A4 9B 00 04 08 00 00 70 02 00 00 04 B6 A4 9B 00 04 08 00 00 20 02 00 00 04 B7 A4 9B 00 04 08 00 00 70 02 00 00 04 B8 A4 9B 00 04 08 00 00 A0 04 00 00 04 B9 A4 9B 00 04 08 00 00 F0 04 00 00 04 BA A4 9B 00 04 08 00 00 FC 0D 00 00 04 BB A4 9B 00 04 08 00 00 C0 02 00 00 04 BC A4 9B 00 04 08 00 00 C0 02 00 00 04 BD A4 9B 00 04 08 00 00 20 02 00 00 04 BE A4 9B 00 04 08 00 00 60 03 00 00 04 BF A4 9B 00 04 08 00 00 60 03 00 00 04 C0 A4 9B 00 04 08 00 00 E0 06 00 00 04 C1 A4 9B 00 04 08 00 00 20 02 00 00 04 C2 A4 9B 00 04 08 00 00 70 02 00 00 04 C3 A4 9B 00 04 08 00 00 50 04 00 00 04 C4 A4 9B 00 04 08 00 00 F0 04 00 00 04 C5 A4 9B 00 04 08 00 00 58 07 00 00 04 C6 A4 9B 00 04 08 00 00 60 03 00 00 04 C7 A4 9B 00 04 08 00 00 20 02 00 00 04 C8 A4 9B 00 04 08 00 00 D0 01 00 00 04 C9 A4 9B 00 04 08 00 00 C0 02 00 00 04 CA A4 9B 00 04 08 00 00 46 01 00 00 04 CB A4 9B 00 04 08 00 00 20 02 00 00 04 CC A4 9B 00 04 08 00 00 00 04 00 00 04 CD A4 9B 00 04 08 00 00 A0 05 00 00 04 CE A4 9B 00 04 08 00 00 10 03 00 00 04 CF A4 9B 00 04 08 00 00 40 05 00 00 04 D0 A4 9B 00 04 08 00 00 2C 06 00 00 04 D1 A4 9B 00 04 08 00 00 56 02 00 00 04 D2 A4 9B 00 04 08 00 00 20 02 00 00 04 D3 A4 9B 00 04 08 00 00 00 04 00 00 04 D4 A4 9B 00 04 08 00 00 C0 02 00 00 04 D5 A4 9B 00 04 08 00 00 20 02 00 00 04 D6 A4 9B 00 04 08 00 00 70 02 00 00 04 D7 A4 9B 00 04 08 00 00 60 03 00 00 04 D8 A4 9B 00 04 08 00 00 00 04 00 00 04 D9 A4 9B 00 04 08 00 00 C0 02 00 00 04 DA A4 9B 00 04 08 00 00 C0 02 00 00 04 DB A4 9B 00 04 08 00 00 2C 06 00 00 04 DC A4 9B 00 04 08 00 00 70 02 00 00 04 DD A4 9B 00 04 08 00 00 20 02 00 00 04 DE A4 9B 00 04 08 00 00 60 03 00 00 04 DF A4 9B 00 04 08 00 00 70 02 00 00 04 E0 A4 9B 00 04 08 00 00 C0 02 00 00 04 E1 A4 9B 00 04 08 00 00 10 03 00 00 04 E2 A4 9B 00 04 08 00 00 30 06 00 00 04 E3 A4 9B 00 04 08 00 00 60 03 00 00 04 E4 A4 9B 00 04 08 00 00 A0 05 00 00 04 E5 A4 9B 00 04 08 00 00 40 05 00 00 04 E6 A4 9B 00 04 08 00 00 2C 06 00 00 04 E7 A4 9B 00 04 08 00 00 C0 02 00 00 04 E8 A4 9B 00 04 08 00 00 C0 02 00 00 04 E9 A4 9B 00 04 08 00 00 70 02 00 00 04 EA A4 9B 00 04 08 00 00 C0 02 00 00 04 EB A4 9B 00 04 08 00 00 20 02 00 00 04 EC A4 9B 00 04 08 00 00 B0 04 00 00 04 ED A4 9B 00 04 08 00 00 50 04 00 00 04 EE A4 9B 00 04 08 00 00 50 04 00 00 04 EF A4 9B 00 04 08 00 00 A0 05 00 00 04 F0 A4 9B 00 04 08 00 00 A0 05 00 00 04 F1 A4 9B 00 04 08 00 00 20 08 00 00 04 F2 A4 9B 00 04 08 00 00 10 03 00 00 04 F3 A4 9B 00 04 08 00 00 F0 04 00 00 04 F4 A4 9B 00 04 08 00 00 70 02 00 00 04 F5 A4 9B 00 04 08 00 00 70 02 00 00 04 F6 A4 9B 00 04 08 00 00 20 02 00 00 04 F7 A4 9B 00 04 08 00 00 20 02 00 00 04 F8 A4 9B 00 04 08 00 00 A0 04 00 00 04 F9 A4 9B 00 04 08 00 00 10 03 00 00 04 FA A4 9B 00 04 08 00 00 C0 02 00 00 04 FB A4 9B 00 04 08 00 00 A0 05 00 00 04 FC A4 9B 00 04 08 00 00 20 08 00 00 04 FD A4 9B 00 04 08 00 00 70 02 00 00 04 FE A4 9B 00 04 08 00 00 10 03 00 00 04 FF A4 9B 00 04 08 00 00 70 02 00 00 04 00 A5 9B 00 04 08 00 00 70 02 00 00 04 01 A5 9B 00 04 08 00 00 D0 01 00 00 04 02 A5 9B 00 04 08 00 00 00 04 00 00 04 03 A5 9B 00 04 08 00 00 00 04 00 00 04 04 A5 9B 00 04 08 00 00 F0 04 00 00 04 05 A5 9B 00 04 08 00 00 40 05 00 00 04 06 A5 9B 00 04 08 00 00 A0 05 00 00 04 07 A5 9B 00 04 04 00 00 30 02 00 00 01 08 A5 9B 00 04 04 00 00 3C 08 00 00 01 09 A5 9B 00 04 04 00 00 30 01 00 00 01 0A A5 9B 00 04 04 00 00 80 03 00 00 01 0B A5 9B 00 04 04 00 00 70 02 00 00 01 0C A5 9B 00 04 04 00 00 80 03 00 00 01 0D A5 9B 00 04 04 00 00 F0 00 00 00 01 0E A5 9B 00 04 04 00 00 A4 01 00 00 01 0F A5 9B 00 04 04 00 00 9E 0C 00 00 01 10 A5 9B 00 04 04 00 00 98 04 00 00 01 11 A5 9B 00 04 04 00 00 98 01 00 00 01 12 A5 9B 00 04 04 00 00 0C 04 00 00 01 13 A5 9B 00 04 04 00 00 00 04 00 00 01 14 A5 9B 00 04 04 00 00 18 01 00 00 01 15 A5 9B 00 04 04 00 00 80 01 00 00 01 16 A5 9B 00 04 04 00 00 E6 08 00 00 01 17 A5 9B 00 04 04 00 00 DC 01 00 00 01 18 A5 9B 00 04 04 00 00 70 02 00 00 01 19 A5 9B 00 04 04 00 00 34 08 00 00 01 1A A5 9B 00 04 04 00 00 22 02 00 00 01 1B A5 9B 00 04 04 00 00 52 03 00 00 01 1C A5 9B 00 04 04 00 00 0E 07 00 00 01 1D A5 9B 00 04 04 00 00 50 04 00 00 01 1E A5 9B 00 04 04 00 00 40 05 00 00 01 1F A5 9B 00 04 04 00 00 EC 04 00 00 01 20 A5 9B 00 04 04 00 00 9A 10 00 00 01 21 A5 9B 00 04 04 00 00 80 01 00 00 01 22 A5 9B 00 04 04 00 00 EC 04 00 00 01 23 A5 9B 00 04 04 00 00 AE 02 00 00 01 24 A5 9B 00 04 04 00 00 AE 02 00 00 01 25 A5 9B 00 04 04 00 00 41 03 00 00 01 26 A5 9B 00 04 04 00 00 A4 01 00 00 01 27 A5 9B 00 04 04 00 00 B0 04 00 00 01 28 A5 9B 00 04 04 00 00 E0 05 00 00 01 29 A5 9B 00 04 04 00 00 0C 04 00 00 01 2A A5 9B 00 04 04 00 00 9A 10 00 00 01 2B A5 9B 00 04 04 00 00 F0 04 00 00 01 2C A5 9B 00 04 04 00 00 DC 01 00 00 01 2D A5 9B 00 04 04 00 00 EC 04 00 00 01 2E A5 9B 00 04 04 00 00 68 02 00 00 01 2F A5 9B 00 04 04 00 00 52 03 00 00 01 30 A5 9B 00 04 04 00 00 22 02 00 00 01 31 A5 9B 00 04 04 00 00 10 03 00 00 01 32 A5 9B 00 04 04 00 00 80 01 00 00 01 33 A5 9B 00 04 04 00 00 AE 02 00 00 01 34 A5 9B 00 04 04 00 00 EB 03 00 00 01 35 A5 9B 00 04 04 00 00 20 12 00 00 01 36 A5 9B 00 04 04 00 00 C8 06 00 00 01 37 A5 9B 00 04 04 00 00 AE 02 00 00 01 38 A5 9B 00 04 04 00 00 BC 02 00 00 01 39 A5 9B 00 04 04 00 00 FB 04 00 00 01 3A A5 9B 00 04 04 00 00 68 02 00 00 01 3B A5 9B 00 04 04 00 00 50 04 00 00 01 3C A5 9B 00 04 04 00 00 20 02 00 00 01 3D A5 9B 00 04 04 00 00 22 02 00 00 01 3E A5 9B 00 04 04 00 00 48 0D 00 00 01 3F A5 9B 00 04 04 00 00 10 03 00 00 01 40 A5 9B 00 04 04 00 00 52 04 00 00 01 41 A5 9B 00 04 04 00 00 AE 02 00 00 01 42 A5 9B 00 04 04 00 00 A8 07 00 00 01 43 A5 9B 00 04 04 00 00 EA 04 00 00 01 44 A5 9B 00 04 04 00 00 AE 02 00 00 01 45 A5 9B 00 04 04 00 00 50 04 00 00 01 46 A5 9B 00 04 04 00 00 10 03 00 00 01 47 A5 9B 00 04 04 00 00 34 08 00 00 01 48 A5 9B 00 04 04 00 00 97 02 00 00 01 49 A5 9B 00 04 04 00 00 A0 05 00 00 01 4A A5 9B 00 04 04 00 00 DC 01 00 00 01 4B A5 9B 00 04 04 00 00 DC 01 00 00 01 4C A5 9B 00 04 04 00 00 6A 05 00 00 01 60 2A 9D 00 04 00 00 00 EC 02 00 00 61 2A 9D 00 04 00 00 00 A4 06 00 00 62 2A 9D 00 04 00 00 00 FE 01 00 00 63 2A 9D 00 04 00 00 00 52 03 00 00 64 2A 9D 00 04 00 00 00 70 02 00 00 65 2A 9D 00 04 00 00 00 FA 05 00 00 66 2A 9D 00 04 00 00 00 3F 05 00 00 67 2A 9D 00 04 00 00 00 41 03 00 00 68 2A 9D 00 04 00 00 00 A8 02 00 00 69 2A 9D 00 04 00 00 00 96 03 00 00 6A 2A 9D 00 04 00 00 00 95 04 00 00 6B 2A 9D 00 04 00 00 00 41 03 00 00 6C 2A 9D 00 04 00 00 00 98 01 00 00 6D 2A 9D 00 04 00 00 00 40 04 00 00 6E 2A 9D 00 04 00 00 00 42 02 00 00 6F 2A 9D 00 04 00 00 00 20 02 00 00 70 2A 9D 00 04 00 00 00 41 03 00 00 71 2A 9D 00 04 00 00 00 42 02 00 00 72 2A 9D 00 04 00 00 00 42 02 00 00 73 2A 9D 00 04 00 00 00 A0 04 00 00 74 2A 9D 00 04 00 00 00 91 08 00 00 75 2A 9D 00 04 00 00 00 97 02 00 00 76 2A 9D 00 04 00 00 00 40 04 00 00 77 2A 9D 00 04 00 00 00 FA 05 00 00 78 2A 9D 00 04 00 00 00 A9 01 00 00 79 2A 9D 00 04 00 00 00 41 03 00 00 7A 2A 9D 00 04 00 00 00 40 04 00 00 7B 2A 9D 00 04 00 00 00 40 04 00 00 7C 2A 9D 00 04 00 00 00 42 02 00 00 7D 2A 9D 00 04 00 00 00 EC 02 00 00 7E 2A 9D 00 04 00 00 00 42 02 00 00 7F 2A 9D 00 04 00 00 00 FA 05 00 00 80 2A 9D 00 04 00 00 00 41 03 00 00 81 2A 9D 00 04 00 00 00 40 04 00 00 82 2A 9D 00 04 00 00 00 00 04 00 00 83 2A 9D 00 04 00 00 00 40 04 00 00 84 2A 9D 00 04 00 00 00 41 03 00 00 85 2A 9D 00 04 00 00 00 95 04 00 00 86 2A 9D 00 04 00 00 00 EC 02 00 00 87 2A 9D 00 04 00 00 00 3F 05 00 00 88 2A 9D 00 04 00 00 00 97 02 00 00 89 2A 9D 00 04 00 00 00 95 04 00 00 8A 2A 9D 00 04 00 00 00 96 03 00 00 8B 2A 9D 00 04 00 00 00 EC 02 00 00 8C 2A 9D 00 04 00 00 00 41 03 00 00 8D 2A 9D 00 04 00 00 00 FA 05 00 00 8E 2A 9D 00 04 00 00 00 96 03 00 00 8F 2A 9D 00 04 00 00 00 ED 01 00 00 90 2A 9D 00 04 00 00 00 96 03 00 00 91 2A 9D 00 04 00 00 00 97 02 00 00 92 2A 9D 00 04 00 00 00 96 03 00 00 93 2A 9D 00 04 00 00 00 40 04 00 00 94 2A 9D 00 04 00 00 00 42 02 00 00 95 2A 9D 00 04 00 00 00 96 03 00 00 96 2A 9D 00 04 00 00 00 F0 04 00 00 97 2A 9D 00 04 00 00 00 70 02 00 00 98 2A 9D 00 04 00 00 00 80 04 00 00 99 2A 9D 00 04 00 00 00 3C 06 00 00 9A 2A 9D 00 04 00 00 00 97 02 00 00 9B 2A 9D 00 04 00 00 00 34 05 00 00 9C 2A 9D 00 04 00 00 00 97 02 00 00 9D 2A 9D 00 04 00 00 00 C0 02 00 00 9E 2A 9D 00 04 00 00 00 20 02 00 00 9F 2A 9D 00 04 00 00 00 10 03 00 00 A0 2A 9D 00 04 00 00 00 30 06 00 00 A1 2A 9D 00 04 00 00 00 97 02 00 00 A2 2A 9D 00 04 00 00 00 54 06 00 00 A3 2A 9D 00 04 00 00 00 EC 02 00 00 A4 2A 9D 00 04 00 00 00 20 02 00 00 A5 2A 9D 00 04 00 00 00 70 02 00 00 A6 2A 9D 00 04 00 00 00 C0 02 00 00 A7 2A 9D 00 04 00 00 00 10 03 00 00 A8 2A 9D 00 04 00 00 00 BE 02 00 00 A9 2A 9D 00 04 00 00 00 0A 02 00 00 AA 2A 9D 00 04 00 00 00 DA 04 00 00 AB 2A 9D 00 04 00 00 00 41 03 00 00 AC 2A 9D 00 04 00 00 00 A3 03 00 00 AD 2A 9D 00 04 00 00 00 B6 03 00 00 AE 2A 9D 00 04 00 00 00 70 02 00 00 AF 2A 9D 00 04 00 00 00 97 02 00 00 B0 2A 9D 00 04 00 00 00 72 03 00 00 B1 2A 9D 00 04 00 00 00 69 01 00 00 B2 2A 9D 00 04 00 00 00 18 03 00 00 B3 2A 9D 00 04 00 00 00 60 03 00 00 B4 2A 9D 00 04 00 00 00 A0 05 00 00 B5 2A 9D 00 04 00 00 00 52 03 00 00 B6 2A 9D 00 04 00 00 00 EC 02 00 00 B7 2A 9D 00 04 00 00 00 34 09 00 00 B8 2A 9D 00 04 00 00 00 B0 01 00 00 B9 2A 9D 00 04 00 00 00 72 03 00 00 BA 2A 9D 00 04 00 00 00 C0 02 00 00 BB 2A 9D 00 04 00 00 00 DB 01 00 00 BC 2A 9D 00 04 00 00 00 46 05 00 00 BD 2A 9D 00 04 00 00 00 96 03 00 00 BE 2A 9D 00 04 00 00 00 90 01 00 00 BF 2A 9D 00 04 00 00 00 1D 01 00 00 C0 2A 9D 00 04 00 00 00 52 02 00 00 C1 2A 9D 00 04 00 00 00 41 03 00 00 C2 2A 9D 00 04 00 00 00 70 02 00 00 C3 2A 9D 00 04 00 00 00 86 02 00 00 C4 2A 9D 00 04 00 00 00 DA 04 00 00 C5 2A 9D 00 04 00 00 00 97 02 00 00 C6 2A 9D 00 04 00 00 00 70 02 00 00 C7 2A 9D 00 04 00 00 00 02 04 00 00 C8 2A 9D 00 04 00 00 00 C0 03 00 00 C9 2A 9D 00 04 00 00 00 97 02 00 00 CA 2A 9D 00 04 00 00 00 70 02 00 00 CB 2A 9D 00 04 00 00 00 44 03 00 00 CC 2A 9D 00 04 00 00 00 80 04 00 00 CD 2A 9D 00 04 00 00 00 4D 08 00 00 CE 2A 9D 00 04 00 00 00 70 02 00 00 CF 2A 9D 00 04 00 00 00 F2 09 00 00 D0 2A 9D 00 04 00 00 00 18 03 00 00 D1 2A 9D 00 04 00 00 00 94 05 00 00 D2 2A 9D 00 04 00 00 00 10 03 00 00 D3 2A 9D 00 04 00 00 00 FD 0C 00 00 D4 2A 9D 00 04 00 00 00 9C 06 00 00 D5 2A 9D 00 04 00 00 00 92 07 00 00 D6 2A 9D 00 04 00 00 00 70 02 00 00 D7 2A 9D 00 04 00 00 00 A3 03 00 00 D8 2A 9D 00 04 00 00 00 8E 05 00 00 D9 2A 9D 00 04 00 00 00 96 03 00 00 DA 2A 9D 00 04 00 00 00 70 02 00 00 DB 2A 9D 00 04 00 00 00 8E 12 00 00 DC 2A 9D 00 04 00 00 00 BE 02 00 00 DD 2A 9D 00 04 00 00 00 40 04 00 00 DE 2A 9D 00 04 00 00 00 D0 01 00 00 DF 2A 9D 00 04 00 00 00 C8 01 00 00 E0 2A 9D 00 04 00 00 00 BE 02 00 00 E1 2A 9D 00 04 00 00 00 42 02 00 00 E2 2A 9D 00 04 00 00 00 C0 02 00 00 E3 2A 9D 00 04 00 00 00 BE 02 00 00 E4 2A 9D 00 04 00 00 00 97 02 00 00 E5 2A 9D 00 04 00 00 00 A0 05 00 00 E6 2A 9D 00 04 00 00 00 42 02 00 00 E7 2A 9D 00 04 00 00 00 E0 01 00 00 E8 2A 9D 00 04 00 00 00 EA 04 00 00 E9 2A 9D 00 04 00 00 00 10 03 00 00 EA 2A 9D 00 04 00 00 00 EC 02 00 00 EB 2A 9D 00 04 00 00 00 20 02 00 00 EC 2A 9D 00 04 00 00 00 52 03 00 00 ED 2A 9D 00 04 00 00 00 80 04 00 00 EE 2A 9D 00 04 00 00 00 62 07 00 00 EF 2A 9D 00 04 00 00 00 FA 05 00 00 F0 2A 9D 00 04 00 00 00 B0 04 00 00 F1 2A 9D 00 04 00 00 00 BE 00 00 00 F2 2A 9D 00 04 00 00 00 10 0E 00 00 F3 2A 9D 00 04 00 00 00 40 04 00 00 F4 2A 9D 00 04 00 00 00 C0 02 00 00 F5 2A 9D 00 04 00 00 00 20 02 00 00 F6 2A 9D 00 04 00 00 00 40 05 00 00 F7 2A 9D 00 04 00 00 00 41 03 00 00 F8 2A 9D 00 04 00 00 00 10 03 00 00 F9 2A 9D 00 04 00 00 00 02 04 00 00 FA 2A 9D 00 04 00 00 00 E8 05 00 00 FB 2A 9D 00 04 00 00 00 A0 05 00 00 FC 2A 9D 00 04 00 00 00 20 02 00 00 FD 2A 9D 00 04 00 00 00 10 03 00 00 FE 2A 9D 00 04 00 00 00 72 03 00 00 FF 2A 9D 00 04 00 00 00 1A 0E 00 00 00 2B 9D 00 04 00 00 00 C0 02 00 00 01 2B 9D 00 04 00 00 00 8E 12 00 00 02 2B 9D 00 04 00 00 00 10 03 00 00 03 2B 9D 00 04 00 00 00 10 03 00 00 04 2B 9D 00 04 00 00 00 C0 02 00 00 05 2B 9D 00 04 00 00 00 00 04 00 00 06 2B 9D 00 04 00 00 00 8E 05 00 00 07 2B 9D 00 04 00 00 00 20 03 00 00 08 2B 9D 00 04 00 00 00 10 03 00 00 09 2B 9D 00 04 00 00 00 97 02 00 00 0A 2B 9D 00 04 00 00 00 70 02 00 00 0B 2B 9D 00 04 00 00 00 70 02 00 00 0C 2B 9D 00 04 00 00 00 00 04 00 00 0D 2B 9D 00 04 00 00 00 96 03 00 00 0E 2B 9D 00 04 00 00 00 60 03 00 00 0F 2B 9D 00 04 00 00 00 3E 06 00 00 10 2B 9D 00 04 00 00 00 C0 02 00 00 11 2B 9D 00 04 00 00 00 C0 02 00 00 12 2B 9D 00 04 00 00 00 22 0B 00 00 13 2B 9D 00 04 00 00 00 68 01 00 00 14 2B 9D 00 04 00 00 00 64 14 00 00 15 2B 9D 00 04 00 00 00 A0 05 00 00 16 2B 9D 00 04 00 00 00 00 04 00 00 17 2B 9D 00 04 00 00 00 C0 02 00 00 18 2B 9D 00 04 00 00 00 22 0B 00 00 19 2B 9D 00 04 00 00 00 72 03 00 00 1A 2B 9D 00 04 00 00 00 BE 02 00 00 1B 2B 9D 00 04 00 00 00 8E 12 00 00 1C 2B 9D 00 04 00 00 00 C0 07 00 00 1D 2B 9D 00 04 00 00 00 00 04 00 00 1E 2B 9D 00 04 00 00 00 40 04 00 00 1F 2B 9D 00 04 00 00 00 EC 02 00 00 20 2B 9D 00 04 00 00 00 70 02 00 00 21 2B 9D 00 04 00 00 00 C0 02 00 00 22 2B 9D 00 04 00 00 00 00 04 00 00 23 2B 9D 00 04 00 00 00 1D 01 00 00 24 2B 9D 00 04 00 00 00 B0 01 00 00 25 2B 9D 00 04 00 00 00 FE 01 00 00 26 2B 9D 00 04 00 00 00 EC 02 00 00 27 2B 9D 00 04 00 00 00 20 03 00 00 28 2B 9D 00 04 00 00 00 10 03 00 00 29 2B 9D 00 04 00 00 00 A0 0F 00 00 2A 2B 9D 00 04 00 00 00 20 03 00 00 2B 2B 9D 00 04 00 00 00 40 04 00 00 2C 2B 9D 00 04 00 00 00 FE 01 00 00 2D 2B 9D 00 04 00 00 00 EA 04 00 00 2E 2B 9D 00 04 00 00 00 30 06 00 00 2F 2B 9D 00 04 00 00 00 BE 02 00 00 30 2B 9D 00 04 00 00 00 C0 02 00 00 31 2B 9D 00 04 00 00 00 95 04 00 00 32 2B 9D 00 04 00 00 00 42 02 00 00 33 2B 9D 00 04 00 00 00 EE 00 00 00 34 2B 9D 00 04 00 00 00 10 03 00 00 35 2B 9D 00 04 00 00 00 20 02 00 00 36 2B 9D 00 04 00 00 00 D0 01 00 00 37 2B 9D 00 04 00 00 00 FB 04 00 00 38 2B 9D 00 04 00 00 00 F6 09 00 00 39 2B 9D 00 04 00 00 00 C0 02 00 00 3A 2B 9D 00 04 00 00 00 40 04 00 00 3B 2B 9D 00 04 00 00 00 90 01 00 00 3C 2B 9D 00 04 00 00 00 FA 05 00 00 3D 2B 9D 00 04 00 00 00 F0 04 00 00 3E 2B 9D 00 04 00 00 00 20 02 00 00 3F 2B 9D 00 04 00 00 00 70 02 00 00 40 2B 9D 00 04 00 00 00 10 03 00 00 41 2B 9D 00 04 00 00 00 C0 02 00 00 42 2B 9D 00 04 00 00 00 D8 0E 00 00 43 2B 9D 00 04 00 00 00 F0 04 00 00 44 2B 9D 00 04 00 00 00 FB 04 00 00 45 2B 9D 00 04 00 00 00 61 04 00 00 46 2B 9D 00 04 00 00 00 DA 04 00 00 47 2B 9D 00 04 00 00 00 52 03 00 00 48 2B 9D 00 04 00 00 00 C0 02 00 00 49 2B 9D 00 04 00 00 00 10 03 00 00 4A 2B 9D 00 04 00 00 00 C8 01 00 00 4B 2B 9D 00 04 00 00 00 B0 01 00 00 4C 2B 9D 00 04 00 00 00 EC 02 00 00 4D 2B 9D 00 04 00 00 00 C0 08 00 00 4E 2B 9D 00 04 00 00 00 A3 03 00 00 4F 2B 9D 00 04 00 00 00 B6 03 00 00 50 2B 9D 00 04 00 00 00 B6 03 00 00 51 2B 9D 00 04 00 00 00 72 03 00 00 52 2B 9D 00 04 00 00 00 97 02 00 00 53 2B 9D 00 04 00 00 00 A4 06 00 00 54 2B 9D 00 04 00 00 00 41 03 00 00 55 2B 9D 00 04 00 00 00 A0 04 00 00 56 2B 9D 00 04 00 00 00 F0 04 00 00 57 2B 9D 00 04 00 00 00 B6 03 00 00 58 2B 9D 00 04 00 00 00 72 03 00 00 59 2B 9D 00 04 00 00 00 EC 02 00 00 5A 2B 9D 00 04 00 00 00 A0 04 00 00 5B 2B 9D 00 04 00 00 00 A3 03 00 00 5C 2B 9D 00 04 00 00 00 8C 0A 00 00 5D 2B 9D 00 04 00 00 00 41 03 00 00 5E 2B 9D 00 04 00 00 00 10 03 00 00 5F 2B 9D 00 04 00 00 00 B6 03 00 00 60 2B 9D 00 04 00 00 00 34 09 00 00 61 2B 9D 00 04 00 00 00 64 02 00 00 62 2B 9D 00 04 00 00 00 42 02 00 00 63 2B 9D 00 04 00 00 00 41 03 00 00 64 2B 9D 00 04 00 00 00 C0 02 00 00 65 2B 9D 00 04 00 00 00 60 09 00 00 66 2B 9D 00 04 00 00 00 60 03 00 00 67 2B 9D 00 04 00 00 00 D0 02 00 00 68 2B 9D 00 04 00 00 00 42 02 00 00 69 2B 9D 00 04 00 00 00 50 04 00 00 6A 2B 9D 00 04 00 00 00 70 02 00 00 6B 2B 9D 00 04 00 00 00 50 04 00 00 6C 2B 9D 00 04 00 00 00 0A 02 00 00 6D 2B 9D 00 04 00 00 00 72 03 00 00 6E 2B 9D 00 04 00 00 00 F6 09 00 00 6F 2B 9D 00 04 00 00 00 00 04 00 00 70 2B 9D 00 04 00 00 00 C2 01 00 00 71 2B 9D 00 04 00 00 00 FE 01 00 00 72 2B 9D 00 04 00 00 00 30 06 00 00 73 2B 9D 00 04 00 00 00 8E 05 00 00 74 2B 9D 00 04 00 00 00 A0 05 00 00 12 2D 31 01 00 04 00 00 01 14 2D 31 01 00 04 00 00 01 15 2D 31 01 00 04 00 00 01 16 2D 31 01 00 04 00 00 01 17 2D 31 01 00 04 00 00 01 18 2D 31 01 00 04 00 00 01 19 2D 31 01 00 04 00 00 01 1A 2D 31 01 00 04 00 00 01 1C 2D 31 01 00 04 00 00 01 1F 2D 31 01 00 04 00 00 01 20 2D 31 01 00 04 00 00 01 21 2D 31 01 00 04 00 00 01 22 2D 31 01 00 04 00 00 01 23 2D 31 01 00 08 00 00 03 24 2D 31 01 00 04 00 00 01 25 2D 31 01 00 04 00 00 01 26 2D 31 01 00 04 00 00 01 28 2D 31 01 00 04 00 00 01 29 2D 31 01 00 04 00 00 01 2A 2D 31 01 00 04 00 00 01 2B 2D 31 01 00 04 00 00 01 2C 2D 31 01 10 00 00 00 05 2D 2D 31 01 00 04 00 00 01 2E 2D 31 01 00 04 00 00 01 2F 2D 31 01 00 04 00 00 01 30 2D 31 01 00 04 00 00 01 31 2D 31 01 00 04 00 00 01 32 2D 31 01 00 04 00 00 01 33 2D 31 01 00 04 00 00 01 34 2D 31 01 00 04 00 00 01 35 2D 31 01 00 04 00 00 01 36 2D 31 01 00 04 00 00 01 37 2D 31 01 00 04 00 00 01 38 2D 31 01 00 04 00 00 01 39 2D 31 01 00 04 00 00 01 3A 2D 31 01 00 04 00 00 01 3B 2D 31 01 00 04 00 00 01 3C 2D 31 01 00 04 00 00 01 3D 2D 31 01 00 04 00 00 01 3E 2D 31 01 00 04 00 00 01 3F 2D 31 01 00 04 00 00 01 40 2D 31 01 00 04 00 00 01 41 2D 31 01 00 04 00 00 01 42 2D 31 01 00 04 00 00 01 43 2D 31 01 00 04 00 00 01 44 2D 31 01 00 04 00 00 01 45 2D 31 01 00 04 00 00 01 46 2D 31 01 00 04 00 00 01 47 2D 31 01 00 04 00 00 01 48 2D 31 01 00 04 00 00 01 49 2D 31 01 00 0C 00 00 01 02 4D 2D 31 01 00 04 00 00 01 4E 2D 31 01 00 04 00 00 01 4F 2D 31 01 00 04 00 00 01 50 2D 31 01 00 04 00 00 01 51 2D 31 01 00 04 00 00 01 52 2D 31 01 00 04 00 00 01 53 2D 31 01 00 04 00 00 01 54 2D 31 01 00 04 00 00 01 55 2D 31 01 00 04 00 00 01 56 2D 31 01 00 04 00 00 01 57 2D 31 01 00 04 00 00 01 58 2D 31 01 00 04 00 00 01 59 2D 31 01 00 04 00 00 01 5A 2D 31 01 00 04 00 00 01 5B 2D 31 01 00 04 00 00 01 5C 2D 31 01 00 04 00 00 01 5D 2D 31 01 00 04 00 00 01 5E 2D 31 01 00 04 00 00 01 5F 2D 31 01 00 04 00 00 01 60 2D 31 01 00 04 00 00 01 61 2D 31 01 00 04 00 00 01 62 2D 31 01 00 04 00 00 01 63 2D 31 01 00 04 00 00 01 64 2D 31 01 00 04 00 00 01 65 2D 31 01 00 04 00 00 01 6A 2D 31 01 00 04 00 00 01 6B 2D 31 01 00 04 00 00 01 6C 2D 31 01 00 04 00 00 01 6D 2D 31 01 00 04 00 00 01 6E 2D 31 01 00 04 00 00 01 70 2D 31 01 00 04 00 00 01 74 2D 31 01 00 04 00 00 01 75 2D 31 01 00 04 00 00 01 76 2D 31 01 00 04 00 00 01 7A 2D 31 01 00 04 00 00 01 7B 2D 31 01 00 04 00 00 01 7C 2D 31 01 00 04 00 00 01 7D 2D 31 01 00 04 00 00 01 7E 2D 31 01 00 04 00 00 01 7F 2D 31 01 00 04 00 00 01 80 2D 31 01 00 04 00 00 01 82 2D 31 01 00 04 00 00 01 83 2D 31 01 00 04 00 00 01 84 2D 31 01 00 04 00 00 01 8A 2D 31 01 00 04 00 00 01 8B 2D 31 01 00 04 00 00 01 8C 2D 31 01 00 04 00 00 01 8D 2D 31 01 00 04 00 00 01 8E 2D 31 01 00 04 00 00 01 8F 2D 31 01 00 04 00 00 01 93 2D 31 01 00 04 00 00 01 99 2D 31 01 00 04 00 00 01 9A 2D 31 01 00 04 00 00 01 A6 2D 31 01 00 04 00 00 01 A7 2D 31 01 00 04 00 00 01 A8 2D 31 01 00 04 00 00 01 A9 2D 31 01 00 04 00 00 01 AA 2D 31 01 00 04 00 00 01 AB 2D 31 01 00 04 00 00 01 AC 2D 31 01 00 04 00 00 01 AD 2D 31 01 00 04 00 00 01 AE 2D 31 01 00 04 00 00 01 AF 2D 31 01 00 04 00 00 01 B0 2D 31 01 00 04 00 00 01 B1 2D 31 01 00 04 00 00 01 B2 2D 31 01 00 04 00 00 01 B3 2D 31 01 00 04 00 00 01 B4 2D 31 01 00 04 00 00 01 B5 2D 31 01 00 04 00 00 01 B6 2D 31 01 00 04 00 00 01 B7 2D 31 01 00 04 00 00 01 B8 2D 31 01 00 04 00 00 01 B9 2D 31 01 00 04 00 00 01 BA 2D 31 01 00 04 00 00 01 BC 2D 31 01 00 04 00 00 01 BD 2D 31 01 00 04 00 00 01 BE 2D 31 01 00 04 00 00 01 BF 2D 31 01 00 04 00 00 01 C0 2D 31 01 00 04 00 00 01 C7 2D 31 01 00 04 00 00 01 C8 2D 31 01 00 04 00 00 01 C9 2D 31 01 00 04 00 00 01 CA 2D 31 01 00 04 00 00 01 CB 2D 31 01 00 04 00 00 01 CC 2D 31 01 00 04 00 00 01 CD 2D 31 01 00 04 00 00 01 CE 2D 31 01 00 04 00 00 01 CF 2D 31 01 00 04 00 00 01 D1 2D 31 01 00 04 00 00 01 D2 2D 31 01 00 04 00 00 01 D3 2D 31 01 00 04 00 00 01 D4 2D 31 01 00 04 00 00 01 D5 2D 31 01 00 04 00 00 01 D6 2D 31 01 00 04 00 00 01 D7 2D 31 01 00 04 00 00 01 D8 2D 31 01 00 04 00 00 01 D9 2D 31 01 00 04 00 00 01 DA 2D 31 01 00 04 00 00 01 DB 2D 31 01 00 04 00 00 01 DC 2D 31 01 00 04 00 00 01 DD 2D 31 01 00 04 00 00 01 DE 2D 31 01 00 04 00 00 01 DF 2D 31 01 00 04 00 00 01 E0 2D 31 01 00 04 00 00 01 E1 2D 31 01 00 04 00 00 01 E2 2D 31 01 00 04 00 00 01 E3 2D 31 01 00 04 00 00 01 F0 2D 31 01 00 04 00 00 01 F1 2D 31 01 00 04 00 00 01 F2 2D 31 01 10 00 00 00 05 F3 2D 31 01 10 00 00 00 05 F4 2D 31 01 00 04 00 00 01 F5 2D 31 01 00 04 00 00 01 F6 2D 31 01 00 04 00 00 01 F7 2D 31 01 00 04 00 00 01 FA 2D 31 01 00 04 00 00 01 FB 2D 31 01 00 04 00 00 01 FC 2D 31 01 00 04 00 00 01 FD 2D 31 01 00 04 00 00 01 FE 2D 31 01 00 04 00 00 01 FF 2D 31 01 00 04 00 00 01 00 2E 31 01 00 04 00 00 01 12 2E 31 01 00 04 00 00 01 13 2E 31 01 00 04 00 00 01 14 2E 31 01 00 04 00 00 01 15 2E 31 01 00 04 00 00 01 16 2E 31 01 00 04 00 00 01 17 2E 31 01 00 04 00 00 01 18 2E 31 01 00 04 00 00 01 1A 2E 31 01 00 04 00 00 01 1D 2E 31 01 00 04 00 00 01 1E 2E 31 01 00 04 00 00 01 1F 2E 31 01 00 04 00 00 01 20 2E 31 01 00 04 00 00 01 21 2E 31 01 00 04 00 00 01 22 2E 31 01 00 04 00 00 01 23 2E 31 01 00 04 00 00 01 24 2E 31 01 00 04 00 00 01 25 2E 31 01 00 04 00 00 01 26 2E 31 01 00 04 00 00 01 27 2E 31 01 00 04 00 00 01 28 2E 31 01 00 04 00 00 01 29 2E 31 01 00 04 00 00 01 2A 2E 31 01 00 04 00 00 01 2B 2E 31 01 00 04 00 00 01 2C 2E 31 01 00 04 00 00 01 2D 2E 31 01 00 04 00 00 01 2E 2E 31 01 00 0C 00 00 01 02 2F 2E 31 01 00 04 00 00 01 30 2E 31 01 00 04 00 00 01 31 2E 31 01 00 04 00 00 01 32 2E 31 01 00 04 00 00 01 33 2E 31 01 00 04 00 00 01 34 2E 31 01 00 04 00 00 01 35 2E 31 01 00 04 00 00 01 36 2E 31 01 00 04 00 00 01 38 2E 31 01 00 04 00 00 01 39 2E 31 01 00 04 00 00 01 3C 2E 31 01 00 04 00 00 01 3D 2E 31 01 00 04 00 00 01 3E 2E 31 01 00 04 00 00 01 3F 2E 31 01 00 04 00 00 01 40 2E 31 01 00 04 00 00 01 41 2E 31 01 00 04 00 00 01 42 2E 31 01 00 08 00 00 03 43 2E 31 01 00 08 00 00 03 44 2E 31 01 00 04 00 00 01 45 2E 31 01 00 04 00 00 01 46 2E 31 01 00 04 00 00 01 48 2E 31 01 00 04 00 00 01 49 2E 31 01 00 04 00 00 01 4A 2E 31 01 00 04 00 00 01 4B 2E 31 01 00 04 00 00 01 4C 2E 31 01 00 04 00 00 01 4D 2E 31 01 00 04 00 00 01 4E 2E 31 01 00 04 00 00 01 4F 2E 31 01 00 04 00 00 01 50 2E 31 01 00 04 00 00 01 51 2E 31 01 00 04 00 00 01 52 2E 31 01 00 04 00 00 01 53 2E 31 01 00 04 00 00 01 54 2E 31 01 00 04 00 00 01 55 2E 31 01 00 04 00 00 01 56 2E 31 01 00 04 00 00 01 57 2E 31 01 00 04 00 00 01 58 2E 31 01 00 04 00 00 01 59 2E 31 01 00 04 00 00 01 5C 2E 31 01 00 04 00 00 01 5D 2E 31 01 00 04 00 00 01 5E 2E 31 01 00 04 00 00 01 6B 2E 31 01 00 04 00 00 01 6C 2E 31 01 00 04 00 00 01 6D 2E 31 01 00 04 00 00 01 6E 2E 31 01 00 04 00 00 01 74 2E 31 01 00 08 00 00 03 82 2E 31 01 00 08 00 00 03 83 2E 31 01 00 08 00 00 03 84 2E 31 01 00 04 00 00 01 85 2E 31 01 00 04 00 00 01 86 2E 31 01 00 04 00 00 01 87 2E 31 01 10 00 00 00 05 88 2E 31 01 00 04 00 00 01 89 2E 31 01 00 04 00 00 01 8A 2E 31 01 00 04 00 00 01 8B 2E 31 01 00 0C 00 00 01 02 8C 2E 31 01 00 04 00 00 01 8D 2E 31 01 00 04 00 00 01 8E 2E 31 01 00 04 00 00 01 90 2E 31 01 00 04 00 00 01 91 2E 31 01 00 04 00 00 01 92 2E 31 01 00 04 00 00 01 93 2E 31 01 00 04 00 00 01 95 2E 31 01 00 04 00 00 01 96 2E 31 01 00 04 00 00 01 98 2E 31 01 00 04 00 00 01 99 2E 31 01 00 04 00 00 01 9A 2E 31 01 00 04 00 00 01 9B 2E 31 01 00 04 00 00 01 9C 2E 31 01 00 04 00 00 01 9D 2E 31 01 00 04 00 00 01 9E 2E 31 01 00 04 00 00 01 9F 2E 31 01 00 04 00 00 01 A0 2E 31 01 00 04 00 00 01 A1 2E 31 01 00 04 00 00 01 A2 2E 31 01 00 04 00 00 01 A3 2E 31 01 00 04 00 00 01 A4 2E 31 01 00 04 00 00 01 AA 2E 31 01 00 04 00 00 01 AB 2E 31 01 00 04 00 00 01 AC 2E 31 01 00 04 00 00 01 AD 2E 31 01 00 04 00 00 01 AE 2E 31 01 00 04 00 00 01 AF 2E 31 01 00 04 00 00 01 B0 2E 31 01 00 04 00 00 01 B2 2E 31 01 00 0C 00 00 01 02 B3 2E 31 01 00 04 00 00 01 B8 2E 31 01 00 04 00 00 01 B9 2E 31 01 00 0C 00 00 01 02 D6 2E 31 01 00 04 00 00 01 D9 2E 31 01 00 04 00 00 01 DA 2E 31 01 10 00 00 00 05 DB 2E 31 01 00 04 00 00 01 DC 2E 31 01 10 00 00 00 05 DD 2E 31 01 10 00 00 00 05 DE 2E 31 01 00 04 00 00 01 E2 2E 31 01 00 04 00 00 01 E3 2E 31 01 00 04 00 00 01 E4 2E 31 01 00 04 00 00 01 E6 2E 31 01 00 0C 00 00 01 02 EE 2E 31 01 00 0C 00 00 01 02 EF 2E 31 01 00 04 00 00 01 F0 2E 31 01 00 04 00 00 01 F1 2E 31 01 00 08 00 00 00 F2 2E 31 01 00 04 00 00 01 F5 2E 31 01 00 0C 00 00 01 02 FA 2E 31 01 00 04 00 00 01 FB 2E 31 01 00 04 00 00 01 FC 2E 31 01 00 0C 00 00 01 02 01 2F 31 01 00 0C 00 00 01 02 02 2F 31 01 00 0C 00 00 01 02 03 2F 31 01 00 08 00 00 00 04 2F 31 01 00 08 00 00 00 06 2F 31 01 00 0C 00 00 01 02 07 2F 31 01 00 04 00 00 01 08 2F 31 01 00 04 00 00 01 09 2F 31 01 00 0C 00 00 01 02 0A 2F 31 01 00 0C 00 00 01 02 0B 2F 31 01 00 08 00 00 00 0C 2F 31 01 00 0C 00 00 01 02 0D 2F 31 01 00 04 00 00 01 0E 2F 31 01 00 04 00 00 01 0F 2F 31 01 00 0C 00 00 01 02 10 2F 31 01 00 0C 00 00 01 02 11 2F 31 01 00 08 00 00 00 12 2F 31 01 00 0C 00 00 01 02 13 2F 31 01 00 0C 00 00 01 02 14 2F 31 01 00 04 00 00 01 15 2F 31 01 00 0C 00 00 01 02 1C 2F 31 01 00 0C 00 00 01 02 1D 2F 31 01 00 04 00 00 01 1E 2F 31 01 00 0C 00 00 01 02 21 2F 31 01 10 04 00 00 55 01 22 2F 31 01 10 04 00 00 55 01 23 2F 31 01 10 08 00 00 63 00 24 2F 31 01 10 0C 00 00 5A 01 02 25 2F 31 01 10 04 00 00 61 01 26 2F 31 01 10 08 00 00 63 00 27 2F 31 01 10 04 00 00 61 01 31 2F 31 01 00 0C 00 00 01 00 A0 B3 32 01 00 04 00 00 01 A1 B3 32 01 00 04 00 00 01 A2 B3 32 01 00 04 00 00 01 A4 B3 32 01 00 04 00 00 01 A5 B3 32 01 00 04 00 00 01 A6 B3 32 01 00 0C 00 00 01 02 A7 B3 32 01 00 04 00 00 01 A8 B3 32 01 00 04 00 00 01 A9 B3 32 01 00 04 00 00 01 AA B3 32 01 00 04 00 00 01 AB B3 32 01 00 04 00 00 01 AC B3 32 01 00 04 00 00 01 AD B3 32 01 00 04 00 00 01 AE B3 32 01 00 04 00 00 01 AF B3 32 01 00 04 00 00 01 B0 B3 32 01 00 04 00 00 01 B1 B3 32 01 00 04 00 00 01 B2 B3 32 01 00 04 00 00 01 B4 B3 32 01 00 04 00 00 01 B5 B3 32 01 00 04 00 00 01 B7 B3 32 01 00 04 00 00 01 B8 B3 32 01 00 04 00 00 01 B9 B3 32 01 00 04 00 00 01 BA B3 32 01 00 04 00 00 01 BB B3 32 01 00 04 00 00 01 BC B3 32 01 00 04 00 00 01 BD B3 32 01 00 04 00 00 01 BE B3 32 01 00 04 00 00 01 BF B3 32 01 00 04 00 00 01 C0 B3 32 01 00 08 00 00 03 C1 B3 32 01 00 04 00 00 01 C2 B3 32 01 00 04 00 00 01 C3 B3 32 01 00 04 00 00 01 C4 B3 32 01 00 04 00 00 01 C5 B3 32 01 00 04 00 00 01 C6 B3 32 01 00 04 00 00 01 C7 B3 32 01 00 04 00 00 01 C8 B3 32 01 00 04 00 00 01 C9 B3 32 01 00 04 00 00 01 CC B3 32 01 00 0C 00 00 01 02 CD B3 32 01 00 04 00 00 01 CE B3 32 01 00 04 00 00 01 CF B3 32 01 00 04 00 00 01 D0 B3 32 01 00 04 00 00 01 D1 B3 32 01 00 04 00 00 01 D2 B3 32 01 00 04 00 00 01 D3 B3 32 01 00 04 00 00 01 D4 B3 32 01 00 08 00 00 03 D5 B3 32 01 00 04 00 00 01 D6 B3 32 01 00 04 00 00 01 D7 B3 32 01 00 04 00 00 01 D8 B3 32 01 00 0C 00 00 01 02 D9 B3 32 01 00 04 00 00 01 DA B3 32 01 00 04 00 00 01 DB B3 32 01 00 04 00 00 01 DC B3 32 01 00 04 00 00 01 DD B3 32 01 00 04 00 00 01 DE B3 32 01 08 00 00 00 01 DF B3 32 01 00 04 00 00 01 E0 B3 32 01 00 08 00 00 02 E1 B3 32 01 00 0C 00 00 01 02 E2 B3 32 01 00 04 00 00 01 E4 B3 32 01 00 04 00 00 01 E5 B3 32 01 00 0C 00 00 01 02 E6 B3 32 01 00 04 00 00 01 E7 B3 32 01 00 04 00 00 01 E8 B3 32 01 00 04 00 00 01 E9 B3 32 01 00 0C 00 00 01 02 EA B3 32 01 00 04 00 00 01 EB B3 32 01 00 04 00 00 01 EC B3 32 01 00 0C 00 00 01 02 ED B3 32 01 00 04 00 00 01 EE B3 32 01 00 04 00 00 01 EF B3 32 01 00 08 00 00 02 F0 B3 32 01 00 0C 00 00 01 02 F2 B3 32 01 10 08 00 00 63 00 40 3A 34 01 00 04 00 00 01 41 3A 34 01 00 04 00 00 01 42 3A 34 01 00 04 00 00 01 43 3A 34 01 00 04 00 00 01 44 3A 34 01 00 04 00 00 01 45 3A 34 01 00 04 00 00 01 46 3A 34 01 00 04 00 00 01 47 3A 34 01 00 04 00 00 01 48 3A 34 01 00 04 00 00 01 49 3A 34 01 00 04 00 00 01 4A 3A 34 01 00 04 00 00 01 4B 3A 34 01 00 04 00 00 01 4C 3A 34 01 00 04 00 00 01 4D 3A 34 01 00 04 00 00 01 4E 3A 34 01 00 04 00 00 01 4F 3A 34 01 00 04 00 00 01 50 3A 34 01 00 04 00 00 01 51 3A 34 01 00 04 00 00 01 52 3A 34 01 00 04 00 00 01 53 3A 34 01 00 04 00 00 01 54 3A 34 01 00 04 00 00 01 55 3A 34 01 00 04 00 00 01 56 3A 34 01 00 04 00 00 01 57 3A 34 01 00 04 00 00 01 58 3A 34 01 00 04 00 00 01 59 3A 34 01 00 04 00 00 01 5A 3A 34 01 00 04 00 00 01 5B 3A 34 01 00 04 00 00 01 5C 3A 34 01 00 04 00 00 01 5D 3A 34 01 00 04 00 00 01 5F 3A 34 01 00 04 00 00 01 60 3A 34 01 00 04 00 00 01 61 3A 34 01 00 04 00 00 01 62 3A 34 01 00 04 00 00 01 63 3A 34 01 00 04 00 00 01 64 3A 34 01 00 04 00 00 01 65 3A 34 01 00 04 00 00 01 66 3A 34 01 00 04 00 00 01 67 3A 34 01 00 04 00 00 01 68 3A 34 01 00 04 00 00 01 69 3A 34 01 00 04 00 00 01 70 3A 34 01 00 04 00 00 01 73 3A 34 01 00 04 00 00 01 74 3A 34 01 00 04 00 00 01 75 3A 34 01 00 04 00 00 01 7A 3A 34 01 00 04 00 00 01 7B 3A 34 01 00 0C 00 00 01 02 7D 3A 34 01 00 04 00 00 01 7E 3A 34 01 00 04 00 00 01 7F 3A 34 01 00 04 00 00 01 81 3A 34 01 00 0C 00 00 01 02 82 3A 34 01 00 04 00 00 01 83 3A 34 01 00 04 00 00 01 84 3A 34 01 00 0C 00 00 01 02 85 3A 34 01 00 04 00 00 01 88 3A 34 01 00 04 00 00 01 89 3A 34 01 00 04 00 00 01 8A 3A 34 01 00 04 00 00 01 8B 3A 34 01 00 04 00 00 01 92 3A 34 01 00 04 00 00 01 93 3A 34 01 00 0C 00 00 01 02 95 3A 34 01 00 0C 00 00 01 02 96 3A 34 01 00 0C 00 00 01 02 98 3A 34 01 00 04 00 00 01 99 3A 34 01 00 0C 00 00 01 02 9A 3A 34 01 00 04 00 00 01 9B 3A 34 01 10 0C 00 00 5A 01 02 EA C0 35 01 00 04 00 00 01 EB C0 35 01 00 04 00 00 01 EC C0 35 01 00 04 00 00 01 ED C0 35 01 00 04 00 00 01 EE C0 35 01 00 04 00 00 01 EF C0 35 01 00 04 00 00 01 F0 C0 35 01 00 04 00 00 01 F3 C0 35 01 00 04 00 00 01 F4 C0 35 01 00 04 00 00 01 F5 C0 35 01 00 04 00 00 01 F6 C0 35 01 00 04 00 00 01 F7 C0 35 01 00 04 00 00 01 F8 C0 35 01 00 08 00 00 03 F9 C0 35 01 10 00 00 00 05 FA C0 35 01 10 00 00 00 05 FB C0 35 01 00 04 00 00 01 FC C0 35 01 00 04 00 00 01 01 C1 35 01 00 04 00 00 01 02 C1 35 01 00 04 00 00 01 03 C1 35 01 00 04 00 00 01 04 C1 35 01 00 04 00 00 01 05 C1 35 01 00 04 00 00 01 06 C1 35 01 00 04 00 00 01 07 C1 35 01 00 04 00 00 01 08 C1 35 01 00 04 00 00 01 09 C1 35 01 00 04 00 00 01 0A C1 35 01 00 04 00 00 01 0B C1 35 01 00 04 00 00 01 0C C1 35 01 00 04 00 00 01 0D C1 35 01 00 04 00 00 01 0E C1 35 01 00 04 00 00 01 0F C1 35 01 00 04 00 00 01 10 C1 35 01 00 04 00 00 01 11 C1 35 01 00 04 00 00 01 12 C1 35 01 00 04 00 00 01 13 C1 35 01 00 04 00 00 01 14 C1 35 01 00 04 00 00 01 15 C1 35 01 00 04 00 00 01 16 C1 35 01 00 04 00 00 01 17 C1 35 01 00 04 00 00 01 18 C1 35 01 00 04 00 00 01 19 C1 35 01 00 0C 00 00 01 02 1A C1 35 01 00 04 00 00 01 1B C1 35 01 00 04 00 00 01 1C C1 35 01 00 04 00 00 01 1D C1 35 01 00 04 00 00 01 1E C1 35 01 00 04 00 00 01 1F C1 35 01 00 04 00 00 01 20 C1 35 01 00 04 00 00 01 21 C1 35 01 00 04 00 00 01 2E C1 35 01 00 04 00 00 01 2F C1 35 01 00 04 00 00 01 38 C1 35 01 00 04 00 00 01 39 C1 35 01 00 04 00 00 01 3A C1 35 01 00 04 00 00 01 3F C1 35 01 00 04 00 00 01 40 C1 35 01 00 04 00 00 01 41 C1 35 01 00 04 00 00 01 42 C1 35 01 00 04 00 00 01 44 C1 35 01 00 04 00 00 01 47 C1 35 01 00 04 00 00 01 48 C1 35 01 00 04 00 00 01 49 C1 35 01 10 00 00 00 05 4A C1 35 01 10 00 00 00 05 4B C1 35 01 00 04 00 00 01 4C C1 35 01 00 04 00 00 01 4D C1 35 01 00 04 00 00 01 4E C1 35 01 00 04 00 00 01 51 C1 35 01 00 04 00 00 01 52 C1 35 01 00 04 00 00 01 53 C1 35 01 00 04 00 00 01 54 C1 35 01 00 04 00 00 01 55 C1 35 01 00 04 00 00 01 56 C1 35 01 00 04 00 00 01 5C C1 35 01 00 04 00 00 01 5D C1 35 01 00 04 00 00 01 5E C1 35 01 00 04 00 00 01 5F C1 35 01 00 04 00 00 01 60 C1 35 01 00 04 00 00 01 61 C1 35 01 00 04 00 00 01 62 C1 35 01 00 04 00 00 01 63 C1 35 01 00 04 00 00 01 64 C1 35 01 00 04 00 00 01 65 C1 35 01 00 04 00 00 01 66 C1 35 01 00 04 00 00 01 67 C1 35 01 00 04 00 00 01 68 C1 35 01 00 04 00 00 01 69 C1 35 01 00 04 00 00 01 6A C1 35 01 00 04 00 00 01 6B C1 35 01 00 04 00 00 01 6C C1 35 01 00 04 00 00 01 6D C1 35 01 00 04 00 00 01 6E C1 35 01 00 04 00 00 01 6F C1 35 01 00 04 00 00 01 70 C1 35 01 00 04 00 00 01 71 C1 35 01 00 04 00 00 01 72 C1 35 01 00 04 00 00 01 73 C1 35 01 00 04 00 00 01 74 C1 35 01 00 04 00 00 01 75 C1 35 01 00 04 00 00 01 76 C1 35 01 00 04 00 00 01 77 C1 35 01 00 04 00 00 01 78 C1 35 01 00 04 00 00 01 79 C1 35 01 00 04 00 00 01 7A C1 35 01 00 04 00 00 01 7B C1 35 01 00 04 00 00 01 7C C1 35 01 00 04 00 00 01 7D C1 35 01 00 04 00 00 01 7E C1 35 01 00 04 00 00 01 7F C1 35 01 00 04 00 00 01 86 C1 35 01 00 08 00 00 03 87 C1 35 01 00 08 00 00 03 88 C1 35 01 00 04 00 00 01 89 C1 35 01 00 04 00 00 01 8A C1 35 01 00 04 00 00 01 8B C1 35 01 00 04 00 00 01 8D C1 35 01 00 04 00 00 01 90 C1 35 01 00 04 00 00 01 94 C1 35 01 00 04 00 00 01 98 C1 35 01 00 04 00 00 01 99 C1 35 01 00 04 00 00 01 9D C1 35 01 00 04 00 00 01 9E C1 35 01 00 04 00 00 01 A2 C1 35 01 00 08 00 00 03 A3 C1 35 01 00 04 00 00 01 A4 C1 35 01 00 04 00 00 01 A5 C1 35 01 00 04 00 00 01 A6 C1 35 01 00 04 00 00 01 A7 C1 35 01 00 04 00 00 01 AA C1 35 01 00 04 00 00 01 AB C1 35 01 00 04 00 00 01 AC C1 35 01 00 04 00 00 01 AD C1 35 01 00 04 00 00 01 AE C1 35 01 00 04 00 00 01 B0 C1 35 01 00 04 00 00 01 B1 C1 35 01 00 04 00 00 01 B2 C1 35 01 00 04 00 00 01 B3 C1 35 01 00 04 00 00 01 B4 C1 35 01 00 04 00 00 01 B5 C1 35 01 00 04 00 00 01 B6 C1 35 01 00 04 00 00 01 B7 C1 35 01 00 04 00 00 01 B8 C1 35 01 00 04 00 00 01 B9 C1 35 01 00 04 00 00 01 BF C1 35 01 00 04 00 00 01 C0 C1 35 01 00 0C 00 00 01 02 C1 C1 35 01 00 0C 00 00 01 02 C2 C1 35 01 00 04 00 00 01 CA C1 35 01 00 0C 00 00 01 02 CD C1 35 01 00 04 00 00 01 CE C1 35 01 00 04 00 00 01 CF C1 35 01 00 04 00 00 01 D0 C1 35 01 00 04 00 00 01 D1 C1 35 01 00 04 00 00 01 D2 C1 35 01 10 00 00 00 05 D3 C1 35 01 00 04 00 00 01 D8 C1 35 01 00 0C 00 00 01 02 D9 C1 35 01 00 04 00 00 01 DA C1 35 01 00 04 00 00 01 DB C1 35 01 00 04 00 00 01 DC C1 35 01 00 04 00 00 01 DD C1 35 01 00 04 00 00 01 DE C1 35 01 00 04 00 00 01 DF C1 35 01 00 0C 00 00 01 02 E7 C1 35 01 00 04 00 00 01 E8 C1 35 01 00 04 00 00 01 E9 C1 35 01 00 04 00 00 01 F1 C1 35 01 00 0C 00 00 01 02 F2 C1 35 01 00 04 00 00 01 F4 C1 35 01 00 08 00 00 00 F5 C1 35 01 00 0C 00 00 01 02 F6 C1 35 01 00 0C 00 00 01 02 F7 C1 35 01 00 0C 00 00 01 02 F8 C1 35 01 00 08 00 00 00 F9 C1 35 01 00 0C 00 00 01 02 FC C1 35 01 00 0C 00 00 01 02 02 C2 35 01 00 04 00 00 01 03 C2 35 01 00 04 00 00 01 04 C2 35 01 00 08 00 00 00 06 C2 35 01 00 08 00 00 00 07 C2 35 01 10 04 00 00 55 01 8E 47 37 01 00 04 00 00 01 8F 47 37 01 00 04 00 00 01 90 47 37 01 00 04 00 00 01 91 47 37 01 00 04 00 00 01 92 47 37 01 00 04 00 00 01 93 47 37 01 00 04 00 00 01 94 47 37 01 00 04 00 00 01 95 47 37 01 00 04 00 00 01 96 47 37 01 00 04 00 00 01 97 47 37 01 00 04 00 00 01 98 47 37 01 00 04 00 00 01 99 47 37 01 00 04 00 00 01 9A 47 37 01 00 04 00 00 01 9B 47 37 01 00 04 00 00 01 9C 47 37 01 00 04 00 00 01 9D 47 37 01 00 04 00 00 01 9E 47 37 01 00 0C 00 00 01 02 9F 47 37 01 00 04 00 00 01 A0 47 37 01 00 04 00 00 01 A1 47 37 01 00 04 00 00 01 A4 47 37 01 00 04 00 00 01 A5 47 37 01 00 04 00 00 01 A6 47 37 01 00 04 00 00 01 A7 47 37 01 00 04 00 00 01 A8 47 37 01 00 04 00 00 01 A9 47 37 01 00 04 00 00 01 AB 47 37 01 00 04 00 00 01 AC 47 37 01 00 04 00 00 01 AD 47 37 01 00 04 00 00 01 AE 47 37 01 00 04 00 00 01 AF 47 37 01 00 04 00 00 01 B0 47 37 01 00 04 00 00 01 B1 47 37 01 00 04 00 00 01 B2 47 37 01 00 04 00 00 01 B4 47 37 01 00 04 00 00 01 B5 47 37 01 00 04 00 00 01 BA 47 37 01 00 04 00 00 01 BB 47 37 01 00 04 00 00 01 BC 47 37 01 00 04 00 00 01 BD 47 37 01 00 04 00 00 01 BE 47 37 01 00 04 00 00 01 BF 47 37 01 00 04 00 00 01 C0 47 37 01 00 04 00 00 01 C1 47 37 01 00 04 00 00 01 C2 47 37 01 00 04 00 00 01 C5 47 37 01 00 04 00 00 01 CA 47 37 01 00 04 00 00 01 CB 47 37 01 00 04 00 00 01 CC 47 37 01 00 04 00 00 01 CD 47 37 01 00 04 00 00 01 CE 47 37 01 00 04 00 00 01 D0 47 37 01 00 04 00 00 01 D1 47 37 01 00 04 00 00 01 D2 47 37 01 00 04 00 00 01 D3 47 37 01 00 04 00 00 01 D4 47 37 01 00 04 00 00 01 D7 47 37 01 00 04 00 00 01 D8 47 37 01 00 04 00 00 01 D9 47 37 01 00 04 00 00 01 DD 47 37 01 00 04 00 00 01 DE 47 37 01 00 04 00 00 01 DF 47 37 01 00 04 00 00 01 E7 47 37 01 00 04 00 00 01 E8 47 37 01 00 04 00 00 01 E9 47 37 01 00 04 00 00 01 EA 47 37 01 00 04 00 00 01 EB 47 37 01 00 04 00 00 01 EC 47 37 01 00 04 00 00 01 EF 47 37 01 00 04 00 00 01 F0 47 37 01 00 08 00 00 03 F1 47 37 01 00 04 00 00 01 F3 47 37 01 00 04 00 00 01 F4 47 37 01 00 04 00 00 01 F5 47 37 01 00 04 00 00 01 F6 47 37 01 00 04 00 00 01 F7 47 37 01 00 04 00 00 01 F8 47 37 01 00 04 00 00 01 F9 47 37 01 00 04 00 00 01 FA 47 37 01 00 04 00 00 01 FB 47 37 01 00 04 00 00 01 FC 47 37 01 00 04 00 00 01 FD 47 37 01 00 04 00 00 01 FE 47 37 01 00 04 00 00 01 FF 47 37 01 00 04 00 00 01 01 48 37 01 00 04 00 00 01 02 48 37 01 00 04 00 00 01 06 48 37 01 00 04 00 00 01 08 48 37 01 00 04 00 00 01 0B 48 37 01 10 00 00 00 02 0D 48 37 01 00 04 00 00 01 0F 48 37 01 00 04 00 00 01 10 48 37 01 00 04 00 00 01 11 48 37 01 00 04 00 00 01 12 48 37 01 00 04 00 00 01 13 48 37 01 00 04 00 00 01 14 48 37 01 00 04 00 00 01 15 48 37 01 00 04 00 00 01 17 48 37 01 00 04 00 00 01 18 48 37 01 00 04 00 00 01 19 48 37 01 00 04 00 00 01 1B 48 37 01 00 08 00 00 02 1F 48 37 01 00 04 00 00 01 20 48 37 01 00 04 00 00 01 21 48 37 01 00 04 00 00 01 22 48 37 01 00 04 00 00 01 23 48 37 01 00 04 00 00 01 24 48 37 01 00 04 00 00 01 25 48 37 01 00 04 00 00 01 26 48 37 01 00 04 00 00 01 27 48 37 01 00 04 00 00 01 28 48 37 01 00 04 00 00 01 29 48 37 01 00 04 00 00 01 2A 48 37 01 00 04 00 00 01 33 48 37 01 00 08 00 00 02 38 48 37 01 14 0C 00 00 62 41 03 00 00 01 01 39 48 37 01 00 04 00 00 01 3A 48 37 01 00 04 00 00 01 3B 48 37 01 00 04 00 00 01 3C 48 37 01 00 04 00 00 01 3E 48 37 01 00 08 00 00 02 43 48 37 01 00 04 00 00 01 44 48 37 01 00 0C 00 00 01 02 4C 48 37 01 00 04 00 00 01 4D 48 37 01 00 04 00 00 01 4E 48 37 01 00 04 00 00 01 50 48 37 01 00 04 00 00 01 51 48 37 01 00 04 00 00 01 52 48 37 01 00 04 00 00 01 53 48 37 01 00 04 00 00 01 54 48 37 01 00 04 00 00 01 55 48 37 01 00 04 00 00 01 56 48 37 01 00 04 00 00 01 58 48 37 01 00 04 00 00 01 59 48 37 01 00 04 00 00 01 5A 48 37 01 00 0C 00 00 01 02 5B 48 37 01 00 0C 00 00 01 02 5D 48 37 01 00 04 00 00 01 5E 48 37 01 00 04 00 00 01 5F 48 37 01 00 04 00 00 01 60 48 37 01 00 04 00 00 01 62 48 37 01 00 0C 00 00 01 02 63 48 37 01 00 04 00 00 01 64 48 37 01 00 0C 00 00 01 02 66 48 37 01 00 0C 00 00 01 02 67 48 37 01 00 0C 00 00 01 02 68 48 37 01 00 0C 00 00 01 02 69 48 37 01 00 0C 00 00 01 02 6A 48 37 01 00 08 00 00 00 6B 48 37 01 00 0C 00 00 01 02 6C 48 37 01 00 0C 00 00 01 02 6E 48 37 01 00 0C 00 00 01 02 6F 48 37 01 00 0C 00 00 01 02 70 48 37 01 00 04 00 00 01 71 48 37 01 10 04 00 00 55 01 72 48 37 01 10 04 00 00 61 01 73 48 37 01 10 04 00 00 55 01 74 48 37 01 00 0C 00 00 01 00 31 CE 38 01 00 04 00 00 01 32 CE 38 01 00 04 00 00 01 33 CE 38 01 00 04 00 00 01 34 CE 38 01 00 04 00 00 01 35 CE 38 01 00 04 00 00 01 36 CE 38 01 00 04 00 00 01 37 CE 38 01 00 04 00 00 01 38 CE 38 01 00 04 00 00 01 39 CE 38 01 00 04 00 00 01 3A CE 38 01 00 08 00 00 02 3B CE 38 01 00 04 00 00 01 3C CE 38 01 00 04 00 00 01 3D CE 38 01 00 04 00 00 01 3E CE 38 01 00 04 00 00 01 3F CE 38 01 00 04 00 00 01 40 CE 38 01 00 04 00 00 01 41 CE 38 01 00 0C 00 00 01 02 42 CE 38 01 00 04 00 00 01 43 CE 38 01 00 04 00 00 01 44 CE 38 01 00 04 00 00 01 45 CE 38 01 00 04 00 00 01 46 CE 38 01 00 04 00 00 01 47 CE 38 01 00 04 00 00 01 48 CE 38 01 00 04 00 00 01 49 CE 38 01 00 04 00 00 01 4A CE 38 01 00 04 00 00 01 4B CE 38 01 00 04 00 00 01 4C CE 38 01 00 04 00 00 01 4D CE 38 01 00 04 00 00 01 4E CE 38 01 00 04 00 00 01 4F CE 38 01 00 04 00 00 01 50 CE 38 01 00 04 00 00 01 51 CE 38 01 00 04 00 00 01 52 CE 38 01 00 04 00 00 01 53 CE 38 01 00 04 00 00 01 56 CE 38 01 00 04 00 00 01 58 CE 38 01 00 04 00 00 01 59 CE 38 01 00 04 00 00 01 5A CE 38 01 00 04 00 00 01 5B CE 38 01 00 04 00 00 01 5C CE 38 01 00 04 00 00 01 5D CE 38 01 00 04 00 00 01 5E CE 38 01 00 04 00 00 01 5F CE 38 01 00 04 00 00 01 60 CE 38 01 00 04 00 00 01 61 CE 38 01 00 04 00 00 01 62 CE 38 01 00 04 00 00 01 63 CE 38 01 00 04 00 00 01 64 CE 38 01 00 04 00 00 01 65 CE 38 01 00 04 00 00 01 67 CE 38 01 00 04 00 00 01 69 CE 38 01 00 04 00 00 01 6A CE 38 01 00 04 00 00 01 6B CE 38 01 00 04 00 00 01 6C CE 38 01 00 04 00 00 01 6D CE 38 01 00 04 00 00 01 6E CE 38 01 00 04 00 00 01 70 CE 38 01 00 04 00 00 01 71 CE 38 01 00 04 00 00 01 75 CE 38 01 00 04 00 00 01 76 CE 38 01 00 0C 00 00 01 02 77 CE 38 01 00 04 00 00 01 78 CE 38 01 00 04 00 00 01 79 CE 38 01 00 04 00 00 01 7A CE 38 01 00 04 00 00 01 7C CE 38 01 00 04 00 00 01 7D CE 38 01 00 04 00 00 01 7E CE 38 01 00 04 00 00 01 82 CE 38 01 00 08 00 00 03 83 CE 38 01 00 08 00 00 02 84 CE 38 01 10 04 00 00 01 01 85 CE 38 01 00 04 00 00 01 86 CE 38 01 00 04 00 00 01 87 CE 38 01 00 04 00 00 01 88 CE 38 01 00 04 00 00 01 89 CE 38 01 00 04 00 00 01 8A CE 38 01 00 04 00 00 01 8D CE 38 01 00 04 00 00 01 8E CE 38 01 00 04 00 00 01 8F CE 38 01 00 0C 00 00 01 02 90 CE 38 01 00 04 00 00 01 91 CE 38 01 00 08 00 00 02 92 CE 38 01 00 04 00 00 01 93 CE 38 01 00 04 00 00 01 94 CE 38 01 00 04 00 00 01 95 CE 38 01 00 04 00 00 01 96 CE 38 01 00 04 00 00 01 97 CE 38 01 00 04 00 00 01 98 CE 38 01 00 04 00 00 01 99 CE 38 01 00 04 00 00 01 A2 CE 38 01 00 04 00 00 01 A3 CE 38 01 00 04 00 00 01 A7 CE 38 01 00 04 00 00 01 A9 CE 38 01 00 04 00 00 01 AA CE 38 01 00 0C 00 00 01 02 AB CE 38 01 00 04 00 00 01 AC CE 38 01 00 04 00 00 01 AD CE 38 01 00 04 00 00 01 B2 CE 38 01 00 04 00 00 01 B3 CE 38 01 00 04 00 00 01 B4 CE 38 01 00 04 00 00 01 B5 CE 38 01 00 04 00 00 01 B8 CE 38 01 00 04 00 00 01 B9 CE 38 01 00 04 00 00 01 BA CE 38 01 00 04 00 00 01 BB CE 38 01 00 04 00 00 01 BC CE 38 01 00 04 00 00 01 BE CE 38 01 00 0C 00 00 01 02 BF CE 38 01 00 04 00 00 01 C0 CE 38 01 00 04 00 00 01 C1 CE 38 01 00 04 00 00 01 C2 CE 38 01 00 04 00 00 01 C3 CE 38 01 00 04 00 00 01 C4 CE 38 01 00 04 00 00 01 C5 CE 38 01 00 04 00 00 01 CB CE 38 01 00 04 00 00 01 CC CE 38 01 00 0C 00 00 01 02 CD CE 38 01 00 0C 00 00 01 02 CE CE 38 01 00 04 00 00 01 CF CE 38 01 00 04 00 00 01 D0 CE 38 01 10 04 00 00 61 01 C9 54 3A 01 00 04 00 00 01 CA 54 3A 01 00 04 00 00 01 CB 54 3A 01 00 04 00 00 01 CC 54 3A 01 00 04 00 00 01 CD 54 3A 01 00 04 00 00 01 D0 54 3A 01 00 04 00 00 01 D1 54 3A 01 00 04 00 00 01 D2 54 3A 01 00 04 00 00 01 D3 54 3A 01 00 04 00 00 01 D4 54 3A 01 00 04 00 00 01 D5 54 3A 01 00 04 00 00 01 D6 54 3A 01 10 00 00 00 05 D7 54 3A 01 10 00 00 00 05 D8 54 3A 01 00 04 00 00 01 D9 54 3A 01 00 04 00 00 01 DA 54 3A 01 00 04 00 00 01 DB 54 3A 01 00 04 00 00 01 DC 54 3A 01 00 04 00 00 01 DD 54 3A 01 00 04 00 00 01 DE 54 3A 01 00 0C 00 00 01 02 DF 54 3A 01 00 04 00 00 01 E0 54 3A 01 00 04 00 00 01 E1 54 3A 01 00 04 00 00 01 E2 54 3A 01 00 0C 00 00 01 02 E3 54 3A 01 00 04 00 00 01 E4 54 3A 01 00 04 00 00 01 E5 54 3A 01 00 04 00 00 01 E6 54 3A 01 00 04 00 00 01 E7 54 3A 01 00 04 00 00 01 E8 54 3A 01 00 04 00 00 01 E9 54 3A 01 00 04 00 00 01 EA 54 3A 01 00 04 00 00 01 EB 54 3A 01 00 04 00 00 01 FC 54 3A 01 00 04 00 00 01 FD 54 3A 01 00 04 00 00 01 FE 54 3A 01 00 04 00 00 01 FF 54 3A 01 00 04 00 00 01 00 55 3A 01 00 04 00 00 01 01 55 3A 01 00 04 00 00 01 02 55 3A 01 00 04 00 00 01 03 55 3A 01 00 04 00 00 01 05 55 3A 01 00 04 00 00 01 06 55 3A 01 00 04 00 00 01 07 55 3A 01 00 04 00 00 01 08 55 3A 01 00 04 00 00 01 09 55 3A 01 00 04 00 00 01 0A 55 3A 01 00 04 00 00 01 0B 55 3A 01 00 04 00 00 01 0F 55 3A 01 00 04 00 00 01 10 55 3A 01 00 04 00 00 01 11 55 3A 01 00 04 00 00 01 12 55 3A 01 00 04 00 00 01 13 55 3A 01 00 04 00 00 01 14 55 3A 01 00 04 00 00 01 15 55 3A 01 00 04 00 00 01 16 55 3A 01 00 04 00 00 01 17 55 3A 01 00 04 00 00 01 18 55 3A 01 00 04 00 00 01 19 55 3A 01 00 04 00 00 01 1A 55 3A 01 00 04 00 00 01 1B 55 3A 01 00 04 00 00 01 1C 55 3A 01 00 04 00 00 01 1D 55 3A 01 00 04 00 00 01 1E 55 3A 01 00 04 00 00 01 1F 55 3A 01 00 04 00 00 01 20 55 3A 01 00 04 00 00 01 21 55 3A 01 00 04 00 00 01 22 55 3A 01 00 04 00 00 01 23 55 3A 01 00 04 00 00 01 24 55 3A 01 00 04 00 00 01 25 55 3A 01 00 04 00 00 01 26 55 3A 01 00 04 00 00 01 27 55 3A 01 00 08 00 00 02 2B 55 3A 01 00 04 00 00 01 2F 55 3A 01 00 04 00 00 01 31 55 3A 01 00 08 00 00 03 32 55 3A 01 10 00 00 00 05 33 55 3A 01 00 04 00 00 01 38 55 3A 01 00 04 00 00 01 39 55 3A 01 00 0C 00 00 01 02 3A 55 3A 01 00 04 00 00 01 3B 55 3A 01 00 04 00 00 01 3C 55 3A 01 00 04 00 00 01 3D 55 3A 01 00 04 00 00 01 3E 55 3A 01 00 04 00 00 01 3F 55 3A 01 00 04 00 00 01 40 55 3A 01 00 04 00 00 01 41 55 3A 01 00 04 00 00 01 42 55 3A 01 00 04 00 00 01 45 55 3A 01 00 04 00 00 01 46 55 3A 01 00 04 00 00 01 47 55 3A 01 00 04 00 00 01 4C 55 3A 01 00 04 00 00 01 51 55 3A 01 00 04 00 00 01 53 55 3A 01 00 04 00 00 01 59 55 3A 01 00 04 00 00 01 5A 55 3A 01 00 04 00 00 01 5B 55 3A 01 00 0C 00 00 01 02 5D 55 3A 01 00 0C 00 00 01 02 60 55 3A 01 00 0C 00 00 01 02 61 55 3A 01 00 0C 00 00 01 02 65 55 3A 01 00 0C 00 00 01 02 66 55 3A 01 00 0C 00 00 01 02 68 55 3A 01 10 0C 00 00 5A 01 02 61 DB 3B 01 00 04 00 00 01 62 DB 3B 01 00 04 00 00 01 63 DB 3B 01 00 04 00 00 01 64 DB 3B 01 10 00 00 00 05 65 DB 3B 01 00 0C 00 00 01 02 66 DB 3B 01 00 04 00 00 01 69 DB 3B 01 00 04 00 00 01 6A DB 3B 01 00 04 00 00 01 6C DB 3B 01 00 04 00 00 01 6D DB 3B 01 00 04 00 00 01 6E DB 3B 01 00 08 00 00 03 6F DB 3B 01 00 04 00 00 01 70 DB 3B 01 00 04 00 00 01 71 DB 3B 01 00 04 00 00 01 72 DB 3B 01 00 04 00 00 01 73 DB 3B 01 00 04 00 00 01 74 DB 3B 01 00 0C 00 00 01 02 75 DB 3B 01 00 04 00 00 01 76 DB 3B 01 00 0C 00 00 01 02 77 DB 3B 01 00 0C 00 00 01 02 78 DB 3B 01 00 04 00 00 01 79 DB 3B 01 00 04 00 00 01 7F DB 3B 01 00 0C 00 00 01 02 80 DB 3B 01 00 04 00 00 01 81 DB 3B 01 00 04 00 00 01 85 DB 3B 01 00 0C 00 00 01 02 86 DB 3B 01 00 0C 00 00 01 02 8A DB 3B 01 00 04 00 00 01 08 62 3D 01 00 04 00 00 01 09 62 3D 01 00 04 00 00 01 0A 62 3D 01 00 04 00 00 01 0B 62 3D 01 00 04 00 00 01 0C 62 3D 01 00 04 00 00 01 0D 62 3D 01 10 00 00 00 05 0E 62 3D 01 10 00 00 00 05 0F 62 3D 01 10 00 00 00 05 10 62 3D 01 00 04 00 00 01 11 62 3D 01 00 04 00 00 01 12 62 3D 01 00 04 00 00 01 13 62 3D 01 00 04 00 00 01 14 62 3D 01 00 04 00 00 01 15 62 3D 01 00 04 00 00 01 16 62 3D 01 00 04 00 00 01 17 62 3D 01 00 04 00 00 01 18 62 3D 01 00 04 00 00 01 19 62 3D 01 00 04 00 00 01 1A 62 3D 01 00 04 00 00 01 1B 62 3D 01 00 04 00 00 01 1C 62 3D 01 00 04 00 00 01 1D 62 3D 01 00 04 00 00 01 1E 62 3D 01 00 04 00 00 01 1F 62 3D 01 00 04 00 00 01 20 62 3D 01 00 04 00 00 01 21 62 3D 01 00 04 00 00 01 22 62 3D 01 00 04 00 00 01 23 62 3D 01 00 04 00 00 01 24 62 3D 01 00 04 00 00 01 25 62 3D 01 00 04 00 00 01 26 62 3D 01 00 04 00 00 01 27 62 3D 01 00 04 00 00 01 28 62 3D 01 00 04 00 00 01 29 62 3D 01 00 04 00 00 01 2A 62 3D 01 00 04 00 00 01 2B 62 3D 01 00 04 00 00 01 2D 62 3D 01 00 04 00 00 01 2E 62 3D 01 00 04 00 00 01 2F 62 3D 01 00 04 00 00 01 30 62 3D 01 00 04 00 00 01 31 62 3D 01 00 0C 00 00 01 02 32 62 3D 01 00 04 00 00 01 33 62 3D 01 00 04 00 00 01 34 62 3D 01 00 04 00 00 01 36 62 3D 01 00 04 00 00 01 37 62 3D 01 00 04 00 00 01 38 62 3D 01 00 04 00 00 01 39 62 3D 01 00 04 00 00 01 3A 62 3D 01 00 04 00 00 01 3B 62 3D 01 00 04 00 00 01 3C 62 3D 01 00 04 00 00 01 3D 62 3D 01 00 04 00 00 01 3E 62 3D 01 00 04 00 00 01 3F 62 3D 01 00 04 00 00 01 40 62 3D 01 00 04 00 00 01 41 62 3D 01 00 04 00 00 01 42 62 3D 01 00 04 00 00 01 43 62 3D 01 00 04 00 00 01 44 62 3D 01 00 04 00 00 01 45 62 3D 01 00 04 00 00 01 46 62 3D 01 00 04 00 00 01 47 62 3D 01 00 04 00 00 01 48 62 3D 01 00 04 00 00 01 49 62 3D 01 00 04 00 00 01 4A 62 3D 01 00 04 00 00 01 4B 62 3D 01 00 04 00 00 01 4C 62 3D 01 00 04 00 00 01 4D 62 3D 01 00 04 00 00 01 4E 62 3D 01 00 04 00 00 01 4F 62 3D 01 00 04 00 00 01 51 62 3D 01 00 0C 00 00 01 02 52 62 3D 01 00 04 00 00 01 53 62 3D 01 00 0C 00 00 01 02 54 62 3D 01 00 04 00 00 01 56 62 3D 01 00 0C 00 00 01 02 57 62 3D 01 00 04 00 00 01 58 62 3D 01 00 04 00 00 01 59 62 3D 01 00 04 00 00 01 5C 62 3D 01 00 04 00 00 01 5D 62 3D 01 00 04 00 00 01 5E 62 3D 01 00 04 00 00 01 5F 62 3D 01 00 04 00 00 01 60 62 3D 01 00 04 00 00 01 62 62 3D 01 00 04 00 00 01 63 62 3D 01 00 04 00 00 01 64 62 3D 01 00 04 00 00 01 65 62 3D 01 00 04 00 00 01 66 62 3D 01 00 04 00 00 01 67 62 3D 01 00 0C 00 00 01 02 6E 62 3D 01 00 04 00 00 01 6F 62 3D 01 00 04 00 00 01 70 62 3D 01 00 04 00 00 01 71 62 3D 01 00 0C 00 00 01 02 72 62 3D 01 00 04 00 00 01 73 62 3D 01 00 04 00 00 01 74 62 3D 01 00 04 00 00 01 77 62 3D 01 00 04 00 00 01 78 62 3D 01 00 04 00 00 01 79 62 3D 01 00 04 00 00 01 7A 62 3D 01 00 04 00 00 01 7B 62 3D 01 00 04 00 00 01 7C 62 3D 01 10 00 00 00 05 7D 62 3D 01 00 04 00 00 01 7E 62 3D 01 10 04 00 00 04 01 7F 62 3D 01 00 0C 00 00 01 02 84 62 3D 01 00 0C 00 00 01 02 85 62 3D 01 00 04 00 00 01 86 62 3D 01 00 0C 00 00 01 02 88 62 3D 01 00 04 00 00 01 89 62 3D 01 00 04 00 00 01 8A 62 3D 01 00 04 00 00 01 8B 62 3D 01 00 0C 00 00 01 02 8C 62 3D 01 00 0C 00 00 01 02 8D 62 3D 01 00 04 00 00 01 8E 62 3D 01 00 04 00 00 01 8F 62 3D 01 00 04 00 00 01 90 62 3D 01 00 04 00 00 01 91 62 3D 01 00 04 00 00 01 94 62 3D 01 00 0C 00 00 01 02 95 62 3D 01 00 04 00 00 01 96 62 3D 01 00 04 00 00 01 97 62 3D 01 00 0C 00 00 01 02 98 62 3D 01 00 0C 00 00 01 02 99 62 3D 01 00 0C 00 00 01 02 9A 62 3D 01 00 0C 00 00 01 02 9B 62 3D 01 00 04 00 00 01 9C 62 3D 01 00 04 00 00 01 9D 62 3D 01 00 04 00 00 01 A2 62 3D 01 00 04 00 00 01 A3 62 3D 01 00 04 00 00 01 A4 62 3D 01 00 04 00 00 01 A5 62 3D 01 00 04 00 00 01 A6 62 3D 01 00 0C 00 00 01 02 A7 62 3D 01 10 00 00 00 05 A8 62 3D 01 10 00 00 00 05 A9 62 3D 01 10 00 00 00 05 AA 62 3D 01 10 00 00 00 05 AB 62 3D 01 00 0C 00 00 01 02 AC 62 3D 01 10 00 00 00 05 AD 62 3D 01 00 0C 00 00 01 02 AE 62 3D 01 00 04 00 00 01 B0 62 3D 01 00 0C 00 00 01 02 B1 62 3D 01 00 0C 00 00 01 02 B2 62 3D 01 00 04 00 00 01 B3 62 3D 01 00 04 00 00 01 B4 62 3D 01 00 04 00 00 01 B8 62 3D 01 00 0C 00 00 01 02 B9 62 3D 01 00 0C 00 00 01 02 BA 62 3D 01 00 04 00 00 01 BB 62 3D 01 00 0C 00 00 01 02 BC 62 3D 01 00 04 00 00 01 BD 62 3D 01 00 04 00 00 01 BE 62 3D 01 00 0C 00 00 01 02 BF 62 3D 01 00 0C 00 00 01 02 C0 62 3D 01 00 04 00 00 01 C1 62 3D 01 00 0C 00 00 01 02 C2 62 3D 01 00 04 00 00 01 C3 62 3D 01 00 0C 00 00 01 02 C5 62 3D 01 00 0C 00 00 01 02 C6 62 3D 01 00 08 00 00 00 C7 62 3D 01 10 0C 00 00 5A 01 02 C9 62 3D 01 00 08 00 00 00 CA 62 3D 01 10 0C 00 00 5A 01 02 CB 62 3D 01 00 08 00 00 00 CC 62 3D 01 10 0C 00 00 60 01 02 CD 62 3D 01 00 08 00 00 00 CE 62 3D 01 00 0C 00 00 01 02 D2 62 3D 01 00 0C 00 00 01 00 A8 E8 3E 01 00 04 00 00 01 A9 E8 3E 01 00 04 00 00 01 AA E8 3E 01 00 04 00 00 01 AB E8 3E 01 00 04 00 00 01 AC E8 3E 01 00 04 00 00 01 AD E8 3E 01 00 04 00 00 01 AE E8 3E 01 00 04 00 00 01 AF E8 3E 01 00 04 00 00 01 B0 E8 3E 01 00 04 00 00 01 B1 E8 3E 01 00 04 00 00 01 B2 E8 3E 01 00 04 00 00 01 B3 E8 3E 01 00 04 00 00 01 B4 E8 3E 01 00 04 00 00 01 B5 E8 3E 01 00 04 00 00 01 B6 E8 3E 01 00 04 00 00 01 B7 E8 3E 01 00 04 00 00 01 B8 E8 3E 01 00 04 00 00 01 B9 E8 3E 01 00 04 00 00 01 BA E8 3E 01 00 0C 00 00 01 02 BB E8 3E 01 00 04 00 00 01 BC E8 3E 01 00 04 00 00 01 BD E8 3E 01 00 04 00 00 01 BE E8 3E 01 00 04 00 00 01 BF E8 3E 01 00 04 00 00 01 C0 E8 3E 01 00 0C 00 00 01 02 C1 E8 3E 01 00 04 00 00 01 C2 E8 3E 01 00 04 00 00 01 C3 E8 3E 01 00 04 00 00 01 C4 E8 3E 01 00 04 00 00 01 C5 E8 3E 01 00 04 00 00 01 C6 E8 3E 01 00 04 00 00 01 C7 E8 3E 01 00 04 00 00 01 C8 E8 3E 01 00 04 00 00 01 CA E8 3E 01 00 04 00 00 01 CB E8 3E 01 00 04 00 00 01 CC E8 3E 01 00 04 00 00 01 CD E8 3E 01 10 04 00 00 01 01 CE E8 3E 01 00 0C 00 00 01 02 D2 E8 3E 01 00 04 00 00 01 D5 E8 3E 01 00 04 00 00 01 D6 E8 3E 01 00 04 00 00 01 D7 E8 3E 01 00 04 00 00 01 D8 E8 3E 01 00 04 00 00 01 D9 E8 3E 01 00 04 00 00 01 DA E8 3E 01 00 04 00 00 01 DB E8 3E 01 00 04 00 00 01 DC E8 3E 01 00 04 00 00 01 DD E8 3E 01 00 0C 00 00 01 02 DE E8 3E 01 00 0C 00 00 01 02 DF E8 3E 01 00 0C 00 00 01 02 E0 E8 3E 01 00 04 00 00 01 E1 E8 3E 01 00 04 00 00 01 E4 E8 3E 01 00 04 00 00 01 E5 E8 3E 01 00 04 00 00 01 E8 E8 3E 01 00 08 00 00 03 E9 E8 3E 01 00 0C 00 00 01 02 EA E8 3E 01 00 0C 00 00 01 02 EB E8 3E 01 00 0C 00 00 01 02 EC E8 3E 01 00 0C 00 00 01 02 EF E8 3E 01 00 08 00 00 00 51 6F 40 01 00 04 00 00 01 52 6F 40 01 00 04 00 00 01 53 6F 40 01 00 04 00 00 01 54 6F 40 01 00 04 00 00 01 55 6F 40 01 00 04 00 00 01 56 6F 40 01 00 04 00 00 01 57 6F 40 01 00 04 00 00 01 58 6F 40 01 00 04 00 00 01 59 6F 40 01 00 04 00 00 01 5A 6F 40 01 00 04 00 00 01 5B 6F 40 01 00 04 00 00 01 5C 6F 40 01 00 0C "));
        mplew.write(HexTool.getByteArrayFromHexString("00 00 01 02 5D 6F 40 01 00 04 00 00 01 5E 6F 40 01 00 0C 00 00 01 02 5F 6F 40 01 00 04 00 00 01 60 6F 40 01 00 04 00 00 01 61 6F 40 01 00 0C 00 00 01 02 62 6F 40 01 00 0C 00 00 01 02 63 6F 40 01 00 08 00 00 00 E0 F5 41 01 00 04 00 00 01 E1 F5 41 01 00 04 00 00 01 E2 F5 41 01 00 04 00 00 01 E3 F5 41 01 00 04 00 00 01 E4 F5 41 01 00 04 00 00 01 E5 F5 41 01 00 04 00 00 01 E6 F5 41 01 00 04 00 00 01 E7 F5 41 01 00 04 00 00 01 E8 F5 41 01 00 04 00 00 01 E9 F5 41 01 00 04 00 00 01 EA F5 41 01 00 04 00 00 01 EB F5 41 01 00 04 00 00 01 EC F5 41 01 00 0C 00 00 01 02 ED F5 41 01 00 04 00 00 01 EE F5 41 01 00 04 00 00 01 F1 F5 41 01 00 04 00 00 01 F2 F5 41 01 00 04 00 00 01 F3 F5 41 01 00 04 00 00 01 F4 F5 41 01 00 04 00 00 01 F6 F5 41 01 00 04 00 00 01 F7 F5 41 01 00 04 00 00 01 F8 F5 41 01 00 04 00 00 01 F9 F5 41 01 00 04 00 00 01 FA F5 41 01 10 00 00 00 05 FC F5 41 01 00 04 00 00 01 FE F5 41 01 00 04 00 00 01 FF F5 41 01 00 04 00 00 01 00 F6 41 01 00 04 00 00 01 01 F6 41 01 00 04 00 00 01 02 F6 41 01 00 04 00 00 01 03 F6 41 01 00 04 00 00 01 04 F6 41 01 00 04 00 00 01 08 F6 41 01 00 04 00 00 01 09 F6 41 01 00 04 00 00 01 0D F6 41 01 00 04 00 00 01 0E F6 41 01 00 04 00 00 01 0F F6 41 01 00 04 00 00 01 12 F6 41 01 00 04 00 00 01 13 F6 41 01 00 04 00 00 01 14 F6 41 01 00 04 00 00 01 19 F6 41 01 00 04 00 00 01 1A F6 41 01 00 04 00 00 01 1C F6 41 01 00 04 00 00 01 1D F6 41 01 00 04 00 00 01 1E F6 41 01 00 04 00 00 01 1F F6 41 01 00 04 00 00 01 20 F6 41 01 00 04 00 00 01 21 F6 41 01 00 04 00 00 01 22 F6 41 01 00 0C 00 00 01 02 23 F6 41 01 00 04 00 00 01 24 F6 41 01 00 04 00 00 01 25 F6 41 01 00 04 00 00 01 29 F6 41 01 00 04 00 00 01 2C F6 41 01 00 0C 00 00 01 02 2E F6 41 01 00 04 00 00 01 2F F6 41 01 00 0C 00 00 01 02 30 F6 41 01 00 0C 00 00 01 02 33 F6 41 01 00 04 00 00 01 34 F6 41 01 00 04 00 00 01 36 F6 41 01 00 04 00 00 01 37 F6 41 01 00 04 00 00 01 38 F6 41 01 00 0C 00 00 01 02 39 F6 41 01 00 04 00 00 01 3C F6 41 01 00 0C 00 00 01 02 3E F6 41 01 00 08 00 00 00 42 F6 41 01 00 04 00 00 01 43 F6 41 01 00 08 00 00 00 44 F6 41 01 00 08 00 00 00 45 F6 41 01 00 0C 00 00 01 02 48 F6 41 01 10 0C 00 00 5A 01 02 80 7C 43 01 00 04 00 00 01 81 7C 43 01 00 04 00 00 01 86 7C 43 01 00 04 00 00 01 89 7C 43 01 00 08 00 00 02 8C 7C 43 01 00 04 00 00 01 8F 7C 43 01 00 0C 00 00 01 02 80 C3 C9 01 00 04 00 00 01 81 C3 C9 01 00 04 00 00 01 82 C3 C9 01 00 04 00 00 01 83 C3 C9 01 00 04 00 00 01 84 C3 C9 01 00 04 00 00 01 85 C3 C9 01 00 04 00 00 01 86 C3 C9 01 00 04 00 00 01 87 C3 C9 01 00 04 00 00 01 88 C3 C9 01 00 04 00 00 01 89 C3 C9 01 00 04 00 00 01 8A C3 C9 01 00 04 00 00 01 8B C3 C9 01 00 04 00 00 01 8C C3 C9 01 00 04 00 00 01 8D C3 C9 01 00 04 00 00 01 8E C3 C9 01 00 04 00 00 01 8F C3 C9 01 00 04 00 00 01 90 C3 C9 01 00 04 00 00 01 91 C3 C9 01 00 04 00 00 01 92 C3 C9 01 00 04 00 00 01 93 C3 C9 01 00 04 00 00 01 96 C3 C9 01 10 00 00 00 05 97 C3 C9 01 10 00 00 00 05 9A C3 C9 01 00 04 00 00 01 9B C3 C9 01 00 04 00 00 01 9C C3 C9 01 00 04 00 00 01 9D C3 C9 01 02 04 00 00 0B 00 01 9E C3 C9 01 00 04 00 00 01 9F C3 C9 01 02 04 00 00 0B 00 01 A0 C3 C9 01 00 04 00 00 01 A1 C3 C9 01 02 04 00 00 0B 00 01 A8 C3 C9 01 00 0C 00 00 01 02 A9 C3 C9 01 00 04 00 00 01 AA C3 C9 01 00 0C 00 00 01 02 AB C3 C9 01 00 04 00 00 01 AE C3 C9 01 00 04 00 00 01 AF C3 C9 01 00 04 00 00 01 B1 C3 C9 01 00 08 00 00 03 B2 C3 C9 01 00 08 00 00 03 B3 C3 C9 01 00 08 00 00 03 B4 C3 C9 01 00 08 00 00 03 B5 C3 C9 01 00 08 00 00 03 B6 C3 C9 01 00 08 00 00 03 B7 C3 C9 01 00 08 00 00 03 B8 C3 C9 01 00 08 00 00 03 B9 C3 C9 01 00 08 00 00 03 BA C3 C9 01 00 08 00 00 03 BB C3 C9 01 00 08 00 00 03 BC C3 C9 01 00 08 00 00 03 BD C3 C9 01 00 08 00 00 03 BE C3 C9 01 00 08 00 00 03 BF C3 C9 01 00 08 00 00 03 C0 C3 C9 01 00 08 00 00 03 C1 C3 C9 01 00 08 00 00 03 C2 C3 C9 01 00 08 00 00 03 C3 C3 C9 01 00 08 00 00 03 C4 C3 C9 01 00 08 00 00 03 C5 C3 C9 01 00 08 00 00 03 C6 C3 C9 01 00 08 00 00 03 C7 C3 C9 01 00 08 00 00 03 C8 C3 C9 01 00 08 00 00 03 C9 C3 C9 01 00 08 00 00 03 CA C3 C9 01 00 08 00 00 03 CB C3 C9 01 00 08 00 00 03 CC C3 C9 01 00 08 00 00 03 CD C3 C9 01 00 08 00 00 03 CE C3 C9 01 00 08 00 00 03 CF C3 C9 01 00 08 00 00 03 D0 C3 C9 01 00 08 00 00 03 D1 C3 C9 01 00 08 00 00 03 D2 C3 C9 01 00 08 00 00 03 D3 C3 C9 01 00 08 00 00 03 D4 C3 C9 01 00 08 00 00 03 D5 C3 C9 01 00 08 00 00 03 D6 C3 C9 01 00 08 00 00 03 20 4A CB 01 00 04 00 00 01 21 4A CB 01 00 04 00 00 01 22 4A CB 01 00 04 00 00 01 23 4A CB 01 00 04 00 00 01 24 4A CB 01 00 04 00 00 01 25 4A CB 01 00 04 00 00 01 26 4A CB 01 00 04 00 00 01 27 4A CB 01 00 04 00 00 01 28 4A CB 01 00 04 00 00 01 29 4A CB 01 00 04 00 00 01 2C 4A CB 01 00 04 00 00 01 2D 4A CB 01 00 04 00 00 01 2E 4A CB 01 00 0C 00 00 01 02 2F 4A CB 01 00 0C 00 00 01 02 36 4A CB 01 00 04 00 00 01 37 4A CB 01 00 04 00 00 01 38 4A CB 01 00 04 00 00 01 39 4A CB 01 00 04 00 00 01 3A 4A CB 01 00 04 00 00 01 3B 4A CB 01 00 04 00 00 01 4A 4A CB 01 00 04 00 00 01 4B 4A CB 01 00 04 00 00 01 4C 4A CB 01 00 04 00 00 01 4D 4A CB 01 00 04 00 00 01 4E 4A CB 01 00 04 00 00 01 4F 4A CB 01 00 04 00 00 01 50 4A CB 01 00 04 00 00 01 51 4A CB 01 00 04 00 00 01 52 4A CB 01 00 04 00 00 01 53 4A CB 01 00 04 00 00 01 54 4A CB 01 00 04 00 00 01 55 4A CB 01 00 04 00 00 01 56 4A CB 01 00 04 00 00 01 57 4A CB 01 00 04 00 00 01 58 4A CB 01 00 04 00 00 01 59 4A CB 01 00 04 00 00 01 5A 4A CB 01 00 04 00 00 01 5B 4A CB 01 00 04 00 00 01 5C 4A CB 01 00 04 00 00 01 5D 4A CB 01 00 04 00 00 01 5E 4A CB 01 00 04 00 00 01 5F 4A CB 01 00 04 00 00 01 60 4A CB 01 00 04 00 00 01 67 4A CB 01 00 04 00 00 01 68 4A CB 01 00 04 00 00 01 69 4A CB 01 00 04 00 00 01 6A 4A CB 01 00 08 00 00 03 6B 4A CB 01 00 08 00 00 03 6C 4A CB 01 00 08 00 00 03 6D 4A CB 01 00 08 00 00 03 6E 4A CB 01 00 08 00 00 03 6F 4A CB 01 00 08 00 00 03 75 4A CB 01 00 0C 00 00 01 02 76 4A CB 01 00 08 00 00 03 77 4A CB 01 00 08 00 00 03 78 4A CB 01 00 08 00 00 03 7B 4A CB 01 00 0C 00 00 01 00 C0 D0 CC 01 00 04 00 00 01 C1 D0 CC 01 00 0C 00 00 01 02 C2 D0 CC 01 00 04 00 00 01 C3 D0 CC 01 00 04 00 00 01 C4 D0 CC 01 00 04 00 00 01 C5 D0 CC 01 00 04 00 00 01 C6 D0 CC 01 00 04 00 00 01 C7 D0 CC 01 00 04 00 00 01 C8 D0 CC 01 00 04 00 00 01 CA D0 CC 01 00 04 00 00 01 CB D0 CC 01 00 04 00 00 01 CC D0 CC 01 00 04 00 00 01 D0 D0 CC 01 00 0C 00 00 01 02 D1 D0 CC 01 00 04 00 00 01 D2 D0 CC 01 00 04 00 00 01 D4 D0 CC 01 00 0C 00 00 01 02 D7 D0 CC 01 00 04 00 00 01 D8 D0 CC 01 00 04 00 00 01 D9 D0 CC 01 00 04 00 00 01 DB D0 CC 01 00 04 00 00 01 DC D0 CC 01 00 04 00 00 01 DD D0 CC 01 00 0C 00 00 01 02 DE D0 CC 01 00 04 00 00 01 E0 D0 CC 01 00 08 00 00 03 E2 D0 CC 01 00 08 00 00 03 E3 D0 CC 01 00 08 00 00 03 80 F0 FA 02 00 04 00 00 01 81 F0 FA 02 00 04 00 00 01 82 F0 FA 02 00 04 00 00 01 83 F0 FA 02 00 04 00 00 01 84 F0 FA 02 00 04 00 00 01 85 F0 FA 02 00 04 00 00 01 86 F0 FA 02 00 04 00 00 01 87 F0 FA 02 00 04 00 00 01 88 F0 FA 02 00 04 00 00 01 89 F0 FA 02 00 04 00 00 01 8A F0 FA 02 00 04 00 00 01 8B F0 FA 02 00 04 00 00 01 8C F0 FA 02 00 04 00 00 01 8D F0 FA 02 00 04 00 00 01 8E F0 FA 02 00 04 00 00 01 8F F0 FA 02 00 04 00 00 01 90 F0 FA 02 00 04 00 00 01 91 F0 FA 02 00 04 00 00 01 92 F0 FA 02 00 04 00 00 01 93 F0 FA 02 00 04 00 00 01 94 F0 FA 02 00 04 00 00 01 95 F0 FA 02 00 04 00 00 01 96 F0 FA 02 00 04 00 00 01 97 F0 FA 02 00 04 00 00 01 98 F0 FA 02 00 04 00 00 01 99 F0 FA 02 00 04 00 00 01 9A F0 FA 02 00 04 00 00 01 9B F0 FA 02 00 04 00 00 01 9C F0 FA 02 00 04 00 00 01 9D F0 FA 02 00 04 00 00 01 9E F0 FA 02 00 04 00 00 01 9F F0 FA 02 00 04 00 00 01 A0 F0 FA 02 00 04 00 00 01 A1 F0 FA 02 00 04 00 00 01 A2 F0 FA 02 00 04 00 00 01 A3 F0 FA 02 00 04 00 00 01 A4 F0 FA 02 00 04 00 00 01 A5 F0 FA 02 00 04 00 00 01 A6 F0 FA 02 00 04 00 00 01 A7 F0 FA 02 00 04 00 00 01 A9 F0 FA 02 00 04 00 00 01 AA F0 FA 02 00 04 00 00 01 AB F0 FA 02 00 04 00 00 01 AC F0 FA 02 00 04 00 00 01 AD F0 FA 02 00 04 00 00 01 AE F0 FA 02 00 04 00 00 01 AF F0 FA 02 00 04 00 00 01 B0 F0 FA 02 00 04 00 00 01 B1 F0 FA 02 00 04 00 00 01 B2 F0 FA 02 00 04 00 00 01 B3 F0 FA 02 00 04 00 00 01 B5 F0 FA 02 00 04 00 00 01 B6 F0 FA 02 00 04 00 00 01 B7 F0 FA 02 00 04 00 00 01 B8 F0 FA 02 00 04 00 00 01 B9 F0 FA 02 00 04 00 00 01 BA F0 FA 02 00 04 00 00 01 BB F0 FA 02 00 04 00 00 01 BC F0 FA 02 00 04 00 00 01 BD F0 FA 02 00 04 00 00 01 BE F0 FA 02 00 04 00 00 01 BF F0 FA 02 00 04 00 00 01 C0 F0 FA 02 00 04 00 00 01 C1 F0 FA 02 00 04 00 00 01 C2 F0 FA 02 00 04 00 00 01 C3 F0 FA 02 00 04 00 00 01 C4 F0 FA 02 00 04 00 00 01 C5 F0 FA 02 00 04 00 00 01 C6 F0 FA 02 00 04 00 00 01 D0 F0 FA 02 10 08 00 00 5F 02 D1 F0 FA 02 00 04 00 00 01 D2 F0 FA 02 00 04 00 00 01 D3 F0 FA 02 00 04 00 00 01 D4 F0 FA 02 00 04 00 00 01 D5 F0 FA 02 00 04 00 00 01 D6 F0 FA 02 00 04 00 00 01 D7 F0 FA 02 00 04 00 00 01 27 77 FC 02 00 04 00 00 01 28 77 FC 02 00 04 00 00 01 29 77 FC 02 00 04 00 00 01 2A 77 FC 02 00 04 00 00 01 2B 77 FC 02 00 04 00 00 01 2C 77 FC 02 00 04 00 00 01 2D 77 FC 02 00 04 00 00 01 2E 77 FC 02 00 04 00 00 01 2F 77 FC 02 00 04 00 00 01 30 77 FC 02 00 04 00 00 01 31 77 FC 02 00 04 00 00 01 32 77 FC 02 00 04 00 00 01 33 77 FC 02 00 04 00 00 01 3F 77 FC 02 00 04 00 00 01 40 77 FC 02 00 0C 00 00 01 02 C2 FD FD 02 00 04 00 00 01 C3 FD FD 02 00 04 00 00 01 C4 FD FD 02 00 04 00 00 01 C5 FD FD 02 00 04 00 00 01 C6 FD FD 02 00 04 00 00 01 C7 FD FD 02 00 04 00 00 01 C8 FD FD 02 00 04 00 00 01 C9 FD FD 02 00 04 00 00 01 CA FD FD 02 00 04 00 00 01 CB FD FD 02 00 04 00 00 01 CC FD FD 02 00 04 00 00 01 CD FD FD 02 00 04 00 00 01 CE FD FD 02 00 04 00 00 01 CF FD FD 02 00 04 00 00 01 D1 FD FD 02 00 04 00 00 01 D2 FD FD 02 00 04 00 00 01 D3 FD FD 02 00 04 00 00 01 D4 FD FD 02 00 04 00 00 01 D5 FD FD 02 00 04 00 00 01 DA FD FD 02 00 04 00 00 01 DB FD FD 02 00 04 00 00 01 DC FD FD 02 00 04 00 00 01 DD FD FD 02 00 04 00 00 01 DE FD FD 02 00 04 00 00 01 DF FD FD 02 00 04 00 00 01 E0 FD FD 02 00 04 00 00 01 E1 FD FD 02 00 04 00 00 01 E2 FD FD 02 00 04 00 00 01 E3 FD FD 02 00 04 00 00 01 E4 FD FD 02 00 04 00 00 01 E5 FD FD 02 00 04 00 00 01 E7 FD FD 02 00 04 00 00 01 E8 FD FD 02 00 04 00 00 01 E9 FD FD 02 00 04 00 00 01 EA FD FD 02 00 04 00 00 01 EB FD FD 02 00 04 00 00 01 F0 FD FD 02 02 00 00 00 01 00 60 84 FF 02 00 0C 00 00 01 02 01 0B 01 03 00 04 00 00 01 02 0B 01 03 00 04 00 00 01 0B 0B 01 03 00 04 00 00 01 0C 0B 01 03 00 04 00 00 01 0D 0B 01 03 00 04 00 00 01 0E 0B 01 03 00 04 00 00 01 0F 0B 01 03 00 0C 00 00 01 02 10 0B 01 03 10 04 00 00 60 01 11 0B 01 03 00 04 00 00 01 12 0B 01 03 00 04 00 00 01 13 0B 01 03 00 04 00 00 01 14 0B 01 03 00 08 00 00 02 15 0B 01 03 00 08 00 00 02 17 0B 01 03 28 00 00 00 01 25 00 1D 0B 01 03 00 04 00 00 01 1E 0B 01 03 00 04 00 00 01 1F 0B 01 03 00 04 00 00 01 20 0B 01 03 00 04 00 00 01 21 0B 01 03 00 04 00 00 01 22 0B 01 03 00 04 00 00 01 23 0B 01 03 00 04 00 00 01 24 0B 01 03 00 04 00 00 01 25 0B 01 03 00 04 00 00 01 26 0B 01 03 00 04 00 00 01 27 0B 01 03 00 04 00 00 01 28 0B 01 03 00 04 00 00 01 29 0B 01 03 00 0C 00 00 01 02 2E 0B 01 03 00 04 00 00 01 2F 0B 01 03 00 04 00 00 01 30 0B 01 03 00 04 00 00 01 37 0B 01 03 00 0C 00 00 01 02 3C 0B 01 03 00 0C 00 00 01 02 3D 0B 01 03 10 0C 00 00 60 01 02 3E 0B 01 03 10 04 00 00 60 01 3F 0B 01 03 10 0C 00 00 60 01 02 40 0B 01 03 10 04 00 00 60 01 41 0B 01 03 00 04 00 00 01 42 0B 01 03 00 04 00 00 01 44 0B 01 03 00 04 00 00 01 45 0B 01 03 00 04 00 00 01 46 0B 01 03 00 04 00 00 01 47 0B 01 03 00 04 00 00 01 48 0B 01 03 00 04 00 00 01 49 0B 01 03 00 0C 00 00 01 02 4A 0B 01 03 08 00 00 00 01 4B 0B 01 03 08 00 00 00 01 4C 0B 01 03 08 00 00 00 01 4D 0B 01 03 08 00 00 00 01 56 0B 01 03 08 00 00 00 01 57 0B 01 03 08 00 00 00 01 58 0B 01 03 08 00 00 00 01 59 0B 01 03 08 00 00 00 01 61 0B 01 03 00 08 00 00 00 62 0B 01 03 00 08 00 00 00 63 0B 01 03 00 08 00 00 00 64 0B 01 03 00 08 00 00 00 65 0B 01 03 00 08 00 00 00 66 0B 01 03 00 08 00 00 00 67 0B 01 03 00 08 00 00 00 68 0B 01 03 00 08 00 00 00 69 0B 01 03 00 04 00 00 01 6A 0B 01 03 00 04 00 00 01 6B 0B 01 03 00 04 00 00 01 6C 0B 01 03 00 04 00 00 01 6D 0B 01 03 00 04 00 00 01 6E 0B 01 03 00 04 00 00 01 6F 0B 01 03 00 04 00 00 01 70 0B 01 03 00 04 00 00 01 71 0B 01 03 00 04 00 00 01 72 0B 01 03 00 04 00 00 01 73 0B 01 03 00 04 00 00 01 74 0B 01 03 00 04 00 00 01 75 0B 01 03 00 04 00 00 01 76 0B 01 03 00 04 00 00 01 77 0B 01 03 00 04 00 00 01 78 0B 01 03 00 04 00 00 01 79 0B 01 03 00 04 00 00 01 7A 0B 01 03 00 04 00 00 01 7B 0B 01 03 00 08 00 00 02 7C 0B 01 03 00 0C 00 00 01 02 7D 0B 01 03 00 0C 00 00 01 02 7F 0B 01 03 00 08 00 00 00 80 0B 01 03 00 08 00 00 00 81 0B 01 03 00 08 00 00 00 87 0B 01 03 10 0C 00 00 60 01 02 88 0B 01 03 00 08 00 00 00 A0 91 02 03 00 04 00 00 01 A1 91 02 03 00 04 00 00 01 A2 91 02 03 00 04 00 00 01 A4 91 02 03 00 04 00 00 01 A5 91 02 03 00 04 00 00 01 A7 91 02 03 00 04 00 00 01 A8 91 02 03 00 04 00 00 01 A9 91 02 03 00 04 00 00 01 AA 91 02 03 00 04 00 00 01 AB 91 02 03 00 04 00 00 01 B1 91 02 03 00 04 00 00 01 B2 91 02 03 00 04 00 00 01 B3 91 02 03 00 04 00 00 01 B4 91 02 03 00 04 00 00 01 B5 91 02 03 00 04 00 00 01 B6 91 02 03 00 04 00 00 01 BE 91 02 03 00 04 00 00 01 BF 91 02 03 00 04 00 00 01 C1 91 02 03 00 04 00 00 01 C2 91 02 03 00 04 00 00 01 C3 91 02 03 00 04 00 00 01 C4 91 02 03 00 04 00 00 01 C5 91 02 03 00 04 00 00 01 C9 91 02 03 00 0C 00 00 01 02 CA 91 02 03 00 04 00 00 01 CB 91 02 03 00 04 00 00 01 CC 91 02 03 00 04 00 00 01 CD 91 02 03 00 04 00 00 01 CE 91 02 03 10 00 00 00 05 CF 91 02 03 10 00 00 00 05 D0 91 02 03 10 00 00 00 05 D1 91 02 03 10 00 00 00 05 D2 91 02 03 00 04 00 00 01 D3 91 02 03 00 04 00 00 01 D4 91 02 03 00 04 00 00 01 D5 91 02 03 00 04 00 00 01 D6 91 02 03 00 04 00 00 01 D7 91 02 03 00 04 00 00 01 D8 91 02 03 00 04 00 00 01 DD 91 02 03 10 00 00 00 05 DE 91 02 03 10 00 00 00 05 E3 91 02 03 00 0C 00 00 01 02 E4 91 02 03 00 04 00 00 01 E5 91 02 03 00 04 00 00 01 E6 91 02 03 00 04 00 00 01 E7 91 02 03 00 04 00 00 01 E8 91 02 03 00 04 00 00 01 E9 91 02 03 00 04 00 00 01 EA 91 02 03 00 04 00 00 01 EB 91 02 03 00 04 00 00 01 EC 91 02 03 00 04 00 00 01 ED 91 02 03 00 04 00 00 01 EE 91 02 03 00 04 00 00 01 EF 91 02 03 00 04 00 00 01 F0 91 02 03 00 04 00 00 01 F1 91 02 03 00 0C 00 00 01 02 F3 91 02 03 00 0C 00 00 01 02 F4 91 02 03 00 04 00 00 01 F5 91 02 03 00 0C 00 00 01 02 00 87 93 03 00 04 00 00 01 01 87 93 03 00 04 00 00 01 02 87 93 03 00 04 00 00 01 03 87 93 03 00 04 00 00 01 04 87 93 03 00 04 00 00 01 05 87 93 03 00 04 00 00 01 0B 87 93 03 00 04 00 00 01 0D 87 93 03 00 0C 00 00 01 02 0F 87 93 03 00 04 00 00 01 10 87 93 03 00 04 00 00 01 11 87 93 03 10 00 00 00 05 12 87 93 03 00 04 00 00 01 13 87 93 03 00 04 00 00 01 14 87 93 03 00 0C 00 00 01 02 17 87 93 03 00 0C 00 00 01 02 18 87 93 03 00 04 00 00 01 19 87 93 03 00 04 00 00 01 1A 87 93 03 00 0C 00 00 01 02 1B 87 93 03 00 04 00 00 01 1C 87 93 03 00 0C 00 00 01 02 1D 87 93 03 00 04 00 00 01 1E 87 93 03 00 04 00 00 01 21 87 93 03 00 04 00 00 01 22 87 93 03 10 04 00 00 04 01 23 87 93 03 00 04 00 00 01 29 87 93 03 00 0C 00 00 01 02 2C 87 93 03 00 0C 00 00 01 02 A1 0D 95 03 00 04 00 00 01 A2 0D 95 03 00 04 00 00 01 A3 0D 95 03 00 04 00 00 01 A4 0D 95 03 00 04 00 00 01 A5 0D 95 03 00 04 00 00 01 A6 0D 95 03 00 04 00 00 01 A7 0D 95 03 00 04 00 00 01 A8 0D 95 03 10 00 00 00 05 A9 0D 95 03 10 00 00 00 05 AA 0D 95 03 00 0C 00 00 01 02 AB 0D 95 03 00 04 00 00 01 AC 0D 95 03 00 04 00 00 01 AD 0D 95 03 00 04 00 00 01 AE 0D 95 03 00 04 00 00 01 AF 0D 95 03 00 04 00 00 01 B0 0D 95 03 00 04 00 00 01 B1 0D 95 03 00 04 00 00 01 B2 0D 95 03 00 04 00 00 01 B3 0D 95 03 00 04 00 00 01 B4 0D 95 03 00 04 00 00 01 B6 0D 95 03 00 04 00 00 01 B7 0D 95 03 00 04 00 00 01 B8 0D 95 03 00 04 00 00 01 B9 0D 95 03 00 04 00 00 01 BA 0D 95 03 00 04 00 00 01 BB 0D 95 03 00 04 00 00 01 BC 0D 95 03 00 04 00 00 01 BD 0D 95 03 00 04 00 00 01 BE 0D 95 03 00 04 00 00 01 BF 0D 95 03 00 04 00 00 01 C3 0D 95 03 00 04 00 00 01 C4 0D 95 03 00 04 00 00 01 C7 0D 95 03 00 04 00 00 01 C8 0D 95 03 00 04 00 00 01 C9 0D 95 03 00 04 00 00 01 CA 0D 95 03 00 04 00 00 01 CB 0D 95 03 00 04 00 00 01 CC 0D 95 03 00 04 00 00 01 CD 0D 95 03 00 04 00 00 01 CE 0D 95 03 00 04 00 00 01 CF 0D 95 03 00 04 00 00 01 D0 0D 95 03 00 04 00 00 01 D1 0D 95 03 00 04 00 00 01 D2 0D 95 03 00 04 00 00 01 D3 0D 95 03 00 04 00 00 01 DA 0D 95 03 00 0C 00 00 01 02 40 94 96 03 00 0C 00 00 01 02 41 94 96 03 00 0C 00 00 01 02 44 94 96 03 00 04 00 00 01 45 94 96 03 00 04 00 00 01 46 94 96 03 00 04 00 00 01 47 94 96 03 00 04 00 00 01 48 94 96 03 00 04 00 00 01 49 94 96 03 00 04 00 00 01 4A 94 96 03 00 04 00 00 01 4B 94 96 03 00 04 00 00 01 4C 94 96 03 00 04 00 00 01 4D 94 96 03 00 04 00 00 01 4E 94 96 03 00 04 00 00 01 4F 94 96 03 00 04 00 00 01 50 94 96 03 00 04 00 00 01 51 94 96 03 00 04 00 00 01 52 94 96 03 00 04 00 00 01 53 94 96 03 00 04 00 00 01 54 94 96 03 00 04 00 00 01 55 94 96 03 00 04 00 00 01 56 94 96 03 00 04 00 00 01 57 94 96 03 00 0C 00 00 01 02 58 94 96 03 00 0C 00 00 01 02 59 94 96 03 00 04 00 00 01 5A 94 96 03 00 04 00 00 01 5B 94 96 03 00 0C 00 00 01 02 5D 94 96 03 00 04 00 00 01 5E 94 96 03 00 04 00 00 01 5F 94 96 03 00 04 00 00 01 60 94 96 03 00 04 00 00 01 61 94 96 03 00 0C 00 00 01 02 62 94 96 03 00 04 00 00 01 63 94 96 03 00 04 00 00 01 64 94 96 03 00 04 00 00 01 65 94 96 03 00 04 00 00 01 66 94 96 03 00 04 00 00 01 67 94 96 03 00 04 00 00 01 68 94 96 03 00 04 00 00 01 69 94 96 03 00 04 00 00 01 6A 94 96 03 00 04 00 00 01 6B 94 96 03 00 04 00 00 01 6C 94 96 03 00 04 00 00 01 6D 94 96 03 00 04 00 00 01 6E 94 96 03 00 04 00 00 01 70 94 96 03 00 04 00 00 01 72 94 96 03 00 04 00 00 01 75 94 96 03 00 04 00 00 01 76 94 96 03 00 04 00 00 01 77 94 96 03 00 04 00 00 01 78 94 96 03 00 04 00 00 01 7A 94 96 03 00 04 00 00 01 7B 94 96 03 00 04 00 00 01 82 1D 2C 04 00 04 00 00 01 83 1D 2C 04 00 04 00 00 01 84 1D 2C 04 00 04 00 00 01 85 1D 2C 04 00 04 00 00 01 86 1D 2C 04 00 04 00 00 01 87 1D 2C 04 10 00 00 00 05 88 1D 2C 04 10 00 00 00 05 89 1D 2C 04 00 04 00 00 01 8A 1D 2C 04 00 04 00 00 01 8B 1D 2C 04 00 04 00 00 01 8C 1D 2C 04 00 04 00 00 01 8D 1D 2C 04 00 04 00 00 01 8E 1D 2C 04 00 04 00 00 01 8F 1D 2C 04 10 00 00 00 05 90 1D 2C 04 10 00 00 00 05 91 1D 2C 04 00 04 00 00 01 92 1D 2C 04 00 04 00 00 01 93 1D 2C 04 00 04 00 00 01 AC 1D 2C 04 00 0C 00 00 01 02 AD 1D 2C 04 00 0C 00 00 01 02 AE 1D 2C 04 00 0C 00 00 01 02 AF 1D 2C 04 00 0C 00 00 01 02 B0 1D 2C 04 00 0C 00 00 01 02 B1 1D 2C 04 00 0C 00 00 01 02 B2 1D 2C 04 00 04 00 00 01 B3 1D 2C 04 00 04 00 00 01 B4 1D 2C 04 00 04 00 00 01 B5 1D 2C 04 00 04 00 00 01 B6 1D 2C 04 00 04 00 00 01 B7 1D 2C 04 00 04 00 00 01 B8 1D 2C 04 00 04 00 00 01 B9 1D 2C 04 00 04 00 00 01 BA 1D 2C 04 00 04 00 00 01 C1 1D 2C 04 00 04 00 00 01 C2 1D 2C 04 00 04 00 00 01 C3 1D 2C 04 00 04 00 00 01 C4 1D 2C 04 00 04 00 00 01 C5 1D 2C 04 00 04 00 00 01 C6 1D 2C 04 00 04 00 00 01 C7 1D 2C 04 00 04 00 00 01 C8 1D 2C 04 00 04 00 00 01 CC 1D 2C 04 00 08 00 00 02 CE 1D 2C 04 00 04 00 00 01 CF 1D 2C 04 00 04 00 00 01 D0 1D 2C 04 00 04 00 00 01 D1 1D 2C 04 00 04 00 00 01 D2 1D 2C 04 00 04 00 00 01 D3 1D 2C 04 00 04 00 00 01 D4 1D 2C 04 00 04 00 00 01 D5 1D 2C 04 00 04 00 00 01 D6 1D 2C 04 00 04 00 00 01 D7 1D 2C 04 00 04 00 00 01 D8 1D 2C 04 00 04 00 00 01 D9 1D 2C 04 00 04 00 00 01 DA 1D 2C 04 00 04 00 00 01 DB 1D 2C 04 00 04 00 00 01 DC 1D 2C 04 00 04 00 00 01 DD 1D 2C 04 00 04 00 00 01 DE 1D 2C 04 00 04 00 00 01 DF 1D 2C 04 00 04 00 00 01 E0 1D 2C 04 00 04 00 00 01 E1 1D 2C 04 00 04 00 00 01 E2 1D 2C 04 00 04 00 00 01 E3 1D 2C 04 00 04 00 00 01 E4 1D 2C 04 00 04 00 00 01 E5 1D 2C 04 00 04 00 00 01 E6 1D 2C 04 00 04 00 00 01 E7 1D 2C 04 00 08 00 00 02 E8 1D 2C 04 00 04 00 00 01 E9 1D 2C 04 00 08 00 00 03 EA 1D 2C 04 10 00 00 00 05 EB 1D 2C 04 10 00 00 00 05 EC 1D 2C 04 10 00 00 00 05 ED 1D 2C 04 10 00 00 00 05 EE 1D 2C 04 00 04 00 00 01 EF 1D 2C 04 00 04 00 00 01 F0 1D 2C 04 00 04 00 00 01 F1 1D 2C 04 00 04 00 00 01 F2 1D 2C 04 00 04 00 00 01 F3 1D 2C 04 00 04 00 00 01 F4 1D 2C 04 00 04 00 00 01 F5 1D 2C 04 00 04 00 00 01 F6 1D 2C 04 00 04 00 00 01 F7 1D 2C 04 00 04 00 00 01 F8 1D 2C 04 00 04 00 00 01 F9 1D 2C 04 00 04 00 00 01 FB 1D 2C 04 00 04 00 00 01 FD 1D 2C 04 00 04 00 00 01 09 1E 2C 04 00 0C 00 00 01 02 0A 1E 2C 04 00 0C 00 00 01 02 0B 1E 2C 04 00 08 00 00 02 0C 1E 2C 04 00 08 00 00 02 0D 1E 2C 04 00 0C 00 00 01 02 0E 1E 2C 04 00 0C 00 00 01 02 0F 1E 2C 04 00 0C 00 00 01 02 10 1E 2C 04 00 04 00 00 01 11 1E 2C 04 00 04 00 00 01 12 1E 2C 04 04 0C 00 00 E0 01 00 00 01 01 13 1E 2C 04 04 0C 00 00 C0 03 00 00 01 01 14 1E 2C 04 04 0C 00 00 C0 12 00 00 01 01 15 1E 2C 04 00 08 00 00 00 16 1E 2C 04 00 08 00 00 03 17 1E 2C 04 00 08 00 00 03 18 1E 2C 04 00 08 00 00 03 19 1E 2C 04 00 04 00 00 01 1A 1E 2C 04 00 0C 00 00 01 02 1B 1E 2C 04 00 0C 00 00 01 02 1C 1E 2C 04 10 0C 00 00 5A 01 02 1D 1E 2C 04 10 04 00 00 55 01 1E 1E 2C 04 10 04 00 00 55 01 1F 1E 2C 04 10 0C 00 00 5A 01 02 00 00 00 63 00 74 00 6F 00 72 00 32 00 44 00 00 00 00 00 8D 00 11 00 D4 00 0E 06 98 E9 86 07 38 C2 BD 07 00 00 65 00 6C 00 00 00 04 00 03 00 D7 01 0C 06 0E 00 00 00 35 00 31 00 31 00 30 00 30 00 30 00 31 00 00 00 00 00 00 00 04 00 07 00 D3 01 0A 06 10 00 00 00 65 00 62 00 75 00 72 00 73 00 74 00 65 00 72 00 00 00 00 00 82 00 0B 00 2F 00 0A 06 B8 05 49 07 88 D6 B3 07 01 00 00 00 00 00 00 00 29 0B 01 03 01 00 00 00 00 00 00 00 10 0B 01 03 01 00 00 00 00 00 00 00 87 0B 01 03 01 00 00 00 00 00 00 00 3D 0B 01 03 01 00 00 00 00 00 00 00 CC 62 3D 01 01 00 00 00 01 00 00 00 29 0B 01 03 01 00 00 00 01 00 00 00 10 0B 01 03 01 00 00 00 01 00 00 00 87 0B 01 03 01 00 00 00 01 00 00 00 3D 0B 01 03 01 00 00 00 01 00 00 00 CC 62 3D 01 02 00 00 00 00 00 00 00 29 0B 01 03 02 00 00 00 00 00 00 00 10 0B 01 03 02 00 00 00 00 00 00 00 87 0B 01 03 02 00 00 00 00 00 00 00 3D 0B 01 03 02 00 00 00 00 00 00 00 CC 62 3D 01 02 00 00 00 01 00 00 00 29 0B 01 03 02 00 00 00 01 00 00 00 10 0B 01 03 02 00 00 00 01 00 00 00 87 0B 01 03 02 00 00 00 01 00 00 00 3D 0B 01 03 02 00 00 00 01 00 00 00 CC 62 3D 01 03 00 00 00 00 00 00 00 29 0B 01 03 03 00 00 00 00 00 00 00 10 0B 01 03 03 00 00 00 00 00 00 00 87 0B 01 03 03 00 00 00 00 00 00 00 3D 0B 01 03 03 00 00 00 00 00 00 00 CC 62 3D 01 03 00 00 00 01 00 00 00 29 0B 01 03 03 00 00 00 01 00 00 00 10 0B 01 03 03 00 00 00 01 00 00 00 87 0B 01 03 03 00 00 00 01 00 00 00 3D 0B 01 03 03 00 00 00 01 00 00 00 CC 62 3D 01 04 00 00 00 00 00 00 00 29 0B 01 03 04 00 00 00 00 00 00 00 10 0B 01 03 04 00 00 00 00 00 00 00 87 0B 01 03 04 00 00 00 00 00 00 00 3D 0B 01 03 04 00 00 00 00 00 00 00 CC 62 3D 01 04 00 00 00 01 00 00 00 29 0B 01 03 04 00 00 00 01 00 00 00 10 0B 01 03 04 00 00 00 01 00 00 00 87 0B 01 03 04 00 00 00 01 00 00 00 3D 0B 01 03 04 00 00 00 01 00 00 00 CC 62 3D 01 05 00 00 00 00 00 00 00 29 0B 01 03 05 00 00 00 00 00 00 00 10 0B 01 03 05 00 00 00 00 00 00 00 87 0B 01 03 05 00 00 00 00 00 00 00 3D 0B 01 03 05 00 00 00 00 00 00 00 CC 62 3D 01 05 00 00 00 01 00 00 00 29 0B 01 03 05 00 00 00 01 00 00 00 10 0B 01 03 05 00 00 00 01 00 00 00 87 0B 01 03 05 00 00 00 01 00 00 00 3D 0B 01 03 05 00 00 00 01 00 00 00 CC 62 3D 01 06 00 00 00 00 00 00 00 29 0B 01 03 06 00 00 00 00 00 00 00 10 0B 01 03 06 00 00 00 00 00 00 00 87 0B 01 03 06 00 00 00 00 00 00 00 3D 0B 01 03 06 00 00 00 00 00 00 00 CC 62 3D 01 06 00 00 00 01 00 00 00 29 0B 01 03 06 00 00 00 01 00 00 00 10 0B 01 03 06 00 00 00 01 00 00 00 87 0B 01 03 06 00 00 00 01 00 00 00 3D 0B 01 03 06 00 00 00 01 00 00 00 CC 62 3D 01 07 00 00 00 00 00 00 00 29 0B 01 03 07 00 00 00 00 00 00 00 10 0B 01 03 07 00 00 00 00 00 00 00 87 0B 01 03 07 00 00 00 00 00 00 00 3D 0B 01 03 07 00 00 00 00 00 00 00 CC 62 3D 01 07 00 00 00 01 00 00 00 29 0B 01 03 07 00 00 00 01 00 00 00 10 0B 01 03 07 00 00 00 01 00 00 00 87 0B 01 03 07 00 00 00 01 00 00 00 3D 0B 01 03 07 00 00 00 01 00 00 00 CC 62 3D 01 08 00 00 00 00 00 00 00 29 0B 01 03 08 00 00 00 00 00 00 00 10 0B 01 03 08 00 00 00 00 00 00 00 87 0B 01 03 08 00 00 00 00 00 00 00 3D 0B 01 03 08 00 00 00 00 00 00 00 CC 62 3D 01 08 00 00 00 01 00 00 00 29 0B 01 03 08 00 00 00 01 00 00 00 10 0B 01 03 08 00 00 00 01 00 00 00 87 0B 01 03 08 00 00 00 01 00 00 00 3D 0B 01 03 08 00 00 00 01 00 00 00 CC 62 3D 01 00 00 00 00 00"));
        return mplew.getPacket();
    }

    public static MaplePacket sendBlockedMessage(int type) {
        MaplePacketLittleEndianWriter mplew = new MaplePacketLittleEndianWriter();
        if (ServerConstants.\u8c03\u8bd5\u8f93\u51fa\u5c01\u5305) {
            System.out.println("sendBlockedMessage--------------------");
        }
        mplew.writeShort(SendPacketOpcode.BLOCK_MSG.getValue());
        mplew.write(type);
        return mplew.getPacket();
    }

    public static MaplePacket playCashSong(int itemid, String name) {
        MaplePacketLittleEndianWriter mplew = new MaplePacketLittleEndianWriter();
        if (ServerConstants.\u8c03\u8bd5\u8f93\u51fa\u5c01\u5305) {
            System.out.println("playCashSong--------------------");
        }
        mplew.writeShort(SendPacketOpcode.CASH_SONG.getValue());
        mplew.writeInt(itemid);
        mplew.writeMapleAsciiString(name);
        return mplew.getPacket();
    }

    public static MaplePacket show\u5854\u7f57\u724c(String name, String otherName, int love, int cardId, int commentId) {
        if (ServerConstants.\u8c03\u8bd5\u8f93\u51fa\u5c01\u5305) {
            System.out.println("playCashSong--------------------");
        }
        MaplePacketLittleEndianWriter mplew = new MaplePacketLittleEndianWriter();
        mplew.writeShort(SendPacketOpcode.SHOW_PREDICT_CARD.getValue());
        mplew.writeMapleAsciiString(name);
        mplew.writeMapleAsciiString(otherName);
        mplew.writeInt(love);
        mplew.writeInt(cardId);
        mplew.writeInt(commentId);
        return mplew.getPacket();
    }

    public static MaplePacket useCharm(byte charmsleft, byte daysleft) {
        MaplePacketLittleEndianWriter mplew = new MaplePacketLittleEndianWriter();
        if (ServerConstants.\u8c03\u8bd5\u8f93\u51fa\u5c01\u5305) {
            System.out.println("useCharm--------------------");
        }
        mplew.writeShort(SendPacketOpcode.SHOW_ITEM_GAIN_INCHAT.getValue());
        mplew.write(6);
        mplew.write(1);
        mplew.write(charmsleft);
        mplew.write(daysleft);
        return mplew.getPacket();
    }

    public static MaplePacket useWheel(byte charmsleft) {
        MaplePacketLittleEndianWriter mplew = new MaplePacketLittleEndianWriter();
        if (ServerConstants.\u8c03\u8bd5\u8f93\u51fa\u5c01\u5305) {
            System.out.println("useWheel--------------------");
        }
        mplew.writeShort(SendPacketOpcode.SHOW_ITEM_GAIN_INCHAT.getValue());
        mplew.write(21);
        mplew.writeLong(charmsleft);
        return mplew.getPacket();
    }

    public static MaplePacket itemExpired(int itemid) {
        MaplePacketLittleEndianWriter mplew = new MaplePacketLittleEndianWriter();
        if (ServerConstants.\u8c03\u8bd5\u8f93\u51fa\u5c01\u5305) {
            System.out.println("itemExpired--------------------");
        }
        mplew.writeShort(SendPacketOpcode.SHOW_STATUS_INFO.getValue());
        mplew.write(2);
        mplew.writeInt(itemid);
        return mplew.getPacket();
    }

    public static MaplePacket ViciousHammer(boolean start, int hammered) {
        MaplePacketLittleEndianWriter mplew = new MaplePacketLittleEndianWriter();
        if (ServerConstants.\u8c03\u8bd5\u8f93\u51fa\u5c01\u5305) {
            System.out.println("ViciousHammer--------------------");
        }
        mplew.writeShort(SendPacketOpcode.VICIOUS_HAMMER.getValue());
        if (start) {
            mplew.write(49);
            mplew.writeInt(0);
            mplew.writeInt(hammered);
        } else {
            mplew.write(53);
            mplew.writeInt(0);
        }
        return mplew.getPacket();
    }

    public static MaplePacket changePetFlag(int uniqueId, boolean added, int flagAdded) {
        MaplePacketLittleEndianWriter mplew = new MaplePacketLittleEndianWriter();
        if (ServerConstants.\u8c03\u8bd5\u8f93\u51fa\u5c01\u5305) {
            System.out.println("changePetFlag--------------------");
        }
        mplew.writeShort(SendPacketOpcode.PET_FLAG_CHANGE.getValue());
        mplew.writeLong(uniqueId);
        mplew.write(added ? 1 : 0);
        mplew.writeShort(flagAdded);
        return mplew.getPacket();
    }

    public static MaplePacket changePetName(MapleCharacter chr, String newname, int slot) {
        MaplePacketLittleEndianWriter mplew = new MaplePacketLittleEndianWriter();
        if (ServerConstants.\u8c03\u8bd5\u8f93\u51fa\u5c01\u5305) {
            System.out.println("changePetName--------------------");
        }
        mplew.writeShort(SendPacketOpcode.PET_NAMECHANGE.getValue());
        mplew.writeInt(chr.getId());
        mplew.write(0);
        mplew.writeMapleAsciiString(newname);
        mplew.write(slot);
        return mplew.getPacket();
    }

    public static MaplePacket showNotes(ResultSet notes, int count) throws SQLException {
        MaplePacketLittleEndianWriter mplew = new MaplePacketLittleEndianWriter();
        if (ServerConstants.\u8c03\u8bd5\u8f93\u51fa\u5c01\u5305) {
            System.out.println("showNotes--------------------");
        }
        mplew.writeShort(SendPacketOpcode.SHOW_NOTES.getValue());
        mplew.write(3);
        mplew.write(count);
        for (int i = 0; i < count; ++i) {
            mplew.writeInt(notes.getInt("id"));
            mplew.writeMapleAsciiString(notes.getString("from"));
            mplew.writeMapleAsciiString(notes.getString("message"));
            mplew.writeLong(PacketHelper.getKoreanTimestamp(notes.getLong("timestamp")));
            mplew.write(notes.getInt("gift"));
            notes.next();
        }
        return mplew.getPacket();
    }

    public static MaplePacket useChalkboard(int charid, String msg) {
        MaplePacketLittleEndianWriter mplew = new MaplePacketLittleEndianWriter();
        if (ServerConstants.\u8c03\u8bd5\u8f93\u51fa\u5c01\u5305) {
            System.out.println("useChalkboard--------------------");
        }
        mplew.writeShort(SendPacketOpcode.CHALKBOARD.getValue());
        mplew.writeInt(charid);
        if (msg == null || msg.length() <= 0) {
            mplew.write(0);
        } else {
            mplew.write(1);
            mplew.writeMapleAsciiString(msg);
        }
        return mplew.getPacket();
    }

    public static MaplePacket getTrockRefresh(MapleCharacter chr, boolean vip, boolean delete) {
        MaplePacketLittleEndianWriter mplew = new MaplePacketLittleEndianWriter();
        if (ServerConstants.\u8c03\u8bd5\u8f93\u51fa\u5c01\u5305) {
            System.out.println("getTrockRefresh--------------------");
        }
        mplew.writeShort(SendPacketOpcode.TROCK_LOCATIONS.getValue());
        mplew.write(delete ? 2 : 3);
        mplew.write(vip ? 1 : 0);
        if (vip) {
            int[] map = chr.getRocks();
            for (int i = 0; i < 10; ++i) {
                mplew.writeInt(map[i]);
            }
        } else {
            int[] map = chr.getRegRocks();
            for (int i = 0; i < 5; ++i) {
                mplew.writeInt(map[i]);
            }
        }
        return mplew.getPacket();
    }

    public static MaplePacket sendWishList(MapleCharacter chr, boolean update) {
        MaplePacketLittleEndianWriter mplew = new MaplePacketLittleEndianWriter();
        if (ServerConstants.\u8c03\u8bd5\u8f93\u51fa\u5c01\u5305) {
            System.out.println("sendWishList--------------------");
        }
        mplew.writeShort(SendPacketOpcode.CS_OPERATION.getValue());
        mplew.write(70);
        Connection con = DatabaseConnection.getConnection();
        int i = 10;
        try {
            PreparedStatement ps = con.prepareStatement("SELECT sn FROM wishlist WHERE characterid = ? LIMIT 10");
            ps.setInt(1, chr.getAccountID());
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                mplew.writeInt(rs.getInt("sn"));
                --i;
            }
            rs.close();
            ps.close();
        }
        catch (SQLException se) {
            System.out.println("Error getting wishlist data:" + se);
        }
        while (i > 0) {
            mplew.writeInt(0);
            --i;
        }
        return mplew.getPacket();
    }

    public static MaplePacket showCashInventory(MapleClient c) {
        MaplePacketLittleEndianWriter mplew = new MaplePacketLittleEndianWriter();
        mplew.writeShort(SendPacketOpcode.CS_OPERATION.getValue());
        mplew.write(66);
        CashShop mci = c.getPlayer().getCashInventory();
        mplew.writeShort(mci.getItemsSize());
        for (IItem itemz : mci.getInventory()) {
            MTSCSPacket.addCashItemInfo(mplew, itemz, c.getAccID(), 0);
        }
        mplew.writeShort(c.getPlayer().getStorage().getSlots());
        mplew.writeShort(c.getCharacterSlots());
        return mplew.getPacket();
    }

    public static MaplePacket showNXMapleTokens(MapleCharacter chr) {
        MaplePacketLittleEndianWriter mplew = new MaplePacketLittleEndianWriter();
        if (ServerConstants.\u8c03\u8bd5\u8f93\u51fa\u5c01\u5305) {
            System.out.println("showNXMapleTokens--------------------");
        }
        mplew.writeShort(SendPacketOpcode.CS_UPDATE.getValue());
        mplew.writeInt(chr.getCSPoints(1));
        mplew.writeInt(chr.getCSPoints(2));
        return mplew.getPacket();
    }

    public static MaplePacket showBoughtCSPackage(Map<Integer, IItem> ccc, int accid) {
        MaplePacketLittleEndianWriter mplew = new MaplePacketLittleEndianWriter();
        if (ServerConstants.\u8c03\u8bd5\u8f93\u51fa\u5c01\u5305) {
            System.out.println("showBoughtCSPackage--------------------");
        }
        mplew.writeShort(SendPacketOpcode.CS_OPERATION.getValue());
        mplew.write(126);
        mplew.write(ccc.size());
        for (Map.Entry<Integer, IItem> sn : ccc.entrySet()) {
            MTSCSPacket.addCashItemInfo(mplew, sn.getValue(), accid, sn.getKey());
        }
        mplew.writeShort(1);
        return mplew.getPacket();
    }

    public static MaplePacket showBoughtCSItem(int itemid, int sn, int uniqueid, int accid, int quantity, String giftFrom, long expire) {
        MaplePacketLittleEndianWriter mplew = new MaplePacketLittleEndianWriter();
        if (ServerConstants.\u8c03\u8bd5\u8f93\u51fa\u5c01\u5305) {
            System.out.println("showBoughtCSItemA--------------------");
        }
        mplew.writeShort(SendPacketOpcode.CS_OPERATION.getValue());
        mplew.write(76);
        MTSCSPacket.addCashItemInfo(mplew, uniqueid, accid, itemid, sn, quantity, giftFrom, expire);
        return mplew.getPacket();
    }

    public static MaplePacket showBoughtCSItem(IItem item, int sn, int accid) {
        MaplePacketLittleEndianWriter mplew = new MaplePacketLittleEndianWriter();
        if (ServerConstants.\u8c03\u8bd5\u8f93\u51fa\u5c01\u5305) {
            System.out.println("showBoughtCSItemB--------------------");
        }
        mplew.writeShort(SendPacketOpcode.CS_OPERATION.getValue());
        mplew.write(76);
        MTSCSPacket.addCashItemInfo(mplew, item, accid, sn);
        return mplew.getPacket();
    }

    public static MaplePacket showXmasSurprise(int idFirst, IItem item, int accid) {
        MaplePacketLittleEndianWriter mplew = new MaplePacketLittleEndianWriter();
        if (ServerConstants.\u8c03\u8bd5\u8f93\u51fa\u5c01\u5305) {
            System.out.println("showXmasSurprise--------------------");
        }
        mplew.writeShort(SendPacketOpcode.XMAS_SURPRISE.getValue());
        mplew.write(230);
        mplew.writeLong(idFirst);
        mplew.writeInt(0);
        MTSCSPacket.addCashItemInfo(mplew, item, accid, 0);
        mplew.writeInt(item.getItemId());
        mplew.write(1);
        mplew.write(1);
        return mplew.getPacket();
    }

    public static final void addCashItemInfo(MaplePacketLittleEndianWriter mplew, IItem item, int accId, int sn) {
        if (ServerConstants.\u8c03\u8bd5\u8f93\u51fa\u5c01\u5305) {
            System.out.println("addCashItemInfoA--------------------");
        }
        MTSCSPacket.addCashItemInfo(mplew, item, accId, sn, true);
    }

    public static final void addCashItemInfo(MaplePacketLittleEndianWriter mplew, IItem item, int accId, int sn, boolean isFirst) {
        if (ServerConstants.\u8c03\u8bd5\u8f93\u51fa\u5c01\u5305) {
            System.out.println("addCashItemInfoB--------------------");
        }
        MTSCSPacket.addCashItemInfo(mplew, item.getUniqueId(), accId, item.getItemId(), sn, item.getQuantity(), item.getGiftFrom(), item.getExpiration(), isFirst);
    }

    public static final void addCashItemInfo(MaplePacketLittleEndianWriter mplew, int uniqueid, int accId, int itemid, int sn, int quantity, String sender, long expire) {
        if (ServerConstants.\u8c03\u8bd5\u8f93\u51fa\u5c01\u5305) {
            System.out.println("addCashItemInfoC--------------------");
        }
        MTSCSPacket.addCashItemInfo(mplew, uniqueid, accId, itemid, sn, quantity, sender, expire, true);
    }

    public static void addCashItemInfo(MaplePacketLittleEndianWriter mplew, int uniqueid, int accId, int itemid, int sn, int quantity, String sender, long expire, boolean isFirst) {
        if (ServerConstants.\u8c03\u8bd5\u8f93\u51fa\u5c01\u5305) {
            System.out.println("addCashItemInfoD--------------------");
        }
        mplew.writeLong(uniqueid > 0 ? (long)uniqueid : 0L);
        mplew.writeLong(accId);
        mplew.writeInt(itemid);
        mplew.writeInt(isFirst ? sn : 0);
        mplew.writeShort(quantity);
        mplew.writeAsciiString(sender, 13);
        PacketHelper.addExpirationTime(mplew, expire);
        mplew.writeLong(0L);
    }

    public static void addModCashItemInfo(MaplePacketLittleEndianWriter mplew, CashItemInfo.CashModInfo item) {
        if (ServerConstants.\u8c03\u8bd5\u8f93\u51fa\u5c01\u5305) {
            System.out.println("addModCashItemInfo--------------------");
        }
        int flags = item.flags;
        mplew.writeInt(item.sn);
        mplew.writeInt(flags);
        if ((flags & 1) != 0) {
            mplew.writeInt(item.itemid);
        }
        if ((flags & 2) != 0) {
            mplew.writeShort(item.count);
        }
        if ((flags & 4) != 0) {
            mplew.writeInt(item.discountPrice);
        }
        if ((flags & 8) != 0) {
            mplew.write(item.unk_1 - 1);
        }
        if ((flags & 0x10) != 0) {
            mplew.write(item.priority);
        }
        if ((flags & 0x20) != 0) {
            mplew.writeShort(item.period);
        }
        if ((flags & 0x40) != 0) {
            mplew.writeInt(0);
        }
        if ((flags & 0x80) != 0) {
            mplew.writeInt(item.meso);
        }
        if ((flags & 0x100) != 0) {
            mplew.write(item.unk_2 - 1);
        }
        if ((flags & 0x200) != 0) {
            mplew.write(item.gender);
        }
        if ((flags & 0x400) != 0) {
            mplew.write(item.showUp ? 1 : 0);
        }
        if ((flags & 0x800) != 0) {
            mplew.write(item.mark);
        }
        if ((flags & 0x1000) != 0) {
            mplew.write(item.unk_3 - 1);
        }
        if ((flags & 0x2000) != 0) {
            mplew.writeShort(0);
        }
        if ((flags & 0x4000) != 0) {
            mplew.writeShort(0);
        }
        if ((flags & 0x8000) != 0) {
            mplew.writeShort(0);
        }
        if ((flags & 0x10000) != 0) {
            List<CashItemInfo> pack = CashItemFactory.getInstance().getPackageItems(item.sn);
            if (pack == null) {
                mplew.write(0);
            } else {
                mplew.write(pack.size());
                for (int i = 0; i < pack.size(); ++i) {
                    mplew.writeInt(pack.get(i).getSN());
                }
            }
        }
    }

    public static MaplePacket showBoughtCSQuestItem(int price, short quantity, byte position, int itemid) {
        MaplePacketLittleEndianWriter mplew = new MaplePacketLittleEndianWriter();
        if (ServerConstants.\u8c03\u8bd5\u8f93\u51fa\u5c01\u5305) {
            System.out.println("showBoughtCSQuestItem--------------------");
        }
        mplew.writeShort(SendPacketOpcode.CS_OPERATION.getValue());
        mplew.write(111);
        mplew.writeInt(price);
        mplew.writeShort(quantity);
        mplew.writeShort(position);
        mplew.writeInt(itemid);
        return mplew.getPacket();
    }

    public static MaplePacket sendCSFail(int err) {
        MaplePacketLittleEndianWriter mplew = new MaplePacketLittleEndianWriter();
        if (ServerConstants.\u8c03\u8bd5\u8f93\u51fa\u5c01\u5305) {
            System.out.println("sendCSFail--------------------");
        }
        mplew.writeShort(SendPacketOpcode.CS_OPERATION.getValue());
        mplew.write(106);
        mplew.write(err);
        return mplew.getPacket();
    }

    public static MaplePacket showCouponRedeemedItem(int itemid) {
        MaplePacketLittleEndianWriter mplew = new MaplePacketLittleEndianWriter();
        if (ServerConstants.\u8c03\u8bd5\u8f93\u51fa\u5c01\u5305) {
            System.out.println("showCouponRedeemedItemA--------------------");
        }
        mplew.writeShort(SendPacketOpcode.CS_OPERATION.getValue());
        mplew.writeShort(60);
        mplew.writeInt(0);
        mplew.writeInt(1);
        mplew.writeShort(1);
        mplew.writeShort(26);
        mplew.writeInt(itemid);
        mplew.writeInt(0);
        return mplew.getPacket();
    }

    public static MaplePacket showCouponRedeemedItem(Map<Integer, IItem> items, int mesos, int maplePoints, MapleClient c) {
        MaplePacketLittleEndianWriter mplew = new MaplePacketLittleEndianWriter();
        if (ServerConstants.\u8c03\u8bd5\u8f93\u51fa\u5c01\u5305) {
            System.out.println("showCouponRedeemedItemB--------------------");
        }
        mplew.writeShort(SendPacketOpcode.CS_OPERATION.getValue());
        mplew.write(60);
        mplew.write(items.size());
        for (Map.Entry<Integer, IItem> item : items.entrySet()) {
            MTSCSPacket.addCashItemInfo(mplew, item.getValue(), c.getAccID(), item.getKey());
        }
        mplew.writeLong(maplePoints);
        mplew.writeInt(mesos);
        return mplew.getPacket();
    }

    public static MaplePacket enableCSorMTS() {
        MaplePacketLittleEndianWriter mplew = new MaplePacketLittleEndianWriter();
        if (ServerConstants.\u8c03\u8bd5\u8f93\u51fa\u5c01\u5305) {
            System.out.println("enableCSorMTS--------------------");
        }
        mplew.write(HexTool.getByteArrayFromHexString("15 00 01 00 00 00 00"));
        return mplew.getPacket();
    }

    public static MaplePacket enableCSUse() {
        MaplePacketLittleEndianWriter mplew = new MaplePacketLittleEndianWriter();
        if (ServerConstants.\u8c03\u8bd5\u8f93\u51fa\u5c01\u5305) {
            System.out.println("enableCSUse--------------------");
        }
        mplew.writeShort(18);
        mplew.writeInt(0);
        mplew.writeShort(0);
        return mplew.getPacket();
    }

    public static MaplePacket getCSInventory(MapleClient c) {
        MaplePacketLittleEndianWriter mplew = new MaplePacketLittleEndianWriter();
        mplew.writeShort(SendPacketOpcode.CS_OPERATION.getValue());
        mplew.write(66);
        CashShop mci = c.getPlayer().getCashInventory();
        mplew.writeShort(mci.getItemsSize());
        for (IItem itemz : mci.getInventory()) {
            Integer sn = null;
            try {
                sn = CashItemFactory.getInstance().getSnFromId(itemz.getItemId());
            }
            catch (Exception exception) {
                // empty catch block
            }
            mplew.writeLong(itemz.getUniqueId());
            mplew.writeLong(c.getAccID());
            mplew.writeInt(itemz.getItemId());
            mplew.writeInt(sn == null ? 0 : sn);
            mplew.writeShort(itemz.getQuantity());
            mplew.writeAsciiString(itemz.getGiftFrom());
            for (int i = itemz.getGiftFrom().getBytes().length; i < 13; ++i) {
                mplew.write(0);
            }
            PacketHelper.addExpirationTime(mplew, itemz.getExpiration());
            mplew.writeLong(0L);
        }
        mplew.writeShort(4);
        mplew.writeShort(3);
        return mplew.getPacket();
    }

    public static MaplePacket getCSGifts(MapleClient c) {
        MaplePacketLittleEndianWriter mplew = new MaplePacketLittleEndianWriter();
        if (ServerConstants.\u8c03\u8bd5\u8f93\u51fa\u5c01\u5305) {
            System.out.println("getCSGifts--------------------");
        }
        mplew.writeShort(SendPacketOpcode.CS_OPERATION.getValue());
        mplew.write(68);
        List<Pair<IItem, String>> mci = c.getPlayer().getCashInventory().loadGifts();
        mplew.writeShort(mci.size());
        for (Pair<IItem, String> mcz : mci) {
            mplew.writeLong(mcz.getLeft().getUniqueId());
            mplew.writeInt(mcz.getLeft().getItemId());
            mplew.writeAsciiString(mcz.getLeft().getGiftFrom(), 13);
            mplew.writeAsciiString(mcz.getRight(), 73);
        }
        return mplew.getPacket();
    }

    public static MaplePacket cashItemExpired(int uniqueid) {
        MaplePacketLittleEndianWriter mplew = new MaplePacketLittleEndianWriter();
        if (ServerConstants.\u8c03\u8bd5\u8f93\u51fa\u5c01\u5305) {
            System.out.println("cashItemExpired--------------------");
        }
        mplew.writeShort(SendPacketOpcode.CS_OPERATION.getValue());
        mplew.write(82);
        mplew.writeLong(uniqueid);
        return mplew.getPacket();
    }

    public static MaplePacket sendGift(int itemid, int quantity, String receiver) {
        MaplePacketLittleEndianWriter mplew = new MaplePacketLittleEndianWriter();
        if (ServerConstants.\u8c03\u8bd5\u8f93\u51fa\u5c01\u5305) {
            System.out.println("sendGift--------------------");
        }
        mplew.writeShort(SendPacketOpcode.CS_OPERATION.getValue());
        mplew.write(83);
        mplew.writeMapleAsciiString(receiver);
        mplew.writeInt(itemid);
        mplew.writeShort(quantity);
        return mplew.getPacket();
    }

    public static MaplePacket increasedInvSlots(int inv, int slots) {
        MaplePacketLittleEndianWriter mplew = new MaplePacketLittleEndianWriter();
        if (ServerConstants.\u8c03\u8bd5\u8f93\u51fa\u5c01\u5305) {
            System.out.println("increasedInvSlots--------------------");
        }
        mplew.writeShort(SendPacketOpcode.CS_OPERATION.getValue());
        mplew.write(101);
        mplew.write(inv);
        mplew.writeShort(slots);
        return mplew.getPacket();
    }

    public static MaplePacket increasedStorageSlots(int slots) {
        MaplePacketLittleEndianWriter mplew = new MaplePacketLittleEndianWriter();
        if (ServerConstants.\u8c03\u8bd5\u8f93\u51fa\u5c01\u5305) {
            System.out.println("increasedStorageSlots--------------------");
        }
        mplew.writeShort(SendPacketOpcode.CS_OPERATION.getValue());
        mplew.write(103);
        mplew.writeShort(slots);
        return mplew.getPacket();
    }

    public static MaplePacket confirmToCSInventory(IItem item, int accId, int sn) {
        MaplePacketLittleEndianWriter mplew = new MaplePacketLittleEndianWriter();
        if (ServerConstants.\u8c03\u8bd5\u8f93\u51fa\u5c01\u5305) {
            System.out.println("confirmToCSInventory--------------------");
        }
        mplew.writeShort(SendPacketOpcode.CS_OPERATION.getValue());
        mplew.write(95);
        mplew.writeLong(item.getUniqueId());
        mplew.writeLong(accId);
        mplew.writeInt(item.getItemId());
        mplew.writeInt(sn);
        mplew.writeShort(item.getQuantity());
        mplew.writeAsciiString(item.getGiftFrom(), 13);
        PacketHelper.addExpirationTime(mplew, item.getExpiration());
        mplew.writeLong(0L);
        return mplew.getPacket();
    }

    public static MaplePacket confirmFromCSInventory(IItem item, short pos) {
        MaplePacketLittleEndianWriter mplew = new MaplePacketLittleEndianWriter();
        if (ServerConstants.\u8c03\u8bd5\u8f93\u51fa\u5c01\u5305) {
            System.out.println("confirmFromCSInventory--------------------");
        }
        mplew.writeShort(SendPacketOpcode.CS_OPERATION.getValue());
        mplew.write(93);
        mplew.writeShort(pos);
        PacketHelper.addItemInfo(mplew, item, true, true);
        return mplew.getPacket();
    }

    public static MaplePacket sendMesobagFailed() {
        MaplePacketLittleEndianWriter mplew = new MaplePacketLittleEndianWriter();
        if (ServerConstants.\u8c03\u8bd5\u8f93\u51fa\u5c01\u5305) {
            System.out.println("sendMesobagFailed--------------------");
        }
        mplew.writeShort(SendPacketOpcode.MESOBAG_FAILURE.getValue());
        return mplew.getPacket();
    }

    public static MaplePacket sendMesobagSuccess(int mesos) {
        MaplePacketLittleEndianWriter mplew = new MaplePacketLittleEndianWriter();
        if (ServerConstants.\u8c03\u8bd5\u8f93\u51fa\u5c01\u5305) {
            System.out.println("sendMesobagSuccess--------------------");
        }
        mplew.writeShort(SendPacketOpcode.MESOBAG_SUCCESS.getValue());
        mplew.writeInt(mesos);
        return mplew.getPacket();
    }

    public static final MaplePacket startMTS(MapleCharacter chr, MapleClient c) {
        MaplePacketLittleEndianWriter mplew = new MaplePacketLittleEndianWriter();
        if (ServerConstants.\u8c03\u8bd5\u8f93\u51fa\u5c01\u5305) {
            System.out.println("startMTS--------------------");
        }
        mplew.writeShort(SendPacketOpcode.MTS_OPEN.getValue());
        PacketHelper.addCharacterInfo(mplew, chr);
        mplew.writeMapleAsciiString(c.getAccountName());
        mplew.writeInt(5000);
        mplew.writeInt(10);
        mplew.writeInt(100);
        mplew.writeInt(24);
        mplew.writeInt(168);
        mplew.writeLong(PacketHelper.getTime(System.currentTimeMillis()));
        return mplew.getPacket();
    }

    public static final MaplePacket sendMTS(List<MTSStorage.MTSItemInfo> items, int tab, int type, int page, int pages) {
        MaplePacketLittleEndianWriter mplew = new MaplePacketLittleEndianWriter();
        if (ServerConstants.\u8c03\u8bd5\u8f93\u51fa\u5c01\u5305) {
            System.out.println("sendMTS--------------------");
        }
        mplew.writeShort(SendPacketOpcode.MTS_OPERATION.getValue());
        mplew.write(21);
        mplew.writeInt(pages * 10);
        mplew.writeInt(items.size());
        mplew.writeInt(tab);
        mplew.writeInt(type);
        mplew.writeInt(page);
        mplew.write(1);
        mplew.write(1);
        for (MTSStorage.MTSItemInfo item : items) {
            MTSCSPacket.addMTSItemInfo(mplew, item);
        }
        mplew.write(1);
        return mplew.getPacket();
    }

    public static final MaplePacket showMTSCash(MapleCharacter p) {
        MaplePacketLittleEndianWriter mplew = new MaplePacketLittleEndianWriter();
        if (ServerConstants.\u8c03\u8bd5\u8f93\u51fa\u5c01\u5305) {
            System.out.println("showMTSCash--------------------");
        }
        mplew.writeShort(SendPacketOpcode.GET_MTS_TOKENS.getValue());
        mplew.writeInt(p.getCSPoints(2));
        return mplew.getPacket();
    }

    public static final MaplePacket getMTSWantedListingOver(int nx, int items) {
        MaplePacketLittleEndianWriter mplew = new MaplePacketLittleEndianWriter();
        if (ServerConstants.\u8c03\u8bd5\u8f93\u51fa\u5c01\u5305) {
            System.out.println("getMTSWantedListingOver--------------------");
        }
        mplew.writeShort(SendPacketOpcode.MTS_OPERATION.getValue());
        mplew.write(61);
        mplew.writeInt(nx);
        mplew.writeInt(items);
        return mplew.getPacket();
    }

    public static final MaplePacket getMTSConfirmSell() {
        MaplePacketLittleEndianWriter mplew = new MaplePacketLittleEndianWriter();
        if (ServerConstants.\u8c03\u8bd5\u8f93\u51fa\u5c01\u5305) {
            System.out.println("getMTSConfirmSell--------------------");
        }
        mplew.writeShort(SendPacketOpcode.MTS_OPERATION.getValue());
        mplew.write(29);
        return mplew.getPacket();
    }

    public static final MaplePacket getMTSFailSell() {
        MaplePacketLittleEndianWriter mplew = new MaplePacketLittleEndianWriter();
        if (ServerConstants.\u8c03\u8bd5\u8f93\u51fa\u5c01\u5305) {
            System.out.println("getMTSFailSell--------------------");
        }
        mplew.writeShort(SendPacketOpcode.MTS_OPERATION.getValue());
        mplew.write(30);
        mplew.write(66);
        return mplew.getPacket();
    }

    public static final MaplePacket getMTSConfirmBuy() {
        MaplePacketLittleEndianWriter mplew = new MaplePacketLittleEndianWriter();
        if (ServerConstants.\u8c03\u8bd5\u8f93\u51fa\u5c01\u5305) {
            System.out.println("getMTSConfirmBuy--------------------");
        }
        mplew.writeShort(SendPacketOpcode.MTS_OPERATION.getValue());
        mplew.write(51);
        return mplew.getPacket();
    }

    public static final MaplePacket getMTSFailBuy() {
        MaplePacketLittleEndianWriter mplew = new MaplePacketLittleEndianWriter();
        if (ServerConstants.\u8c03\u8bd5\u8f93\u51fa\u5c01\u5305) {
            System.out.println("getMTSFailBuy--------------------");
        }
        mplew.writeShort(SendPacketOpcode.MTS_OPERATION.getValue());
        mplew.write(52);
        mplew.write(66);
        return mplew.getPacket();
    }

    public static final MaplePacket getMTSConfirmCancel() {
        MaplePacketLittleEndianWriter mplew = new MaplePacketLittleEndianWriter();
        if (ServerConstants.\u8c03\u8bd5\u8f93\u51fa\u5c01\u5305) {
            System.out.println("getMTSConfirmCancel--------------------");
        }
        mplew.writeShort(SendPacketOpcode.MTS_OPERATION.getValue());
        mplew.write(37);
        return mplew.getPacket();
    }

    public static final MaplePacket getMTSFailCancel() {
        MaplePacketLittleEndianWriter mplew = new MaplePacketLittleEndianWriter();
        if (ServerConstants.\u8c03\u8bd5\u8f93\u51fa\u5c01\u5305) {
            System.out.println("getMTSFailCancel--------------------");
        }
        mplew.writeShort(SendPacketOpcode.MTS_OPERATION.getValue());
        mplew.write(38);
        mplew.write(66);
        return mplew.getPacket();
    }

    public static final MaplePacket getMTSConfirmTransfer(int quantity, int pos) {
        MaplePacketLittleEndianWriter mplew = new MaplePacketLittleEndianWriter();
        if (ServerConstants.\u8c03\u8bd5\u8f93\u51fa\u5c01\u5305) {
            System.out.println("getMTSConfirmTransfer--------------------");
        }
        mplew.writeShort(SendPacketOpcode.MTS_OPERATION.getValue());
        mplew.write(39);
        mplew.writeInt(quantity);
        mplew.writeInt(pos);
        return mplew.getPacket();
    }

    private static final void addMTSItemInfo(MaplePacketLittleEndianWriter mplew, MTSStorage.MTSItemInfo item) {
        if (ServerConstants.\u8c03\u8bd5\u8f93\u51fa\u5c01\u5305) {
            System.out.println("addMTSItemInfo--------------------");
        }
        PacketHelper.addItemInfo(mplew, item.getItem(), true, true);
        mplew.writeInt(item.getId());
        mplew.writeInt(item.getTaxes());
        mplew.writeInt(item.getPrice());
        mplew.writeInt(0);
        mplew.writeInt(KoreanDateUtil.getQuestTimestamp(item.getEndingDate()));
        mplew.writeInt(KoreanDateUtil.getQuestTimestamp(item.getEndingDate()));
        mplew.writeMapleAsciiString(item.getSeller());
        mplew.writeMapleAsciiString(item.getSeller());
        mplew.writeZeroBytes(28);
    }

    public static final MaplePacket getNotYetSoldInv(List<MTSStorage.MTSItemInfo> items) {
        MaplePacketLittleEndianWriter mplew = new MaplePacketLittleEndianWriter();
        if (ServerConstants.\u8c03\u8bd5\u8f93\u51fa\u5c01\u5305) {
            System.out.println("getNotYetSoldInv--------------------");
        }
        mplew.writeShort(SendPacketOpcode.MTS_OPERATION.getValue());
        mplew.write(35);
        mplew.writeInt(items.size());
        for (MTSStorage.MTSItemInfo item : items) {
            MTSCSPacket.addMTSItemInfo(mplew, item);
        }
        return mplew.getPacket();
    }

    public static final MaplePacket getTransferInventory(List<IItem> items, boolean changed) {
        MaplePacketLittleEndianWriter mplew = new MaplePacketLittleEndianWriter();
        if (ServerConstants.\u8c03\u8bd5\u8f93\u51fa\u5c01\u5305) {
            System.out.println("getTransferInventory--------------------");
        }
        mplew.writeShort(SendPacketOpcode.MTS_OPERATION.getValue());
        mplew.write(33);
        mplew.writeInt(items.size());
        int i = 0;
        for (IItem item : items) {
            PacketHelper.addItemInfo(mplew, item, true, true);
            mplew.writeInt(Integer.MAX_VALUE - i);
            mplew.writeInt(110);
            mplew.writeInt(1011);
            mplew.writeZeroBytes(48);
            ++i;
        }
        mplew.writeInt(-47 + i - 1);
        mplew.write(changed ? 1 : 0);
        return mplew.getPacket();
    }

    public static final MaplePacket addToCartMessage(boolean fail, boolean remove) {
        MaplePacketLittleEndianWriter mplew = new MaplePacketLittleEndianWriter();
        if (ServerConstants.\u8c03\u8bd5\u8f93\u51fa\u5c01\u5305) {
            System.out.println("addToCartMessage--------------------");
        }
        mplew.writeShort(SendPacketOpcode.MTS_OPERATION.getValue());
        if (remove) {
            if (fail) {
                mplew.write(44);
                mplew.writeInt(-1);
            } else {
                mplew.write(43);
            }
        } else if (fail) {
            mplew.write(42);
            mplew.writeInt(-1);
        } else {
            mplew.write(41);
        }
        return mplew.getPacket();
    }

    public static MaplePacket sendBoughtRings(boolean couple, IItem item, int sn, int accid, String receiver) {
        MaplePacketLittleEndianWriter mplew = new MaplePacketLittleEndianWriter();
        mplew.writeShort(SendPacketOpcode.CS_OPERATION.getValue());
        mplew.write(36 + (couple ? 69 : 79));
        MTSCSPacket.addCashItemInfo(mplew, item, accid, sn);
        mplew.writeMapleAsciiString(receiver);
        mplew.writeInt(item.getItemId());
        mplew.writeShort(1);
        return mplew.getPacket();
    }
}

