/*
 * Decompiled with CFR 0.152.
 */
package server;

import client.MapleCharacter;
import client.SkillFactory;
import constants.ServerConstants;
import database.DatabaseConnection;
import handling.MapleServerHandler;
import handling.cashshop.CashShopServer;
import handling.channel.ChannelServer;
import handling.channel.MapleGuildRanking;
import handling.login.LoginInformationProvider;
import handling.login.LoginServer;
import handling.world.World;
import handling.world.family.MapleFamilyBuff;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Map;
import server.AutobanManager;
import server.CashItemFactory;
import server.MapleCarnivalFactory;
import server.MapleItemInformationProvider;
import server.PredictCardFactory;
import server.RandomRewards;
import server.ServerProperties;
import server.ShutdownServer;
import server.SpeedRunner;
import server.Timer;
import server.events.MapleOxQuizFactory;
import server.life.MapleLifeFactory;
import server.maps.MapleMapFactory;
import server.quest.MapleQuest;
import tools.FileoutputUtil;
import tools.StringUtil;

public class Start {
    public static boolean Check = true;
    public static final Start instance = new Start();
    private static int maxUsers = 0;

    public static void main(String[] args) {
        if (Boolean.parseBoolean(ServerProperties.getProperty("tms.Admin"))) {
            System.out.println("[!!! Admin Only Mode Active !!!]");
        }
        if (Boolean.parseBoolean(ServerProperties.getProperty("tms.AutoRegister"))) {
            System.out.println("\u52a0\u8f7d \u81ea\u52a8\u6ce8\u518c\u5b8c\u6210 :::");
        }
        try (PreparedStatement ps = DatabaseConnection.getConnection().prepareStatement("UPDATE accounts SET loggedin = 0");){
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            throw new RuntimeException("[EXCEPTION] Please check if the SQL server is active.");
        }
        World.init();
        Timer.WorldTimer.getInstance().start();
        Timer.EtcTimer.getInstance().start();
        Timer.MapTimer.getInstance().start();
        Timer.MobTimer.getInstance().start();
        Timer.CloneTimer.getInstance().start();
        Timer.EventTimer.getInstance().start();
        Timer.BuffTimer.getInstance().start();
        LoginInformationProvider.getInstance();
        MapleQuest.initQuests();
        MapleLifeFactory.loadQuestCounts();
        MapleItemInformationProvider.getInstance().load();
        RandomRewards.getInstance();
        SkillFactory.getSkill(99999999);
        MapleOxQuizFactory.getInstance().initialize();
        MapleCarnivalFactory.getInstance();
        MapleGuildRanking.getInstance().RankingUpdate();
        MapleFamilyBuff.getBuffEntry();
        MapleServerHandler.registerMBean();
        CashItemFactory.getInstance().initialize();
        LoginServer.run_startup_configurations();
        ChannelServer.startChannel_Main();
        CashShopServer.run_startup_configurations();
        Timer.CheatTimer.getInstance().register(AutobanManager.getInstance(), 60000L);
        Start.\u5728\u7ebf\u65f6\u95f4(1);
        if (Boolean.parseBoolean(ServerProperties.getProperty("tms.RandDrop"))) {
            ChannelServer.getInstance(1).getMapFactory().getMap(910000000).spawnRandDrop();
        }
        Runtime.getRuntime().addShutdownHook(new Thread(new Shutdown()));
        try {
            SpeedRunner.getInstance().loadSpeedRuns();
        }
        catch (SQLException e) {
            System.out.println("SpeedRunner\u9519\u8bef:" + e);
        }
        World.registerRespawn();
        LoginServer.setOn();
        System.out.println("\r\n\u7ecf\u9a8c\u500d\u7387:" + Integer.parseInt(ServerProperties.getProperty("tms.Exp")) + "  \u7269\u54c1\u500d\u7387\uff1a" + Integer.parseInt(ServerProperties.getProperty("tms.Drop")) + "  \u91d1\u5e01\u500d\u7387" + Integer.parseInt(ServerProperties.getProperty("tms.Meso")));
        System.out.println("\r\n\u52a0\u8f7d\u5b8c\u6210!\u5f00\u7aef\u6210\u529f! :::");
    }

    public void startServer() throws InterruptedException {
        Check = false;
        if (Boolean.parseBoolean(ServerProperties.getProperty("tms.Admin", "false"))) {
            System.out.println("[!!! Admin Only Mode Active !!!]");
        }
        if (Boolean.parseBoolean(ServerProperties.getProperty("tms.AutoRegister", "true"))) {
            ServerConstants.\u81ea\u52a8\u6ce8\u518c = Boolean.parseBoolean(ServerProperties.getProperty("tms.AutoRegister", "true"));
            System.out.println("\u52a0\u8f7d \u81ea\u52a8\u6ce8\u518c\u5b8c\u6210 :::");
        }
        try {
            try (PreparedStatement ps = DatabaseConnection.getConnection().prepareStatement("UPDATE accounts SET loggedin = 0");){
                ps.executeUpdate();
            }
            ps = DatabaseConnection.getConnection().prepareStatement("UPDATE accounts SET lastGainHM = 0");
            var2_4 = null;
            try {
                ps.executeUpdate();
            }
            catch (Throwable throwable) {
                var2_4 = throwable;
                throw throwable;
            }
            finally {
                if (ps != null) {
                    if (var2_4 != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable x2) {
                            var2_4.addSuppressed(x2);
                        }
                    } else {
                        ps.close();
                    }
                }
            }
        }
        catch (SQLException ex) {
            throw new RuntimeException("[EXCEPTION] Please check if the SQL server is active.");
        }
        World.init();
        Timer.WorldTimer.getInstance().start();
        Timer.EtcTimer.getInstance().start();
        Timer.MapTimer.getInstance().start();
        Timer.MobTimer.getInstance().start();
        Timer.CloneTimer.getInstance().start();
        Timer.EventTimer.getInstance().start();
        Timer.BuffTimer.getInstance().start();
        LoginInformationProvider.getInstance();
        MapleQuest.initQuests();
        MapleLifeFactory.loadQuestCounts();
        MapleItemInformationProvider.getInstance().load();
        RandomRewards.getInstance();
        SkillFactory.getSkill(99999999);
        MapleOxQuizFactory.getInstance().initialize();
        MapleCarnivalFactory.getInstance();
        MapleGuildRanking.getInstance().RankingUpdate();
        MapleFamilyBuff.getBuffEntry();
        MapleServerHandler.registerMBean();
        PredictCardFactory.getInstance().initialize();
        CashItemFactory.getInstance().initialize();
        LoginServer.run_startup_configurations();
        ChannelServer.startChannel_Main();
        CashShopServer.run_startup_configurations();
        Timer.CheatTimer.getInstance().register(AutobanManager.getInstance(), 60000L);
        Start.\u81ea\u52a8\u5b58\u6863(5);
        if (Boolean.parseBoolean(ServerProperties.getProperty("tms.RandDrop"))) {
            ChannelServer.getInstance(1).getMapFactory().getMap(910000000).spawnRandDrop();
        }
        Runtime.getRuntime().addShutdownHook(new Thread(new Shutdown()));
        try {
            SpeedRunner.getInstance().loadSpeedRuns();
        }
        catch (SQLException e) {
            System.out.println("SpeedRunner\u9519\u8bef:" + e);
        }
        World.registerRespawn();
        LoginServer.setOn();
        MapleMapFactory.loadCustomLife();
        Timer.WorldTimer.getInstance().register(DatabaseConnection.CloseSQLConnections, 1080000L);
        System.out.println("\r\n\u7ecf\u9a8c\u500d\u7387:" + Integer.parseInt(ServerProperties.getProperty("tms.Exp")) + "  \u7269\u54c1\u500d\u7387\uff1a" + Integer.parseInt(ServerProperties.getProperty("tms.Drop")) + "  \u91d1\u5e01\u500d\u7387" + Integer.parseInt(ServerProperties.getProperty("tms.Meso")));
        System.out.println("\r\n\u52a0\u8f7d\u5b8c\u6210!\u5f00\u7aef\u6210\u529f! :::");
    }

    public static void \u81ea\u52a8\u5b58\u6863(int time) {
        Timer.WorldTimer.getInstance().register(new Runnable(){

            @Override
            public void run() {
                int ppl = 0;
                try {
                    for (ChannelServer cserv : ChannelServer.getAllInstances()) {
                        for (MapleCharacter chr : cserv.getPlayerStorage().getAllCharacters()) {
                            if (chr == null) continue;
                            ++ppl;
                            chr.saveToDB(false, false);
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }, 60000 * time);
    }

    public static void \u5728\u7ebf\u7edf\u8ba1(int time) {
        System.out.println("\u670d\u52a1\u7aef\u542f\u7528\u5728\u7ebf\u7edf\u8ba1." + time + "\u5206\u949f\u7edf\u8ba1\u4e00\u6b21\u5728\u7ebf\u7684\u4eba\u6570\u4fe1\u606f.");
        Timer.WorldTimer.getInstance().register(new Runnable(){

            @Override
            public void run() {
                Map<Integer, Integer> connected = World.getConnected();
                StringBuilder conStr = new StringBuilder(FileoutputUtil.CurrentReadable_Time() + " \u5728\u7ebf\u4eba\u6570: ");
                for (int i : connected.keySet()) {
                    if (i != 0) continue;
                    int users = connected.get(i);
                    conStr.append(StringUtil.getRightPaddedStr(String.valueOf(users), ' ', 3));
                    if (users > maxUsers) {
                        maxUsers = users;
                    }
                    conStr.append(" \u6700\u9ad8\u5728\u7ebf: ");
                    conStr.append(maxUsers);
                    break;
                }
                System.out.println(conStr.toString());
                if (maxUsers > 0) {
                    FileoutputUtil.log("\u5728\u7ebf\u7edf\u8ba1.txt", conStr.toString() + "\r\n");
                }
            }
        }, 60000 * time);
    }

    public static void \u5728\u7ebf\u65f6\u95f4(int time) {
        Timer.WorldTimer.getInstance().register(new Runnable(){

            @Override
            public void run() {
                try {
                    for (ChannelServer chan : ChannelServer.getAllInstances()) {
                        for (MapleCharacter chr : chan.getPlayerStorage().getAllCharacters()) {
                            if (chr == null) continue;
                            chr.gainGamePoints(1);
                            if (chr.getGamePoints() >= 5) continue;
                            chr.resetGamePointsPD();
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }, 60000 * time);
    }

    public static class Shutdown
    implements Runnable {
        @Override
        public void run() {
            new Thread(ShutdownServer.getInstance()).start();
        }
    }
}

