/*
 * Decompiled with CFR 0.152.
 */
package server;

import client.MapleClient;
import handling.world.World;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.locks.ReentrantLock;
import tools.FileoutputUtil;
import tools.MaplePacketCreator;

public class AutobanManager
implements Runnable {
    private Map<Integer, Integer> points = new HashMap<Integer, Integer>();
    private Map<Integer, List<String>> reasons = new HashMap<Integer, List<String>>();
    private Set<ExpirationEntry> expirations = new TreeSet<ExpirationEntry>();
    private static final int AUTOBAN_POINTS = 5000;
    private static AutobanManager instance = new AutobanManager();
    private final ReentrantLock lock = new ReentrantLock(true);

    public static final AutobanManager getInstance() {
        return instance;
    }

    public final void autoban(MapleClient c, String reason) {
        if (c.getPlayer().isGM() || c.getPlayer().isClone()) {
            c.getPlayer().dropMessage(5, "[WARNING] A/b triggled : " + reason);
            return;
        }
        this.addPoints(c, 5000, 0L, reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addPoints(MapleClient c, int points, long expiration, String reason) {
        this.lock.lock();
        try {
            List<Object> reasonList;
            int acc = c.getPlayer().getAccountID();
            if (this.points.containsKey(acc)) {
                int SavedPoints = this.points.get(acc);
                if (SavedPoints >= 5000) {
                    return;
                }
                this.points.put(acc, SavedPoints + points);
                reasonList = this.reasons.get(acc);
                reasonList.add(reason);
            } else {
                this.points.put(acc, points);
                reasonList = new LinkedList<String>();
                reasonList.add(reason);
                this.reasons.put(acc, reasonList);
            }
            if (this.points.get(acc) >= 5000) {
                if (c.getPlayer().isGM() || c.getPlayer().isClone()) {
                    c.getPlayer().dropMessage(5, "[WARNING] A/b triggled : " + reason);
                    return;
                }
                StringBuilder sb = new StringBuilder("a/b ");
                sb.append(c.getPlayer().getName());
                sb.append(" (IP ");
                sb.append(c.getSession().getRemoteAddress().toString());
                sb.append("): ");
                sb.append(" (MAC ");
                sb.append(c.getMac());
                sb.append("): ");
                for (String s : this.reasons.get(acc)) {
                    sb.append(s);
                    sb.append(", ");
                }
                World.Broadcast.broadcastMessage(MaplePacketCreator.serverNotice(0, "'" + c.getPlayer().getName() + "'\u81ea\u52a8\u5c01\u53f7\u7cfb\u7edf\u975e\u6cd5\u4f7f\u7528\u5916\u6302\u7a0b\u5e8f\uff01\u6c38\u4e45\u5c01\u505c\u5904\u7406\uff01").getBytes());
                FileoutputUtil.logToFile_chr(c.getPlayer(), "Logs/Log_\u5c01\u53f7.rtf", sb.toString());
                c.getPlayer().ban(sb.toString(), false, true, false);
                c.disconnect(true, false);
            } else if (expiration > 0L) {
                this.expirations.add(new ExpirationEntry(System.currentTimeMillis() + expiration, acc, points));
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public final void run() {
        long now = System.currentTimeMillis();
        for (ExpirationEntry e : this.expirations) {
            if (e.time <= now) {
                this.points.put(e.acc, this.points.get(e.acc) - e.points);
                continue;
            }
            return;
        }
    }

    private static class ExpirationEntry
    implements Comparable<ExpirationEntry> {
        public long time;
        public int acc;
        public int points;

        public ExpirationEntry(long time, int acc, int points) {
            this.time = time;
            this.acc = acc;
            this.points = points;
        }

        @Override
        public int compareTo(ExpirationEntry o) {
            return (int)(this.time - o.time);
        }

        public boolean equals(Object oth) {
            if (!(oth instanceof ExpirationEntry)) {
                return false;
            }
            ExpirationEntry ee = (ExpirationEntry)oth;
            return this.time == ee.time && this.points == ee.points && this.acc == ee.acc;
        }
    }
}

