/*
 * Decompiled with CFR 0.152.
 */
package scripting;

import client.MapleClient;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import scripting.EncodingDetect;
import scripting.PortalPlayerInteraction;
import scripting.PortalScript;
import server.MaplePortal;
import tools.FileoutputUtil;

public class PortalScriptManager {
    private static final PortalScriptManager instance = new PortalScriptManager();
    private final Map<String, PortalScript> scripts = new HashMap<String, PortalScript>();
    private static final ScriptEngineFactory sef = new ScriptEngineManager().getEngineByName("javascript").getFactory();

    public static final PortalScriptManager getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PortalScript getPortalScript(MapleClient c, String scriptName) {
        if (this.scripts.containsKey(scriptName)) {
            this.scripts.clear();
            return this.scripts.get(scriptName);
        }
        File scriptFile = new File("scripts/portal/" + scriptName + ".js");
        if (!scriptFile.exists()) {
            return null;
        }
        FileInputStream fr = null;
        ScriptEngine portal = sef.getScriptEngine();
        try {
            fr = new FileInputStream(scriptFile);
            BufferedReader bf = new BufferedReader(new InputStreamReader((InputStream)fr, EncodingDetect.getJavaEncode(scriptFile)));
            CompiledScript compiled = ((Compilable)((Object)portal)).compile(bf);
            compiled.eval();
        }
        catch (Exception e) {
            System.err.println("Error executing Portalscript: " + scriptName + ":" + e);
            FileoutputUtil.log("Logs/Log_Script_\u811a\u672c\u5f02\u5e38.rtf", "Error executing Portal script. (" + scriptName + ") " + e);
        }
        finally {
            if (fr != null) {
                try {
                    ((InputStream)fr).close();
                }
                catch (IOException e) {
                    System.err.println("ERROR CLOSING" + e);
                }
            }
        }
        PortalScript script = ((Invocable)((Object)portal)).getInterface(PortalScript.class);
        this.scripts.put(scriptName, script);
        return script;
    }

    public final void executePortalScript(MaplePortal portal, MapleClient c) {
        PortalScript script = this.getPortalScript(c, portal.getScriptName());
        if (c.getPlayer().isGM()) {
            c.getPlayer().dropMessage("[\u7cfb\u7edf\u63d0\u793a]\u60a8\u5df2\u7ecf\u5efa\u7acb\u4e0ePortalScript:[" + portal.getScriptName() + ".js]\u7684\u5bf9\u8bdd\u3002" + (script != null ? "" : "(\u811a\u672c\u4e0d\u5b58\u5728\u6216\u5f02\u5e38)"));
        }
        if (script != null) {
            try {
                script.enter(new PortalPlayerInteraction(c, portal));
            }
            catch (Exception e) {
                System.err.println("Error entering Portalscript: " + portal.getScriptName() + ":" + e);
            }
        } else {
            System.out.println("Unhandled portal script " + portal.getScriptName() + " on map " + c.getPlayer().getMapId());
            FileoutputUtil.log("Logs/Log_Script_\u811a\u672c\u5f02\u5e38.rtf", "Unhandled portal script " + portal.getScriptName() + " on map " + c.getPlayer().getMapId());
        }
    }

    public final void clearScripts() {
        this.scripts.clear();
    }
}

