/*
 * Decompiled with CFR 0.152.
 */
package scripting;

import client.MapleClient;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.locks.Lock;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import scripting.AbstractScriptManager;
import scripting.NPCConversationManager;
import server.quest.MapleQuest;
import tools.FileoutputUtil;

public class NPCScriptManager
extends AbstractScriptManager {
    private final Map<MapleClient, NPCConversationManager> cms = new WeakHashMap<MapleClient, NPCConversationManager>();
    private static final NPCScriptManager instance = new NPCScriptManager();

    public static final NPCScriptManager getInstance() {
        return instance;
    }

    public void start(MapleClient c, int npc) {
        this.start(c, npc, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start(MapleClient c, int npc, int wh) {
        Lock lock = c.getNPCLock();
        lock.lock();
        try {
            if (c.getPlayer().isGM()) {
                if (wh == 0) {
                    c.getPlayer().dropMessage("[\u7cfb\u7edf\u63d0\u793a]\u60a8\u5df2\u7ecf\u5efa\u7acb\u4e0eNPC:" + npc + "\u7684\u5bf9\u8bdd\u3002");
                } else {
                    c.getPlayer().dropMessage("[\u7cfb\u7edf\u63d0\u793a]\u60a8\u5df2\u7ecf\u5efa\u7acb\u4e0eNPC:" + npc + "_" + wh + "\u7684\u5bf9\u8bdd\u3002");
                }
            }
            if (!this.cms.containsKey(c)) {
                Invocable iv = wh == 0 ? this.getInvocable("npc/" + npc + ".js", c, true) : this.getInvocable("npc/" + npc + "_" + wh + ".js", c, true);
                ScriptEngine scriptengine = (ScriptEngine)((Object)iv);
                NPCConversationManager cm = wh == 0 ? new NPCConversationManager(c, npc, -1, -1, iv, 0) : new NPCConversationManager(c, npc, -1, -1, iv, wh);
                this.cms.put(c, cm);
                if (iv == null || NPCScriptManager.getInstance() == null) {
                    if (wh == 0) {
                        cm.sendOk("\u6b22\u8fce\u6765\u5230#b\u5192\u9669\u5c9b#k\u3002\u5bf9\u4e0d\u8d77\u6682\u65f6\u65e0\u6cd5\u67e5\u8be2\u5230\u529f\u80fd\u3002\r\n\u6211\u7684ID\u662f: #r" + npc + "#k.\r\n ");
                    } else {
                        cm.sendOk("\u6b22\u8fce\u6765\u5230#b\u5192\u9669\u5c9b#k\u3002\u5bf9\u4e0d\u8d77\u6682\u65f6\u65e0\u6cd5\u67e5\u8be2\u5230\u529f\u80fd\u3002\r\n\u6211\u7684ID\u662f: #r" + npc + "_" + wh + "#k.\r\n ");
                    }
                    cm.dispose();
                    return;
                }
                scriptengine.put("cm", cm);
                scriptengine.put("npcid", npc);
                c.getPlayer().setConversation(1);
                try {
                    iv.invokeFunction("start", new Object[0]);
                }
                catch (NoSuchMethodException nsme) {
                    iv.invokeFunction("action", (byte)1, (byte)0, 0);
                }
            } else {
                c.getPlayer().dropMessage(5, "\u4f60\u73b0\u5728\u5df2\u7ecf\u5047\u6b7b\u8bf7\u4f7f\u7528@ea");
            }
        }
        catch (Exception e) {
            System.err.println("NPC \u8173\u672c\u932f\u8aa4, \u5b83ID\u70ba : " + npc + "_" + wh + "." + e);
            if (c.getPlayer().isGM()) {
                c.getPlayer().dropMessage("[\u7cfb\u7d71\u63d0\u793a] NPC " + npc + "_" + wh + "\u8173\u672c\u932f\u8aa4 " + e + "");
            }
            FileoutputUtil.log("Logs/Log_Script_\u811a\u672c\u5f02\u5e38.rtf", "Error executing NPC script, NPC ID : " + npc + "_" + wh + "." + e);
            this.dispose(c);
        }
        finally {
            lock.unlock();
        }
    }

    public void action(MapleClient c, byte mode, byte type, int selection) {
        this.action(c, mode, type, selection, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void action(MapleClient c, byte mode, byte type, int selection, int wh) {
        if (mode != -1) {
            NPCConversationManager cm = this.cms.get(c);
            if (cm == null || cm.getLastMsg() > -1) {
                return;
            }
            Lock lock = c.getNPCLock();
            lock.lock();
            try {
                if (cm.pendingDisposal) {
                    this.dispose(c);
                } else if (wh == 0) {
                    cm.getIv().invokeFunction("action", mode, type, selection);
                } else {
                    cm.getIv().invokeFunction("action", mode, type, selection, wh);
                }
            }
            catch (Exception e) {
                if (c.getPlayer().isGM()) {
                    c.getPlayer().dropMessage("[\u7cfb\u7d71\u63d0\u793a] NPC " + cm.getNpc() + "_" + wh + "\u8173\u672c\u932f\u8aa4 " + e + "");
                }
                System.err.println("NPC \u8173\u672c\u932f\u8aa4. \u5b83ID\u70ba : " + cm.getNpc() + "_" + wh + ":" + e);
                this.dispose(c);
                FileoutputUtil.log("Logs/Log_Script_\u811a\u672c\u5f02\u5e38.rtf", "Error executing NPC script, NPC ID : " + cm.getNpc() + "_" + wh + "." + e);
            }
            finally {
                lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void startQuest(MapleClient c, int npc, int quest) {
        if (!MapleQuest.getInstance(quest).canStart(c.getPlayer(), null)) {
            return;
        }
        Lock lock = c.getNPCLock();
        lock.lock();
        try {
            if (!this.cms.containsKey(c)) {
                Invocable iv = this.getInvocable("quest/" + quest + ".js", c, true);
                if (iv == null) {
                    this.dispose(c);
                    return;
                }
                ScriptEngine scriptengine = (ScriptEngine)((Object)iv);
                NPCConversationManager cm = new NPCConversationManager(c, npc, quest, 0, iv, 0);
                this.cms.put(c, cm);
                scriptengine.put("qm", cm);
                c.getPlayer().setConversation(1);
                if (c.getPlayer().isGM()) {
                    c.getPlayer().dropMessage("[\u7cfb\u7d71\u63d0\u793a]\u60a8\u5df2\u7d93\u5efa\u7acb\u8207\u4efb\u52d9\u8173\u672c:" + quest + "\u7684\u5f80\u4f86\u3002");
                }
                iv.invokeFunction("start", (byte)1, (byte)0, 0);
            } else {
                this.dispose(c);
            }
        }
        catch (Exception e) {
            System.err.println("Error executing Quest script. (" + quest + ")..NPCID: " + npc + ":" + e);
            FileoutputUtil.log("Logs/Log_Script_\u811a\u672c\u5f02\u5e38.rtf", "Error executing Quest script. (" + quest + ")..NPCID: " + npc + ":" + e);
            this.dispose(c);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void startQuest(MapleClient c, byte mode, byte type, int selection) {
        Lock lock = c.getNPCLock();
        NPCConversationManager cm = this.cms.get(c);
        if (cm == null || cm.getLastMsg() > -1) {
            return;
        }
        lock.lock();
        try {
            if (cm.pendingDisposal) {
                this.dispose(c);
            } else {
                cm.getIv().invokeFunction("start", mode, type, selection);
            }
        }
        catch (Exception e) {
            if (c.getPlayer().isGM()) {
                c.getPlayer().dropMessage("[\u7cfb\u7d71\u63d0\u793a]\u4efb\u52d9\u8173\u672c:" + cm.getQuest() + "\u932f\u8aa4...NPC: " + cm.getNpc() + ":" + e);
            }
            System.err.println("Error executing Quest script. (" + cm.getQuest() + ")...NPC: " + cm.getNpc() + ":" + e);
            FileoutputUtil.log("Logs/Log_Script_\u811a\u672c\u5f02\u5e38.rtf", "Error executing Quest script. (" + cm.getQuest() + ")..NPCID: " + cm.getNpc() + ":" + e);
            this.dispose(c);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void endQuest(MapleClient c, int npc, int quest, boolean customEnd) {
        if (!customEnd && !MapleQuest.getInstance(quest).canComplete(c.getPlayer(), null)) {
            return;
        }
        Lock lock = c.getNPCLock();
        lock.lock();
        try {
            if (!this.cms.containsKey(c)) {
                Invocable iv = this.getInvocable("quest/" + quest + ".js", c, true);
                if (iv == null) {
                    this.dispose(c);
                    return;
                }
                ScriptEngine scriptengine = (ScriptEngine)((Object)iv);
                NPCConversationManager cm = new NPCConversationManager(c, npc, quest, 1, iv, 0);
                this.cms.put(c, cm);
                scriptengine.put("qm", cm);
                c.getPlayer().setConversation(1);
                iv.invokeFunction("end", (byte)1, (byte)0, 0);
            }
        }
        catch (Exception e) {
            if (c.getPlayer().isGM()) {
                c.getPlayer().dropMessage("[\u7cfb\u7d71\u63d0\u793a]\u4efb\u52d9\u8173\u672c:" + quest + "\u932f\u8aa4...NPC: " + quest + ":" + e);
            }
            System.err.println("Error executing Quest script. (" + quest + ")..NPCID: " + npc + ":" + e);
            FileoutputUtil.log("Logs/Log_Script_\u811a\u672c\u5f02\u5e38.rtf", "Error executing Quest script. (" + quest + ")..NPCID: " + npc + ":" + e);
            this.dispose(c);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void endQuest(MapleClient c, byte mode, byte type, int selection) {
        Lock lock = c.getNPCLock();
        NPCConversationManager cm = this.cms.get(c);
        if (cm == null || cm.getLastMsg() > -1) {
            return;
        }
        lock.lock();
        try {
            if (cm.pendingDisposal) {
                this.dispose(c);
            } else {
                cm.getIv().invokeFunction("end", mode, type, selection);
            }
        }
        catch (Exception e) {
            if (c.getPlayer().isGM()) {
                c.getPlayer().dropMessage("[\u7cfb\u7d71\u63d0\u793a]\u4efb\u52d9\u8173\u672c:" + cm.getQuest() + "\u932f\u8aa4...NPC: " + cm.getNpc() + ":" + e);
            }
            System.err.println("Error executing Quest script. (" + cm.getQuest() + ")...NPC: " + cm.getNpc() + ":" + e);
            FileoutputUtil.log("Logs/Log_Script_\u811a\u672c\u5f02\u5e38.rtf", "Error executing Quest script. (" + cm.getQuest() + ")..NPCID: " + cm.getNpc() + ":" + e);
            this.dispose(c);
        }
        finally {
            lock.unlock();
        }
    }

    public final void dispose(MapleClient c) {
        NPCConversationManager npccm = this.cms.get(c);
        if (npccm != null) {
            this.cms.remove(c);
            if (npccm.getType() == -1) {
                if (npccm.getwh() == 0) {
                    c.removeScriptEngine("scripts/npc/" + npccm.getNpc() + ".js");
                } else {
                    c.removeScriptEngine("scripts/npc/" + npccm.getNpc() + "_" + npccm.getwh() + ".js");
                }
                c.removeScriptEngine("scripts/npc/notcoded.js");
            } else {
                c.removeScriptEngine("scripts/quest/" + npccm.getQuest() + ".js");
            }
        }
        if (c.getPlayer() != null && c.getPlayer().getConversation() == 1) {
            c.getPlayer().setConversation(0);
        }
    }

    public final NPCConversationManager getCM(MapleClient c) {
        return this.cms.get(c);
    }
}

