/*
 * Decompiled with CFR 0.152.
 */
package handling.mina;

import client.MapleClient;
import constants.ServerConstants;
import handling.MaplePacket;
import handling.SendPacketOpcode;
import java.util.concurrent.locks.Lock;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolEncoder;
import org.apache.mina.filter.codec.ProtocolEncoderOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tools.FileoutputUtil;
import tools.HexTool;
import tools.MapleAESOFB;
import tools.MapleCustomEncryption;
import tools.data.input.ByteArrayByteStream;
import tools.data.input.GenericLittleEndianAccessor;

public class MaplePacketEncoder
implements ProtocolEncoder {
    private static Logger log = LoggerFactory.getLogger(MaplePacketEncoder.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void encode(IoSession session, Object message, ProtocolEncoderOutput out) throws Exception {
        MapleClient client = (MapleClient)session.getAttribute((Object)"CLIENT");
        if (client != null) {
            MapleAESOFB send_crypto = client.getSendCrypto();
            byte[] inputInitialPacket = ((MaplePacket)message).getBytes();
            if (ServerConstants.\u5c01\u5305\u663e\u793a) {
                int packetLen = inputInitialPacket.length;
                int pHeader = this.readFirstShort(inputInitialPacket);
                String pHeaderStr = Integer.toHexString(pHeader).toUpperCase();
                String op = this.lookupRecv(pHeader);
                boolean show = false;
                switch (op) {
                    case "WARP_TO_MAP": 
                    case "PING": 
                    case "NPC_ACTION": 
                    case "UPDATE_STATS": 
                    case "MOVE_PLAYER": 
                    case "SPAWN_NPC": 
                    case "SPAWN_NPC_REQUEST_CONTROLLER": 
                    case "REMOVE_NPC": 
                    case "MOVE_LIFE": 
                    case "MOVE_MONSTER": 
                    case "MOVE_MONSTER_RESPONSE": 
                    case "SPAWN_MONSTER": 
                    case "SPAWN_MONSTER_CONTROL": 
                    case "ANDROID_MOVE": {
                        show = false;
                    }
                }
                String Recv = "\u670d\u52a1\u7aef\u53d1\u9001 " + op + " [" + pHeaderStr + "] (" + packetLen + ")\r\n";
                if (packetLen <= 50000) {
                    String RecvTo = Recv + HexTool.toString(inputInitialPacket) + "\r\n" + HexTool.toStringFromAscii(inputInitialPacket);
                    if (show) {
                        FileoutputUtil.packetLog("log\\\u670d\u52a1\u7aef\u5c01\u5305.log", RecvTo);
                        System.out.println(RecvTo);
                    }
                } else {
                    log.info(HexTool.toString(new byte[]{inputInitialPacket[0], inputInitialPacket[1]}) + " ...");
                }
            }
            byte[] unencrypted = new byte[inputInitialPacket.length];
            System.arraycopy(inputInitialPacket, 0, unencrypted, 0, inputInitialPacket.length);
            byte[] ret = new byte[unencrypted.length + 4];
            Lock mutex = client.getLock();
            mutex.lock();
            try {
                byte[] header = send_crypto.getPacketHeader(unencrypted.length);
                MapleCustomEncryption.encryptData(unencrypted);
                send_crypto.crypt(unencrypted);
                System.arraycopy(header, 0, ret, 0, 4);
            }
            finally {
                mutex.unlock();
            }
            System.arraycopy(unencrypted, 0, ret, 4, unencrypted.length);
            out.write((Object)IoBuffer.wrap((byte[])ret));
        } else {
            out.write((Object)IoBuffer.wrap((byte[])((MaplePacket)message).getBytes()));
        }
    }

    public void dispose(IoSession session) throws Exception {
    }

    private String lookupRecv(int val) {
        for (SendPacketOpcode op : SendPacketOpcode.values()) {
            if (op.getValue() != val) continue;
            return op.name();
        }
        return "UNKNOWN";
    }

    private int readFirstShort(byte[] arr) {
        return new GenericLittleEndianAccessor(new ByteArrayByteStream(arr)).readShort();
    }
}

