/*
 * Decompiled with CFR 0.152.
 */
package handling.mina;

import client.MapleClient;
import constants.ServerConstants;
import handling.RecvPacketOpcode;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.CumulativeProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tools.FileoutputUtil;
import tools.HexTool;
import tools.MapleAESOFB;
import tools.MapleCustomEncryption;
import tools.data.input.ByteArrayByteStream;
import tools.data.input.GenericLittleEndianAccessor;

public class MaplePacketDecoder
extends CumulativeProtocolDecoder {
    public static final String DECODER_STATE_KEY = MaplePacketDecoder.class.getName() + ".STATE";
    private static Logger log = LoggerFactory.getLogger(MaplePacketDecoder.class);

    protected boolean doDecode(IoSession session, IoBuffer in, ProtocolDecoderOutput out) throws Exception {
        DecoderState decoderState = (DecoderState)session.getAttribute((Object)DECODER_STATE_KEY);
        if (decoderState == null) {
            decoderState = new DecoderState();
            session.setAttribute((Object)DECODER_STATE_KEY, (Object)decoderState);
        }
        MapleClient client = (MapleClient)session.getAttribute((Object)"CLIENT");
        if (decoderState.packetlength == -1) {
            if (in.remaining() >= 4) {
                int packetHeader = in.getInt();
                if (!client.getReceiveCrypto().checkPacket(packetHeader)) {
                    session.close();
                    return false;
                }
                decoderState.packetlength = MapleAESOFB.getPacketLength(packetHeader);
            } else if (in.remaining() < 4 && decoderState.packetlength == -1) {
                log.trace("\u89e3\u7801\u2026\u6ca1\u6709\u8db3\u591f\u7684\u6570\u636e/\u5c31\u662f\u6240\u8c13\u7684\u5305\u4e0d\u5b8c\u6574");
                return false;
            }
        }
        if (in.remaining() >= decoderState.packetlength) {
            byte[] decryptedPacket = new byte[decoderState.packetlength];
            in.get(decryptedPacket, 0, decoderState.packetlength);
            decoderState.packetlength = -1;
            client.getReceiveCrypto().crypt(decryptedPacket);
            MapleCustomEncryption.decryptData(decryptedPacket);
            out.write((Object)decryptedPacket);
            if (ServerConstants.\u5c01\u5305\u663e\u793a) {
                int packetLen = decryptedPacket.length;
                int pHeader = this.readFirstShort(decryptedPacket);
                String pHeaderStr = Integer.toHexString(pHeader).toUpperCase();
                String op = this.lookupSend(pHeader);
                boolean show = true;
                switch (op) {
                    case "PONG": 
                    case "NPC_ACTION": 
                    case "MOVE_LIFE": 
                    case "MOVE_PLAYER": 
                    case "MOVE_ANDROID": 
                    case "MOVE_SUMMON": 
                    case "AUTO_AGGRO": 
                    case "HEAL_OVER_TIME": 
                    case "BUTTON_PRESSED": 
                    case "STRANGE_DATA": {
                        show = false;
                    }
                }
                String Send = "\u5ba2\u6237\u7aef\u53d1\u9001 " + op + " [" + pHeaderStr + "] (" + packetLen + ")\r\n";
                if (packetLen <= 3000) {
                    String SendTo = Send + HexTool.toString(decryptedPacket) + "\r\n" + HexTool.toStringFromAscii(decryptedPacket);
                    if (show) {
                        FileoutputUtil.packetLog("log\\\u5ba2\u6237\u7aef\u5c01\u5305.log", SendTo);
                        System.out.println(SendTo);
                    }
                    String SendTos = "\r\n\u65f6\u95f4\uff1a" + FileoutputUtil.CurrentReadable_Time() + "  ";
                    if (op.equals("UNKNOWN")) {
                        FileoutputUtil.packetLog("log\\\u672a\u77e5\u5ba2\u670d\u7aef\u5c01\u5305.log", SendTos + SendTo);
                    }
                } else {
                    log.info(HexTool.toString(new byte[]{decryptedPacket[0], decryptedPacket[1]}) + "...");
                }
            }
            return true;
        }
        return false;
    }

    private String lookupSend(int val) {
        for (RecvPacketOpcode op : RecvPacketOpcode.values()) {
            if (op.getValue() != val) continue;
            return op.name();
        }
        return "UNKNOWN";
    }

    private int readFirstShort(byte[] arr) {
        return new GenericLittleEndianAccessor(new ByteArrayByteStream(arr)).readShort();
    }

    public static class DecoderState {
        public int packetlength = -1;
    }
}

