/*
 * Decompiled with CFR 0.152.
 */
package handling.channel.handler;

import client.ISkill;
import client.MapleBuffStat;
import client.MapleCharacter;
import client.MapleClient;
import client.SkillFactory;
import client.SummonSkillEntry;
import client.anticheat.CheatingOffense;
import client.status.MonsterStatus;
import client.status.MonsterStatusEffect;
import handling.channel.handler.MovementParse;
import java.awt.Point;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import server.MapleStatEffect;
import server.Timer;
import server.life.MapleMonster;
import server.life.SummonAttackEntry;
import server.maps.MapleMap;
import server.maps.MapleMapObject;
import server.maps.MapleMapObjectType;
import server.maps.MapleSummon;
import server.maps.SummonMovementType;
import server.movement.LifeMovementFragment;
import tools.MaplePacketCreator;
import tools.data.input.SeekableLittleEndianAccessor;
import tools.packet.MobPacket;

public class SummonHandler {
    public static final void MoveDragon(SeekableLittleEndianAccessor slea, MapleCharacter chr) {
        slea.skip(8);
        List<LifeMovementFragment> res = MovementParse.parseMovement(slea, 5);
        if (chr != null && chr.getDragon() != null) {
            Point pos = chr.getDragon().getPosition();
            MovementParse.updatePosition(res, chr.getDragon(), 0);
            if (!chr.isHidden()) {
                chr.getMap().broadcastMessage(chr, MaplePacketCreator.moveDragon(chr.getDragon(), pos, res), chr.getPosition());
            }
            WeakReference<MapleCharacter>[] clones = chr.getClones();
            for (int i = 0; i < clones.length; ++i) {
                if (clones[i].get() == null) continue;
                final MapleMap map = chr.getMap();
                final MapleCharacter clone = (MapleCharacter)clones[i].get();
                final ArrayList<LifeMovementFragment> res3 = new ArrayList<LifeMovementFragment>(res);
                Timer.CloneTimer.getInstance().schedule(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (clone.getMap() == map && clone.getDragon() != null) {
                                Point startPos = clone.getDragon().getPosition();
                                MovementParse.updatePosition(res3, clone.getDragon(), 0);
                                if (!clone.isHidden()) {
                                    map.broadcastMessage(clone, MaplePacketCreator.moveDragon(clone.getDragon(), startPos, res3), clone.getPosition());
                                }
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }, 500 * i + 500);
            }
        }
    }

    public static final void MoveSummon(SeekableLittleEndianAccessor slea, MapleCharacter chr) {
        int oid = slea.readInt();
        Point startPos = new Point(slea.readShort(), slea.readShort());
        List<LifeMovementFragment> res = MovementParse.parseMovement(slea, 4);
        if (chr == null) {
            return;
        }
        for (MapleSummon sum : chr.getSummons().values()) {
            if (sum.getObjectId() != oid || sum.getMovementType() == SummonMovementType.STATIONARY) continue;
            Point pos = sum.getPosition();
            MovementParse.updatePosition(res, sum, 0);
            if (sum.isChangedMap()) break;
            chr.getMap().broadcastMessage(chr, MaplePacketCreator.moveSummon(chr.getId(), oid, startPos, res), sum.getPosition());
            break;
        }
    }

    public static final void DamageSummon(SeekableLittleEndianAccessor slea, MapleCharacter chr) {
        int skillid = slea.readInt();
        byte unkByte = slea.readByte();
        int damage = slea.readInt();
        int monsterIdFrom = slea.readInt();
        Iterator<MapleSummon> iter = chr.getSummons().values().iterator();
        if (SkillFactory.getSkill(skillid) != null) {
            while (iter.hasNext()) {
                MapleSummon summon = iter.next();
                if (!summon.isPuppet() || summon.getOwnerId() != chr.getId()) continue;
                summon.addHP((short)(-damage));
                if (summon.getHP() <= 0) {
                    chr.cancelEffectFromBuffStat(MapleBuffStat.PUPPET);
                }
                chr.getMap().broadcastMessage(chr, MaplePacketCreator.damageSummon(chr.getId(), skillid, damage, unkByte, monsterIdFrom), summon.getPosition());
                break;
            }
        }
    }

    public static void SummonAttack(SeekableLittleEndianAccessor slea, MapleClient c, MapleCharacter chr) {
        ISkill summonSkill;
        MapleStatEffect summonEffect;
        if (chr == null || !chr.isAlive()) {
            return;
        }
        MapleMap map = chr.getMap();
        MapleMapObject obj = map.getMapObject(slea.readInt(), MapleMapObjectType.SUMMON);
        if (obj == null) {
            return;
        }
        MapleSummon summon = (MapleSummon)obj;
        if (summon.getOwnerId() != chr.getId() || summon.getSkillLevel() <= 0) {
            return;
        }
        SummonSkillEntry sse = SkillFactory.getSummonData(summon.getSkill());
        if (sse == null) {
            return;
        }
        slea.skip(8);
        int tick = slea.readInt();
        chr.updateTick(tick);
        summon.CheckSummonAttackFrequency(chr, tick);
        slea.skip(8);
        byte animation = slea.readByte();
        slea.skip(8);
        int numAttacked = slea.readByte();
        if (numAttacked > sse.mobCount) {
            chr.getCheatTracker().registerOffense(CheatingOffense.\u53ec\u5524\u517d\u653b\u51fb\u602a\u7269\u6570\u91cf\u5f02\u5e38);
            return;
        }
        ArrayList<SummonAttackEntry> allDamage = new ArrayList<SummonAttackEntry>();
        chr.getCheatTracker().checkSummonAttack();
        for (int i = 0; i < numAttacked; ++i) {
            MapleMonster mob2 = map.getMonsterByOid(slea.readInt());
            if (mob2 == null) continue;
            if (chr.getPosition().distanceSq(mob2.getPosition()) > 400000.0) {
                chr.getCheatTracker().registerOffense(CheatingOffense.\u53ec\u5524\u517d\u653b\u51fb\u8303\u56f4\u8fc7\u5927);
            }
            slea.skip(14);
            int damage = slea.readInt();
            allDamage.add(new SummonAttackEntry(mob2, damage));
        }
        if (!summon.isChangedMap()) {
            // empty if block
        }
        if ((summonEffect = (summonSkill = SkillFactory.getSkill(summon.getSkill())).getEffect(summon.getSkillLevel())) == null) {
            return;
        }
        for (SummonAttackEntry attackEntry : allDamage) {
            int toDamage = attackEntry.getDamage();
            MapleMonster mob3 = attackEntry.getMonster();
            if (toDamage > 0 && summonEffect.getMonsterStati().size() > 0 && summonEffect.makeChanceResult()) {
                for (Map.Entry<MonsterStatus, Integer> z : summonEffect.getMonsterStati().entrySet()) {
                    mob3.applyStatus(chr, new MonsterStatusEffect(z.getKey(), z.getValue(), summonSkill.getId(), null, false), summonEffect.isPoison(), 4000L, false);
                }
            }
            if (!chr.isGM() && toDamage >= 120000) continue;
            mob3.damage(chr, toDamage, true);
            chr.checkMonsterAggro(mob3);
            if (mob3.isAlive()) continue;
            chr.getClient().getSession().write((Object)MobPacket.killMonster(mob3.getObjectId(), 1));
        }
        if (summon.isGaviota()) {
            chr.getMap().broadcastMessage(MaplePacketCreator.removeSummon(summon, true));
            chr.getMap().removeMapObject(summon);
            chr.removeVisibleMapObject(summon);
            chr.cancelEffectFromBuffStat(MapleBuffStat.SUMMON);
        }
    }
}

