/*
 * Decompiled with CFR 0.152.
 */
package database;

import database.DatabaseException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import server.ServerProperties;

public class DatabaseConnection {
    private static final HashMap<Integer, ConWrapper> connections = new HashMap();
    private static final Logger log = LoggerFactory.getLogger(DatabaseConnection.class);
    private static String dbDriver = "";
    private static String dbUrl = "";
    private static String dbUser = "";
    private static String dbPass = "";
    private static final long connectionTimeOut = 1800000L;
    private static final ReentrantLock lock = new ReentrantLock();
    public static final Runnable CloseSQLConnections = new Runnable(){

        @Override
        public void run() {
            DatabaseConnection.closeTimeout();
        }
    };

    public static int getConnectionsCount() {
        return connections.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void close() {
        block6: {
            try {
                Thread cThread = Thread.currentThread();
                Integer threadID = (int)cThread.getId();
                ConWrapper ret = connections.get(threadID);
                if (ret == null) break block6;
                Connection c = ret.getConnection();
                if (!c.isClosed()) {
                    c.close();
                }
                lock.lock();
                try {
                    connections.remove(threadID);
                }
                finally {
                    lock.unlock();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Connection getConnection() {
        ConWrapper ret;
        block13: {
            Thread cThread;
            Integer threadID;
            if (!DatabaseConnection.isInitialized()) {
                DatabaseConnection.InitDB();
            }
            if ((ret = connections.get(threadID = Integer.valueOf((int)(cThread = Thread.currentThread()).getId()))) == null) {
                Connection retCon = DatabaseConnection.connectToDB();
                ret = new ConWrapper(threadID, retCon);
                lock.lock();
                try {
                    connections.put(threadID, ret);
                }
                finally {
                    lock.unlock();
                }
            }
            Connection c = ret.getConnection();
            try {
                if (!c.isClosed()) break block13;
                Connection retCon = DatabaseConnection.connectToDB();
                lock.lock();
                try {
                    connections.remove(threadID);
                    connections.put(threadID, ret);
                }
                finally {
                    lock.unlock();
                }
                ret = new ConWrapper(threadID, retCon);
            }
            catch (Exception exception) {}
        }
        return ret.getConnection();
    }

    private static Connection connectToDB() {
        try {
            Properties props = new Properties();
            props.put("user", dbUser);
            props.put("password", dbPass);
            props.put("autoReconnect", "true");
            props.put("characterEncoding", "UTF8");
            props.put("connectTimeout", "2000000");
            props.put("serverTimezone", "Asia/Taipei");
            Connection con = DriverManager.getConnection(dbUrl, props);
            PreparedStatement ps = con.prepareStatement("SET time_zone = '+08:00'");
            ps.execute();
            ps.close();
            return con;
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    public static boolean isInitialized() {
        return !dbUser.equals("");
    }

    public static void InitDB() {
        dbDriver = "com.mysql.jdvc.Driver";
        String db = ServerProperties.getProperty("database", "twms");
        String ip = ServerProperties.getProperty("ip", "localhost");
        String port = ServerProperties.getProperty("port", "3306");
        dbUrl = "jdbc:mysql://" + ip + ":" + port + "/" + db + "?autoReconnect=true&characterEncoding=UTF8&maxReconnects=2147483640&connectTimeout=3600000&socketTimeout=3600000";
        dbUser = ServerProperties.getProperty("user", "twms113");
        dbPass = ServerProperties.getProperty("password", "twms113");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeTimeout() {
        int i = 0;
        lock.lock();
        ArrayList<Integer> keys = new ArrayList<Integer>(connections.keySet());
        try {
            for (Integer tid : keys) {
                ConWrapper con = connections.get(tid);
                if (!con.close()) continue;
                ++i;
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeAll() {
        HashMap<Integer, ConWrapper> hashMap = connections;
        synchronized (hashMap) {
            for (ConWrapper con : connections.values()) {
                try {
                    con.connection.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    static class ConWrapper {
        private final int tid;
        private long lastAccessTime;
        private Connection connection;

        public ConWrapper(int tid, Connection con) {
            this.tid = tid;
            this.lastAccessTime = System.currentTimeMillis();
            this.connection = con;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean close() {
            boolean ret = false;
            if (this.connection == null) {
                ret = false;
            } else {
                try {
                    lock.lock();
                    try {
                        if (this.expiredConnection() || this.connection.isValid(10)) {
                            try {
                                this.connection.close();
                                ret = true;
                            }
                            catch (SQLException e) {
                                ret = false;
                            }
                        }
                        connections.remove(this.tid);
                    }
                    finally {
                        lock.unlock();
                    }
                }
                catch (SQLException ex) {
                    ret = false;
                }
            }
            return ret;
        }

        public Connection getConnection() {
            if (this.expiredConnection()) {
                try {
                    this.connection.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                this.connection = DatabaseConnection.connectToDB();
            }
            this.lastAccessTime = System.currentTimeMillis();
            return this.connection;
        }

        public boolean expiredConnection() {
            return System.currentTimeMillis() - this.lastAccessTime >= 1800000L;
        }
    }
}

