/*
 * Decompiled with CFR 0.152.
 */
package client.messages.commands;

import client.ISkill;
import client.LoginCrypto;
import client.MapleCharacter;
import client.MapleCharacterUtil;
import client.MapleClient;
import client.MapleDisease;
import client.MapleStat;
import client.SkillFactory;
import client.anticheat.CheatingOffense;
import client.inventory.Equip;
import client.inventory.IItem;
import client.inventory.ItemFlag;
import client.inventory.MapleInventoryIdentifier;
import client.inventory.MapleInventoryType;
import client.inventory.MaplePet;
import client.inventory.MapleRing;
import client.messages.CommandProcessorUtil;
import client.messages.commands.CommandExecute;
import com.mysql.jdbc.Connection;
import com.mysql.jdbc.PreparedStatement;
import constants.GameConstants;
import constants.ServerConstants;
import database.DatabaseConnection;
import handling.RecvPacketOpcode;
import handling.SendPacketOpcode;
import handling.channel.ChannelServer;
import handling.login.LoginServer;
import handling.login.handler.AutoRegister;
import handling.world.CheaterData;
import handling.world.World;
import handling.world.family.MapleFamily;
import handling.world.guild.MapleGuild;
import java.awt.Point;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import org.apache.mina.core.session.IoSession;
import scripting.EventManager;
import scripting.NPCScriptManager;
import scripting.PortalScriptManager;
import scripting.ReactorScriptManager;
import server.CashItemFactory;
import server.MapleInventoryManipulator;
import server.MapleItemInformationProvider;
import server.MaplePortal;
import server.MapleShopFactory;
import server.ShutdownServer;
import server.Timer;
import server.events.MapleEvent;
import server.events.MapleEventType;
import server.events.MapleOxQuizFactory;
import server.life.MapleLifeFactory;
import server.life.MapleMonster;
import server.life.MapleMonsterInformationProvider;
import server.life.MapleNPC;
import server.life.MobSkillFactory;
import server.life.OverrideMonsterStats;
import server.life.PlayerNPC;
import server.maps.MapleMap;
import server.maps.MapleMapObject;
import server.maps.MapleMapObjectType;
import server.maps.MapleReactor;
import server.maps.MapleReactorFactory;
import server.maps.MapleReactorStats;
import server.quest.MapleQuest;
import tools.ArrayMap;
import tools.CPUSampler;
import tools.FileoutputUtil;
import tools.HexTool;
import tools.MaplePacketCreator;
import tools.MockIOSession;
import tools.StringUtil;
import tools.data.output.MaplePacketLittleEndianWriter;
import tools.packet.MobPacket;

public class AdminCommand {
    public static ServerConstants.PlayerGMRank getPlayerLevelRequired() {
        return ServerConstants.PlayerGMRank.ADMIN;
    }

    public static class reloadcpq
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            c.getPlayer().getMap().reloadCPQ();
            c.getPlayer().dropMessage("\u5609\u5e74\u534e\u5730\u56fe\u66f4\u65b0\u6210\u529f");
            return 1;
        }
    }

    public static class closemap
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            int mapid = 0;
            String input = null;
            Object map = null;
            if (splitted.length < 2) {
                c.getPlayer().dropMessage(splitted[0] + " - \u5173\u95ed\u5730\u56fe");
                return 0;
            }
            try {
                input = splitted[1];
                mapid = Integer.parseInt(input);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (c.getChannelServer().getMapFactory().getMap(mapid) == null) {
                c.getPlayer().dropMessage("\u5730\u56fe\u4e0d\u5b58\u5728");
                return 0;
            }
            for (ChannelServer cserv : ChannelServer.getAllInstances()) {
                cserv.getMapFactory().destroyMap(mapid, true);
            }
            return 1;
        }
    }

    public static class openmap
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            int mapid = 0;
            String input = null;
            Object map = null;
            if (splitted.length < 2) {
                c.getPlayer().dropMessage(splitted[0] + " - \u5f00\u653e\u5730\u56fe");
                return 0;
            }
            try {
                input = splitted[1];
                mapid = Integer.parseInt(input);
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (ChannelServer cserv : ChannelServer.getAllInstances()) {
                cserv.getMapFactory().HealMap(mapid);
            }
            return 1;
        }
    }

    public static class register
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            java.sql.Connection con;
            String acc = null;
            String password = null;
            try {
                acc = splitted[1];
                password = splitted[2];
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (acc == null || password == null) {
                c.getPlayer().dropMessage("\u8d26\u53f7\u6216\u5bc6\u7801\u5f02\u5e38");
                return 0;
            }
            boolean ACCexist = AutoRegister.getAccountExists(acc);
            if (ACCexist) {
                c.getPlayer().dropMessage("\u5e10\u53f7\u5df2\u88ab\u4f7f\u7528");
                return 0;
            }
            if (acc.length() >= 12) {
                c.getPlayer().dropMessage("\u5bc6\u7801\u957f\u5ea6\u8fc7\u957f");
                return 0;
            }
            try {
                con = DatabaseConnection.getConnection();
            }
            catch (Exception ex) {
                System.out.println(ex);
                return 0;
            }
            try (PreparedStatement ps = (PreparedStatement)con.prepareStatement("INSERT INTO accounts (name, password, md5pass) VALUES (?, ? ,?)");){
                ps.setString(1, acc);
                ps.setString(2, LoginCrypto.hexSha1(password));
                ps.setString(3, "");
                ps.executeUpdate();
                ps.close();
            }
            catch (SQLException ex) {
                System.out.println(ex);
                return 0;
            }
            c.getPlayer().dropMessage("[\u6ce8\u518c\u5b8c\u6210]\u8d26\u53f7: " + acc + " \u5bc6\u7801: " + password);
            return 1;
        }
    }

    public static class mob
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            MapleMonster monster = null;
            for (MapleMapObject monstermo : c.getPlayer().getMap().getMapObjectsInRange(c.getPlayer().getPosition(), 100000.0, Arrays.asList(MapleMapObjectType.MONSTER))) {
                monster = (MapleMonster)monstermo;
                if (!monster.isAlive()) continue;
                c.getPlayer().dropMessage(6, "\u602a\u7269 " + monster.toString());
            }
            if (monster == null) {
                c.getPlayer().dropMessage(6, "\u627e\u4e0d\u5230\u602a\u7269");
            }
            return 1;
        }
    }

    public static class Packet
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            MaplePacketLittleEndianWriter mplew = new MaplePacketLittleEndianWriter();
            int packetheader = Integer.parseInt(splitted[1]);
            String packet_in = " 00 00 00 00 00 00 00 00 00 ";
            if (splitted.length > 2) {
                packet_in = StringUtil.joinStringFrom(splitted, 2);
            }
            mplew.writeShort(packetheader);
            mplew.write(HexTool.getByteArrayFromHexString(packet_in));
            mplew.writeZeroBytes(20);
            c.getSession().write((Object)mplew.getPacket());
            c.getPlayer().dropMessage(packetheader + "\u5df2\u4f20\u9001\u5c01\u5305[" + mplew.getPacket().getBytes().length + "] : " + mplew.toString());
            return 1;
        }
    }

    public static class WhereAmI
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            c.getPlayer().dropMessage(5, "\u76ee\u524d\u5730\u56fe " + c.getPlayer().getMap().getId() + "\u5750\u6807 (" + String.valueOf(c.getPlayer().getPosition().x) + " , " + String.valueOf(c.getPlayer().getPosition().y) + ")");
            return 1;
        }
    }

    public static class maxstats
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            MapleCharacter player = c.getPlayer();
            player.getStat().setMaxHp((short)30000);
            player.getStat().setMaxMp((short)30000);
            player.getStat().setStr((short)Short.MAX_VALUE);
            player.getStat().setDex((short)Short.MAX_VALUE);
            player.getStat().setInt((short)Short.MAX_VALUE);
            player.getStat().setLuk((short)Short.MAX_VALUE);
            player.updateSingleStat(MapleStat.MAXHP, 30000);
            player.updateSingleStat(MapleStat.MAXMP, 30000);
            player.updateSingleStat(MapleStat.STR, Short.MAX_VALUE);
            player.updateSingleStat(MapleStat.DEX, Short.MAX_VALUE);
            player.updateSingleStat(MapleStat.INT, Short.MAX_VALUE);
            player.updateSingleStat(MapleStat.LUK, Short.MAX_VALUE);
            return 1;
        }
    }

    public static class buff
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            MapleCharacter player = c.getPlayer();
            SkillFactory.getSkill(9001002).getEffect(1).applyTo(player);
            SkillFactory.getSkill(9001003).getEffect(1).applyTo(player);
            SkillFactory.getSkill(9001008).getEffect(1).applyTo(player);
            SkillFactory.getSkill(9001001).getEffect(1).applyTo(player);
            return 1;
        }
    }

    public static class Drop
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            if (splitted.length < 2) {
                return 0;
            }
            int itemId = 0;
            try {
                itemId = Integer.parseInt(splitted[1]);
            }
            catch (NumberFormatException ex) {
                ex.printStackTrace();
            }
            short quantity = (short)CommandProcessorUtil.getOptionalIntArg(splitted, 2, 1);
            MapleItemInformationProvider ii = MapleItemInformationProvider.getInstance();
            if (GameConstants.isPet(itemId)) {
                c.getPlayer().dropMessage(5, "\u5ba0\u7269\u8bf7\u5230\u8d2d\u7269\u5546\u57ce\u8d2d\u4e70.");
            } else if (!ii.itemExists(itemId)) {
                c.getPlayer().dropMessage(5, itemId + " - \u7269\u54c1\u4e0d\u5b58\u5728");
            } else {
                client.inventory.Item toDrop = GameConstants.getInventoryType(itemId) == MapleInventoryType.EQUIP ? ii.randomizeStats((Equip)ii.getEquipById(itemId)) : new client.inventory.Item(itemId, 0, quantity, 0);
                toDrop.setGMLog(c.getPlayer().getName());
                c.getPlayer().getMap().spawnItemDrop(c.getPlayer(), c.getPlayer(), toDrop, c.getPlayer().getPosition(), true, true);
            }
            return 1;
        }
    }

    public static class maxSkills
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            MapleCharacter player = c.getPlayer();
            player.maxSkills();
            return 1;
        }
    }

    public static class WarpAllHere
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            for (ChannelServer CS : ChannelServer.getAllInstances()) {
                for (MapleCharacter mch : CS.getPlayerStorage().getAllCharactersThreadSafe()) {
                    if (mch.getMapId() != c.getPlayer().getMapId()) {
                        mch.changeMap(c.getPlayer().getMap(), c.getPlayer().getPosition());
                    }
                    if (mch.getClient().getChannel() == c.getPlayer().getClient().getChannel()) continue;
                    mch.changeChannel(c.getPlayer().getClient().getChannel());
                }
            }
            return 1;
        }

        public String getMessage() {
            return "!WarpAllHere \u628a\u6240\u6709\u73a9\u5bb6\u4f20\u9001\u5230\u8fd9\u91cc";
        }
    }

    public static class setRate
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            MapleCharacter player;
            MapleCharacter mc = player = c.getPlayer();
            if (splitted.length > 2) {
                int arg = Integer.parseInt(splitted[2]);
                int seconds = Integer.parseInt(splitted[3]);
                int mins = Integer.parseInt(splitted[4]);
                int hours = Integer.parseInt(splitted[5]);
                int time = seconds + mins * 60 + hours * 60 * 60;
                boolean bOk = true;
                if (splitted[1].equals("\u7ecf\u9a8c")) {
                    if (arg <= 1000) {
                        for (ChannelServer cservs : ChannelServer.getAllInstances()) {
                            cservs.setExpRate(arg);
                            cservs.broadcastPacket(MaplePacketCreator.serverNotice(6, "\u7ecf\u9a8c\u500d\u7387\u5df2\u7ecf\u6210\u529f\u4fee\u6539\u4e3a " + arg + "\u500d\u3002\u795d\u5927\u5bb6\u6e38\u620f\u5f00\u5fc3.\u7ecf\u9a8c\u500d\u7387\u5c06\u5728\u65f6\u95f4\u5230\u540e\u81ea\u52a8\u66f4\u6b63\uff01"));
                        }
                    } else {
                        mc.dropMessage("\u64cd\u4f5c\u5df2\u88ab\u7cfb\u7edf\u9650\u5236\u3002");
                    }
                } else if (splitted[1].equals("\u7206\u7387")) {
                    if (arg <= 50) {
                        for (ChannelServer cservs : ChannelServer.getAllInstances()) {
                            cservs.setDropRate(arg);
                            cservs.broadcastPacket(MaplePacketCreator.serverNotice(6, "\u7206\u7387\u500d\u7387\u5df2\u7ecf\u6210\u529f\u4fee\u6539\u4e3a " + arg + "\u500d\u3002\u795d\u5927\u5bb6\u6e38\u620f\u5f00\u5fc3.\u7206\u7387\u500d\u7387\u5c06\u5728\u65f6\u95f4\u5230\u540e\u81ea\u52a8\u66f4\u6b63\uff01\uff01"));
                        }
                    } else {
                        mc.dropMessage("\u64cd\u4f5c\u5df2\u88ab\u7cfb\u7edf\u9650\u5236\u3002");
                    }
                } else if (splitted[1].equals("\u91d1\u5e01")) {
                    if (arg <= 50) {
                        for (ChannelServer cservs : ChannelServer.getAllInstances()) {
                            cservs.setMesoRate(arg);
                            cservs.broadcastPacket(MaplePacketCreator.serverNotice(6, "\u91d1\u5e01\u500d\u7387\u5df2\u7ecf\u6210\u529f\u4fee\u6539\u4e3a " + arg + "\u500d\u3002\u795d\u5927\u5bb6\u6e38\u620f\u5f00\u5fc3.\u91d1\u5e01\u500d\u7387\u5c06\u5728\u65f6\u95f4\u5230\u540e\u81ea\u52a8\u66f4\u6b63\uff01\uff01"));
                        }
                    } else {
                        mc.dropMessage("\u64cd\u4f5c\u5df2\u88ab\u7cfb\u7edf\u9650\u5236\u3002");
                    }
                } else if (splitted[1].equalsIgnoreCase("boss\u7206\u7387")) {
                    if (arg <= 50) {
                        for (ChannelServer cservs : ChannelServer.getAllInstances()) {
                            cservs.setBossDropRate(arg);
                            cservs.broadcastPacket(MaplePacketCreator.serverNotice(6, "BOSS\u6389\u5b9d\u5df2\u7ecf\u6210\u529f\u4fee\u6539\u4e3a " + arg + "\u500d\u3002\u795d\u5927\u5bb6\u6e38\u620f\u5f00\u5fc3.boos\u6389\u843d\u500d\u7387\u5c06\u5728\u65f6\u95f4\u5230\u540e\u81ea\u52a8\u66f4\u6b63\uff01\uff01"));
                        }
                    } else {
                        mc.dropMessage("\u64cd\u4f5c\u5df2\u88ab\u7cfb\u7edf\u9650\u5236\u3002");
                    }
                } else if (splitted[1].equals("\u5ba0\u7269\u7ecf\u9a8c")) {
                    if (arg > 5) {
                        mc.dropMessage("\u64cd\u4f5c\u5df2\u88ab\u7cfb\u7edf\u9650\u5236\u3002");
                    }
                } else {
                    bOk = false;
                }
                if (bOk) {
                    String rate = splitted[1];
                    World.scheduleRateDelay(rate, time);
                } else {
                    mc.dropMessage("\u4f7f\u7528\u65b9\u6cd5: !\u500d\u7387\u8bbe\u7f6e <exp\u7ecf\u9a8c|drop\u7206\u7387|meso\u91d1\u5e01|bossboss\u7206\u7387|pet> <\u7c7b> <\u79d2> <\u5206> <\u65f6>");
                }
            } else {
                mc.dropMessage("\u4f7f\u7528\u65b9\u6cd5: !\u500d\u7387\u8bbe\u7f6e <exp\u7ecf\u9a8c|drop\u7206\u7387|meso\u91d1\u5e01|bossboss\u7206\u7387|pet> <\u7c7b> <\u79d2> <\u5206> <\u65f6>");
            }
            return 1;
        }
    }

    public static class mesoEveryone
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            if (splitted.length < 2) {
                c.getPlayer().dropMessage(splitted[0] + " <\u91d1\u5e01\u91cf>");
                return 0;
            }
            int ret = 0;
            int gain = Integer.parseInt(splitted[1]);
            for (MapleCharacter mch : c.getChannelServer().getPlayerStorage().getAllCharactersThreadSafe()) {
                mch.gainMeso(gain, true);
                ++ret;
            }
            for (ChannelServer cserv1 : ChannelServer.getAllInstances()) {
                for (MapleCharacter mch : cserv1.getPlayerStorage().getAllCharacters()) {
                    mch.startMapEffect("\u7ba1\u7406\u5458\u53d1\u653e" + gain + "\u5192\u9669\u5e01\u7ed9\u5728\u7ebf\u7684\u6240\u6709\u73a9\u5bb6\uff01\u795d\u60a8\u73a9\u7684\u5f00\u5fc3\u73a9\u7684\u5feb\u4e50", 5121009);
                }
            }
            c.getPlayer().dropMessage(6, "\u547d\u4ee4\u4f7f\u7528\u6210\u529f\uff0c\u5f53\u524d\u5171\u6709: " + ret + " \u4e2a\u73a9\u5bb6\u83b7\u5f97: " + gain + " \u5192\u9669\u5e01 " + " \u603b\u8ba1: " + ret * gain);
            return 1;
        }
    }

    public static class CashEveryone
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            if (splitted.length > 2) {
                int type = Integer.parseInt(splitted[1]);
                int quantity = Integer.parseInt(splitted[2]);
                switch (type) {
                    case 1: {
                        type = 1;
                        break;
                    }
                    case 2: {
                        type = 2;
                        break;
                    }
                    default: {
                        c.getPlayer().dropMessage(6, "\u7528\u6cd5: !\u7ed9\u6240\u6709\u4eba\u70b9\u5377 [\u70b9\u5377\u7c7b\u578b1-2] [\u70b9\u5377\u6570\u91cf][1\u662f\u70b9\u5377.2\u662f\u62b5\u7528\u5377]");
                        return 0;
                    }
                }
                int ret = 0;
                for (ChannelServer cserv : ChannelServer.getAllInstances()) {
                    for (MapleCharacter mch : cserv.getPlayerStorage().getAllCharacters()) {
                        mch.modifyCSPoints(type, quantity);
                        ++ret;
                    }
                }
                String show = type == 1 ? "\u70b9\u5377" : "\u62b5\u7528\u5377";
                for (ChannelServer cserv1 : ChannelServer.getAllInstances()) {
                    for (MapleCharacter mch : cserv1.getPlayerStorage().getAllCharacters()) {
                        mch.startMapEffect("\u7ba1\u7406\u5458\u53d1\u653e" + quantity + show + "\u70b9\u5377\u7ed9\u5728\u7ebf\u7684\u6240\u6709\u73a9\u5bb6\uff01\u795d\u60a8\u7684\u5f00\u5fc3\u73a9\u7684\u5feb\u4e50", 5121009);
                    }
                }
                c.getPlayer().dropMessage(6, "\u547d\u4ee4\u4f7f\u7528\u6210\u529f\uff0c\u5f53\u524d\u5171\u6709: " + ret + " \u4e2a\u73a9\u5bb6\u83b7\u5f97: " + quantity + " \u70b9\u7684" + (type == 1 ? "\u70b9\u5238 " : " \u62b5\u7528\u5238 ") + " \u603b\u8ba1: " + ret * quantity);
            } else {
                c.getPlayer().dropMessage(6, "\u7528\u6cd5: !\u7ed9\u6240\u6709\u4eba\u70b9\u5377 [\u70b9\u5377\u7c7b\u578b1-2] [\u70b9\u5377\u6570\u91cf][1\u662f\u70b9\u5377.2\u662f\u62b5\u7528\u5377]");
            }
            return 1;
        }
    }

    public static class ExpEveryone
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            if (splitted.length < 2) {
                c.getPlayer().dropMessage(splitted[0] + " <\u7ecf\u9a8c\u91cf>");
                return 0;
            }
            int gain = Integer.parseInt(splitted[1]);
            int ret = 0;
            for (ChannelServer cserv : ChannelServer.getAllInstances()) {
                for (MapleCharacter mch : cserv.getPlayerStorage().getAllCharacters()) {
                    mch.gainExp(gain, true, true, true);
                    ++ret;
                }
            }
            for (ChannelServer cserv1 : ChannelServer.getAllInstances()) {
                for (MapleCharacter mch : cserv1.getPlayerStorage().getAllCharacters()) {
                    mch.startMapEffect("\u7ba1\u7406\u5458\u53d1\u653e" + gain + "\u7ecf\u9a8c\u7ed9\u5728\u7ebf\u7684\u6240\u6709\u73a9\u5bb6\uff01\u795d\u60a8\u73a9\u7684\u5f00\u5fc3\u73a9\u7684\u5feb\u4e50", 5121009);
                }
            }
            c.getPlayer().dropMessage(6, "\u547d\u4ee4\u4f7f\u7528\u6210\u529f\uff0c\u5f53\u524d\u5171\u6709: " + ret + " \u4e2a\u73a9\u5bb6\u83b7\u5f97: " + gain + " \u70b9\u7684" + " \u7ecf\u9a8c " + " \u603b\u8ba1: " + ret * gain);
            return 1;
        }
    }

    public static class RemoveItemOff
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            if (splitted.length < 2) {
                return 0;
            }
            Connection dcon = (Connection)DatabaseConnection.getConnection();
            try {
                int id = 0;
                int quantity = 0;
                String name = splitted[2];
                PreparedStatement ps = (PreparedStatement)dcon.prepareStatement("select * from characters where name = ?");
                ps.setString(1, name);
                try (ResultSet rs = ps.executeQuery();){
                    if (rs.next()) {
                        id = rs.getInt("id");
                    }
                }
                if (id == 0) {
                    c.getPlayer().dropMessage(5, "\u89d2\u8272\u4e0d\u5b58\u5728\u8d44\u6599\u5e93\u3002");
                    return 0;
                }
                PreparedStatement ps2 = (PreparedStatement)dcon.prepareStatement("delete from inventoryitems WHERE itemid = ? and characterid = ?");
                ps2.setInt(1, Integer.parseInt(splitted[1]));
                ps2.setInt(2, id);
                ps2.executeUpdate();
                c.getPlayer().dropMessage(6, "\u6240\u6709ID\u4e3a " + splitted[1] + " \u7684\u9053\u5177" + quantity + "\u5df2\u7ecf\u4ece " + name + " \u8eab\u4e0a\u88ab\u79fb\u9664\u4e86");
                ps.close();
                ps2.close();
                return 1;
            }
            catch (SQLException e) {
                return 0;
            }
        }

        public String getMessage() {
            return "!removeitem <\u7269\u54c1ID> <\u89d2\u8272\u540d\u7a31> - \u79fb\u9664\u73a9\u5bb6\u8eab\u4e0a\u7684\u9053\u5177";
        }
    }

    public static class copyInv
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            MapleCharacter player = c.getPlayer();
            int type = 1;
            if (splitted.length < 2) {
                return 0;
            }
            String name = splitted[1];
            int ch = World.Find.findChannel(name);
            if (ch <= 0) {
                c.getPlayer().dropMessage(6, "\u73a9\u5bb6\u5fc5\u987b\u5728\u7ebf");
                return 0;
            }
            MapleCharacter victim = ChannelServer.getInstance(ch).getPlayerStorage().getCharacterByName(name);
            if (victim == null) {
                player.dropMessage("\u627e\u4e0d\u5230\u8be5\u73a9\u5bb6");
                return 1;
            }
            try {
                type = Integer.parseInt(splitted[2]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (type == 0) {
                for (IItem ii : victim.getInventory(MapleInventoryType.EQUIPPED).list()) {
                    IItem n = ii.copy();
                    player.getInventory(MapleInventoryType.EQUIP).addItem(n);
                }
                player.fakeRelog();
            } else {
                int i;
                MapleInventoryType types = type == 1 ? MapleInventoryType.EQUIP : (type == 2 ? MapleInventoryType.USE : (type == 3 ? MapleInventoryType.ETC : (type == 4 ? MapleInventoryType.SETUP : (type == 5 ? MapleInventoryType.CASH : null))));
                if (types == null) {
                    c.getPlayer().dropMessage("\u53d1\u751f\u9519\u8bef");
                    return 1;
                }
                int[] equip = new int[97];
                for (i = 1; i < 97; ++i) {
                    if (victim.getInventory(types).getItem((short)i) == null) continue;
                    equip[i] = i;
                }
                for (i = 0; i < equip.length; ++i) {
                    if (equip[i] == 0) continue;
                    IItem n = victim.getInventory(types).getItem((short)equip[i]).copy();
                    player.getInventory(types).addItem(n);
                }
                player.fakeRelog();
            }
            return 1;
        }

        public String getMessage() {
            return "!copyinv \u73a9\u5bb6\u540d\u79f0 \u88c5\u5907\u680f\u4f4d(0 = \u88c5\u5907\u4e2d 1=\u88c5\u5907\u680f 2=\u6d88\u8017\u680f 3=\u5176\u4ed6\u680f 4=\u88c5\u9970\u680f 5=\u70b9\u6570\u680f)(\u9884\u8bbe\u88c5\u5907\u680f) - \u590d\u5236\u73a9\u5bb6\u9053\u5177";
        }
    }

    public static class PNPC
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            int npcId = Integer.parseInt(splitted[1]);
            MapleNPC npc = MapleLifeFactory.getNPC(npcId);
            if (npc != null && !npc.getName().equals("MISSINGNO")) {
                int xpos = c.getPlayer().getPosition().x;
                int ypos = c.getPlayer().getPosition().y;
                int fh = c.getPlayer().getMap().getFootholds().findBelow(c.getPlayer().getPosition()).getId();
                npc.setPosition(c.getPlayer().getPosition());
                npc.setCy(ypos);
                npc.setRx0(xpos);
                npc.setRx1(xpos);
                npc.setFh(fh);
                npc.setCustom(true);
                try {
                    Connection con = (Connection)DatabaseConnection.getConnection();
                    try (PreparedStatement ps = (PreparedStatement)con.prepareStatement("INSERT INTO wz_customlife (dataid, f, hide, fh, cy, rx0, rx1, type, x, y, mid) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");){
                        ps.setInt(1, npcId);
                        ps.setInt(2, 0);
                        ps.setInt(3, 0);
                        ps.setInt(4, fh);
                        ps.setInt(5, ypos);
                        ps.setInt(6, xpos);
                        ps.setInt(7, xpos);
                        ps.setString(8, "n");
                        ps.setInt(9, xpos);
                        ps.setInt(10, ypos);
                        ps.setInt(11, c.getPlayer().getMapId());
                        ps.executeUpdate();
                    }
                }
                catch (SQLException e) {
                    c.getPlayer().dropMessage(6, "Failed to save NPC to the database");
                }
                for (ChannelServer cserv : ChannelServer.getAllInstances()) {
                    cserv.getMapFactory().getMap(c.getPlayer().getMapId()).addMapObject(npc);
                    cserv.getMapFactory().getMap(c.getPlayer().getMapId()).broadcastMessage(MaplePacketCreator.spawnNPC(npc, true));
                }
                c.getPlayer().dropMessage(6, "Please do not reload this map or else the NPC will disappear till the next restart.");
            } else {
                c.getPlayer().dropMessage(6, "\u67e5\u65e0\u6b64 Npc ");
            }
            return 1;
        }

        public String getMessage() {
            return "!\u6c38\u4e45npc - \u5efa\u7acb\u6c38\u4e45NPC";
        }
    }

    public static class Reloadall
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            for (ChannelServer instance : ChannelServer.getAllInstances()) {
                instance.reloadEvents();
            }
            MapleShopFactory.getInstance().clear();
            PortalScriptManager.getInstance().clearScripts();
            MapleItemInformationProvider.getInstance().load();
            CashItemFactory.getInstance().initialize();
            MapleMonsterInformationProvider.getInstance().clearDrops();
            MapleGuild.loadAll();
            MapleFamily.loadAll();
            MapleLifeFactory.loadQuestCounts();
            MapleQuest.initQuests();
            MapleOxQuizFactory.getInstance();
            ReactorScriptManager.getInstance().clearDrops();
            SendPacketOpcode.reloadValues();
            RecvPacketOpcode.reloadValues();
            return 1;
        }

        public String getMessage() {
            return "!Reloadall - \u91cd\u7f6e\u5168\u670d\u52a1\u5668";
        }
    }

    public static class ResetMap
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            c.getPlayer().getMap().resetFully();
            return 1;
        }

        public String getMessage() {
            return "!respawn - \u91cd\u7f6e\u8fd9\u4e2a\u5730\u56fe";
        }
    }

    public static class Respawn
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            c.getPlayer().getMap().respawn(true);
            return 1;
        }

        public String getMessage() {
            return "!respawn - \u91cd\u65b0\u8f7d\u5165\u5730\u56fe";
        }
    }

    public static class ReloadMap
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            MapleMap map;
            MapleCharacter player = c.getPlayer();
            if (splitted.length < 2) {
                return 0;
            }
            boolean custMap = splitted.length >= 2;
            int mapid = custMap ? Integer.parseInt(splitted[1]) : player.getMapId();
            MapleMap mapleMap = map = custMap ? player.getClient().getChannelServer().getMapFactory().getMap(mapid) : player.getMap();
            if (player.getClient().getChannelServer().getMapFactory().destroyMap(mapid)) {
                MapleMap newMap = player.getClient().getChannelServer().getMapFactory().getMap(mapid);
                MaplePortal newPor = newMap.getPortal(0);
                LinkedHashSet<MapleCharacter> mcs = new LinkedHashSet<MapleCharacter>(map.getCharacters());
                block2: for (MapleCharacter m : mcs) {
                    for (int x = 0; x < 5; ++x) {
                        try {
                            m.changeMap(newMap, newPor);
                            continue block2;
                        }
                        catch (Throwable throwable) {
                            continue;
                        }
                    }
                    player.dropMessage("Failed warping " + m.getName() + " to the new map. Skipping...");
                }
                player.dropMessage("\u5730\u56fe\u5237\u65b0\u5b8c\u6bd5\uff0c\u5982\u8fd8\u51fa\u73b0NPC\u4e0d\u89c1\u8bf7\u4f7f\u7528\u6b64\u547d\u4ee4.");
                return 1;
            }
            player.dropMessage("Unsuccessful reset!");
            return 1;
        }

        public String getMessage() {
            return "!reloadmap <maipid> - \u91cd\u7f6e\u67d0\u4e2a\u5730\u56fe";
        }
    }

    public static class StopProfiling
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            CPUSampler sampler = CPUSampler.getInstance();
            try {
                File file;
                String filename = "odinprofile.txt";
                if (splitted.length > 1) {
                    filename = splitted[1];
                }
                if ((file = new File(filename)).exists()) {
                    c.getPlayer().dropMessage(6, "The entered filename already exists, choose a different one");
                    return 1;
                }
                sampler.stop();
                try (FileWriter fw = new FileWriter(file);){
                    sampler.save(fw, 1, 10);
                }
            }
            catch (IOException e) {
                System.err.println("Error saving profile" + e);
            }
            sampler.reset();
            return 1;
        }

        public String getMessage() {
            return "!stopprofiling <filename> - \u53d6\u6d88\u8bb0\u5f55JVM\u8d44\u8baf\u5e76\u4fdd\u5b58\u5230\u6863\u6848";
        }
    }

    public static class StartProfiling
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            CPUSampler sampler = CPUSampler.getInstance();
            sampler.addIncluded("client");
            sampler.addIncluded("constants");
            sampler.addIncluded("database");
            sampler.addIncluded("handling");
            sampler.addIncluded("provider");
            sampler.addIncluded("scripting");
            sampler.addIncluded("server");
            sampler.addIncluded("tools");
            sampler.start();
            return 1;
        }

        public String getMessage() {
            return "!startprofiling \u5f00\u59cb\u8bb0\u5f55JVM\u8d44\u8baf";
        }
    }

    public static class Map
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            if (splitted.length < 2) {
                return 0;
            }
            try {
                MapleMap target = c.getChannelServer().getMapFactory().getMap(Integer.parseInt(splitted[1]));
                if (target == null) {
                    c.getPlayer().dropMessage(5, "\u5730\u56fe\u4e0d\u5b58\u5728.");
                    return 1;
                }
                MaplePortal targetPortal = null;
                if (splitted.length > 2) {
                    try {
                        targetPortal = target.getPortal(Integer.parseInt(splitted[2]));
                    }
                    catch (IndexOutOfBoundsException e) {
                        c.getPlayer().dropMessage(5, "\u4f20\u9001\u70b9\u9519\u8bef.");
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (targetPortal == null) {
                    targetPortal = target.getPortal(0);
                }
                c.getPlayer().changeMap(target, targetPortal);
            }
            catch (Exception e) {
                c.getPlayer().dropMessage(5, "Error: " + e.getMessage());
            }
            return 1;
        }

        public String getMessage() {
            return "!map <mapid|charname> [portal] - \u4f20\u9001\u5230\u67d0\u5730\u56fe/\u4eba";
        }
    }

    public static class LOLCastle
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            if (splitted.length != 2) {
                return 0;
            }
            MapleMap target = c.getChannelServer().getEventSM().getEventManager("lolcastle").getInstance("lolcastle" + splitted[1]).getMapFactory().getMap(990000300, false, false);
            c.getPlayer().changeMap(target, target.getPortal(0));
            return 1;
        }

        public String getMessage() {
            return "!lolcastle level (level = 1-5) - \u4e0d\u77e5\u9053\u662f\u5565";
        }
    }

    public static class WarpPlayersTo
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            try {
                MapleMap target = c.getChannelServer().getMapFactory().getMap(Integer.parseInt(splitted[1]));
                MapleMap from = c.getPlayer().getMap();
                for (MapleCharacter chr : from.getCharactersThreadsafe()) {
                    chr.changeMap(target, target.getPortal(0));
                }
            }
            catch (Exception e) {
                return 0;
            }
            return 1;
        }

        public String getMessage() {
            return "!WarpPlayersTo <maipid> \u628a\u6240\u6709\u73a9\u5bb6\u4f20\u9001\u5230\u67d0\u4e2a\u5730\u56fe";
        }
    }

    public static class Clock
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            if (splitted.length < 2) {
                return 0;
            }
            c.getPlayer().getMap().broadcastMessage(MaplePacketCreator.getClock(CommandProcessorUtil.getOptionalIntArg(splitted, 1, 60)));
            return 1;
        }

        public String getMessage() {
            return "!clock <time> \u65f6\u949f";
        }
    }

    public static class Spawn
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            MapleMonster onemob;
            if (splitted.length < 2) {
                return 0;
            }
            int mid = 0;
            try {
                mid = Integer.parseInt(splitted[1]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            int num = Math.min(CommandProcessorUtil.getOptionalIntArg(splitted, 2, 1), 500);
            if (num > 1000) {
                num = 1000;
            }
            Long hp = CommandProcessorUtil.getNamedLongArg(splitted, 1, "hp");
            Integer exp = CommandProcessorUtil.getNamedIntArg(splitted, 1, "exp");
            Double php = CommandProcessorUtil.getNamedDoubleArg(splitted, 1, "php");
            Double pexp = CommandProcessorUtil.getNamedDoubleArg(splitted, 1, "pexp");
            try {
                onemob = MapleLifeFactory.getMonster(mid);
            }
            catch (RuntimeException e) {
                c.getPlayer().dropMessage(5, "\u9519\u8bef: " + e.getMessage());
                return 1;
            }
            long newhp = hp != null ? hp : (php != null ? (long)((double)onemob.getMobMaxHp() * (php / 100.0)) : onemob.getMobMaxHp());
            int newexp = exp != null ? exp : (pexp != null ? (int)((double)onemob.getMobExp() * (pexp / 100.0)) : onemob.getMobExp());
            if (newhp < 1L) {
                newhp = 1L;
            }
            OverrideMonsterStats overrideStats = new OverrideMonsterStats(newhp, onemob.getMobMaxMp(), newexp, false);
            for (int i = 0; i < num; ++i) {
                MapleMonster mob2 = MapleLifeFactory.getMonster(mid);
                mob2.setHp(newhp);
                mob2.setOverrideStats(overrideStats);
                c.getPlayer().getMap().spawnMonsterOnGroundBelow(mob2, c.getPlayer().getPosition());
            }
            return 1;
        }

        public String getMessage() {
            return "!spawn <\u602a\u7269ID> <hp|exp|php||pexp = ?> - \u53ec\u5524\u602a\u7269";
        }
    }

    public static class ReloadQuests
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            MapleQuest.clearQuests();
            return 1;
        }

        public String getMessage() {
            return "!\u91cd\u65b0\u8f7d\u5165\u4efb\u52a1 - \u91cd\u65b0\u8f7d\u5165\u4efb\u52a1";
        }
    }

    public static class ReloadEvents
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            for (ChannelServer instance : ChannelServer.getAllInstances()) {
                instance.reloadEvents();
            }
            return 1;
        }
    }

    public static class ReloadShops
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            MapleShopFactory.getInstance().clear();
            return 1;
        }

        public String getMessage() {
            return "!\u91cd\u65b0\u8f7d\u5165\u5546\u5e97 - \u91cd\u65b0\u8f7d\u5165\u5546\u5e97";
        }
    }

    public static class ReloadPortals
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            PortalScriptManager.getInstance().clearScripts();
            return 1;
        }

        public String getMessage() {
            return "!reloadportals - \u91cd\u65b0\u8f7d\u5165\u8fdb\u5165\u70b9";
        }
    }

    public static class ReloadDrops
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            MapleMonsterInformationProvider.getInstance().clearDrops();
            ReactorScriptManager.getInstance().clearDrops();
            return 1;
        }

        public String getMessage() {
            return "!\u91cd\u65b0\u8f7d\u5165\u6389\u5b9d - \u91cd\u65b0\u8f09\u5165\u6389\u5b9d";
        }
    }

    public static class ReloadOps
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            SendPacketOpcode.reloadValues();
            RecvPacketOpcode.reloadValues();
            return 1;
        }

        public String getMessage() {
            return "!reloadops - \u91cd\u65b0\u8f7d\u5165OpCode";
        }
    }

    public static class MyPos
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            Point pos = c.getPlayer().getPosition();
            c.getPlayer().dropMessage(6, "X: " + pos.x + " | Y: " + pos.y + " | RX0: " + (pos.x + 50) + " | RX1: " + (pos.x - 50) + " | FH: " + c.getPlayer().getFH() + "| CY:" + pos.y);
            return 1;
        }

        public String getMessage() {
            return "!mypos - \u6211\u7684\u4f4d\u7f6e";
        }
    }

    public static class DestroyPNPC
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            try {
                c.getPlayer().dropMessage(6, "Destroying playerNPC...");
                MapleNPC npc = c.getPlayer().getMap().getNPCByOid(Integer.parseInt(splitted[1]));
                if (npc instanceof PlayerNPC) {
                    ((PlayerNPC)npc).destroy(true);
                    c.getPlayer().dropMessage(6, "Done");
                } else {
                    c.getPlayer().dropMessage(6, "!destroypnpc [objectid]");
                }
            }
            catch (Exception e) {
                c.getPlayer().dropMessage(6, "NPC failed... : " + e.getMessage());
            }
            return 1;
        }

        public String getMessage() {
            return "!destroypnpc [objectid] - \u522a\u9664PNPC";
        }
    }

    public static class MakeOfflineP
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            try {
                c.getPlayer().dropMessage(6, "Making playerNPC...");
                MapleClient cs = new MapleClient(null, null, (IoSession)new MockIOSession());
                MapleCharacter chhr = MapleCharacter.loadCharFromDB(MapleCharacterUtil.getIdByName(splitted[1]), cs, false);
                if (chhr == null) {
                    c.getPlayer().dropMessage(6, splitted[1] + " does not exist");
                } else {
                    PlayerNPC npc = new PlayerNPC(chhr, Integer.parseInt(splitted[2]), c.getPlayer().getMap(), c.getPlayer());
                    npc.addToServer();
                    c.getPlayer().dropMessage(6, "Done");
                }
            }
            catch (Exception e) {
                c.getPlayer().dropMessage(6, "NPC failed... : " + e.getMessage());
            }
            return 1;
        }

        public String getMessage() {
            return "!\u79bb\u7ebfnpc <charname> <npcid> - \u521b\u9020\u79bb\u7ebfPNPC";
        }
    }

    public static class MakePNPC
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            if (splitted.length < 3) {
                return 0;
            }
            try {
                c.getPlayer().dropMessage(6, "Making playerNPC...");
                String name = splitted[1];
                int ch = World.Find.findChannel(name);
                if (ch <= 0) {
                    c.getPlayer().dropMessage(6, "\u73a9\u5bb6\u5fc5\u987b\u5728\u7ebf");
                    return 1;
                }
                MapleCharacter chhr = ChannelServer.getInstance(ch).getPlayerStorage().getCharacterByName(name);
                if (chhr == null) {
                    c.getPlayer().dropMessage(6, splitted[1] + " is not online");
                } else {
                    int npcId = Integer.parseInt(splitted[2]);
                    MapleNPC npc_c = MapleLifeFactory.getNPC(npcId);
                    if (npc_c == null || npc_c.getName().equals("MISSINGNO")) {
                        c.getPlayer().dropMessage(6, "NPC\u4e0d\u5b58\u5728");
                        return 1;
                    }
                    PlayerNPC npc = new PlayerNPC(chhr, npcId, c.getPlayer().getMap(), c.getPlayer());
                    npc.addToServer();
                    c.getPlayer().dropMessage(6, "Done");
                }
            }
            catch (Exception e) {
                c.getPlayer().dropMessage(6, "NPC failed... : " + e.getMessage());
            }
            return 1;
        }

        public String getMessage() {
            return "!\u73a9\u5bb6npc <playername> <npcid> - \u521b\u9020\u73a9\u5bb6NPC";
        }
    }

    public static class LookPortals
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            for (MaplePortal portal : c.getPlayer().getMap().getPortals()) {
                c.getPlayer().dropMessage(5, "Portal: ID: " + portal.getId() + " script: " + portal.getScriptName() + " name: " + portal.getName() + " pos: " + portal.getPosition().x + "," + portal.getPosition().y + " target: " + portal.getTargetMapId() + " / " + portal.getTarget());
            }
            return 1;
        }

        public String getMessage() {
            return "!\u53cd\u5e94\u5806 - \u67e5\u770b\u6240\u6709\u53cd\u5e94\u5806";
        }
    }

    public static class LookReactors
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            for (MapleMapObject mapleMapObject : c.getPlayer().getMap().getAllReactorsThreadsafe()) {
                MapleReactor reactor2l = (MapleReactor)mapleMapObject;
                c.getPlayer().dropMessage(5, "Reactor: oID: " + reactor2l.getObjectId() + " reactorID: " + reactor2l.getReactorId() + " Position: " + reactor2l.getPosition().toString() + " State: " + reactor2l.getState() + " Name: " + reactor2l.getName());
            }
            return 1;
        }

        public String getMessage() {
            return "!lookreactors - \u67e5\u770b\u6240\u6709\u53cd\u5e94\u5806";
        }
    }

    public static class LookNPCs
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            for (MapleMapObject mapleMapObject : c.getPlayer().getMap().getAllNPCsThreadsafe()) {
                MapleNPC reactor2l = (MapleNPC)mapleMapObject;
                c.getPlayer().dropMessage(5, "NPC: oID: " + reactor2l.getObjectId() + " npcID: " + reactor2l.getId() + " Position: " + reactor2l.getPosition().toString() + " Name: " + reactor2l.getName());
            }
            return 1;
        }

        public String getMessage() {
            return "!looknpcs - \u67e5\u770b\u6240\u6709NPC";
        }
    }

    public static class RemoveNPCs
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            c.getPlayer().getMap().resetNPCs();
            return 1;
        }

        public String getMessage() {
            return "!removenpcs - \u522a\u9664\u6240\u6709NPC";
        }
    }

    public static class NPC
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            int npcId = 0;
            try {
                npcId = Integer.parseInt(splitted[1]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            MapleNPC npc = MapleLifeFactory.getNPC(npcId);
            if (npc != null && !npc.getName().equals("MISSINGNO")) {
                npc.setPosition(c.getPlayer().getPosition());
                npc.setCy(c.getPlayer().getPosition().y);
                npc.setRx0(c.getPlayer().getPosition().x + 50);
                npc.setRx1(c.getPlayer().getPosition().x - 50);
                npc.setFh(c.getPlayer().getMap().getFootholds().findBelow(c.getPlayer().getPosition()).getId());
                npc.setCustom(true);
                c.getPlayer().getMap().addMapObject(npc);
                c.getPlayer().getMap().broadcastMessage(MaplePacketCreator.spawnNPC(npc, true));
            } else {
                c.getPlayer().dropMessage(6, "\u627e\u4e0d\u5230\u6b64\u4ee3\u7801\u4e3a" + npcId + "\u7684Npc");
            }
            return 1;
        }

        public String getMessage() {
            return "!npc <npcid> - \u547c\u53eb\u51faNPC";
        }
    }

    public static class HitMonsterByOID
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            MapleMap map = c.getPlayer().getMap();
            int targetId = Integer.parseInt(splitted[1]);
            int damage = Integer.parseInt(splitted[2]);
            MapleMonster monster = map.getMonsterByOid(targetId);
            if (monster != null) {
                map.broadcastMessage(MobPacket.damageMonster(targetId, damage));
                monster.damage(c.getPlayer(), damage, false);
            }
            return 1;
        }

        public String getMessage() {
            return "!hitmonsterbyoid <moboid> <damage> - \u78b0\u649e\u5730\u56fe\u4e0a\u67d0\u500b\u602a\u7269";
        }
    }

    public static class KillMonsterByOID
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            int targetId;
            if (splitted.length < 2) {
                return 0;
            }
            MapleMap map = c.getPlayer().getMap();
            MapleMonster monster = map.getMonsterByOid(targetId = Integer.parseInt(splitted[1]));
            if (monster != null) {
                map.killMonster(monster, c.getPlayer(), false, false, (byte)1);
            }
            return 1;
        }

        public String getMessage() {
            return "!killmonsterbyoid <moboid> - \u6740\u6389\u5730\u56fe\u4e0a\u67d0\u4e2a\u602a\u7269";
        }
    }

    public static class KillMonster
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            if (splitted.length < 2) {
                return 0;
            }
            MapleMap map = c.getPlayer().getMap();
            double range = Double.POSITIVE_INFINITY;
            for (MapleMapObject monstermo : map.getMapObjectsInRange(c.getPlayer().getPosition(), range, Arrays.asList(MapleMapObjectType.MONSTER))) {
                MapleMonster mob2 = (MapleMonster)monstermo;
                if (mob2.getId() != Integer.parseInt(splitted[1])) continue;
                mob2.damage(c.getPlayer(), mob2.getHp(), false);
            }
            return 1;
        }

        public String getMessage() {
            return "!killmonster <mobid> - \u6740\u6389\u5730\u56fe\u4e0a\u67d0\u4e2a\u602a\u7269";
        }
    }

    public static class ResetMobs
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            c.getPlayer().getMap().killAllMonsters(false);
            return 1;
        }

        public String getMessage() {
            return "!resetmobs - \u91cd\u7f6e\u5730\u56fe\u4e0a\u6240\u6709\u602a\u7269";
        }
    }

    public static class KillAll
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            MapleMap map = c.getPlayer().getMap();
            double range = Double.POSITIVE_INFINITY;
            boolean drop = false;
            if (splitted.length > 1) {
                int irange = 9999;
                if (splitted.length < 2) {
                    range = irange * irange;
                } else {
                    try {
                        map = c.getChannelServer().getMapFactory().getMap(Integer.parseInt(splitted[1]));
                        range = Integer.parseInt(splitted[2]) * Integer.parseInt(splitted[2]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (splitted.length >= 3) {
                    drop = splitted[3].equalsIgnoreCase("true");
                }
            }
            List<MapleMapObject> monsters = map.getMapObjectsInRange(c.getPlayer().getPosition(), range, Arrays.asList(MapleMapObjectType.MONSTER));
            for (MapleMapObject monstermo : map.getMapObjectsInRange(c.getPlayer().getPosition(), range, Arrays.asList(MapleMapObjectType.MONSTER))) {
                MapleMonster mob2 = (MapleMonster)monstermo;
                map.killMonster(mob2, c.getPlayer(), drop, false, (byte)1);
            }
            c.getPlayer().dropMessage("\u60a8\u603b\u5171\u6740\u4e86 " + monsters.size() + " \u602a\u7269");
            return 1;
        }

        public String getMessage() {
            return "!killall [range] [mapid] - \u6740\u6389\u6240\u6709\u602a\u7269";
        }
    }

    public static class GoTo
    extends CommandExecute {
        private static final HashMap<String, Integer> gotomaps = new HashMap();

        @Override
        public int execute(MapleClient c, String[] splitted) {
            if (splitted.length < 2) {
                c.getPlayer().dropMessage(6, "Syntax: !goto <mapname>");
            } else if (gotomaps.containsKey(splitted[1])) {
                MapleMap target = c.getChannelServer().getMapFactory().getMap(gotomaps.get(splitted[1]));
                MaplePortal targetPortal = target.getPortal(0);
                c.getPlayer().changeMap(target, targetPortal);
            } else if (splitted[1].equals("locations")) {
                c.getPlayer().dropMessage(6, "Use !goto <location>. Locations are as follows:");
                StringBuilder sb = new StringBuilder();
                for (String s : gotomaps.keySet()) {
                    sb.append(s).append(", ");
                }
                c.getPlayer().dropMessage(6, sb.substring(0, sb.length() - 2));
            } else {
                c.getPlayer().dropMessage(6, "Invalid command \u6307\u4ee4\u898f\u5247 - Use !goto <location>. For a list of locations, use !goto locations.");
            }
            return 1;
        }

        public String getMessage() {
            return "!goto <\u540d\u79f0> - \u5230\u67d0\u4e2a\u5730\u56fe";
        }

        static {
            gotomaps.put("gmmap", 180000000);
            gotomaps.put("southperry", 2000000);
            gotomaps.put("amherst", 1010000);
            gotomaps.put("henesys", 100000000);
            gotomaps.put("ellinia", 101000000);
            gotomaps.put("perion", 102000000);
            gotomaps.put("kerning", 103000000);
            gotomaps.put("lithharbour", 104000000);
            gotomaps.put("sleepywood", 105040300);
            gotomaps.put("florina", 110000000);
            gotomaps.put("orbis", 200000000);
            gotomaps.put("happyville", 209000000);
            gotomaps.put("elnath", 211000000);
            gotomaps.put("ludibrium", 220000000);
            gotomaps.put("aquaroad", 230000000);
            gotomaps.put("leafre", 240000000);
            gotomaps.put("mulung", 250000000);
            gotomaps.put("herbtown", 251000000);
            gotomaps.put("omegasector", 221000000);
            gotomaps.put("koreanfolktown", 222000000);
            gotomaps.put("newleafcity", 600000000);
            gotomaps.put("sharenian", 990000000);
            gotomaps.put("pianus", 230040420);
            gotomaps.put("horntail", 240060200);
            gotomaps.put("chorntail", 240060201);
            gotomaps.put("mushmom", 100000005);
            gotomaps.put("griffey", 240020101);
            gotomaps.put("manon", 240020401);
            gotomaps.put("zakum", 280030000);
            gotomaps.put("czakum", 280030001);
            gotomaps.put("papulatus", 220080001);
            gotomaps.put("showatown", 801000000);
            gotomaps.put("zipangu", 800000000);
            gotomaps.put("ariant", 260000100);
            gotomaps.put("nautilus", 120000000);
            gotomaps.put("boatquay", 541000000);
            gotomaps.put("malaysia", 550000000);
            gotomaps.put("taiwan", 740000000);
            gotomaps.put("thailand", 500000000);
            gotomaps.put("erev", 130000000);
            gotomaps.put("ellinforest", 300000000);
            gotomaps.put("kampung", 551000000);
            gotomaps.put("singapore", 540000000);
            gotomaps.put("amoria", 680000000);
            gotomaps.put("timetemple", 270000000);
            gotomaps.put("pinkbean", 270050100);
            gotomaps.put("peachblossom", 700000000);
            gotomaps.put("fm", 910000000);
            gotomaps.put("freemarket", 910000000);
            gotomaps.put("oxquiz", 109020001);
            gotomaps.put("ola", 109030101);
            gotomaps.put("fitness", 109040000);
            gotomaps.put("snowball", 109060000);
            gotomaps.put("cashmap", 741010200);
            gotomaps.put("golden", 950100000);
            gotomaps.put("phantom", 610010000);
            gotomaps.put("cwk", 610030000);
            gotomaps.put("rien", 140000000);
        }
    }

    public static class DCAll
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            int range = -1;
            if (splitted.length < 2) {
                return 0;
            }
            String input = null;
            try {
                input = splitted[1];
            }
            catch (Exception exception) {
                // empty catch block
            }
            switch (splitted[1]) {
                case "m": {
                    range = 0;
                    break;
                }
                case "c": {
                    range = 1;
                    break;
                }
                default: {
                    range = 2;
                }
            }
            if (range == -1) {
                range = 1;
            }
            if (range == 0) {
                c.getPlayer().getMap().disconnectAll();
            } else if (range == 1) {
                c.getChannelServer().getPlayerStorage().disconnectAll();
            } else if (range == 2) {
                for (ChannelServer cserv : ChannelServer.getAllInstances()) {
                    cserv.getPlayerStorage().disconnectAll(true);
                }
            }
            String show = "";
            switch (range) {
                case 0: {
                    show = "\u5730\u56fe";
                    break;
                }
                case 1: {
                    show = "\u983b\u9053";
                    break;
                }
                case 2: {
                    show = "\u4e16\u754c";
                }
            }
            String msg = "[GM \u5bc6\u8bed] GM " + c.getPlayer().getName() + "  DC \u4e86 " + show + "\u73a9\u5bb6";
            World.Broadcast.broadcastGMMessage(MaplePacketCreator.serverNotice(6, msg).getBytes());
            return 1;
        }

        public String getMessage() {
            return "!dcall [m|c|w] - \u6240\u6709\u73a9\u5bb6\u65ad\u7ebf";
        }
    }

    public static class MesoRate
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            int rate;
            if (splitted.length > 1) {
                rate = Integer.parseInt(splitted[1]);
                if (splitted.length > 2 && splitted[2].equalsIgnoreCase("all")) {
                    for (ChannelServer cserv : ChannelServer.getAllInstances()) {
                        cserv.setMesoRate(rate);
                    }
                } else {
                    c.getChannelServer().setMesoRate(rate);
                }
            } else {
                return 0;
            }
            c.getPlayer().dropMessage(6, "\u91d1\u5e01\u7206\u7387\u5df2\u6539\u53d8\u66f4\u4e3a " + rate + "x");
            return 1;
        }

        public String getMessage() {
            return "!mesorate <\u500d\u7387> - \u66f4\u6539\u91d1\u94b1\u500d\u7387";
        }
    }

    public static class DropRate
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            int rate;
            if (splitted.length > 1) {
                rate = Integer.parseInt(splitted[1]);
                if (splitted.length > 2 && splitted[2].equalsIgnoreCase("all")) {
                    for (ChannelServer cserv : ChannelServer.getAllInstances()) {
                        cserv.setDropRate(rate);
                    }
                } else {
                    c.getChannelServer().setDropRate(rate);
                }
            } else {
                return 0;
            }
            c.getPlayer().dropMessage(6, "\u6389\u5b9d\u500d\u7387\u5df2\u6539\u53d8\u66f4\u4e3a " + rate + "x");
            return 1;
        }

        public String getMessage() {
            return "!droprate <\u500d\u7387> - \u66f4\u6539\u6389\u843d\u500d\u7387";
        }
    }

    public static class ExpRate
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            int rate;
            if (splitted.length > 1) {
                rate = Integer.parseInt(splitted[1]);
                if (splitted.length > 2 && splitted[2].equalsIgnoreCase("all")) {
                    for (ChannelServer cserv : ChannelServer.getAllInstances()) {
                        cserv.setExpRate(rate);
                    }
                } else {
                    c.getChannelServer().setExpRate(rate);
                }
            } else {
                return 0;
            }
            c.getPlayer().dropMessage(6, "\u7ecf\u9a8c\u500d\u7387\u5df2\u6539\u53d8\u66f4\u4e3a " + rate + "x");
            return 1;
        }

        public String getMessage() {
            return "!exprate <\u500d\u7387> - \u66f4\u6539\u7ecf\u9a8c\u500d\u7387";
        }
    }

    public static class RemoveDrops
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            c.getPlayer().dropMessage(5, "\u6e05\u9664\u4e86 " + c.getPlayer().getMap().getNumItems() + " \u4e2a\u6389\u843d\u7269");
            c.getPlayer().getMap().removeDrops();
            return 1;
        }

        public String getMessage() {
            return "!removedrops - \u79fb\u9664\u5730\u4e0a\u7684\u7269\u54c1";
        }
    }

    public static class cleardrops
    extends RemoveDrops {
    }

    public static class SetReactor
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            if (splitted.length < 2) {
                return 0;
            }
            c.getPlayer().getMap().setReactorState(Byte.parseByte(splitted[1]));
            return 1;
        }

        public String getMessage() {
            return "!hitreactor - \u89e6\u78b0Reactor";
        }
    }

    public static class ResetReactors
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            c.getPlayer().getMap().resetReactors();
            return 1;
        }

        public String getMessage() {
            return "!resetreactors - \u91cd\u7f6e\u6b64\u5730\u56fe\u6240\u6709\u7684Reactor";
        }
    }

    public static class DestroyReactor
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            if (splitted.length < 2) {
                return 0;
            }
            MapleMap map = c.getPlayer().getMap();
            List<MapleMapObject> reactors = map.getMapObjectsInRange(c.getPlayer().getPosition(), Double.POSITIVE_INFINITY, Arrays.asList(MapleMapObjectType.REACTOR));
            if (splitted[1].equals("all")) {
                for (MapleMapObject reactorL : reactors) {
                    MapleReactor reactor2l = (MapleReactor)reactorL;
                    c.getPlayer().getMap().destroyReactor(reactor2l.getObjectId());
                }
            } else {
                c.getPlayer().getMap().destroyReactor(Integer.parseInt(splitted[1]));
            }
            return 1;
        }

        public String getMessage() {
            return "!drstroyreactor - \u79fb\u9664Reactor";
        }
    }

    public static class HReactor
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            if (splitted.length < 2) {
                return 0;
            }
            c.getPlayer().getMap().getReactorByOid(Integer.parseInt(splitted[1])).hitReactor(c);
            return 1;
        }

        public String getMessage() {
            return "!hitreactor - \u89e6\u78b0Reactor";
        }
    }

    public static class SpawnReactor
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            if (splitted.length < 2) {
                return 0;
            }
            int id = 0;
            try {
                id = Integer.parseInt(splitted[1]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            MapleReactorStats reactorSt = MapleReactorFactory.getReactor(id);
            MapleReactor reactor = new MapleReactor(reactorSt, id);
            reactor.setDelay(-1);
            reactor.setPosition(c.getPlayer().getPosition());
            c.getPlayer().getMap().spawnReactor(reactor);
            return 1;
        }

        public String getMessage() {
            return "!spawnreactor - \u8bbe\u7acbReactor";
        }
    }

    public static class ToggleMegaphone
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            World.toggleMegaphoneMuteState();
            c.getPlayer().dropMessage(6, "\u5e7f\u64ad\u662f\u5426\u5c01\u9501 : " + (c.getChannelServer().getMegaphoneMuteState() ? "\u662f" : "\u5426"));
            return 1;
        }

        public String getMessage() {
            return "!togglemegaphone - \u5f00\u542f\u6216\u8005\u5173\u95ed\u5e7f\u64ad";
        }
    }

    public static class toggleDrop
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            c.getPlayer().getMap().toggleDrops();
            return 1;
        }

        public String getMessage() {
            return "!toggledrop - \u5f00\u542f\u6216\u5173\u95ed\u6389\u843d";
        }
    }

    public static class ToggleOffense
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            if (splitted.length < 2) {
                return 0;
            }
            try {
                CheatingOffense co = CheatingOffense.valueOf(splitted[1]);
                co.setEnabled(!co.isEnabled());
            }
            catch (IllegalArgumentException iae) {
                c.getPlayer().dropMessage(6, "Offense " + splitted[1] + " not found");
            }
            return 1;
        }

        public String getMessage() {
            return "!toggleoffense <Offense> - \u5f00\u542f\u6216\u5173\u95edCheatOffense";
        }
    }

    public static class FakeRelog
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            MapleCharacter player = c.getPlayer();
            c.sendPacket(MaplePacketCreator.getCharInfo(player));
            player.getMap().removePlayer(player);
            player.getMap().addPlayer(player);
            return 1;
        }

        public String getMessage() {
            return "!fakerelog - \u5047\u767b\u51fa\u518d\u767b\u5165";
        }
    }

    public static class ShowTrace
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            if (splitted.length < 2) {
                return 0;
            }
            Thread[] threads = new Thread[Thread.activeCount()];
            Thread.enumerate(threads);
            Thread t = threads[Integer.parseInt(splitted[1])];
            c.getPlayer().dropMessage(6, t.toString() + ":");
            for (StackTraceElement elem : t.getStackTrace()) {
                c.getPlayer().dropMessage(6, elem.toString());
            }
            return 1;
        }

        public String getMessage() {
            return "!showtrace - show trace info";
        }
    }

    public static class Threads
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            Thread[] threads = new Thread[Thread.activeCount()];
            Thread.enumerate(threads);
            String filter = "";
            if (splitted.length > 1) {
                filter = splitted[1];
            }
            for (int i = 0; i < threads.length; ++i) {
                String tstring = threads[i].toString();
                if (!tstring.toLowerCase().contains(filter.toLowerCase())) continue;
                c.getPlayer().dropMessage(6, i + ": " + tstring);
            }
            return 1;
        }

        public String getMessage() {
            return "!threads - \u67e5\u770bThreads\u8d44\u8baf";
        }
    }

    public static class SpawnDebug
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            c.getPlayer().dropMessage(6, c.getPlayer().getMap().spawnDebug());
            return 1;
        }

        public String getMessage() {
            return "!spawndebug - debug\u602a\u7269\u51fa\u751f";
        }
    }

    public static class NearestPortal
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            MaplePortal portal = c.getPlayer().getMap().findClosestSpawnpoint(c.getPlayer().getPosition());
            c.getPlayer().dropMessage(6, portal.getName() + " id: " + portal.getId() + " script: " + portal.getScriptName());
            return 1;
        }

        public String getMessage() {
            return "!nearestportal - \u4e0d\u77e5\u9053\u5565";
        }
    }

    public static class FCompleteOther
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            MapleQuest.getInstance(Integer.parseInt(splitted[2])).forceComplete(c.getChannelServer().getPlayerStorage().getCharacterByName(splitted[1]), Integer.parseInt(splitted[3]));
            return 1;
        }

        public String getMessage() {
            return "!fcompleteother - \u4e0d\u77e5\u9053\u5565";
        }
    }

    public static class FStartOther
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            MapleQuest.getInstance(Integer.parseInt(splitted[2])).forceStart(c.getChannelServer().getPlayerStorage().getCharacterByName(splitted[1]), Integer.parseInt(splitted[3]), splitted.length >= 4 ? splitted[4] : null);
            return 1;
        }

        public String getMessage() {
            return "!fstartother - \u4e0d\u77e5\u9053\u5565";
        }
    }

    public static class FCompleteQuest
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            if (splitted.length < 2) {
                return 0;
            }
            MapleQuest.getInstance(Integer.parseInt(splitted[1])).forceComplete(c.getPlayer(), Integer.parseInt(splitted[2]));
            return 1;
        }

        public String getMessage() {
            return "!fcompletequest <\u4efb\u52a1ID> - \u5f3a\u5236\u5b8c\u6210\u4efb\u52a1";
        }
    }

    public static class FStartQuest
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            if (splitted.length < 2) {
                return 0;
            }
            MapleQuest.getInstance(Integer.parseInt(splitted[1])).forceStart(c.getPlayer(), Integer.parseInt(splitted[2]), splitted.length >= 4 ? splitted[3] : null);
            return 1;
        }

        public String getMessage() {
            return "!fstartquest <\u4efb\u52a1ID> - \u5f3a\u5236\u5f00\u59cb\u4efb\u52a1";
        }
    }

    public static class CompleteQuest
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            if (splitted.length < 2) {
                return 0;
            }
            MapleQuest.getInstance(Integer.parseInt(splitted[1])).complete(c.getPlayer(), Integer.parseInt(splitted[2]), Integer.parseInt(splitted[3]));
            return 1;
        }

        public String getMessage() {
            return "!completequest <\u4efb\u52a1ID> - \u5b8c\u6210\u4efb\u52a1";
        }
    }

    public static class StartQuest
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            if (splitted.length < 2) {
                return 0;
            }
            MapleQuest.getInstance(Integer.parseInt(splitted[1])).start(c.getPlayer(), Integer.parseInt(splitted[2]));
            return 1;
        }

        public String getMessage() {
            return "!startquest <\u4efb\u52a1ID> - \u5f00\u59cb\u4efb\u52a1";
        }
    }

    public static class ResetQuest
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            if (splitted.length < 2) {
                return 0;
            }
            MapleQuest.getInstance(Integer.parseInt(splitted[1])).forfeit(c.getPlayer());
            return 1;
        }

        public String getMessage() {
            return "!resetquest <\u4efb\u52a1ID> - \u91cd\u7f6e\u4efb\u52a1";
        }
    }

    public static class Connected
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            java.util.Map<Integer, Integer> connected = World.getConnected();
            StringBuilder conStr = new StringBuilder("\u5df2\u8fde\u63a5\u7684\u5ba2\u6236\u7aef: ");
            boolean first = true;
            for (int i : connected.keySet()) {
                if (!first) {
                    conStr.append(", ");
                } else {
                    first = false;
                }
                if (i == 0) {
                    conStr.append("\u6240\u6709: ");
                    conStr.append(connected.get(i));
                    continue;
                }
                conStr.append("\u983b\u9053 ");
                conStr.append(i);
                conStr.append(": ");
                conStr.append(connected.get(i));
            }
            c.getPlayer().dropMessage(6, conStr.toString());
            return 1;
        }

        public String getMessage() {
            return "!connected - \u67e5\u770b\u5df2\u8fde\u7ebf\u7684\u5ba2\u6236\u7aef";
        }
    }

    public static class Cheaters
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            List<CheaterData> cheaters = World.getCheaters();
            for (int x = cheaters.size() - 1; x >= 0; --x) {
                CheaterData cheater = cheaters.get(x);
                c.getPlayer().dropMessage(6, cheater.getInfo());
            }
            return 1;
        }

        public String getMessage() {
            return "!cheaters - \u67e5\u770b\u4f5c\u5f0a\u89d2\u8272";
        }
    }

    public static class whoishere
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            StringBuilder builder = new StringBuilder("\u5728\u6b64\u5730\u56fe\u7684\u73a9\u5bb6: ");
            for (MapleCharacter chr : c.getPlayer().getMap().getCharactersThreadsafe()) {
                if (builder.length() > 150) {
                    builder.setLength(builder.length() - 2);
                    c.getPlayer().dropMessage(6, builder.toString());
                    builder = new StringBuilder();
                }
                builder.append(MapleCharacterUtil.makeMapleReadable(chr.getName()));
                builder.append(", ");
            }
            builder.setLength(builder.length() - 2);
            c.getPlayer().dropMessage(6, builder.toString());
            return 1;
        }

        public String getMessage() {
            return "!whoishere - \u67e5\u770b\u76ee\u524d\u5730\u56fe\u4e0a\u7684\u73a9\u5bb6";
        }
    }

    public static class CharInfo
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            if (splitted.length < 2) {
                return 0;
            }
            StringBuilder builder = new StringBuilder();
            String name = splitted[1];
            int ch = World.Find.findChannel(name);
            if (ch <= 0) {
                c.getPlayer().dropMessage(6, "\u73a9\u5bb6\u5fc5\u987b\u5728\u7ebf");
                return 0;
            }
            MapleCharacter other = ChannelServer.getInstance(ch).getPlayerStorage().getCharacterByName(name);
            if (other == null) {
                builder.append("\u89d2\u8272\u4e0d\u5b58\u5728");
                c.getPlayer().dropMessage(6, builder.toString());
            } else {
                if (other.getClient().getLastPing() <= 0L) {
                    other.getClient().sendPing();
                }
                builder.append(MapleClient.getLogMessage(other, ""));
                builder.append(" \u5728 ").append(other.getPosition().x);
                builder.append(" /").append(other.getPosition().y);
                builder.append(" || \u8840\u91cf : ");
                builder.append(other.getStat().getHp());
                builder.append(" /");
                builder.append(other.getStat().getCurrentMaxHp());
                builder.append(" || \u9b54\u91cf : ");
                builder.append(other.getStat().getMp());
                builder.append(" /");
                builder.append(other.getStat().getCurrentMaxMp());
                builder.append(" || \u7269\u7406\u653b\u64ca\u529b : ");
                builder.append(other.getStat().getTotalWatk());
                builder.append(" || \u9b54\u6cd5\u653b\u64ca\u529b : ");
                builder.append(other.getStat().getTotalMagic());
                builder.append(" || \u6700\u9ad8\u653b\u64ca : ");
                builder.append(other.getStat().getCurrentMaxBaseDamage());
                builder.append(" || \u653b\u64ca%\u6578 : ");
                builder.append(other.getStat().dam_r);
                builder.append(" || BOSS\u653b\u64ca%\u6578 : ");
                builder.append(other.getStat().bossdam_r);
                builder.append(" || \u529b\u91cf : ");
                builder.append(other.getStat().getStr());
                builder.append(" || \u654f\u6377 : ");
                builder.append(other.getStat().getDex());
                builder.append(" || \u667a\u529b : ");
                builder.append(other.getStat().getInt());
                builder.append(" || \u5e78\u904b : ");
                builder.append(other.getStat().getLuk());
                builder.append(" || \u5168\u90e8\u529b\u91cf : ");
                builder.append(other.getStat().getTotalStr());
                builder.append(" || \u5168\u90e8\u654f\u6377 : ");
                builder.append(other.getStat().getTotalDex());
                builder.append(" || \u5168\u90e8\u667a\u529b : ");
                builder.append(other.getStat().getTotalInt());
                builder.append(" || \u5168\u90e8\u5e78\u904b : ");
                builder.append(other.getStat().getTotalLuk());
                builder.append(" || \u7d93\u9a57\u503c : ");
                builder.append(other.getExp());
                builder.append(" || \u7d44\u968a\u72c0\u614b : ");
                builder.append(other.getParty() != null);
                builder.append(" || \u4ea4\u6613\u72c0\u614b: ");
                builder.append(other.getTrade() != null);
                builder.append(" || Latency: ");
                builder.append(other.getClient().getLatency());
                builder.append(" || \u6700\u5f8cPING: ");
                builder.append(other.getClient().getLastPing());
                builder.append(" || \u6700\u5f8cPONG: ");
                builder.append(other.getClient().getLastPong());
                builder.append(" || IP: ");
                builder.append(other.getClient().getSessionIPAddress());
                other.getClient().DebugMessage(builder);
                c.getPlayer().dropMessage(6, builder.toString());
            }
            return 1;
        }

        public String getMessage() {
            return "!charinfo <\u89d2\u8272\u540d\u79f0> - \u67e5\u770b\u89d2\u8272\u72b6\u6001";
        }
    }

    public static class PermWeather
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            if (c.getPlayer().getMap().getPermanentWeather() > 0) {
                c.getPlayer().getMap().setPermanentWeather(0);
                c.getPlayer().getMap().broadcastMessage(MaplePacketCreator.removeMapEffect());
                c.getPlayer().dropMessage(5, "\u5730\u56fe\u5929\u6c14\u5df2\u88ab\u7981\u7528.");
            } else {
                int weather = CommandProcessorUtil.getOptionalIntArg(splitted, 1, 5120000);
                if (!MapleItemInformationProvider.getInstance().itemExists(weather) || weather / 10000 != 512) {
                    c.getPlayer().dropMessage(5, "\u65e0\u6548\u7684ID.");
                } else {
                    c.getPlayer().getMap().setPermanentWeather(weather);
                    c.getPlayer().getMap().broadcastMessage(MaplePacketCreator.startMapEffect("", weather, false));
                    c.getPlayer().dropMessage(5, "\u5730\u56fe\u5929\u6c14\u5df2\u542f\u7528.");
                }
            }
            return 1;
        }

        public String getMessage() {
            return "!permweather - \u8bbe\u5b9a\u5929\u6c14";
        }
    }

    public static class Monitor
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            if (splitted.length < 2) {
                return 0;
            }
            MapleCharacter target = c.getChannelServer().getPlayerStorage().getCharacterByName(splitted[1]);
            if (target != null) {
                if (target.getClient().isMonitored()) {
                    target.getClient().setMonitored(false);
                    c.getPlayer().dropMessage(5, "Not monitoring " + target.getName() + " anymore.");
                } else {
                    target.getClient().setMonitored(true);
                    c.getPlayer().dropMessage(5, "Monitoring " + target.getName() + ".");
                }
            } else {
                c.getPlayer().dropMessage(5, "\u627e\u4e0d\u5230\u8be5\u73a9\u5bb6");
            }
            return 1;
        }

        public String getMessage() {
            return "!monitor <\u73a9\u5bb6> - \u8bb0\u5f55\u73a9\u5bb6\u8d44\u8baf";
        }
    }

    public static class DisposeClones
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            c.getPlayer().dropMessage(6, c.getPlayer().getCloneSize() + "\u4e2a\u514b\u9686\u4f53\u6d88\u5931\u4e86.");
            c.getPlayer().disposeClones();
            return 1;
        }

        public String getMessage() {
            return "!disposeclones - \u6467\u6bc1\u514b\u9686\u4f53";
        }
    }

    public static class CloneMe
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            c.getPlayer().cloneLook();
            return 1;
        }

        public String getMessage() {
            return "!cloneme - \u4ea7\u751f\u514b\u9686\u4f53";
        }
    }

    public static class giveMeso
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            if (splitted.length < 2) {
                return 0;
            }
            String name = splitted[1];
            int gain = Integer.parseInt(splitted[2]);
            int ch = World.Find.findChannel(name);
            if (ch <= 0) {
                c.getPlayer().dropMessage(6, "\u73a9\u5bb6\u5fc5\u987b\u5728\u7ebf");
                return 0;
            }
            MapleCharacter victim = ChannelServer.getInstance(ch).getPlayerStorage().getCharacterByName(name);
            if (victim == null) {
                c.getPlayer().dropMessage(5, "\u627e\u4e0d\u5230 '" + name);
            } else {
                victim.gainMeso(gain, true);
                String msg = "[GM \u5bc6\u8bed] GM " + c.getPlayer().getName() + " \u7ed9\u4e86 " + victim.getName() + " \u91d1\u5e01 " + gain + "\u70b9";
                World.Broadcast.broadcastGMMessage(MaplePacketCreator.serverNotice(6, msg).getBytes());
            }
            return 1;
        }

        public String getMessage() {
            return "!gainmeso <\u540d\u5b57> <\u6570\u91cf> - \u7d66\u73a9\u5bb6\u91d1\u5e01";
        }
    }

    public static class SendAllNote
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            if (splitted.length >= 1) {
                String text = StringUtil.joinStringFrom(splitted, 1);
                for (MapleCharacter mch : c.getChannelServer().getPlayerStorage().getAllCharacters()) {
                    c.getPlayer().sendNote(mch.getName(), text);
                }
            } else {
                return 0;
            }
            return 1;
        }

        public String getMessage() {
            return "!sendallnote <\u6587\u5b57> \u4f20\u9001Note\u7d66\u76ee\u524d\u983b\u9053\u7684\u6240\u6709\u4eba";
        }
    }

    public static class Disease
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            int type;
            if (splitted.length < 3) {
                return 0;
            }
            if (splitted[1].equalsIgnoreCase("SEAL")) {
                type = 120;
            } else if (splitted[1].equalsIgnoreCase("DARKNESS")) {
                type = 121;
            } else if (splitted[1].equalsIgnoreCase("WEAKEN")) {
                type = 122;
            } else if (splitted[1].equalsIgnoreCase("STUN")) {
                type = 123;
            } else if (splitted[1].equalsIgnoreCase("CURSE")) {
                type = 124;
            } else if (splitted[1].equalsIgnoreCase("POISON")) {
                type = 125;
            } else if (splitted[1].equalsIgnoreCase("SLOW")) {
                type = 126;
            } else if (splitted[1].equalsIgnoreCase("SEDUCE")) {
                type = 128;
            } else if (splitted[1].equalsIgnoreCase("REVERSE")) {
                type = 132;
            } else if (splitted[1].equalsIgnoreCase("ZOMBIFY")) {
                type = 133;
            } else if (splitted[1].equalsIgnoreCase("POTION")) {
                type = 134;
            } else if (splitted[1].equalsIgnoreCase("SHADOW")) {
                type = 135;
            } else if (splitted[1].equalsIgnoreCase("BLIND")) {
                type = 136;
            } else if (splitted[1].equalsIgnoreCase("FREEZE")) {
                type = 137;
            } else {
                return 0;
            }
            MapleDisease dis = MapleDisease.getBySkill(type);
            if (splitted.length == 4) {
                String name = splitted[2];
                int ch = World.Find.findChannel(name);
                if (ch <= 0) {
                    c.getPlayer().dropMessage(6, "\u73a9\u5bb6\u5fc5\u987b\u5728\u7ebf");
                    return 0;
                }
                MapleCharacter victim = ChannelServer.getInstance(ch).getPlayerStorage().getCharacterByName(name);
                if (victim == null) {
                    c.getPlayer().dropMessage(5, "\u627e\u4e0d\u5230\u6b64\u73a9\u5bb6");
                } else {
                    victim.setChair(0);
                    victim.getClient().sendPacket(MaplePacketCreator.cancelChair(-1));
                    victim.getMap().broadcastMessage(victim, MaplePacketCreator.showChair(c.getPlayer().getId(), 0), false);
                    victim.giveDebuff(dis, MobSkillFactory.getMobSkill(type, CommandProcessorUtil.getOptionalIntArg(splitted, 3, 1)));
                }
            } else {
                for (MapleCharacter victim : c.getPlayer().getMap().getCharactersThreadsafe()) {
                    victim.setChair(0);
                    victim.getClient().sendPacket(MaplePacketCreator.cancelChair(-1));
                    victim.getMap().broadcastMessage(victim, MaplePacketCreator.showChair(c.getPlayer().getId(), 0), false);
                    victim.giveDebuff(dis, MobSkillFactory.getMobSkill(type, CommandProcessorUtil.getOptionalIntArg(splitted, 2, 1)));
                }
            }
            return 1;
        }

        public String getMessage() {
            return "!disease <SEAL/DARKNESS/WEAKEN/STUN/CURSE/POISON/SLOW/SEDUCE/REVERSE/ZOMBIFY/POTION/SHADOW/BLIND/FREEZE> [\u89d2\u8272\u540d\u79f0] <\u72b6\u6001\u7b49\u7ea7> - \u8ba9\u4eba\u5f97\u5230\u7279\u6b8a\u72b6\u6001";
        }
    }

    public static class SpeakWorld
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            for (ChannelServer cserv : ChannelServer.getAllInstances()) {
                for (MapleCharacter victim : cserv.getPlayerStorage().getAllCharacters()) {
                    if (victim.getId() == c.getPlayer().getId()) continue;
                    victim.getMap().broadcastMessage(MaplePacketCreator.getChatText(victim.getId(), StringUtil.joinStringFrom(splitted, 1), victim.isGM(), 0));
                }
            }
            return 1;
        }

        public String getMessage() {
            return "!speakchannel <\u8baf\u606f> - \u5bf9\u76ee\u524d\u670d\u52a1\u5668\u8fdb\u884c\u4f20\u9001\u4fe1\u606f";
        }
    }

    public static class SpeakChannel
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            for (MapleCharacter victim : c.getChannelServer().getPlayerStorage().getAllCharacters()) {
                if (victim.getId() == c.getPlayer().getId()) continue;
                victim.getMap().broadcastMessage(MaplePacketCreator.getChatText(victim.getId(), StringUtil.joinStringFrom(splitted, 1), victim.isGM(), 0));
            }
            return 1;
        }

        public String getMessage() {
            return "!speakchannel <\u8baf\u606f> - \u5bf9\u76ee\u524d\u9891\u9053\u8fdb\u884c\u53d1\u9001\u4fe1\u606f";
        }
    }

    public static class SpeakMap
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            for (MapleCharacter victim : c.getPlayer().getMap().getCharactersThreadsafe()) {
                if (victim.getId() == c.getPlayer().getId()) continue;
                victim.getMap().broadcastMessage(MaplePacketCreator.getChatText(victim.getId(), StringUtil.joinStringFrom(splitted, 1), victim.isGM(), 0));
            }
            return 1;
        }

        public String getMessage() {
            return "!speakmap <\u8baf\u606f> - \u5bf9\u76ee\u524d\u5730\u56fe\u8fdb\u884c\u53d1\u9001\u4fe1\u606f";
        }
    }

    public static class Speak
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            String name = splitted[1];
            int ch = World.Find.findChannel(name);
            if (ch <= 0) {
                c.getPlayer().dropMessage(6, "\u73a9\u5bb6\u5fc5\u987b\u5728\u7ebf");
                return 0;
            }
            MapleCharacter victim = ChannelServer.getInstance(ch).getPlayerStorage().getCharacterByName(name);
            if (victim == null) {
                c.getPlayer().dropMessage(5, "\u627e\u4e0d\u5230 '" + splitted[1]);
                return 0;
            }
            victim.getMap().broadcastMessage(MaplePacketCreator.getChatText(victim.getId(), StringUtil.joinStringFrom(splitted, 2), victim.isGM(), 0));
            return 1;
        }

        public String getMessage() {
            return "!speak <\u73a9\u5bb6\u540d\u79f0> <\u8baf\u606f> - \u5bf9\u67d0\u4e2a\u73a9\u5bb6\u53d1\u4fe1\u606f";
        }
    }

    public static class SpeakMega
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            MapleCharacter victim = null;
            if (splitted.length >= 2) {
                victim = c.getChannelServer().getPlayerStorage().getCharacterByName(splitted[1]);
            }
            try {
                World.Broadcast.broadcastSmega(MaplePacketCreator.serverNotice(3, victim == null ? c.getChannel() : victim.getClient().getChannel(), victim == null ? splitted[1] : victim.getName() + " : " + StringUtil.joinStringFrom(splitted, 2), true).getBytes());
            }
            catch (Exception e) {
                return 0;
            }
            return 1;
        }

        public String getMessage() {
            return "!speakmega [\u73a9\u5bb6\u540d\u79f0] <\u8baf\u606f> - \u5bf9\u67d0\u4e2a\u73a9\u5bb6\u7684\u983b\u9053\u8fdb\u884c\u5e7f\u64ad";
        }
    }

    public static class KillMap
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            for (MapleCharacter map : c.getPlayer().getMap().getCharactersThreadsafe()) {
                if (map == null || map.isGM()) continue;
                map.getStat().setHp(0);
                map.getStat().setMp(0);
                map.updateSingleStat(MapleStat.HP, 0);
                map.updateSingleStat(MapleStat.MP, 0);
            }
            return 1;
        }

        public String getMessage() {
            return "!killmap - \u6740\u6389\u6240\u6709\u73a9\u5bb6";
        }
    }

    public static class RemoveItem
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            if (splitted.length < 3) {
                return 0;
            }
            String name = splitted[1];
            int id = Integer.parseInt(splitted[2]);
            int ch = World.Find.findChannel(name);
            if (ch <= 0) {
                c.getPlayer().dropMessage(6, "\u73a9\u5bb6\u5fc5\u987b\u5728\u7ebf");
                return 0;
            }
            MapleCharacter chr = ChannelServer.getInstance(ch).getPlayerStorage().getCharacterByName(name);
            if (chr == null) {
                c.getPlayer().dropMessage(6, "\u6b64\u73a9\u5bb6\u5e76\u4e0d\u5b58\u5728");
            } else {
                chr.removeAll(id);
                c.getPlayer().dropMessage(6, "\u6240\u6709ID\u4e3a " + id + " \u7684\u9053\u5177\u5df2\u7ecf\u4ece " + name + " \u8eab\u4e0a\u88ab\u79fb\u9664\u4e86");
            }
            return 1;
        }

        public String getMessage() {
            return "!removeitem <\u89d2\u8272\u540d\u79f0> <\u7269\u54c1ID> - \u79fb\u9664\u73a9\u5bb6\u8eab\u4e0a\u7684\u9053\u5177";
        }
    }

    public static class CheckGash
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            if (splitted.length < 2) {
                return 0;
            }
            String name = splitted[1];
            int ch = World.Find.findChannel(name);
            if (ch <= 0) {
                c.getPlayer().dropMessage(6, "\u73a9\u5bb6\u5fc5\u987b\u5728\u7ebf");
                return 0;
            }
            MapleCharacter chrs = ChannelServer.getInstance(ch).getPlayerStorage().getCharacterByName(name);
            if (chrs == null) {
                c.getPlayer().dropMessage(5, "\u627e\u4e0d\u5230\u8be5\u89d2\u8272");
            } else {
                c.getPlayer().dropMessage(6, chrs.getName() + " \u6709 " + chrs.getCSPoints(1) + " \u70b9\u6570.");
            }
            return 1;
        }

        public String getMessage() {
            return "!checkgash <\u73a9\u5bb6\u540d\u79f0> - \u68c0\u67e5\u70b9\u6570";
        }
    }

    public static class \u9009\u62e9\u6d3b\u52a8
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            String msg;
            MapleEventType type = MapleEventType.getByString(splitted[1]);
            if (type == null) {
                StringBuilder sb = new StringBuilder("\u76ee\u524d\u5f00\u653e\u7684\u6d3b\u52a8\u6709: ");
                for (MapleEventType t : MapleEventType.values()) {
                    sb.append(t.name()).append(",");
                }
                c.getPlayer().dropMessage(5, sb.toString().substring(0, sb.toString().length() - 1));
            }
            if ((msg = MapleEvent.scheduleEvent(type, c.getChannelServer())).length() > 0) {
                c.getPlayer().dropMessage(5, msg);
            }
            return 1;
        }

        public String getMessage() {
            return "!\u9009\u62e9\u6d3b\u52a8 - \u9009\u62e9\u6d3b\u52a8";
        }
    }

    public static class \u5173\u95ed\u6d3b\u52a8\u5165\u53e3
    extends CommandExecute {
        private static boolean tt = false;

        @Override
        public int execute(MapleClient c, String[] splitted) {
            if (c.getChannelServer().getEvent() == c.getPlayer().getMapId()) {
                MapleEvent.setEvent(c.getChannelServer(), false);
                c.getPlayer().dropMessage(5, "\u5df2\u7ecf\u5173\u95ed\u6d3b\u52a8\u5165\u53e3\uff0c\u53ef\u4ee5\u4f7f\u7528 !\u6d3b\u52a8\u5f00\u59cb \u4f86\u542f\u52a8\u3002");
                World.Broadcast.broadcastMessage(MaplePacketCreator.serverNotice(6, "\u983b\u9053:" + c.getChannel() + "\u6d3b\u52a8\u76ee\u524d\u5df2\u7ecf\u5173\u95ed\u5927\u95e8\u53e3\u3002").getBytes());
                c.getPlayer().getMap().broadcastMessage(MaplePacketCreator.getClock(60));
                Timer.EventTimer.getInstance().register(new Runnable(){

                    @Override
                    public void run() {
                        tt = true;
                    }
                }, 60000L);
                if (tt) {
                    MapleEvent.onStartEvent(c.getPlayer());
                }
                return 1;
            }
            c.getPlayer().dropMessage(5, "\u60a8\u5fc5\u987b\u5148\u4f7f\u7528 !\u9009\u62e9\u6d3b\u52a8 \u8bbe\u5b9a\u5f53\u524d\u983b\u9053\u7684\u6d3b\u52a8\uff0c\u5e76\u5728\u5f53\u524d\u983b\u9053\u6d3b\u52a8\u5730\u56fe\u91cc\u4f7f\u7528\u3002");
            return 1;
        }

        public String getMessage() {
            return "!\u5173\u95ed\u6d3b\u52a8\u5165\u53e3 -\u5173\u95ed\u6d3b\u52a8\u5165\u53e3";
        }
    }

    public static class \u6d3b\u52a8\u5f00\u59cb
    extends CommandExecute {
        private static ScheduledFuture<?> ts = null;
        private int min = 1;

        @Override
        public int execute(final MapleClient c, String[] splitted) {
            if (c.getChannelServer().getEvent() == c.getPlayer().getMapId()) {
                MapleEvent.setEvent(c.getChannelServer(), false);
                c.getPlayer().dropMessage(5, "\u5df2\u7ecf\u5173\u95ed\u6d3b\u52a8\u5165\u53e3\uff0c\u53ef\u4ee5\u4f7f\u7528 !\u6d3b\u52a8\u5f00\u59cb \u4f86\u542f\u52a8\u3002");
                World.Broadcast.broadcastMessage(MaplePacketCreator.serverNotice(6, "\u983b\u9053:" + c.getChannel() + "\u6d3b\u52a8\u76ee\u524d\u5df2\u7ecf\u5173\u95ed\u5927\u95e8\u53e3\u3002").getBytes());
                c.getPlayer().getMap().broadcastMessage(MaplePacketCreator.getClock(60));
                ts = Timer.EventTimer.getInstance().register(new Runnable(){

                    @Override
                    public void run() {
                        if (\u6d3b\u52a8\u5f00\u59cb.this.min == 0) {
                            MapleEvent.onStartEvent(c.getPlayer());
                            ts.cancel(false);
                            return;
                        }
                        \u6d3b\u52a8\u5f00\u59cb.this.min--;
                    }
                }, 60000L);
                return 1;
            }
            c.getPlayer().dropMessage(5, "\u60a8\u5fc5\u987b\u5148\u4f7f\u7528 !\u9009\u62e9\u6d3b\u52a8 \u8bbe\u5b9a\u7576\u524d\u983b\u9053\u7684\u6d3b\u52a8\uff0c\u5e76\u5728\u5f53\u524d\u983b\u9053\u6d3b\u52a8\u5730\u56fe\u91cc\u4f7f\u7528\u3002");
            return 1;
        }

        public String getMessage() {
            return "!\u6d3b\u52a8\u5f00\u59cb - \u6d3b\u52a8\u5f00\u59cb";
        }
    }

    public static class \u5f00\u542f\u81ea\u52a8\u6d3b\u52a8
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            EventManager em = c.getChannelServer().getEventSM().getEventManager("AutomatedEvent");
            if (em != null) {
                em.scheduleRandomEvent();
            }
            return 1;
        }

        public String getMessage() {
            return "!\u5f00\u542f\u81ea\u52a8\u6d3b\u52a8 - \u5f00\u542f\u81ea\u52a8\u6d3b\u52a8";
        }
    }

    public static class Song
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            if (splitted.length < 2) {
                return 0;
            }
            c.getPlayer().getMap().broadcastMessage(MaplePacketCreator.musicChange(splitted[1]));
            return 1;
        }

        public String getMessage() {
            return "!song - \u64ad\u653e\u97f3\u4e50";
        }
    }

    public static class MobVac
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            for (MapleMapObject mapleMapObject : c.getPlayer().getMap().getAllMonstersThreadsafe()) {
                MapleMonster monster = (MapleMonster)mapleMapObject;
                c.getPlayer().getMap().broadcastMessage(MobPacket.moveMonster(false, -1, 0, 0, 0, 0, monster.getObjectId(), monster.getPosition(), c.getPlayer().getPosition(), c.getPlayer().getLastRes()));
                monster.setPosition(c.getPlayer().getPosition());
            }
            return 1;
        }

        public String getMessage() {
            return "!mobvac - \u5168\u56fe\u5438\u602a";
        }
    }

    public static class ItemCheck
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            if (splitted.length < 3 || splitted[1] == null || splitted[1].equals("") || splitted[2] == null || splitted[2].equals("")) {
                return 0;
            }
            int item = Integer.parseInt(splitted[2]);
            String name = splitted[1];
            int ch = World.Find.findChannel(name);
            if (ch <= 0) {
                c.getPlayer().dropMessage(6, "\u73a9\u5bb6\u5fc5\u987b\u5728\u7ebf");
                return 0;
            }
            MapleCharacter chr = ChannelServer.getInstance(ch).getPlayerStorage().getCharacterByName(name);
            int itemamount = chr.getItemQuantity(item, true);
            if (itemamount > 0) {
                c.getPlayer().dropMessage(6, chr.getName() + " \u6709 " + itemamount + " (" + item + ").");
            } else {
                c.getPlayer().dropMessage(6, chr.getName() + " \u5e76\u6c92\u6709 (" + item + ")");
            }
            return 1;
        }

        public String getMessage() {
            return "!itemcheck <playername> <itemid> - \u68c0\u67e5\u7269\u54c1";
        }
    }

    public static class Marry
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            if (splitted.length < 3) {
                return 0;
            }
            int itemId = Integer.parseInt(splitted[2]);
            if (!GameConstants.isEffectRing(itemId)) {
                c.getPlayer().dropMessage(6, "\u9519\u8bef\u7684\u6212\u6307ID.");
            } else {
                String name = splitted[1];
                int ch = World.Find.findChannel(name);
                if (ch <= 0) {
                    c.getPlayer().dropMessage(6, "\u73a9\u5bb6\u5fc5\u987b\u5728\u7ebf");
                    return 0;
                }
                MapleCharacter fff = ChannelServer.getInstance(ch).getPlayerStorage().getCharacterByName(name);
                if (fff == null) {
                    c.getPlayer().dropMessage(6, "\u73a9\u5bb6\u5fc5\u987b\u5728\u7ebf");
                } else {
                    int[] ringID = new int[]{MapleInventoryIdentifier.getInstance(), MapleInventoryIdentifier.getInstance()};
                    try {
                        MapleCharacter[] chrz = new MapleCharacter[]{fff, c.getPlayer()};
                        for (int i = 0; i < chrz.length; ++i) {
                            Equip eq = (Equip)MapleItemInformationProvider.getInstance().getEquipById(itemId);
                            if (eq == null) {
                                c.getPlayer().dropMessage(6, "\u9519\u8bef\u7684\u6212\u6307ID.");
                                return 1;
                            }
                            eq.setUniqueId(ringID[i]);
                            MapleInventoryManipulator.addbyItem(chrz[i].getClient(), eq.copy());
                            chrz[i].dropMessage(6, "\u6210\u529f\u4e0e  " + chrz[i == 0 ? 1 : 0].getName() + " \u7ed3\u5a5a");
                        }
                        MapleRing.addToDB(itemId, c.getPlayer(), fff.getName(), fff.getId(), ringID);
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
            }
            return 1;
        }

        public String getMessage() {
            return "!marry <\u73a9\u5bb6\u540d\u79f0> <\u6212\u6307\u4ee3\u7801> - \u7ed3\u5a5a";
        }
    }

    public static class Letter
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            int nstart;
            int start;
            if (splitted.length < 3) {
                c.getPlayer().dropMessage(6, "\u6307\u4ee4\u89c4\u5219: ");
                return 0;
            }
            if (splitted[1].equalsIgnoreCase("green")) {
                start = 3991026;
                nstart = 3990019;
            } else if (splitted[1].equalsIgnoreCase("red")) {
                start = 3991000;
                nstart = 3990009;
            } else {
                c.getPlayer().dropMessage(6, "\u672a\u77e5\u7684\u984f\u8272!");
                return 1;
            }
            String splitString = StringUtil.joinStringFrom(splitted, 2);
            ArrayList<Integer> chars = new ArrayList<Integer>();
            splitString = splitString.toUpperCase();
            for (int i = 0; i < splitString.length(); ++i) {
                char chr = splitString.charAt(i);
                if (chr == ' ') {
                    chars.add(-1);
                    continue;
                }
                if (chr >= 'A' && chr <= 'Z') {
                    chars.add(Integer.valueOf(chr));
                    continue;
                }
                if (chr < '0' || chr > '9') continue;
                chars.add(chr + 200);
            }
            int w = 32;
            int dStart = c.getPlayer().getPosition().x - splitString.length() / 2 * 32;
            for (Integer i : chars) {
                client.inventory.Item item;
                int val;
                if (i == -1) {
                    dStart += 32;
                    continue;
                }
                if (i < 200) {
                    val = start + i - 65;
                    item = new client.inventory.Item(val, 0, 1);
                    c.getPlayer().getMap().spawnItemDrop(c.getPlayer(), c.getPlayer(), item, new Point(dStart, c.getPlayer().getPosition().y), false, false);
                    dStart += 32;
                    continue;
                }
                if (i < 200 || i > 300) continue;
                val = nstart + i - 48 - 200;
                item = new client.inventory.Item(val, 0, 1);
                c.getPlayer().getMap().spawnItemDrop(c.getPlayer(), c.getPlayer(), item, new Point(dStart, c.getPlayer().getPosition().y), false, false);
                dStart += 32;
            }
            return 1;
        }

        public String getMessage() {
            return " !letter <color (green/red)> <word> - \u9001\u4fe1";
        }
    }

    public static class Say
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            if (splitted.length <= 1) {
                return 0;
            }
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            sb.append(c.getPlayer().getName());
            sb.append("] ");
            sb.append(StringUtil.joinStringFrom(splitted, 1));
            World.Broadcast.broadcastMessage(MaplePacketCreator.serverNotice(6, sb.toString()).getBytes());
            return 1;
        }

        public String getMessage() {
            return "!say \u8baf\u606f - \u670d\u52a1\u5668\u516c\u544a";
        }
    }

    public static class serverMsg
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            StringBuilder sb;
            if (splitted.length > 1) {
                sb = new StringBuilder();
                sb.append(StringUtil.joinStringFrom(splitted, 1));
                for (ChannelServer ch : ChannelServer.getAllInstances()) {
                    ch.setServerMessage(sb.toString());
                }
            } else {
                return 0;
            }
            World.Broadcast.broadcastMessage(MaplePacketCreator.serverMessage(sb.toString()).getBytes());
            return 1;
        }

        public String getMessage() {
            return "!servermsg \u8baf\u606f - \u66f4\u6539\u4e0a\u65b9\u9ec3\u8272\u516c\u544a";
        }
    }

    public static class Item
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            if (splitted.length < 2) {
                return 0;
            }
            int itemId = 0;
            try {
                itemId = Integer.parseInt(splitted[1]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            short quantity = (short)CommandProcessorUtil.getOptionalIntArg(splitted, 2, 1);
            MapleItemInformationProvider ii = MapleItemInformationProvider.getInstance();
            if (GameConstants.isPet(itemId)) {
                MaplePet pet = MaplePet.createPet(itemId, MapleInventoryIdentifier.getInstance());
                if (pet != null) {
                    MapleInventoryManipulator.addById(c, itemId, (short)1, c.getPlayer().getName(), pet, 90L, (byte)0);
                }
            } else if (!ii.itemExists(itemId)) {
                c.getPlayer().dropMessage(5, itemId + " - \u7269\u54c1\u4e0d\u5b58\u5728");
            } else {
                client.inventory.Item item;
                int flag = 0;
                flag = (byte)(flag | ItemFlag.LOCK.getValue());
                if (GameConstants.getInventoryType(itemId) == MapleInventoryType.EQUIP) {
                    item = ii.randomizeStats((Equip)ii.getEquipById(itemId));
                } else {
                    item = new client.inventory.Item(itemId, 0, quantity, 0);
                    if (GameConstants.getInventoryType(itemId) != MapleInventoryType.USE) {
                        // empty if block
                    }
                }
                item.setOwner(c.getPlayer().getName());
                item.setGMLog(c.getPlayer().getName());
                MapleInventoryManipulator.addbyItem(c, item);
            }
            return 1;
        }

        public String getMessage() {
            return "!item <\u9053\u5177ID> - \u53d6\u5f97\u9053\u5177";
        }
    }

    public static class UnlockInv
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            ArrayMap<IItem, MapleInventoryType> eqs = new ArrayMap<IItem, MapleInventoryType>();
            boolean add = false;
            if (splitted.length < 2 || splitted[1].equals("\u5168\u90e8")) {
                for (MapleInventoryType type : MapleInventoryType.values()) {
                    for (IItem item : c.getPlayer().getInventory(type)) {
                        if (ItemFlag.LOCK.check(item.getFlag())) {
                            item.setFlag((byte)(item.getFlag() - ItemFlag.LOCK.getValue()));
                            add = true;
                            c.getPlayer().reloadC();
                            c.getPlayer().dropMessage(5, "\u5df2\u7ecf\u89e3\u9501");
                        }
                        if (ItemFlag.UNTRADEABLE.check(item.getFlag())) {
                            item.setFlag((byte)(item.getFlag() - ItemFlag.UNTRADEABLE.getValue()));
                            add = true;
                            c.getPlayer().reloadC();
                            c.getPlayer().dropMessage(5, "\u5df2\u7ecf\u89e3\u9501");
                        }
                        if (add) {
                            eqs.put(item, type);
                        }
                        add = false;
                    }
                }
            } else if (splitted[1].equals("\u5df2\u88c5\u5907\u9053\u5177")) {
                for (IItem iItem : c.getPlayer().getInventory(MapleInventoryType.EQUIPPED)) {
                    if (ItemFlag.LOCK.check(iItem.getFlag())) {
                        iItem.setFlag((byte)(iItem.getFlag() - ItemFlag.LOCK.getValue()));
                        add = true;
                        c.getPlayer().reloadC();
                        c.getPlayer().dropMessage(5, "\u5df2\u7ecf\u89e3\u9501");
                    }
                    if (ItemFlag.UNTRADEABLE.check(iItem.getFlag())) {
                        iItem.setFlag((byte)(iItem.getFlag() - ItemFlag.UNTRADEABLE.getValue()));
                        add = true;
                        c.getPlayer().reloadC();
                        c.getPlayer().dropMessage(5, "\u5df2\u7d93\u89e3\u9396");
                    }
                    if (add) {
                        eqs.put(iItem, MapleInventoryType.EQUIP);
                    }
                    add = false;
                }
            } else if (splitted[1].equals("\u6b66\u5668")) {
                for (IItem iItem : c.getPlayer().getInventory(MapleInventoryType.EQUIP)) {
                    if (ItemFlag.LOCK.check(iItem.getFlag())) {
                        iItem.setFlag((byte)(iItem.getFlag() - ItemFlag.LOCK.getValue()));
                        add = true;
                        c.getPlayer().reloadC();
                        c.getPlayer().dropMessage(5, "\u5df2\u7ecf\u89e3\u9501");
                    }
                    if (ItemFlag.UNTRADEABLE.check(iItem.getFlag())) {
                        iItem.setFlag((byte)(iItem.getFlag() - ItemFlag.UNTRADEABLE.getValue()));
                        add = true;
                        c.getPlayer().reloadC();
                        c.getPlayer().dropMessage(5, "\u5df2\u7ecf\u89e3\u9501");
                    }
                    if (add) {
                        eqs.put(iItem, MapleInventoryType.EQUIP);
                    }
                    add = false;
                }
            } else if (splitted[1].equals("\u6d88\u8017")) {
                for (IItem iItem : c.getPlayer().getInventory(MapleInventoryType.USE)) {
                    if (ItemFlag.LOCK.check(iItem.getFlag())) {
                        iItem.setFlag((byte)(iItem.getFlag() - ItemFlag.LOCK.getValue()));
                        add = true;
                        c.getPlayer().reloadC();
                        c.getPlayer().dropMessage(5, "\u5df2\u7ecf\u89e3\u9501");
                    }
                    if (ItemFlag.UNTRADEABLE.check(iItem.getFlag())) {
                        iItem.setFlag((byte)(iItem.getFlag() - ItemFlag.UNTRADEABLE.getValue()));
                        add = true;
                        c.getPlayer().reloadC();
                        c.getPlayer().dropMessage(5, "\u5df2\u7ecf\u89e3\u9501");
                    }
                    if (add) {
                        eqs.put(iItem, MapleInventoryType.USE);
                    }
                    add = false;
                }
            } else if (splitted[1].equals("\u88c5\u9970")) {
                for (IItem iItem : c.getPlayer().getInventory(MapleInventoryType.SETUP)) {
                    if (ItemFlag.LOCK.check(iItem.getFlag())) {
                        iItem.setFlag((byte)(iItem.getFlag() - ItemFlag.LOCK.getValue()));
                        add = true;
                        c.getPlayer().reloadC();
                        c.getPlayer().dropMessage(5, "\u5df2\u7ecf\u89e3\u9501");
                    }
                    if (ItemFlag.UNTRADEABLE.check(iItem.getFlag())) {
                        iItem.setFlag((byte)(iItem.getFlag() - ItemFlag.UNTRADEABLE.getValue()));
                        add = true;
                        c.getPlayer().reloadC();
                        c.getPlayer().dropMessage(5, "\u5df2\u7ecf\u89e3\u9501");
                    }
                    if (add) {
                        eqs.put(iItem, MapleInventoryType.SETUP);
                    }
                    add = false;
                }
            } else if (splitted[1].equals("\u5176\u4ed6")) {
                for (IItem iItem : c.getPlayer().getInventory(MapleInventoryType.ETC)) {
                    if (ItemFlag.LOCK.check(iItem.getFlag())) {
                        iItem.setFlag((byte)(iItem.getFlag() - ItemFlag.LOCK.getValue()));
                        add = true;
                        c.getPlayer().reloadC();
                        c.getPlayer().dropMessage(5, "\u5df2\u7ecf\u89e3\u9501");
                    }
                    if (ItemFlag.UNTRADEABLE.check(iItem.getFlag())) {
                        iItem.setFlag((byte)(iItem.getFlag() - ItemFlag.UNTRADEABLE.getValue()));
                        add = true;
                        c.getPlayer().reloadC();
                        c.getPlayer().dropMessage(5, "\u5df2\u7ecf\u89e3\u9501");
                    }
                    if (add) {
                        eqs.put(iItem, MapleInventoryType.ETC);
                    }
                    add = false;
                }
            } else if (splitted[1].equals("\u7279\u6b8a")) {
                for (IItem iItem : c.getPlayer().getInventory(MapleInventoryType.CASH)) {
                    if (ItemFlag.LOCK.check(iItem.getFlag())) {
                        iItem.setFlag((byte)(iItem.getFlag() - ItemFlag.LOCK.getValue()));
                        add = true;
                        c.getPlayer().reloadC();
                        c.getPlayer().dropMessage(5, "\u5df2\u7ecf\u89e3\u9501");
                    }
                    if (ItemFlag.UNTRADEABLE.check(iItem.getFlag())) {
                        iItem.setFlag((byte)(iItem.getFlag() - ItemFlag.UNTRADEABLE.getValue()));
                        add = true;
                        c.getPlayer().reloadC();
                        c.getPlayer().dropMessage(5, "\u5df2\u7ecf\u89e3\u9501");
                    }
                    if (add) {
                        eqs.put(iItem, MapleInventoryType.CASH);
                    }
                    add = false;
                }
            } else {
                return 0;
            }
            for (Map.Entry entry : eqs.entrySet()) {
                c.getPlayer().forceReAddItem_NoUpdate(((IItem)entry.getKey()).copy(), (MapleInventoryType)((Object)entry.getValue()));
            }
            return 1;
        }

        public String getMessage() {
            return "!unlockinv <\u5168\u90e8/\u5df2\u88c5\u5907\u9053\u5177/\u6b66\u5668/\u6d88\u8017/\u88c5\u9970/\u5176\u4ed6/\u7279\u6b8a> - \u89e3\u9501\u9053\u5177";
        }
    }

    public static class LevelUp
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            if (splitted.length < 2) {
                c.getPlayer().levelUp();
            } else {
                int up = 0;
                try {
                    up = Integer.parseInt(splitted[1]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                for (int i = 0; i < up; ++i) {
                    c.getPlayer().levelUp();
                }
            }
            c.getPlayer().setExp(0);
            c.getPlayer().updateSingleStat(MapleStat.EXP, 0);
            return 1;
        }

        public String getMessage() {
            return "!levelup - \u7b49\u7d1a\u4e0a\u5347";
        }
    }

    public static class GainVP
    extends GainPoint {
    }

    public static class GainPoint
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            if (splitted.length < 3) {
                return 0;
            }
            int amount = Integer.parseInt(splitted[1]);
            String name = splitted[2];
            int ch = World.Find.findChannel(name);
            if (ch <= 0) {
                return 0;
            }
            MapleCharacter player = ChannelServer.getInstance(ch).getPlayerStorage().getCharacterByName(name);
            if (player == null) {
                return 0;
            }
            player.setPoints(player.getPoints() + amount);
            return 1;
        }

        public String getMessage() {
            return "!gainpoint <\u6578\u91cf> <\u73a9\u5bb6> - \u53d6\u5f97Point";
        }
    }

    public static class GainMaplePoint
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            if (splitted.length < 3) {
                return 0;
            }
            int amount = Integer.parseInt(splitted[1]);
            String name = splitted[2];
            int ch = World.Find.findChannel(name);
            if (ch <= 0) {
                return 0;
            }
            MapleCharacter player = ChannelServer.getInstance(ch).getPlayerStorage().getCharacterByName(name);
            if (player == null) {
                return 0;
            }
            player.modifyCSPoints(2, amount, true);
            String msg = "[GM \u5bc6\u8bed] GM " + c.getPlayer().getName() + " \u7ed9\u4e86 " + player.getName() + " \u67ab\u53f6\u70b9\u6570 " + amount + "\u70b9";
            World.Broadcast.broadcastGMMessage(MaplePacketCreator.serverNotice(6, msg).getBytes());
            return 1;
        }

        public String getMessage() {
            return "!gainmaplepoint <\u6578\u91cf> <\u73a9\u5bb6> - \u53d6\u5f97\u67ab\u53f6\u70b9\u6570";
        }
    }

    public static class GainCash
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            if (splitted.length < 3) {
                return 0;
            }
            MapleCharacter player = c.getPlayer();
            int amount = 0;
            String name = "";
            try {
                amount = Integer.parseInt(splitted[1]);
                name = splitted[2];
            }
            catch (Exception ex) {
                c.getPlayer().dropMessage("\u8be5\u73a9\u5bb6\u4e0d\u5728\u7ebf");
                return 1;
            }
            int ch = World.Find.findChannel(name);
            if (ch <= 0) {
                c.getPlayer().dropMessage("\u8be5\u73a9\u5bb6\u4e0d\u5728\u7ebf");
                return 1;
            }
            player = ChannelServer.getInstance(ch).getPlayerStorage().getCharacterByName(name);
            if (player == null) {
                c.getPlayer().dropMessage("\u8be5\u73a9\u5bb6\u4e0d\u5728\u7ebf");
                return 1;
            }
            player.modifyCSPoints(1, amount, true);
            player.dropMessage("\u5df2\u7ecf\u6536\u5230\u70b9\u5377" + amount + "\u70b9");
            String msg = "[GM \u5bc6\u8bed] GM " + c.getPlayer().getName() + " \u7d66\u4e86 " + player.getName() + " \u70b9\u5377 " + amount + "\u70b9";
            FileoutputUtil.logToFile("logs/Data/\u7ed9\u4e88\u70b9\u5377.txt", "\r\n " + FileoutputUtil.NowTime() + " GM " + c.getPlayer().getName() + " \u7ed9\u4e86 " + player.getName() + " \u70b9\u5377 " + amount + "\u70b9");
            return 1;
        }

        public String getMessage() {
            return "!gaingash <\u6578\u91cf> <\u73a9\u5bb6> - \u53d6\u5f97Gash\u70b9\u6570";
        }
    }

    public static class \u5173\u952e\u65f6\u523b
    extends CommandExecute {
        protected static ScheduledFuture<?> ts = null;

        @Override
        public int execute(final MapleClient c, String[] splitted) {
            int minutesLeft;
            if (splitted.length < 1) {
                return 0;
            }
            if (ts != null) {
                ts.cancel(false);
                c.getPlayer().dropMessage(0, "\u539f\u5b9a\u7684\u5173\u952e\u65f6\u523b\u5df2\u53d6\u6d88");
            }
            try {
                minutesLeft = Integer.parseInt(splitted[1]);
            }
            catch (NumberFormatException ex) {
                return 0;
            }
            if (minutesLeft > 0) {
                ts = Timer.EventTimer.getInstance().schedule(new Runnable(){

                    @Override
                    public void run() {
                        for (ChannelServer cserv : ChannelServer.getAllInstances()) {
                            for (MapleCharacter mch : cserv.getPlayerStorage().getAllCharacters()) {
                                if (c.getPlayer().isGM()) continue;
                                NPCScriptManager.getInstance().start(mch.getClient(), 9010010);
                            }
                        }
                        World.Broadcast.broadcastMessage(MaplePacketCreator.serverNotice(6, "\u5173\u952e\u65f6\u523b\u5df2\u7ecf\u5f00\u59cb\u4e86!!!").getBytes());
                        World.Broadcast.broadcastMessage(MaplePacketCreator.serverMessage("\u5173\u952e\u65f6\u523b\u5df2\u7ecf\u5f00\u59cb\u4e86!!!").getBytes());
                        ts.cancel(false);
                        ts = null;
                    }
                }, minutesLeft * 60 * 1000);
                c.getPlayer().dropMessage(0, "\u5173\u952e\u65f6\u523b\u9884\u5b9a\u5df2\u5b8c\u6210");
            } else {
                c.getPlayer().dropMessage(0, "\u8bbe\u5b9a\u7684\u65f6\u95f4\u5fc5\u987b > 0\u3002");
            }
            return 1;
        }

        public String getMessage() {
            return "!\u5173\u952e\u65f6\u523b <\u65f6\u95f4:\u5206\u949f> - \u5173\u952e\u65f6\u523b";
        }
    }

    public static class Shop
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            int shopId;
            MapleShopFactory shop = MapleShopFactory.getInstance();
            try {
                shopId = Integer.parseInt(splitted[1]);
            }
            catch (NumberFormatException ex) {
                return 0;
            }
            if (shop.getShop(shopId) != null) {
                shop.getShop(shopId).sendShop(c);
            } else {
                c.getPlayer().dropMessage(5, "\u6b64\u5546\u5e97ID\u4e0d\u5b58\u5728");
            }
            return 1;
        }

        public String getMessage() {
            return "!shop - \u5f00\u542f\u5546\u5e97";
        }
    }

    public static class AP
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            c.getPlayer().setRemainingAp((short)CommandProcessorUtil.getOptionalIntArg(splitted, 1, 1));
            c.getPlayer().updateSingleStat(MapleStat.AVAILABLEAP, CommandProcessorUtil.getOptionalIntArg(splitted, 1, 1));
            return 1;
        }

        public String getMessage() {
            return "!ap [\u6570\u91cf] - \u589e\u52a0AP";
        }
    }

    public static class SP
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            c.getPlayer().setRemainingSp(CommandProcessorUtil.getOptionalIntArg(splitted, 1, 1));
            c.sendPacket(MaplePacketCreator.updateSp(c.getPlayer(), false));
            return 1;
        }

        public String getMessage() {
            return "!sp [\u6570\u91cf] - \u589e\u52a0SP";
        }
    }

    public static class GiveSkill
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            if (splitted.length < 3) {
                return 0;
            }
            String name = splitted[1];
            int ch = World.Find.findChannel(name);
            if (ch <= 0) {
                return 0;
            }
            MapleCharacter victim = ChannelServer.getInstance(ch).getPlayerStorage().getCharacterByName(name);
            ISkill skill = SkillFactory.getSkill(Integer.parseInt(splitted[2]));
            byte level = (byte)CommandProcessorUtil.getOptionalIntArg(splitted, 3, 1);
            byte masterlevel = (byte)CommandProcessorUtil.getOptionalIntArg(splitted, 4, 1);
            if (level > skill.getMaxLevel()) {
                level = skill.getMaxLevel();
            }
            victim.changeSkillLevel(skill, level, masterlevel);
            return 1;
        }

        public String getMessage() {
            return "!giveskill <\u73a9\u5bb6\u540d\u79f0> <\u6280\u80fdID> [\u6280\u80fd\u7b49\u7d1a] [\u6280\u80fd\u6700\u5927\u7b49\u7d1a] - \u7ed9\u4e88\u6280\u80fd";
        }
    }

    public static class GodMode
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            MapleCharacter player = c.getPlayer();
            if (player.isInvincible()) {
                player.setInvincible(false);
                player.dropMessage(6, "\u65e0\u654c\u5df2\u7ecf\u5173\u95ed");
            } else {
                player.setInvincible(true);
                player.dropMessage(6, "\u65e0\u654c\u5df2\u7ecf\u5f00\u542f.");
            }
            return 1;
        }

        public String getMessage() {
            return "!godmode  - \u65e0\u654c\u5f00\u5173";
        }
    }

    public static class HealMap
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            MapleCharacter player = c.getPlayer();
            for (MapleCharacter mch : player.getMap().getCharacters()) {
                if (mch == null) continue;
                mch.getStat().setHp(mch.getStat().getMaxHp());
                mch.updateSingleStat(MapleStat.HP, mch.getStat().getMaxHp());
                mch.getStat().setMp(mch.getStat().getMaxMp());
                mch.updateSingleStat(MapleStat.MP, mch.getStat().getMaxMp());
                mch.dispelDebuffs();
            }
            return 1;
        }

        public String getMessage() {
            return "!healmap  - \u6cbb\u6108\u5730\u56fe\u4e0a\u6240\u6709\u7684\u4eba";
        }
    }

    public static class autoreg
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            c.getPlayer().dropMessage("\u76ee\u524d\u81ea\u52a8\u6ce8\u518c\u5df2\u7ecf " + ServerConstants.ChangeAutoReg());
            return 1;
        }

        public String getMessage() {
            return "!autoreg  - \u81ea\u52a8\u6ce8\u518c\u5f00\u5173";
        }
    }

    public static class Fame
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            short fame;
            MapleCharacter player = c.getPlayer();
            if (splitted.length < 2) {
                c.getPlayer().dropMessage("!fame <\u89d2\u8272\u540d\u79f0> <\u540d\u58f0> ...  - \u540d\u58f0");
                return 0;
            }
            String name = splitted[1];
            int ch = World.Find.findChannel(name);
            if (ch <= 0) {
                return 0;
            }
            MapleCharacter victim = ChannelServer.getInstance(ch).getPlayerStorage().getCharacterByName(name);
            try {
                fame = Short.parseShort(splitted[2]);
            }
            catch (NumberFormatException nfe) {
                c.getPlayer().dropMessage(6, "\u4e0d\u5408\u6cd5\u7684\u6570\u5b57");
                return 0;
            }
            if (victim != null && player.allowedToTarget(victim)) {
                victim.addFame(fame);
                victim.updateSingleStat(MapleStat.FAME, victim.getFame());
            } else {
                c.getPlayer().dropMessage(6, "[fame] \u89d2\u8272\u4e0d\u5b58\u5728");
            }
            return 1;
        }

        public String getMessage() {
            return "!fame <\u89d2\u8272\u540d\u79f0> <\u540d\u58f0> ...  - \u540d\u58f0";
        }
    }

    public static class Skill
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            if (splitted.length < 2) {
                return 0;
            }
            ISkill skill = SkillFactory.getSkill(Integer.parseInt(splitted[1]));
            byte level = (byte)CommandProcessorUtil.getOptionalIntArg(splitted, 2, 1);
            byte masterlevel = (byte)CommandProcessorUtil.getOptionalIntArg(splitted, 3, 1);
            if (level > skill.getMaxLevel()) {
                level = skill.getMaxLevel();
            }
            c.getPlayer().changeSkillLevel(skill, level, masterlevel);
            return 1;
        }

        public String getMessage() {
            return "!skill <\u6280\u80fdID> [\u6280\u80fd\u7b49\u7d1a] [\u6280\u80fd\u6700\u5927\u7b49\u7d1a] ...  - \u5b66\u4e60\u6280\u80fd";
        }
    }

    public static class Kill
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            MapleCharacter player = c.getPlayer();
            if (splitted.length < 2) {
                return 0;
            }
            for (int i = 1; i < splitted.length; ++i) {
                String name = splitted[1];
                int ch = World.Find.findChannel(name);
                if (ch <= 0) {
                    return 0;
                }
                MapleCharacter victim = ChannelServer.getInstance(ch).getPlayerStorage().getCharacterByName(name);
                if (victim == null) {
                    c.getPlayer().dropMessage(6, "[kill] \u73a9\u5bb6 " + splitted[i] + " \u4e0d\u5b58\u5728.");
                    continue;
                }
                if (!player.allowedToTarget(victim)) continue;
                victim.getStat().setHp(0);
                victim.getStat().setMp(0);
                victim.updateSingleStat(MapleStat.HP, 0);
                victim.updateSingleStat(MapleStat.MP, 0);
            }
            return 1;
        }

        public String getMessage() {
            return "!kill <\u73a9\u5bb6\u540d\u79f01> <\u73a9\u5bb6\u540d\u79f02> ...  - \u6740\u6389\u73a9\u5bb6";
        }
    }

    public static class TempBan
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            String name = splitted[1];
            int ch = World.Find.findChannel(name);
            if (ch <= 0) {
                return 0;
            }
            MapleCharacter victim = ChannelServer.getInstance(ch).getPlayerStorage().getCharacterByName(name);
            int reason = Integer.parseInt(splitted[2]);
            int numDay = Integer.parseInt(splitted[3]);
            Calendar cal = Calendar.getInstance();
            cal.add(5, numDay);
            DateFormat df = DateFormat.getInstance();
            if (victim == null) {
                c.getPlayer().dropMessage(6, "[tempban] \u627e\u4e0d\u5230\u76ee\u6807\u89d2\u8272");
            } else {
                victim.tempban("\u7531" + c.getPlayer().getName() + "\u6682\u65f6\u9501\u5b9a\u4e86", cal, reason, true);
                c.getPlayer().dropMessage(6, "[tempban] " + splitted[1] + " \u5df2\u6210\u529f\u88ab\u6682\u65f6\u9501\u5b9a\u81f3 " + df.format(cal.getTime()));
            }
            return 1;
        }

        public String getMessage() {
            return "!tempban <\u73a9\u5bb6\u540d\u79f0> - \u6682\u65f6\u9501\u5b9a\u73a9\u5bb6";
        }
    }

    public static class UnbanIP
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            if (splitted.length < 2) {
                return 0;
            }
            byte ret_ = MapleClient.unbanIPMacs(splitted[1]);
            if (ret_ == -2) {
                c.getPlayer().dropMessage(6, "[unbanip] SQL \u9519\u8bef.");
            } else if (ret_ == -1) {
                c.getPlayer().dropMessage(6, "[unbanip] \u89d2\u8272\u4e0d\u5b58\u5728.");
            } else if (ret_ == 0) {
                c.getPlayer().dropMessage(6, "[unbanip] No IP or Mac with that character exists!");
            } else if (ret_ == 1) {
                c.getPlayer().dropMessage(6, "[unbanip] IP\u6216Mac\u5df2\u89e3\u9501\u5176\u4e2d\u4e00\u500b.");
            } else if (ret_ == 2) {
                c.getPlayer().dropMessage(6, "[unbanip] IP\u4ee5\u53caMac\u5df2\u6210\u529f\u89e3\u9501.");
            }
            return 1;
        }

        public String getMessage() {
            return "!unbanip <\u73a9\u5bb6\u540d\u79f0> - \u89e3\u9501\u73a9\u5bb6";
        }
    }

    public static class Heal
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            c.getPlayer().getStat().setHp(c.getPlayer().getStat().getCurrentMaxHp());
            c.getPlayer().getStat().setMp(c.getPlayer().getStat().getCurrentMaxMp());
            c.getPlayer().updateSingleStat(MapleStat.HP, c.getPlayer().getStat().getCurrentMaxHp());
            c.getPlayer().updateSingleStat(MapleStat.MP, c.getPlayer().getStat().getCurrentMaxMp());
            c.getPlayer().dispelDebuffs();
            return 1;
        }

        public String getMessage() {
            return "!heal - \u8865\u6ee1\u8840\u9b54";
        }
    }

    public static class LowHP
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            c.getPlayer().getStat().setHp(1);
            c.getPlayer().getStat().setMp(1);
            c.getPlayer().updateSingleStat(MapleStat.HP, 1);
            c.getPlayer().updateSingleStat(MapleStat.MP, 1);
            return 1;
        }

        public String getMessage() {
            return "!lowhp - \u8840\u9b54\u5f52\u3127";
        }
    }

    public static class SaveAll
    extends CommandExecute {
        private int p = 0;

        @Override
        public int execute(MapleClient c, String[] splitted) {
            for (ChannelServer cserv : ChannelServer.getAllInstances()) {
                List<MapleCharacter> chrs = cserv.getPlayerStorage().getAllCharactersThreadSafe();
                for (MapleCharacter chr : chrs) {
                    ++this.p;
                    chr.saveToDB(false, false);
                }
            }
            c.getPlayer().dropMessage("[\u4fdd\u5b58] " + this.p + "\u4e2a\u73a9\u5bb6\u6570\u636e\u4fdd\u5b58\u5230\u6570\u636e\u4e2d.");
            this.p = 0;
            return 1;
        }

        public String getMessage() {
            return "!saveall - \u4fdd\u5b58\u6240\u6709\u89d2\u8272\u8cc7\u6599";
        }
    }

    public static class ShutdownTime
    extends CommandExecute {
        private static ScheduledFuture<?> ts = null;
        private int minutesLeft = 0;
        private static Thread t = null;

        @Override
        public int execute(MapleClient c, String[] splitted) {
            if (splitted.length < 2) {
                return 0;
            }
            this.minutesLeft = Integer.parseInt(splitted[1]);
            c.getPlayer().dropMessage(6, "\u670d\u52a1\u5668\u5c06\u5728 " + this.minutesLeft + "\u5206\u949f\u540e\u5173\u95ed. \u8bf7\u5c3d\u901f\u5173\u95ed\u7cbe\u7075\u5546\u4eba \u5e76\u4e0b\u7ebf.");
            if (!(ts != null || t != null && t.isAlive())) {
                t = new Thread(ShutdownServer.getInstance());
                ts = Timer.EventTimer.getInstance().register(new Runnable(){

                    @Override
                    public void run() {
                        if (ShutdownTime.this.minutesLeft == 0) {
                            ShutdownServer.getInstance().run();
                            t.start();
                            ts.cancel(false);
                            return;
                        }
                        StringBuilder message = new StringBuilder();
                        message.append("[\u5192\u9669\u5c9b\u516c\u544a] \u670d\u52a1\u5668\u5c06\u5728 ");
                        message.append(ShutdownTime.this.minutesLeft);
                        message.append("\u5206\u949f\u540e\u5173\u95ed. \u8bf7\u5c3d\u901f\u5173\u95ed\u7cbe\u7075\u5546\u4eba \u5e76\u4e0b\u7ebf.");
                        World.Broadcast.broadcastMessage(MaplePacketCreator.serverNotice(6, message.toString()).getBytes());
                        World.Broadcast.broadcastMessage(MaplePacketCreator.serverMessage(message.toString()).getBytes());
                        for (ChannelServer cs : ChannelServer.getAllInstances()) {
                            cs.setServerMessage("\u670d\u52a1\u5668\u5c06\u4e8e " + ShutdownTime.this.minutesLeft + " \u5206\u949f\u540e\u5f00\u542f");
                        }
                        ShutdownTime.this.minutesLeft--;
                    }
                }, 60000L);
            } else {
                c.getPlayer().dropMessage(6, "\u670d\u52a1\u5668\u5173\u95ed\u65f6\u95f4\u4fee\u6539\u4e3a " + this.minutesLeft + "\u5206\u949f\u540e\uff0c\u8bf7\u7a0d\u7b49\u670d\u52a1\u5668\u5173\u95ed");
            }
            return 1;
        }

        public String getMessage() {
            return "!shutdowntime <\u79d2\u6570> - \u5173\u95ed\u670d\u52a1\u5668";
        }
    }

    public static class Shutdown
    extends CommandExecute {
        private static Thread t = null;

        @Override
        public int execute(MapleClient c, String[] splitted) {
            c.getPlayer().dropMessage(6, "\u5173\u95ed\u670d\u52a1\u5668...");
            if (t == null || !t.isAlive()) {
                t = new Thread(ShutdownServer.getInstance());
                t.start();
            } else {
                c.getPlayer().dropMessage(6, "\u5df2\u5728\u6267\u884c\u4e2d...");
            }
            return 1;
        }

        public String getMessage() {
            return "!shutdown - \u5173\u95ed\u670d\u52a1\u5668";
        }
    }

    public static class SavePlayerShops
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            for (ChannelServer cserv : ChannelServer.getAllInstances()) {
                cserv.closeAllMerchant();
            }
            c.getPlayer().dropMessage(6, "\u96c7\u4f63\u5546\u4eba\u50a8\u5b58\u5b8c\u6bd5.");
            return 1;
        }
    }

    public static class setUserLimit
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            int UserLimit = LoginServer.getUserLimit();
            try {
                UserLimit = Integer.parseInt(splitted[1]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            LoginServer.setUserLimit(UserLimit);
            c.getPlayer().dropMessage("\u670d\u52a1\u5668\u4eba\u6570\u4e0a\u9650\u5df2\u66f4\u6539\u4e3a" + UserLimit);
            return 1;
        }
    }

    public static class BanStatus
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            if (splitted.length < 2) {
                return 0;
            }
            String name = splitted[1];
            String mac = "";
            String ip = "";
            int acid = 0;
            boolean Systemban = false;
            boolean ACbanned = false;
            boolean IPbanned = false;
            boolean MACbanned = false;
            String reason = null;
            try {
                java.sql.Connection con = DatabaseConnection.getConnection();
                PreparedStatement ps = (PreparedStatement)con.prepareStatement("select accountid from characters where name = ?");
                ps.setString(1, name);
                try (ResultSet rs = ps.executeQuery();){
                    if (rs.next()) {
                        acid = rs.getInt("accountid");
                    }
                }
                ps = (PreparedStatement)con.prepareStatement("select banned, banreason, macs, Sessionip from accounts where id = ?");
                ps.setInt(1, acid);
                rs = ps.executeQuery();
                var15_16 = null;
                try {
                    if (rs.next()) {
                        Systemban = rs.getInt("banned") == 2;
                        ACbanned = rs.getInt("banned") == 1 || rs.getInt("banned") == 2;
                        reason = rs.getString("banreason");
                        mac = rs.getString("macs");
                        ip = rs.getString("Sessionip");
                    }
                }
                catch (Throwable throwable) {
                    var15_16 = throwable;
                    throw throwable;
                }
                finally {
                    if (rs != null) {
                        if (var15_16 != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable x2) {
                                var15_16.addSuppressed(x2);
                            }
                        } else {
                            rs.close();
                        }
                    }
                }
                ps.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (reason == null || reason == "") {
                reason = "?";
            }
            if (c.isBannedIP(ip)) {
                IPbanned = true;
            }
            if (c.isBannedMac(mac)) {
                MACbanned = true;
            }
            c.getPlayer().dropMessage("\u73a9\u5bb6[" + name + "] \u5e10\u53f7ID[" + acid + "]\u662f\u5426\u88ab\u5c01\u9501: " + (ACbanned ? "\u662f" : "\u5426") + (Systemban ? "(\u7cfb\u7edf\u81ea\u52a8\u5c01\u9501)" : "") + ", \u539f\u56e0: " + reason);
            c.getPlayer().dropMessage("IP: " + ip + " \u662f\u5426\u5728\u5c01\u9501IP\u540d\u5355: " + (IPbanned ? "\u662f" : "\u5426"));
            c.getPlayer().dropMessage("MAC: " + mac + " \u662f\u5426\u5728\u5c01\u9501MAC\u540d\u5355: " + (MACbanned ? "\u662f" : "\u5426"));
            return 1;
        }

        public String getMessage() {
            return "!BanStatus <\ue010\u7522\ue6bd\u563f> - \u7429\ue0f8\ue010\u7522\u740c\ue725\u7806\ue087\u739b\u306e\ue165\ue6c3";
        }
    }

    public static class sendNoticeGG
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            if (splitted.length < 2) {
                c.getPlayer().dropMessage("\u4f7f\u7528\u65b9\u6cd5: !\u53d1\u9001\u516c\u544a [\u516c\u544a\u5185\u5bb9] - \u7ed9\u6240\u6709\u4eba\u53d1\u9001\u516c\u544a");
                return 0;
            }
            String msg = splitted[1];
            for (ChannelServer cserv1 : ChannelServer.getAllInstances()) {
                for (MapleCharacter mch : cserv1.getPlayerStorage().getAllCharacters()) {
                    mch.startMapEffect(msg, 5121009);
                }
            }
            return 1;
        }

        public String getMessage() {
            return "!\u53d1\u9001\u516c\u544a [\u516c\u544a\u5185\u5bb9] - \u7ed9\u6240\u6709\u4eba\u53d1\u9001\u516c\u544a";
        }
    }

    public static class Debug
    extends CommandExecute {
        @Override
        public int execute(MapleClient c, String[] splitted) {
            c.getPlayer().setDebugMessage(!c.getPlayer().getDebugMessage());
            return 1;
        }
    }

    public static class \u53d1\u9001\u516c\u544a
    extends sendNoticeGG {
    }

    public static class \u5c01\u53f7\u72b6\u6001
    extends BanStatus {
    }

    public static class \u4eba\u6570\u4e0a\u9650
    extends setUserLimit {
    }

    public static class \u602a\u7269\u4ee3\u7801
    extends mob {
    }

    public static class \u81ea\u52a8\u6ce8\u518c
    extends autoreg {
    }

    public static class \u8ba1\u65f6\u5668
    extends Clock {
    }

    public static class \u53ec\u5524\u602a\u7269
    extends Spawn {
    }

    public static class \u6e05\u9664\u5730\u677f
    extends cleardrops {
    }

    public static class \u5438\u602a
    extends MobVac {
    }

    public static class \u8bbe\u7f6e\u4eba\u6c14
    extends Fame {
    }

    public static class \u6e05\u602a
    extends KillAll {
    }

    public static class \u5168\u90e8\u590d\u6d3b
    extends HealMap {
    }

    public static class \u4e22
    extends Drop {
    }

    public static class \u5237
    extends Item {
    }

    public static class \u5730\u56fe\u4ee3\u7801
    extends WhereAmI {
    }

    public static class \u500d\u7387\u8bbe\u7f6e
    extends setRate {
    }

    public static class \u795d\u798f
    extends buff {
    }

    public static class \u5237\u65b0\u5730\u56fe
    extends ReloadMap {
    }

    public static class \u7ed9\u70b9\u5377
    extends GainCash {
    }

    public static class \u7ed9\u6240\u6709\u4eba\u70b9\u5377
    extends CashEveryone {
    }

    public static class \u7ed9\u7ecf\u9a8c
    extends ExpEveryone {
    }

    public static class \u7ed9\u91d1\u5e01
    extends mesoEveryone {
    }

    public static class \u62c9\u5168\u90e8
    extends WarpAllHere {
    }

    public static class \u6ee1\u6280\u80fd
    extends maxSkills {
    }

    public static class \u6ee1\u5c5e\u6027
    extends maxstats {
    }

    public static class \u6ce8\u518c
    extends register {
    }

    public static class \u5173\u95ed\u5730\u56fe
    extends closemap {
    }

    public static class \u5f00\u653e\u5730\u56fe
    extends openmap {
    }
}

