/*
 * Decompiled with CFR 0.152.
 */
package client;

import client.BuddyEntry;
import client.MapleCharacter;
import client.MapleClient;
import database.DatabaseConnection;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import tools.MaplePacketCreator;

public class BuddyList
implements Serializable {
    public static final String DEFAULT_GROUP = "\u5176\u4ed6";
    private final Map<Integer, BuddyEntry> buddies;
    private byte capacity;
    private final Deque<BuddyEntry> pendingReqs = new LinkedList<BuddyEntry>();

    public BuddyList(byte capacity) {
        this.buddies = new LinkedHashMap<Integer, BuddyEntry>();
        this.capacity = capacity;
    }

    public BuddyList(int capacity) {
        this.buddies = new LinkedHashMap<Integer, BuddyEntry>();
        this.capacity = (byte)capacity;
    }

    public boolean contains(int characterId) {
        return this.buddies.containsKey(characterId);
    }

    public boolean containsVisible(int charId) {
        BuddyEntry ble = this.buddies.get(charId);
        if (ble == null) {
            return false;
        }
        return ble.isVisible();
    }

    public byte getCapacity() {
        return this.capacity;
    }

    public void setCapacity(byte newCapacity) {
        this.capacity = newCapacity;
    }

    public BuddyEntry get(int characterId) {
        return this.buddies.get(characterId);
    }

    public BuddyEntry get(String characterName) {
        String searchName = characterName.toLowerCase();
        for (BuddyEntry ble : this.buddies.values()) {
            if (!ble.getName().toLowerCase().equals(searchName)) continue;
            return ble;
        }
        return null;
    }

    public void put(BuddyEntry newEntry) {
        this.buddies.put(newEntry.getCharacterId(), newEntry);
    }

    public void remove(int characterId) {
        this.buddies.remove(characterId);
    }

    public Collection<BuddyEntry> getBuddies() {
        return this.buddies.values();
    }

    public boolean isFull() {
        return this.buddies.size() >= this.capacity;
    }

    public Collection<Integer> getBuddiesIds() {
        return this.buddies.keySet();
    }

    public void loadFromTransfer(Map<BuddyEntry, Boolean> data) {
        for (Map.Entry<BuddyEntry, Boolean> qs : data.entrySet()) {
            BuddyEntry buddyid = qs.getKey();
            boolean pair = qs.getValue();
            if (!pair) {
                this.pendingReqs.push(buddyid);
                continue;
            }
            this.put(new BuddyEntry(buddyid.getName(), buddyid.getCharacterId(), buddyid.getGroup(), -1, true, buddyid.getLevel(), buddyid.getJob()));
        }
    }

    public void loadFromDb(int characterId) throws SQLException {
        Connection con = DatabaseConnection.getConnection();
        PreparedStatement ps = con.prepareStatement("SELECT b.buddyid, b.pending, c.name as buddyname, c.job as buddyjob, c.level as buddylevel, b.groupname FROM buddies as b, characters as c WHERE c.id = b.buddyid AND b.characterid = ?");
        ps.setInt(1, characterId);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            int buddyid = rs.getInt("buddyid");
            String buddyname = rs.getString("buddyname");
            if (rs.getInt("pending") == 1) {
                this.pendingReqs.push(new BuddyEntry(buddyname, buddyid, rs.getString("groupname"), -1, false, rs.getInt("buddylevel"), rs.getInt("buddyjob")));
                continue;
            }
            this.put(new BuddyEntry(buddyname, buddyid, rs.getString("groupname"), -1, true, rs.getInt("buddylevel"), rs.getInt("buddyjob")));
        }
        rs.close();
        ps.close();
        ps = con.prepareStatement("DELETE FROM buddies WHERE pending = 1 AND characterid = ?");
        ps.setInt(1, characterId);
        ps.executeUpdate();
        ps.close();
    }

    public BuddyEntry pollPendingRequest() {
        return this.pendingReqs.pollLast();
    }

    public void addBuddyRequest(MapleClient client, int buddyId, String buddyName, int buddyChannel, int buddyLevel, int buddyJob) {
        this.put(new BuddyEntry(buddyName, buddyId, DEFAULT_GROUP, buddyChannel, false, buddyLevel, buddyJob));
        if (this.pendingReqs.isEmpty()) {
            client.sendPacket(MaplePacketCreator.requestBuddylistAdd(buddyId, buddyName, buddyLevel, buddyJob));
        } else {
            BuddyEntry newPair = new BuddyEntry(buddyName, buddyId, DEFAULT_GROUP, -1, false, buddyJob, buddyLevel);
            this.pendingReqs.push(newPair);
        }
    }

    public static int getBuddyCount(int chrId, int pending) {
        int count = 0;
        Connection con = DatabaseConnection.getConnection();
        try (PreparedStatement ps = con.prepareStatement("SELECT COUNT(*) as buddyCount FROM buddies WHERE characterid = ? AND pending = ?");){
            ps.setInt(1, chrId);
            ps.setInt(2, pending);
            try (ResultSet rs = ps.executeQuery();){
                if (!rs.next()) {
                    throw new RuntimeException("BuddyListHandler: getBuudyCount From DB is Error.");
                }
                count = rs.getInt("buddyCount");
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        return count;
    }

    public static int getBuddyCapacity(int charId) {
        int capacity = -1;
        Connection con = DatabaseConnection.getConnection();
        try (PreparedStatement ps = con.prepareStatement("SELECT buddyCapacity FROM characters WHERE id = ?");){
            ps.setInt(1, charId);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    capacity = rs.getInt("buddyCapacity");
                }
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        return capacity;
    }

    public static int getBuddyPending(int chrId, int buddyId) {
        int pending = -1;
        Connection con = DatabaseConnection.getConnection();
        try (PreparedStatement ps = con.prepareStatement("SELECT pending FROM buddies WHERE characterid = ? AND buddyid = ?");){
            ps.setInt(1, chrId);
            ps.setInt(2, buddyId);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    pending = rs.getInt("pending");
                }
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        return pending;
    }

    public static void addBuddyToDB(MapleCharacter player, BuddyEntry buddy) {
        try {
            Connection con = DatabaseConnection.getConnection();
            try (PreparedStatement ps = con.prepareStatement("INSERT INTO buddies (`characterid`, `buddyid`, `groupname`, `pending`) VALUES (?, ?, ?, 1)");){
                ps.setInt(1, buddy.getCharacterId());
                ps.setInt(2, player.getId());
                ps.setString(3, buddy.getGroup());
                ps.executeUpdate();
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    public static enum BuddyAddResult {
        BUDDYLIST_FULL,
        ALREADY_ON_LIST,
        OK;

    }

    public static enum BuddyOperation {
        ADDED,
        DELETED;

    }
}

