/*
 * Decompiled with CFR 0.152.
 */
package client;

import database.DatabaseConnection;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class BuddyEntry {
    private final String name;
    private String group;
    private final int characterId;
    private final int level;
    private final int job;
    private boolean visible;
    private int channel;

    public BuddyEntry(String name, int characterId, String group, int channel, boolean visible, int level, int job) {
        this.name = name;
        this.characterId = characterId;
        this.group = group;
        this.channel = channel;
        this.visible = visible;
        this.level = level;
        this.job = job;
    }

    public int getChannel() {
        return this.channel;
    }

    public void setChannel(int channel) {
        this.channel = channel;
    }

    public boolean isOnline() {
        return this.channel >= 0;
    }

    public void setOffline() {
        this.channel = -1;
    }

    public String getName() {
        return this.name;
    }

    public int getCharacterId() {
        return this.characterId;
    }

    public int getLevel() {
        return this.level;
    }

    public int getJob() {
        return this.job;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String newGroup) {
        this.group = newGroup;
    }

    public static BuddyEntry getByNameFromDB(String buddyName) {
        try {
            Connection con = DatabaseConnection.getConnection();
            PreparedStatement ps = con.prepareStatement("SELECT id, name, level, job FROM characters WHERE name = ?");
            ps.setString(1, buddyName);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                return new BuddyEntry(rs.getString("name"), rs.getInt("id"), "\u5176\u4ed6", -1, false, rs.getInt("level"), rs.getInt("job"));
            }
            return null;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static BuddyEntry getByIdfFromDB(int buddyCharId) {
        try {
            Connection con = DatabaseConnection.getConnection();
            PreparedStatement ps = con.prepareStatement("SELECT id, name, level, job FROM characters WHERE id = ?");
            ps.setInt(1, buddyCharId);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                return new BuddyEntry(rs.getString("name"), rs.getInt("id"), "\u5176\u4ed6", -1, true, rs.getInt("level"), rs.getInt("job"));
            }
            return null;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public final int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.characterId;
        return result;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        BuddyEntry other = (BuddyEntry)obj;
        return this.characterId == other.characterId;
    }
}

