/*
 * Decompiled with CFR 0.152.
 */
package sun.org.mozilla.javascript.internal;

import java.io.CharArrayWriter;
import java.io.FilenameFilter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sun.org.mozilla.javascript.internal.Context;
import sun.org.mozilla.javascript.internal.Evaluator;
import sun.org.mozilla.javascript.internal.Interpreter;
import sun.org.mozilla.javascript.internal.ScriptStackElement;
import sun.org.mozilla.javascript.internal.SecurityUtilities;

public abstract class RhinoException
extends RuntimeException {
    private static boolean useMozillaStackStyle = false;
    private String sourceName;
    private int lineNumber;
    private String lineSource;
    private int columnNumber;
    Object interpreterStackInfo;
    int[] interpreterLineData;

    RhinoException() {
        Evaluator evaluator = Context.createInterpreter();
        if (evaluator != null) {
            evaluator.captureStackInfo(this);
        }
    }

    RhinoException(String string) {
        super(string);
        Evaluator evaluator = Context.createInterpreter();
        if (evaluator != null) {
            evaluator.captureStackInfo(this);
        }
    }

    @Override
    public final String getMessage() {
        String string = this.details();
        if (this.sourceName == null || this.lineNumber <= 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append(" (");
        if (this.sourceName != null) {
            stringBuffer.append(this.sourceName);
        }
        if (this.lineNumber > 0) {
            stringBuffer.append('#');
            stringBuffer.append(this.lineNumber);
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public String details() {
        return super.getMessage();
    }

    public final String sourceName() {
        return this.sourceName;
    }

    public final void initSourceName(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        if (this.sourceName != null) {
            throw new IllegalStateException();
        }
        this.sourceName = string;
    }

    public final int lineNumber() {
        return this.lineNumber;
    }

    public final void initLineNumber(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        if (this.lineNumber > 0) {
            throw new IllegalStateException();
        }
        this.lineNumber = n;
    }

    public final int columnNumber() {
        return this.columnNumber;
    }

    public final void initColumnNumber(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        if (this.columnNumber > 0) {
            throw new IllegalStateException();
        }
        this.columnNumber = n;
    }

    public final String lineSource() {
        return this.lineSource;
    }

    public final void initLineSource(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        if (this.lineSource != null) {
            throw new IllegalStateException();
        }
        this.lineSource = string;
    }

    final void recordErrorOrigin(String string, int n, String string2, int n2) {
        if (n == -1) {
            n = 0;
        }
        if (string != null) {
            this.initSourceName(string);
        }
        if (n != 0) {
            this.initLineNumber(n);
        }
        if (string2 != null) {
            this.initLineSource(string2);
        }
        if (n2 != 0) {
            this.initColumnNumber(n2);
        }
    }

    private String generateStackTrace() {
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        super.printStackTrace(new PrintWriter(charArrayWriter));
        String string = charArrayWriter.toString();
        Evaluator evaluator = Context.createInterpreter();
        if (evaluator != null) {
            return evaluator.getPatchedStack(this, string);
        }
        return null;
    }

    public String getScriptStackTrace() {
        ScriptStackElement[] scriptStackElementArray;
        StringBuilder stringBuilder = new StringBuilder();
        String string = SecurityUtilities.getSystemProperty("line.separator");
        for (ScriptStackElement scriptStackElement : scriptStackElementArray = this.getScriptStack()) {
            if (useMozillaStackStyle) {
                scriptStackElement.renderMozillaStyle(stringBuilder);
            } else {
                scriptStackElement.renderJavaStyle(stringBuilder);
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public String getScriptStackTrace(FilenameFilter filenameFilter) {
        return this.getScriptStackTrace();
    }

    public ScriptStackElement[] getScriptStack() {
        Evaluator evaluator;
        ArrayList<ScriptStackElement> arrayList = new ArrayList<ScriptStackElement>();
        ScriptStackElement[][] scriptStackElementArray = null;
        if (this.interpreterStackInfo != null && (evaluator = Context.createInterpreter()) instanceof Interpreter) {
            scriptStackElementArray = ((Interpreter)evaluator).getScriptStackElements(this);
        }
        int n = 0;
        StackTraceElement[] stackTraceElementArray = this.getStackTrace();
        Pattern pattern = Pattern.compile("_c_(.*)_\\d+");
        for (StackTraceElement stackTraceElement : stackTraceElementArray) {
            String string = stackTraceElement.getFileName();
            if (stackTraceElement.getMethodName().startsWith("_c_") && stackTraceElement.getLineNumber() > -1 && string != null && !string.endsWith(".java")) {
                ScriptStackElement[] scriptStackElementArray2 = stackTraceElement.getMethodName();
                Matcher matcher = pattern.matcher((CharSequence)scriptStackElementArray2);
                scriptStackElementArray2 = !"_c_script_0".equals(scriptStackElementArray2) && matcher.find() ? matcher.group(1) : null;
                arrayList.add(new ScriptStackElement(string, (String)scriptStackElementArray2, stackTraceElement.getLineNumber()));
                continue;
            }
            if (!"sun.org.mozilla.javascript.internal.Interpreter".equals(stackTraceElement.getClassName()) || !"interpretLoop".equals(stackTraceElement.getMethodName()) || scriptStackElementArray == null || scriptStackElementArray.length <= n) continue;
            for (ScriptStackElement scriptStackElement : scriptStackElementArray[n++]) {
                arrayList.add(scriptStackElement);
            }
        }
        return arrayList.toArray(new ScriptStackElement[arrayList.size()]);
    }

    @Override
    public void printStackTrace(PrintWriter printWriter) {
        if (this.interpreterStackInfo == null) {
            super.printStackTrace(printWriter);
        } else {
            printWriter.print(this.generateStackTrace());
        }
    }

    @Override
    public void printStackTrace(PrintStream printStream) {
        if (this.interpreterStackInfo == null) {
            super.printStackTrace(printStream);
        } else {
            printStream.print(this.generateStackTrace());
        }
    }

    public static boolean usesMozillaStackStyle() {
        return useMozillaStackStyle;
    }

    public static void useMozillaStackStyle(boolean bl) {
        useMozillaStackStyle = bl;
    }
}

