/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.io.IOError;
import java.io.IOException;
import java.nio.file.FileSystemException;
import java.nio.file.NotLinkException;
import java.nio.file.Path;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.misc.Unsafe;
import sun.nio.fs.NativeBuffer;
import sun.nio.fs.NativeBuffers;
import sun.nio.fs.WindowsException;
import sun.nio.fs.WindowsFileAttributes;
import sun.nio.fs.WindowsFileSystem;
import sun.nio.fs.WindowsNativeDispatcher;
import sun.nio.fs.WindowsPath;

class WindowsLinkSupport {
    private static final Unsafe unsafe = Unsafe.getUnsafe();

    private WindowsLinkSupport() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String readLink(WindowsPath windowsPath) throws IOException {
        long l = 0L;
        try {
            l = windowsPath.openForReadAttributeAccess(false);
        }
        catch (WindowsException windowsException) {
            windowsException.rethrowAsIOException(windowsPath);
        }
        try {
            String string = WindowsLinkSupport.readLinkImpl(l);
            return string;
        }
        finally {
            WindowsNativeDispatcher.CloseHandle(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getFinalPath(WindowsPath windowsPath) throws IOException {
        long l = 0L;
        try {
            l = windowsPath.openForReadAttributeAccess(true);
        }
        catch (WindowsException windowsException) {
            windowsException.rethrowAsIOException(windowsPath);
        }
        try {
            String string = WindowsLinkSupport.stripPrefix(WindowsNativeDispatcher.GetFinalPathNameByHandle(l));
            return string;
        }
        catch (WindowsException windowsException) {
            if (windowsException.lastError() != 124) {
                windowsException.rethrowAsIOException(windowsPath);
            }
        }
        finally {
            WindowsNativeDispatcher.CloseHandle(l);
        }
        return null;
    }

    static String getFinalPath(WindowsPath windowsPath, boolean bl) throws IOException {
        WindowsFileSystem windowsFileSystem = windowsPath.getFileSystem();
        try {
            if (!bl || !windowsFileSystem.supportsLinks()) {
                return windowsPath.getPathForWin32Calls();
            }
            if (!WindowsFileAttributes.get(windowsPath, false).isSymbolicLink()) {
                return windowsPath.getPathForWin32Calls();
            }
        }
        catch (WindowsException windowsException) {
            windowsException.rethrowAsIOException(windowsPath);
        }
        String string = WindowsLinkSupport.getFinalPath(windowsPath);
        if (string != null) {
            return string;
        }
        WindowsPath windowsPath2 = windowsPath;
        int n = 0;
        do {
            Object object;
            try {
                object = WindowsFileAttributes.get(windowsPath2, false);
                if (!((WindowsFileAttributes)object).isSymbolicLink()) {
                    return windowsPath2.getPathForWin32Calls();
                }
            }
            catch (WindowsException windowsException) {
                windowsException.rethrowAsIOException(windowsPath2);
            }
            object = WindowsPath.createFromNormalizedPath(windowsFileSystem, WindowsLinkSupport.readLink(windowsPath2));
            WindowsPath windowsPath3 = windowsPath2.getParent();
            if (windowsPath3 == null) {
                final WindowsPath windowsPath4 = windowsPath2;
                windowsPath2 = AccessController.doPrivileged(new PrivilegedAction<WindowsPath>(){

                    @Override
                    public WindowsPath run() {
                        return windowsPath4.toAbsolutePath();
                    }
                });
                windowsPath3 = windowsPath2.getParent();
            }
            windowsPath2 = windowsPath3.resolve((Path)object);
        } while (++n < 32);
        throw new FileSystemException(windowsPath.getPathForExceptionMessage(), null, "Too many links");
    }

    static String getRealPath(WindowsPath windowsPath, boolean bl) throws IOException {
        int n;
        int n2;
        int n3;
        WindowsFileSystem windowsFileSystem = windowsPath.getFileSystem();
        if (bl && !windowsFileSystem.supportsLinks()) {
            bl = false;
        }
        String string = null;
        try {
            string = windowsPath.toAbsolutePath().toString();
        }
        catch (IOError iOError) {
            throw (IOException)iOError.getCause();
        }
        if (string.indexOf(46) >= 0) {
            try {
                string = WindowsNativeDispatcher.GetFullPathName(string);
            }
            catch (WindowsException windowsException) {
                windowsException.rethrowAsIOException(windowsPath);
            }
        }
        StringBuilder stringBuilder = new StringBuilder(string.length());
        char c = string.charAt(0);
        char c2 = string.charAt(1);
        if ((c <= 'z' && c >= 'a' || c <= 'Z' && c >= 'A') && c2 == ':' && string.charAt(2) == '\\') {
            stringBuilder.append(Character.toUpperCase(c));
            stringBuilder.append(":\\");
            n3 = 3;
        } else if (c == '\\' && c2 == '\\') {
            n2 = string.length() - 1;
            n = string.indexOf(92, 2);
            if (n == -1 || n == n2) {
                throw new FileSystemException(windowsPath.getPathForExceptionMessage(), null, "UNC has invalid share");
            }
            if ((n = string.indexOf(92, n + 1)) < 0) {
                n = n2;
                stringBuilder.append(string).append("\\");
            } else {
                stringBuilder.append(string, 0, n + 1);
            }
            n3 = n + 1;
        } else {
            throw new AssertionError((Object)"path type not recognized");
        }
        if (n3 >= string.length()) {
            String string2 = stringBuilder.toString();
            try {
                WindowsNativeDispatcher.GetFileAttributes(string2);
            }
            catch (WindowsException windowsException) {
                windowsException.rethrowAsIOException(string);
            }
            return string2;
        }
        n2 = n3;
        while (n2 < string.length()) {
            n = string.indexOf(92, n2);
            int n4 = n == -1 ? string.length() : n;
            String string3 = stringBuilder.toString() + string.substring(n2, n4);
            try {
                WindowsNativeDispatcher.FirstFile firstFile = WindowsNativeDispatcher.FindFirstFile(WindowsLinkSupport.addLongPathPrefixIfNeeded(string3));
                WindowsNativeDispatcher.FindClose(firstFile.handle());
                if (bl && WindowsFileAttributes.isReparsePoint(firstFile.attributes())) {
                    String string4 = WindowsLinkSupport.getFinalPath(windowsPath);
                    if (string4 == null) {
                        WindowsPath windowsPath2 = WindowsLinkSupport.resolveAllLinks(WindowsPath.createFromNormalizedPath(windowsFileSystem, string));
                        string4 = WindowsLinkSupport.getRealPath(windowsPath2, false);
                    }
                    return string4;
                }
                stringBuilder.append(firstFile.name());
                if (n != -1) {
                    stringBuilder.append('\\');
                }
            }
            catch (WindowsException windowsException) {
                windowsException.rethrowAsIOException(string);
            }
            n2 = n4 + 1;
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readLinkImpl(long l) throws IOException {
        int n = 16384;
        NativeBuffer nativeBuffer = NativeBuffers.getNativeBuffer(n);
        try {
            try {
                WindowsNativeDispatcher.DeviceIoControlGetReparsePoint(l, nativeBuffer.address(), n);
            }
            catch (WindowsException windowsException) {
                if (windowsException.lastError() == 4390) {
                    throw new NotLinkException(null, null, windowsException.errorString());
                }
                windowsException.rethrowAsIOException((String)null);
            }
            int n2 = (int)unsafe.getLong(nativeBuffer.address() + 0L);
            if (n2 != -1610612724) {
                throw new NotLinkException(null, null, "Reparse point is not a symbolic link");
            }
            short s = unsafe.getShort(nativeBuffer.address() + 8L);
            short s2 = unsafe.getShort(nativeBuffer.address() + 10L);
            if (s2 % 2 != 0) {
                throw new FileSystemException(null, null, "Symbolic link corrupted");
            }
            char[] cArray = new char[s2 / 2];
            unsafe.copyMemory(null, nativeBuffer.address() + 20L + (long)s, cArray, Unsafe.ARRAY_CHAR_BASE_OFFSET, s2);
            String string = WindowsLinkSupport.stripPrefix(new String(cArray));
            if (string.length() == 0) {
                throw new IOException("Symbolic link target is invalid");
            }
            String string2 = string;
            return string2;
        }
        finally {
            nativeBuffer.release();
        }
    }

    private static WindowsPath resolveAllLinks(WindowsPath windowsPath) throws IOException {
        assert (windowsPath.isAbsolute());
        WindowsFileSystem windowsFileSystem = windowsPath.getFileSystem();
        int n = 0;
        int n2 = 0;
        while (n2 < windowsPath.getNameCount()) {
            WindowsPath windowsPath2 = windowsPath.getRoot().resolve(windowsPath.subpath(0, n2 + 1));
            WindowsFileAttributes windowsFileAttributes = null;
            try {
                windowsFileAttributes = WindowsFileAttributes.get(windowsPath2, false);
            }
            catch (WindowsException windowsException) {
                windowsException.rethrowAsIOException(windowsPath2);
            }
            if (windowsFileAttributes.isSymbolicLink()) {
                if (++n > 32) {
                    throw new IOException("Too many links");
                }
                WindowsPath windowsPath3 = WindowsPath.createFromNormalizedPath(windowsFileSystem, WindowsLinkSupport.readLink(windowsPath2));
                WindowsPath windowsPath4 = null;
                int n3 = windowsPath.getNameCount();
                if (n2 + 1 < n3) {
                    windowsPath4 = windowsPath.subpath(n2 + 1, n3);
                }
                windowsPath = windowsPath2.getParent().resolve(windowsPath3);
                try {
                    String string = WindowsNativeDispatcher.GetFullPathName(windowsPath.toString());
                    if (!string.equals(windowsPath.toString())) {
                        windowsPath = WindowsPath.createFromNormalizedPath(windowsFileSystem, string);
                    }
                }
                catch (WindowsException windowsException) {
                    windowsException.rethrowAsIOException(windowsPath);
                }
                if (windowsPath4 != null) {
                    windowsPath = windowsPath.resolve(windowsPath4);
                }
                n2 = 0;
                continue;
            }
            ++n2;
        }
        return windowsPath;
    }

    private static String addLongPathPrefixIfNeeded(String string) {
        if (string.length() > 248) {
            string = string.startsWith("\\\\") ? "\\\\?\\UNC" + string.substring(1, string.length()) : "\\\\?\\" + string;
        }
        return string;
    }

    private static String stripPrefix(String string) {
        if (string.startsWith("\\\\?\\")) {
            string = string.startsWith("\\\\?\\UNC\\") ? "\\" + string.substring(7) : string.substring(4);
            return string;
        }
        if (string.startsWith("\\??\\")) {
            string = string.startsWith("\\??\\UNC\\") ? "\\" + string.substring(7) : string.substring(4);
            return string;
        }
        return string;
    }
}

