/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class ArrayBlockingQueue<E>
extends AbstractQueue<E>
implements BlockingQueue<E>,
Serializable {
    private static final long serialVersionUID = -817911632652898426L;
    final Object[] items;
    int takeIndex;
    int putIndex;
    int count;
    final ReentrantLock lock;
    private final Condition notEmpty;
    private final Condition notFull;

    final int inc(int n) {
        return ++n == this.items.length ? 0 : n;
    }

    final int dec(int n) {
        return (n == 0 ? this.items.length : n) - 1;
    }

    static <E> E cast(Object object) {
        return (E)object;
    }

    final E itemAt(int n) {
        return ArrayBlockingQueue.cast(this.items[n]);
    }

    private static void checkNotNull(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
    }

    private void insert(E e) {
        this.items[this.putIndex] = e;
        this.putIndex = this.inc(this.putIndex);
        ++this.count;
        this.notEmpty.signal();
    }

    private E extract() {
        Object[] objectArray = this.items;
        E e = ArrayBlockingQueue.cast(objectArray[this.takeIndex]);
        objectArray[this.takeIndex] = null;
        this.takeIndex = this.inc(this.takeIndex);
        --this.count;
        this.notFull.signal();
        return e;
    }

    void removeAt(int n) {
        Object[] objectArray = this.items;
        if (n == this.takeIndex) {
            objectArray[this.takeIndex] = null;
            this.takeIndex = this.inc(this.takeIndex);
        } else {
            int n2;
            while ((n2 = this.inc(n)) != this.putIndex) {
                objectArray[n] = objectArray[n2];
                n = n2;
            }
            objectArray[n] = null;
            this.putIndex = n;
        }
        --this.count;
        this.notFull.signal();
    }

    public ArrayBlockingQueue(int n) {
        this(n, false);
    }

    public ArrayBlockingQueue(int n, boolean bl) {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        this.items = new Object[n];
        this.lock = new ReentrantLock(bl);
        this.notEmpty = this.lock.newCondition();
        this.notFull = this.lock.newCondition();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayBlockingQueue(int n, boolean bl, Collection<? extends E> collection) {
        this(n, bl);
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            int n2 = 0;
            try {
                for (E e : collection) {
                    ArrayBlockingQueue.checkNotNull(e);
                    this.items[n2++] = e;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new IllegalArgumentException();
            }
            this.count = n2;
            this.putIndex = n2 == n ? 0 : n2;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    @Override
    public boolean add(E e) {
        return super.add(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(E e) {
        ArrayBlockingQueue.checkNotNull(e);
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            if (this.count == this.items.length) {
                boolean bl = false;
                return bl;
            }
            this.insert(e);
            boolean bl = true;
            return bl;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(E e) throws InterruptedException {
        ArrayBlockingQueue.checkNotNull(e);
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lockInterruptibly();
        try {
            while (this.count == this.items.length) {
                this.notFull.await();
            }
            this.insert(e);
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(E e, long l, TimeUnit timeUnit) throws InterruptedException {
        ArrayBlockingQueue.checkNotNull(e);
        long l2 = timeUnit.toNanos(l);
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lockInterruptibly();
        try {
            while (this.count == this.items.length) {
                if (l2 <= 0L) {
                    boolean bl = false;
                    return bl;
                }
                l2 = this.notFull.awaitNanos(l2);
            }
            this.insert(e);
            boolean bl = true;
            return bl;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E poll() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            E e = this.count == 0 ? null : (E)this.extract();
            return e;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E take() throws InterruptedException {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lockInterruptibly();
        try {
            while (this.count == 0) {
                this.notEmpty.await();
            }
            E e = this.extract();
            return e;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E poll(long l, TimeUnit timeUnit) throws InterruptedException {
        long l2 = timeUnit.toNanos(l);
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lockInterruptibly();
        try {
            while (this.count == 0) {
                if (l2 <= 0L) {
                    E e = null;
                    return e;
                }
                l2 = this.notEmpty.awaitNanos(l2);
            }
            E e = this.extract();
            return e;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E peek() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            E e = this.count == 0 ? null : (E)this.itemAt(this.takeIndex);
            return e;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            int n = this.count;
            return n;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int remainingCapacity() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            int n = this.items.length - this.count;
            return n;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object object) {
        if (object == null) {
            return false;
        }
        Object[] objectArray = this.items;
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            int n = this.takeIndex;
            for (int i = this.count; i > 0; --i) {
                if (object.equals(objectArray[n])) {
                    this.removeAt(n);
                    boolean bl = true;
                    return bl;
                }
                n = this.inc(n);
            }
            n = 0;
            return n != 0;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object object) {
        if (object == null) {
            return false;
        }
        Object[] objectArray = this.items;
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            int n = this.takeIndex;
            for (int i = this.count; i > 0; --i) {
                if (object.equals(objectArray[n])) {
                    boolean bl = true;
                    return bl;
                }
                n = this.inc(n);
            }
            n = 0;
            return n != 0;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] toArray() {
        Object[] objectArray = this.items;
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            int n = this.count;
            Object[] objectArray2 = new Object[n];
            int n2 = this.takeIndex;
            for (int i = 0; i < n; ++i) {
                objectArray2[i] = objectArray[n2];
                n2 = this.inc(n2);
            }
            Object[] objectArray3 = objectArray2;
            return objectArray3;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T[] toArray(T[] objectArray) {
        Object[] objectArray2 = this.items;
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            int n = this.count;
            int n2 = objectArray.length;
            if (n2 < n) {
                objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), n);
            }
            int n3 = this.takeIndex;
            for (int i = 0; i < n; ++i) {
                objectArray[i] = objectArray2[n3];
                n3 = this.inc(n3);
            }
            if (n2 > n) {
                objectArray[n] = null;
            }
            Object[] objectArray3 = objectArray;
            return objectArray3;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    @Override
    public String toString() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            int n = this.count;
            if (n == 0) {
                String string = "[]";
                return string;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append('[');
            int n2 = this.takeIndex;
            while (true) {
                Object object;
                stringBuilder.append((object = this.items[n2]) == this ? "(this Collection)" : object);
                if (--n == 0) {
                    String string = stringBuilder.append(']').toString();
                    return string;
                }
                stringBuilder.append(',').append(' ');
                n2 = this.inc(n2);
            }
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object[] objectArray = this.items;
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            int n = this.takeIndex;
            for (int i = this.count; i > 0; --i) {
                objectArray[n] = null;
                n = this.inc(n);
            }
            this.count = 0;
            this.putIndex = 0;
            this.takeIndex = 0;
            this.notFull.signalAll();
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int drainTo(Collection<? super E> collection) {
        ArrayBlockingQueue.checkNotNull(collection);
        if (collection == this) {
            throw new IllegalArgumentException();
        }
        Object[] objectArray = this.items;
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            int n;
            int n2 = this.takeIndex;
            int n3 = this.count;
            for (n = 0; n < n3; ++n) {
                collection.add(ArrayBlockingQueue.cast(objectArray[n2]));
                objectArray[n2] = null;
                n2 = this.inc(n2);
            }
            if (n > 0) {
                this.count = 0;
                this.putIndex = 0;
                this.takeIndex = 0;
                this.notFull.signalAll();
            }
            int n4 = n;
            return n4;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int drainTo(Collection<? super E> collection, int n) {
        ArrayBlockingQueue.checkNotNull(collection);
        if (collection == this) {
            throw new IllegalArgumentException();
        }
        if (n <= 0) {
            return 0;
        }
        Object[] objectArray = this.items;
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            int n2;
            int n3;
            int n4 = this.takeIndex;
            int n5 = n3 = n < this.count ? n : this.count;
            for (n2 = 0; n2 < n3; ++n2) {
                collection.add(ArrayBlockingQueue.cast(objectArray[n4]));
                objectArray[n4] = null;
                n4 = this.inc(n4);
            }
            if (n2 > 0) {
                this.count -= n2;
                this.takeIndex = n4;
                this.notFull.signalAll();
            }
            int n6 = n2;
            return n6;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    @Override
    public Iterator<E> iterator() {
        return new Itr();
    }

    private class Itr
    implements Iterator<E> {
        private int remaining;
        private int nextIndex;
        private E nextItem;
        private E lastItem;
        private int lastRet;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Itr() {
            ReentrantLock reentrantLock = ArrayBlockingQueue.this.lock;
            reentrantLock.lock();
            try {
                this.lastRet = -1;
                this.remaining = ArrayBlockingQueue.this.count;
                if (this.remaining > 0) {
                    this.nextIndex = ArrayBlockingQueue.this.takeIndex;
                    this.nextItem = ArrayBlockingQueue.this.itemAt(this.nextIndex);
                }
            }
            finally {
                reentrantLock.unlock();
            }
        }

        @Override
        public boolean hasNext() {
            return this.remaining > 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E next() {
            ReentrantLock reentrantLock = ArrayBlockingQueue.this.lock;
            reentrantLock.lock();
            try {
                if (this.remaining <= 0) {
                    throw new NoSuchElementException();
                }
                this.lastRet = this.nextIndex;
                Object e = ArrayBlockingQueue.this.itemAt(this.nextIndex);
                if (e == null) {
                    e = this.nextItem;
                    this.lastItem = null;
                } else {
                    this.lastItem = e;
                }
                while (--this.remaining > 0 && (this.nextItem = ArrayBlockingQueue.this.itemAt(this.nextIndex = ArrayBlockingQueue.this.inc(this.nextIndex))) == null) {
                }
                Object e2 = e;
                return e2;
            }
            finally {
                reentrantLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            ReentrantLock reentrantLock = ArrayBlockingQueue.this.lock;
            reentrantLock.lock();
            try {
                int n = this.lastRet;
                if (n == -1) {
                    throw new IllegalStateException();
                }
                this.lastRet = -1;
                Object e = this.lastItem;
                this.lastItem = null;
                if (e != null && e == ArrayBlockingQueue.this.items[n]) {
                    boolean bl = n == ArrayBlockingQueue.this.takeIndex;
                    ArrayBlockingQueue.this.removeAt(n);
                    if (!bl) {
                        this.nextIndex = ArrayBlockingQueue.this.dec(this.nextIndex);
                    }
                }
            }
            finally {
                reentrantLock.unlock();
            }
        }
    }
}

