/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.AdapterMethodHandle;
import java.lang.invoke.BoundMethodHandle;
import java.lang.invoke.CallSite;
import java.lang.invoke.DirectMethodHandle;
import java.lang.invoke.MemberName;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.sql.DriverManager;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import sun.misc.Unsafe;
import sun.reflect.Reflection;

class MethodHandleNatives {
    static final int JVM_PUSH_LIMIT;
    static final int JVM_STACK_MOVE_UNIT;
    static final int CONV_OP_IMPLEMENTED_MASK;
    static final boolean HAVE_RICOCHET_FRAMES;
    static final int OP_ROT_ARGS_DOWN_LIMIT_BIAS;
    static final boolean COUNT_GWT;

    private MethodHandleNatives() {
    }

    static native void init(MemberName var0, Object var1);

    static native void expand(MemberName var0);

    static native void resolve(MemberName var0, Class<?> var1);

    static native int getMembers(Class<?> var0, String var1, String var2, int var3, Class<?> var4, int var5, MemberName[] var6);

    static native void init(AdapterMethodHandle var0, MethodHandle var1, int var2);

    static native void init(BoundMethodHandle var0, Object var1, int var2);

    static native void init(DirectMethodHandle var0, Object var1, boolean var2, Class<?> var3);

    static native void init(MethodType var0);

    static native Object getTarget(MethodHandle var0, int var1);

    static MemberName getMethodName(MethodHandle methodHandle) {
        return (MemberName)MethodHandleNatives.getTarget(methodHandle, 2);
    }

    static AccessibleObject getTargetMethod(MethodHandle methodHandle) {
        return (AccessibleObject)MethodHandleNatives.getTarget(methodHandle, 3);
    }

    static Object getTargetInfo(MethodHandle methodHandle) {
        return MethodHandleNatives.getTarget(methodHandle, 0);
    }

    static Object[] makeTarget(Class<?> clazz, String string, String string2, int n, Class<?> clazz2) {
        return new Object[]{clazz, string, string2, n, clazz2};
    }

    static native int getConstant(int var0);

    static native void setCallSiteTargetNormal(CallSite var0, MethodHandle var1);

    static native void setCallSiteTargetVolatile(CallSite var0, MethodHandle var1);

    private static native void registerNatives();

    private static native int getNamedCon(int var0, Object[] var1);

    static boolean verifyConstants() {
        Object[] objectArray = new Object[]{null};
        int n = 0;
        while (true) {
            block6: {
                objectArray[0] = null;
                int n2 = MethodHandleNatives.getNamedCon(n, objectArray);
                if (objectArray[0] == null) break;
                String string = (String)objectArray[0];
                try {
                    Field field = Constants.class.getDeclaredField(string);
                    int n3 = field.getInt(null);
                    if (n3 == n2) break block6;
                    String string2 = string + ": JVM has " + n2 + " while Java has " + n3;
                    if (string.equals("CONV_OP_LIMIT")) {
                        System.err.println("warning: " + string2);
                        break block6;
                    }
                    throw new InternalError(string2);
                }
                catch (Exception exception) {
                    if (exception instanceof NoSuchFieldException) {
                        String string3 = string + ": JVM has " + n2 + " which Java does not define";
                        if (string.startsWith("OP_") || string.startsWith("GC_")) {
                            System.err.println("warning: " + string3);
                        }
                    }
                    throw new InternalError(string + ": access failed, got " + exception);
                }
            }
            ++n;
        }
        return true;
    }

    static CallSite makeDynamicCallSite(MethodHandle methodHandle, String string, MethodType methodType, Object object, MemberName memberName, int n) {
        return CallSite.makeSite(methodHandle, string, methodType, object, memberName, n);
    }

    static void checkSpreadArgument(Object object, int n) {
        MethodHandleStatics.checkSpreadArgument(object, n);
    }

    static MethodType findMethodHandleType(Class<?> clazz, Class<?>[] classArray) {
        return MethodType.makeImpl(clazz, classArray, true);
    }

    static void notifyGenericMethodType(MethodType methodType) {
        methodType.form().notifyGenericMethodType();
    }

    static void raiseException(int n, Object clazz, Object clazz2) {
        String string = null;
        switch (n) {
            case 190: {
                try {
                    int n2;
                    String string2 = "";
                    if (clazz2 instanceof AdapterMethodHandle) {
                        n2 = ((AdapterMethodHandle)((Object)clazz2)).getConversion();
                        int n3 = AdapterMethodHandle.extractStackMove(n2);
                        string2 = " of length " + (n3 + 1);
                    }
                    n2 = clazz == null ? 0 : Array.getLength(clazz);
                    string = "required array" + string2 + ", but encountered wrong length " + n2;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    clazz2 = Object[].class;
                    n = 192;
                }
                break;
            }
            case 191: {
                if (clazz2 != BootstrapMethodError.class) break;
                throw new BootstrapMethodError((Throwable)((Object)clazz));
            }
        }
        if (string == null) {
            if (!(clazz instanceof Class) && !(clazz instanceof MethodType)) {
                clazz = clazz.getClass();
            }
            string = clazz != null ? "required " + clazz2 + " but encountered " + clazz : "required " + clazz2;
        }
        switch (n) {
            case 190: {
                throw new ArrayIndexOutOfBoundsException(string);
            }
            case 50: {
                throw new ClassCastException(string);
            }
            case 192: {
                throw new ClassCastException(string);
            }
        }
        throw new InternalError("unexpected code " + n + ": " + string);
    }

    static MethodHandle linkMethodHandleConstant(Class<?> clazz, int n, Class<?> clazz2, String string, Object object) {
        try {
            MethodHandles.Lookup lookup = MethodHandles.Lookup.IMPL_LOOKUP.in(clazz);
            return lookup.linkMethodHandleConstant(n, clazz2, string, object);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            IncompatibleClassChangeError incompatibleClassChangeError = new IncompatibleClassChangeError();
            incompatibleClassChangeError.initCause(reflectiveOperationException);
            throw incompatibleClassChangeError;
        }
    }

    static boolean workaroundWithoutRicochetFrames() {
        assert (!HAVE_RICOCHET_FRAMES) : "this code should not be executed if `-XX:+UseRicochetFrames is enabled";
        return true;
    }

    static boolean isCallerSensitive(MemberName memberName) {
        assert (memberName.isInvocable());
        Class<?> clazz = memberName.getDeclaringClass();
        switch (memberName.getName()) {
            case "doPrivileged": {
                return clazz == AccessController.class;
            }
            case "getUnsafe": {
                return clazz == Unsafe.class;
            }
            case "lookup": {
                return clazz == MethodHandles.class;
            }
            case "invoke": {
                return clazz == Method.class;
            }
            case "get": 
            case "getBoolean": 
            case "getByte": 
            case "getChar": 
            case "getShort": 
            case "getInt": 
            case "getLong": 
            case "getFloat": 
            case "getDouble": 
            case "set": 
            case "setBoolean": 
            case "setByte": 
            case "setChar": 
            case "setShort": 
            case "setInt": 
            case "setLong": 
            case "setFloat": 
            case "setDouble": {
                return clazz == Field.class;
            }
            case "newInstance": {
                if (clazz == Constructor.class) {
                    return true;
                }
                if (clazz != Class.class) break;
                return true;
            }
            case "forName": 
            case "getClassLoader": 
            case "getClasses": 
            case "getFields": 
            case "getMethods": 
            case "getConstructors": 
            case "getDeclaredClasses": 
            case "getDeclaredFields": 
            case "getDeclaredMethods": 
            case "getDeclaredConstructors": 
            case "getField": 
            case "getMethod": 
            case "getConstructor": 
            case "getDeclaredField": 
            case "getDeclaredMethod": 
            case "getDeclaredConstructor": {
                return clazz == Class.class;
            }
            case "getConnection": 
            case "getDriver": 
            case "getDrivers": 
            case "deregisterDriver": {
                return clazz == DriverManager.class;
            }
            case "newUpdater": {
                if (clazz == AtomicIntegerFieldUpdater.class) {
                    return true;
                }
                if (clazz == AtomicLongFieldUpdater.class) {
                    return true;
                }
                if (clazz != AtomicReferenceFieldUpdater.class) break;
                return true;
            }
            case "getContextClassLoader": {
                return clazz == Thread.class;
            }
            case "getPackage": 
            case "getPackages": {
                return clazz == Package.class;
            }
            case "getParent": 
            case "getSystemClassLoader": {
                return clazz == ClassLoader.class;
            }
            case "load": 
            case "loadLibrary": {
                if (clazz == Runtime.class) {
                    return true;
                }
                if (clazz != System.class) break;
                return true;
            }
            case "getCallerClass": {
                if (clazz == Reflection.class) {
                    return true;
                }
                if (clazz != System.class) break;
                return true;
            }
            case "getCallerClassLoader": {
                return clazz == ClassLoader.class;
            }
            case "getProxyClass": 
            case "newProxyInstance": {
                return clazz == Proxy.class;
            }
            case "getBundle": 
            case "clearCache": {
                return clazz == ResourceBundle.class;
            }
        }
        return false;
    }

    static {
        MethodHandleNatives.registerNatives();
        JVM_PUSH_LIMIT = MethodHandleNatives.getConstant(0);
        JVM_STACK_MOVE_UNIT = MethodHandleNatives.getConstant(1);
        int n = MethodHandleNatives.getConstant(2);
        CONV_OP_IMPLEMENTED_MASK = n != 0 ? n : 991;
        n = MethodHandleNatives.getConstant(3);
        OP_ROT_ARGS_DOWN_LIMIT_BIAS = n != 0 ? (int)n : -1;
        HAVE_RICOCHET_FRAMES = (CONV_OP_IMPLEMENTED_MASK & 0x400) != 0;
        boolean bl = COUNT_GWT = MethodHandleNatives.getConstant(4) != 0;
        assert (MethodHandleNatives.verifyConstants());
    }

    static class Constants {
        static final int GC_JVM_PUSH_LIMIT = 0;
        static final int GC_JVM_STACK_MOVE_UNIT = 1;
        static final int GC_CONV_OP_IMPLEMENTED_MASK = 2;
        static final int GC_OP_ROT_ARGS_DOWN_LIMIT_BIAS = 3;
        static final int GC_COUNT_GWT = 4;
        static final int ETF_HANDLE_OR_METHOD_NAME = 0;
        static final int ETF_DIRECT_HANDLE = 1;
        static final int ETF_METHOD_NAME = 2;
        static final int ETF_REFLECT_METHOD = 3;
        static final int MN_IS_METHOD = 65536;
        static final int MN_IS_CONSTRUCTOR = 131072;
        static final int MN_IS_FIELD = 262144;
        static final int MN_IS_TYPE = 524288;
        static final int MN_SEARCH_SUPERCLASSES = 0x100000;
        static final int MN_SEARCH_INTERFACES = 0x200000;
        static final int VM_INDEX_UNINITIALIZED = -99;
        static final int ARG_SLOT_PUSH_SHIFT = 16;
        static final int ARG_SLOT_MASK = 65535;
        static final int OP_RETYPE_ONLY = 0;
        static final int OP_RETYPE_RAW = 1;
        static final int OP_CHECK_CAST = 2;
        static final int OP_PRIM_TO_PRIM = 3;
        static final int OP_REF_TO_PRIM = 4;
        static final int OP_PRIM_TO_REF = 5;
        static final int OP_SWAP_ARGS = 6;
        static final int OP_ROT_ARGS = 7;
        static final int OP_DUP_ARGS = 8;
        static final int OP_DROP_ARGS = 9;
        static final int OP_COLLECT_ARGS = 10;
        static final int OP_SPREAD_ARGS = 11;
        static final int OP_FOLD_ARGS = 12;
        static final int CONV_OP_LIMIT = 14;
        static final int CONV_OP_MASK = 3840;
        static final int CONV_TYPE_MASK = 15;
        static final int CONV_VMINFO_MASK = 255;
        static final int CONV_VMINFO_SHIFT = 0;
        static final int CONV_OP_SHIFT = 8;
        static final int CONV_DEST_TYPE_SHIFT = 12;
        static final int CONV_SRC_TYPE_SHIFT = 16;
        static final int CONV_STACK_MOVE_SHIFT = 20;
        static final int CONV_STACK_MOVE_MASK = 4095;
        static final int DEFAULT_CONV_OP_IMPLEMENTED_MASK = 991;
        static final int T_BOOLEAN = 4;
        static final int T_CHAR = 5;
        static final int T_FLOAT = 6;
        static final int T_DOUBLE = 7;
        static final int T_BYTE = 8;
        static final int T_SHORT = 9;
        static final int T_INT = 10;
        static final int T_LONG = 11;
        static final int T_OBJECT = 12;
        static final int T_VOID = 14;
        static final int T_ILLEGAL = 99;
        static final int REF_getField = 1;
        static final int REF_getStatic = 2;
        static final int REF_putField = 3;
        static final int REF_putStatic = 4;
        static final int REF_invokeVirtual = 5;
        static final int REF_invokeStatic = 6;
        static final int REF_invokeSpecial = 7;
        static final int REF_newInvokeSpecial = 8;
        static final int REF_invokeInterface = 9;

        Constants() {
        }
    }
}

