/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.util;

import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class ReadAllStream
extends InputStream {
    @NotNull
    private final MemoryStream memStream = new MemoryStream();
    @NotNull
    private final FileStream fileStream = new FileStream();
    private boolean readAll;
    private boolean closed;

    public void readAll(InputStream inputStream, long l) throws IOException {
        assert (!this.readAll);
        this.readAll = true;
        boolean bl = this.memStream.readAll(inputStream, l);
        if (!bl) {
            this.fileStream.readAll(inputStream);
        }
    }

    @Override
    public int read() throws IOException {
        int n = this.memStream.read();
        if (n == -1) {
            n = this.fileStream.read();
        }
        return n;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.memStream.read(byArray, n, n2);
        if (n3 == -1) {
            n3 = this.fileStream.read(byArray, n, n2);
        }
        return n3;
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.memStream.close();
            this.fileStream.close();
            this.closed = true;
        }
    }

    private static class FileStream
    extends InputStream {
        @Nullable
        private File tempFile;
        @Nullable
        private FileInputStream fin;

        private FileStream() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void readAll(InputStream inputStream) throws IOException {
            this.tempFile = File.createTempFile("jaxws", ".bin");
            try (FileOutputStream fileOutputStream = new FileOutputStream(this.tempFile);){
                int n;
                byte[] byArray = new byte[8192];
                while ((n = inputStream.read(byArray)) != -1) {
                    fileOutputStream.write(byArray, 0, n);
                }
            }
            this.fin = new FileInputStream(this.tempFile);
        }

        @Override
        public int read() throws IOException {
            return this.fin != null ? this.fin.read() : -1;
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            return this.fin != null ? this.fin.read(byArray, n, n2) : -1;
        }

        @Override
        public void close() throws IOException {
            if (this.fin != null) {
                this.fin.close();
            }
            if (this.tempFile != null) {
                this.tempFile.delete();
            }
        }
    }

    private static class MemoryStream
    extends InputStream {
        private Chunk head;
        private Chunk tail;
        private int curOff;

        private MemoryStream() {
        }

        private void add(byte[] byArray, int n) {
            if (this.tail != null) {
                this.tail = this.tail.createNext(byArray, 0, n);
            } else {
                this.head = this.tail = new Chunk(byArray, 0, n);
            }
        }

        boolean readAll(InputStream inputStream, long l) throws IOException {
            long l2 = 0L;
            do {
                byte[] byArray = new byte[8192];
                int n = this.fill(inputStream, byArray);
                l2 += (long)n;
                if (n != 0) {
                    this.add(byArray, n);
                }
                if (n == byArray.length) continue;
                return true;
            } while (l2 <= l);
            return false;
        }

        private int fill(InputStream inputStream, byte[] byArray) throws IOException {
            int n;
            int n2;
            for (n = 0; n < byArray.length && (n2 = inputStream.read(byArray, n, byArray.length - n)) != -1; n += n2) {
            }
            return n;
        }

        @Override
        public int read() throws IOException {
            if (!this.fetch()) {
                return -1;
            }
            return this.head.buf[this.curOff++] & 0xFF;
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (!this.fetch()) {
                return -1;
            }
            n2 = Math.min(n2, this.head.len - (this.curOff - this.head.off));
            System.arraycopy(this.head.buf, this.curOff, byArray, n, n2);
            this.curOff += n2;
            return n2;
        }

        private boolean fetch() {
            if (this.head == null) {
                return false;
            }
            if (this.curOff == this.head.off + this.head.len) {
                this.head = this.head.next;
                if (this.head == null) {
                    return false;
                }
                this.curOff = this.head.off;
            }
            return true;
        }

        private static final class Chunk {
            Chunk next;
            final byte[] buf;
            final int off;
            final int len;

            public Chunk(byte[] byArray, int n, int n2) {
                this.buf = byArray;
                this.off = n;
                this.len = n2;
            }

            public Chunk createNext(byte[] byArray, int n, int n2) {
                this.next = new Chunk(byArray, n, n2);
                return this.next;
            }
        }
    }
}

