/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.server;

import com.sun.istack.internal.NotNull;
import com.sun.xml.internal.stream.buffer.MutableXMLStreamBuffer;
import com.sun.xml.internal.stream.buffer.XMLStreamBufferResult;
import com.sun.xml.internal.ws.api.server.SDDocument;
import com.sun.xml.internal.ws.api.server.SDDocumentSource;
import com.sun.xml.internal.ws.server.SDDocumentImpl;
import com.sun.xml.internal.ws.server.ServerRtException;
import com.sun.xml.internal.ws.wsdl.writer.WSDLResolver;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import javax.xml.ws.Holder;
import javax.xml.ws.WebServiceException;

final class WSDLGenResolver
implements WSDLResolver {
    private final List<SDDocumentImpl> docs;
    private final List<SDDocumentSource> newDocs = new ArrayList<SDDocumentSource>();
    private SDDocumentSource concreteWsdlSource;
    private SDDocumentImpl abstractWsdl;
    private SDDocumentImpl concreteWsdl;
    private final Map<String, List<SDDocumentImpl>> nsMapping = new HashMap<String, List<SDDocumentImpl>>();
    private final QName serviceName;
    private final QName portTypeName;

    public WSDLGenResolver(@NotNull List<SDDocumentImpl> list, QName qName, QName qName2) {
        this.docs = list;
        this.serviceName = qName;
        this.portTypeName = qName2;
        for (SDDocumentImpl sDDocumentImpl : list) {
            SDDocument sDDocument;
            if (sDDocumentImpl.isWSDL() && (sDDocument = (SDDocument.WSDL)((Object)sDDocumentImpl)).hasPortType()) {
                this.abstractWsdl = sDDocumentImpl;
            }
            if (!sDDocumentImpl.isSchema()) continue;
            sDDocument = (SDDocument.Schema)((Object)sDDocumentImpl);
            List<SDDocumentImpl> list2 = this.nsMapping.get(sDDocument.getTargetNamespace());
            if (list2 == null) {
                list2 = new ArrayList<SDDocumentImpl>();
                this.nsMapping.put(sDDocument.getTargetNamespace(), list2);
            }
            list2.add(sDDocumentImpl);
        }
    }

    @Override
    public Result getWSDL(String string) {
        URL uRL = this.createURL(string);
        MutableXMLStreamBuffer mutableXMLStreamBuffer = new MutableXMLStreamBuffer();
        mutableXMLStreamBuffer.setSystemId(uRL.toExternalForm());
        this.concreteWsdlSource = SDDocumentSource.create(uRL, mutableXMLStreamBuffer);
        this.newDocs.add(this.concreteWsdlSource);
        XMLStreamBufferResult xMLStreamBufferResult = new XMLStreamBufferResult(mutableXMLStreamBuffer);
        xMLStreamBufferResult.setSystemId(string);
        return xMLStreamBufferResult;
    }

    private URL createURL(String string) {
        try {
            return new URL("file:///" + string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new WebServiceException(malformedURLException);
        }
    }

    @Override
    public Result getAbstractWSDL(Holder<String> holder) {
        if (this.abstractWsdl != null) {
            holder.value = this.abstractWsdl.getURL().toString();
            return null;
        }
        URL uRL = this.createURL((String)holder.value);
        MutableXMLStreamBuffer mutableXMLStreamBuffer = new MutableXMLStreamBuffer();
        mutableXMLStreamBuffer.setSystemId(uRL.toExternalForm());
        SDDocumentSource sDDocumentSource = SDDocumentSource.create(uRL, mutableXMLStreamBuffer);
        this.newDocs.add(sDDocumentSource);
        XMLStreamBufferResult xMLStreamBufferResult = new XMLStreamBufferResult(mutableXMLStreamBuffer);
        xMLStreamBufferResult.setSystemId((String)holder.value);
        return xMLStreamBufferResult;
    }

    @Override
    public Result getSchemaOutput(String string, Holder<String> holder) {
        List<SDDocumentImpl> list = this.nsMapping.get(string);
        if (list != null) {
            if (list.size() > 1) {
                throw new ServerRtException("server.rt.err", "More than one schema for the target namespace " + string);
            }
            holder.value = list.get(0).getURL().toExternalForm();
            return null;
        }
        URL uRL = this.createURL((String)holder.value);
        MutableXMLStreamBuffer mutableXMLStreamBuffer = new MutableXMLStreamBuffer();
        mutableXMLStreamBuffer.setSystemId(uRL.toExternalForm());
        SDDocumentSource sDDocumentSource = SDDocumentSource.create(uRL, mutableXMLStreamBuffer);
        this.newDocs.add(sDDocumentSource);
        XMLStreamBufferResult xMLStreamBufferResult = new XMLStreamBufferResult(mutableXMLStreamBuffer);
        xMLStreamBufferResult.setSystemId((String)holder.value);
        return xMLStreamBufferResult;
    }

    public SDDocumentImpl updateDocs() {
        for (SDDocumentSource sDDocumentSource : this.newDocs) {
            SDDocumentImpl sDDocumentImpl = SDDocumentImpl.create(sDDocumentSource, this.serviceName, this.portTypeName);
            if (sDDocumentSource == this.concreteWsdlSource) {
                this.concreteWsdl = sDDocumentImpl;
            }
            this.docs.add(sDDocumentImpl);
        }
        return this.concreteWsdl;
    }
}

