/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.encoding;

import com.sun.xml.internal.ws.api.SOAPVersion;
import com.sun.xml.internal.ws.api.WSBinding;
import com.sun.xml.internal.ws.api.message.Attachment;
import com.sun.xml.internal.ws.api.message.Message;
import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.api.pipe.Codec;
import com.sun.xml.internal.ws.api.pipe.ContentType;
import com.sun.xml.internal.ws.developer.StreamingAttachmentFeature;
import com.sun.xml.internal.ws.encoding.ContentTypeImpl;
import com.sun.xml.internal.ws.encoding.ImageDataContentHandler;
import com.sun.xml.internal.ws.encoding.MimeMultipartParser;
import com.sun.xml.internal.ws.encoding.StringDataContentHandler;
import com.sun.xml.internal.ws.encoding.XmlDataContentHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.ReadableByteChannel;
import java.util.UUID;
import javax.activation.CommandMap;
import javax.activation.MailcapCommandMap;

abstract class MimeCodec
implements Codec {
    public static final String MULTIPART_RELATED_MIME_TYPE = "multipart/related";
    private String boundary;
    private String messageContentType;
    private boolean hasAttachments;
    protected Codec rootCodec;
    protected final SOAPVersion version;
    protected final WSBinding binding;

    protected MimeCodec(SOAPVersion sOAPVersion, WSBinding wSBinding) {
        this.version = sOAPVersion;
        this.binding = wSBinding;
    }

    @Override
    public String getMimeType() {
        return MULTIPART_RELATED_MIME_TYPE;
    }

    @Override
    public ContentType encode(Packet packet, OutputStream outputStream) throws IOException {
        ContentType contentType;
        Message message = packet.getMessage();
        if (message == null) {
            return null;
        }
        if (this.hasAttachments) {
            MimeCodec.writeln("--" + this.boundary, outputStream);
            contentType = this.rootCodec.getStaticContentType(packet);
            String string = contentType != null ? contentType.getContentType() : this.rootCodec.getMimeType();
            MimeCodec.writeln("Content-Type: " + (String)string, outputStream);
            MimeCodec.writeln(outputStream);
        }
        contentType = this.rootCodec.encode(packet, outputStream);
        if (this.hasAttachments) {
            MimeCodec.writeln(outputStream);
            for (Attachment attachment : message.getAttachments()) {
                MimeCodec.writeln("--" + this.boundary, outputStream);
                String string = attachment.getContentId();
                if (string != null && string.length() > 0 && string.charAt(0) != '<') {
                    string = '<' + string + '>';
                }
                MimeCodec.writeln("Content-Id:" + string, outputStream);
                MimeCodec.writeln("Content-Type: " + attachment.getContentType(), outputStream);
                MimeCodec.writeln("Content-Transfer-Encoding: binary", outputStream);
                MimeCodec.writeln(outputStream);
                attachment.writeTo(outputStream);
                MimeCodec.writeln(outputStream);
            }
            MimeCodec.writeAsAscii("--" + this.boundary, outputStream);
            MimeCodec.writeAsAscii("--", outputStream);
        }
        return this.hasAttachments ? new ContentTypeImpl(this.messageContentType, packet.soapAction, null) : contentType;
    }

    @Override
    public ContentType getStaticContentType(Packet packet) {
        Message message = packet.getMessage();
        boolean bl = this.hasAttachments = !message.getAttachments().isEmpty();
        if (this.hasAttachments) {
            this.boundary = "uuid:" + UUID.randomUUID().toString();
            String string = "boundary=\"" + this.boundary + "\"";
            this.messageContentType = "multipart/related; type=\"" + this.rootCodec.getMimeType() + "\"; " + string;
            return new ContentTypeImpl(this.messageContentType, packet.soapAction, null);
        }
        return this.rootCodec.getStaticContentType(packet);
    }

    protected MimeCodec(MimeCodec mimeCodec) {
        this.version = mimeCodec.version;
        this.binding = mimeCodec.binding;
    }

    @Override
    public void decode(InputStream inputStream, String string, Packet packet) throws IOException {
        MimeMultipartParser mimeMultipartParser = new MimeMultipartParser(inputStream, string, this.binding.getFeature(StreamingAttachmentFeature.class));
        this.decode(mimeMultipartParser, packet);
    }

    @Override
    public void decode(ReadableByteChannel readableByteChannel, String string, Packet packet) {
        throw new UnsupportedOperationException();
    }

    protected abstract void decode(MimeMultipartParser var1, Packet var2) throws IOException;

    @Override
    public abstract MimeCodec copy();

    public static void writeln(String string, OutputStream outputStream) throws IOException {
        MimeCodec.writeAsAscii(string, outputStream);
        MimeCodec.writeln(outputStream);
    }

    public static void writeAsAscii(String string, OutputStream outputStream) throws IOException {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            outputStream.write((byte)string.charAt(i));
        }
    }

    public static void writeln(OutputStream outputStream) throws IOException {
        outputStream.write(13);
        outputStream.write(10);
    }

    static {
        try {
            CommandMap commandMap = CommandMap.getDefaultCommandMap();
            if (commandMap instanceof MailcapCommandMap) {
                MailcapCommandMap mailcapCommandMap = (MailcapCommandMap)commandMap;
                String string = ";;x-java-content-handler=";
                mailcapCommandMap.addMailcap("text/xml" + string + XmlDataContentHandler.class.getName());
                mailcapCommandMap.addMailcap("application/xml" + string + XmlDataContentHandler.class.getName());
                if (commandMap.createDataContentHandler("image/*") == null) {
                    mailcapCommandMap.addMailcap("image/*" + string + ImageDataContentHandler.class.getName());
                }
                if (commandMap.createDataContentHandler("text/plain") == null) {
                    mailcapCommandMap.addMailcap("text/plain" + string + StringDataContentHandler.class.getName());
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

