/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AiffFileFormat;
import com.sun.media.sound.SunFileReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.UnsupportedAudioFileException;

public class AiffFileReader
extends SunFileReader {
    private static final int MAX_READ_LENGTH = 8;
    public static final AudioFileFormat.Type[] types = new AudioFileFormat.Type[]{AudioFileFormat.Type.AIFF};

    @Override
    public AudioFileFormat getAudioFileFormat(InputStream inputStream) throws UnsupportedAudioFileException, IOException {
        AudioFileFormat audioFileFormat = this.getCOMM(inputStream, true);
        inputStream.reset();
        return audioFileFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AudioFileFormat getAudioFileFormat(URL uRL) throws UnsupportedAudioFileException, IOException {
        AudioFileFormat audioFileFormat = null;
        try (InputStream inputStream = uRL.openStream();){
            audioFileFormat = this.getCOMM(inputStream, false);
        }
        return audioFileFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AudioFileFormat getAudioFileFormat(File file) throws UnsupportedAudioFileException, IOException {
        AudioFileFormat audioFileFormat = null;
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            audioFileFormat = this.getCOMM(fileInputStream, false);
        }
        return audioFileFormat;
    }

    @Override
    public AudioInputStream getAudioInputStream(InputStream inputStream) throws UnsupportedAudioFileException, IOException {
        AudioFileFormat audioFileFormat = this.getCOMM(inputStream, true);
        return new AudioInputStream(inputStream, audioFileFormat.getFormat(), audioFileFormat.getFrameLength());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AudioInputStream getAudioInputStream(URL uRL) throws UnsupportedAudioFileException, IOException {
        InputStream inputStream = uRL.openStream();
        AudioFileFormat audioFileFormat = null;
        try {
            audioFileFormat = this.getCOMM(inputStream, false);
        }
        finally {
            if (audioFileFormat == null) {
                inputStream.close();
            }
        }
        return new AudioInputStream(inputStream, audioFileFormat.getFormat(), audioFileFormat.getFrameLength());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AudioInputStream getAudioInputStream(File file) throws UnsupportedAudioFileException, IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        AudioFileFormat audioFileFormat = null;
        try {
            audioFileFormat = this.getCOMM(fileInputStream, false);
        }
        finally {
            if (audioFileFormat == null) {
                fileInputStream.close();
            }
        }
        return new AudioInputStream(fileInputStream, audioFileFormat.getFormat(), audioFileFormat.getFrameLength());
    }

    private AudioFileFormat getCOMM(InputStream inputStream, boolean bl) throws UnsupportedAudioFileException, IOException {
        int n;
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        if (bl) {
            dataInputStream.mark(8);
        }
        int n2 = 0;
        int n3 = 0;
        AudioFormat audioFormat = null;
        int n4 = dataInputStream.readInt();
        if (n4 != 1179603533) {
            if (bl) {
                dataInputStream.reset();
            }
            throw new UnsupportedAudioFileException("not an AIFF file");
        }
        int n5 = dataInputStream.readInt();
        int n6 = dataInputStream.readInt();
        n2 += 12;
        if (n5 <= 0) {
            n5 = -1;
            n = -1;
        } else {
            n = n5 + 8;
        }
        boolean bl2 = false;
        if (n6 == 1095321155) {
            bl2 = true;
        }
        boolean bl3 = false;
        while (!bl3) {
            int n7;
            int n8 = dataInputStream.readInt();
            int n9 = dataInputStream.readInt();
            n2 += 8;
            int n10 = 0;
            switch (n8) {
                case 1180058962: {
                    break;
                }
                case 1129270605: {
                    int n11;
                    if (!bl2 && n9 < 18 || bl2 && n9 < 22) {
                        throw new UnsupportedAudioFileException("Invalid AIFF/COMM chunksize");
                    }
                    n7 = dataInputStream.readShort();
                    dataInputStream.readInt();
                    int n12 = dataInputStream.readShort();
                    float f = (float)this.read_ieee_extended(dataInputStream);
                    n10 += 18;
                    AudioFormat.Encoding encoding = AudioFormat.Encoding.PCM_SIGNED;
                    if (bl2) {
                        n11 = dataInputStream.readInt();
                        n10 += 4;
                        switch (n11) {
                            case 1313820229: {
                                encoding = AudioFormat.Encoding.PCM_SIGNED;
                                break;
                            }
                            case 1970037111: {
                                encoding = AudioFormat.Encoding.ULAW;
                                n12 = 8;
                                break;
                            }
                            default: {
                                throw new UnsupportedAudioFileException("Invalid AIFF encoding");
                            }
                        }
                    }
                    n11 = AiffFileReader.calculatePCMFrameSize(n12, n7);
                    audioFormat = new AudioFormat(encoding, f, n12, n7, n11, f, true);
                    break;
                }
                case 1397968452: {
                    int n13 = dataInputStream.readInt();
                    int n14 = dataInputStream.readInt();
                    n3 = n9 < n5 ? n9 - n10 : n5 - (n2 + (n10 += 8));
                    bl3 = true;
                }
            }
            n2 += n10;
            if (bl3 || (n7 = n9 - n10) <= 0) continue;
            n2 += dataInputStream.skipBytes(n7);
        }
        if (audioFormat == null) {
            throw new UnsupportedAudioFileException("missing COMM chunk");
        }
        AudioFileFormat.Type type = bl2 ? AudioFileFormat.Type.AIFC : AudioFileFormat.Type.AIFF;
        return new AiffFileFormat(type, n, audioFormat, n3 / audioFormat.getFrameSize());
    }

    private void write_ieee_extended(DataOutputStream dataOutputStream, double d) throws IOException {
        int n = 16398;
        double d2 = d;
        while (d2 < 44000.0) {
            d2 *= 2.0;
            --n;
        }
        dataOutputStream.writeShort(n);
        dataOutputStream.writeInt((int)d2 << 16);
        dataOutputStream.writeInt(0);
    }

    private double read_ieee_extended(DataInputStream dataInputStream) throws IOException {
        double d = 0.0;
        int n = 0;
        long l = 0L;
        long l2 = 0L;
        double d2 = 3.4028234663852886E38;
        n = dataInputStream.readUnsignedShort();
        long l3 = dataInputStream.readUnsignedShort();
        long l4 = dataInputStream.readUnsignedShort();
        l = l3 << 16 | l4;
        l3 = dataInputStream.readUnsignedShort();
        l4 = dataInputStream.readUnsignedShort();
        l2 = l3 << 16 | l4;
        if (n == 0 && l == 0L && l2 == 0L) {
            d = 0.0;
        } else if (n == Short.MAX_VALUE) {
            d = d2;
        } else {
            n -= 16383;
            d = (double)l * Math.pow(2.0, n -= 31);
            d += (double)l2 * Math.pow(2.0, n -= 32);
        }
        return d;
    }
}

