/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.jfr;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import java.util.Date;
import oracle.jrockit.jfr.Logger;
import oracle.jrockit.jfr.Repository;

@Deprecated
public class RepositoryChunk {
    private final Logger logger;
    private final Repository repository;
    private Date startTime;
    private Date endTime;
    private final File tempFile;
    private final File destFile;
    private volatile int refCount = 1;
    private long size;
    private FileChannel output;
    static boolean rename_overwrites;
    static boolean checked_overwrites;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RepositoryChunk(Repository repository, Logger logger) throws IOException {
        File file;
        File file2;
        String string;
        this.logger = logger;
        this.repository = repository;
        File file3 = repository.getPath();
        String string2 = string = repository.filenameBase();
        int n = 0;
        try {
            repository.lock();
            while (!(file2 = new File(file3, string2 + ".jfr")).createNewFile()) {
                string2 = string + "_" + n++;
            }
            file = new File(file3, string2 + ".jfr.part");
            if (!file.createNewFile()) {
                file2.delete();
                throw new IOException("Could not create temporary file " + file);
            }
        }
        finally {
            repository.unlock();
        }
        this.destFile = file2;
        this.tempFile = file;
        this.startTime = new Date();
    }

    public RepositoryChunk(Repository repository, Logger logger, File file) {
        this.repository = repository;
        this.logger = logger;
        this.tempFile = file;
        String string = file.getPath();
        this.destFile = new File(string.substring(0, string.length() - ".part".length()));
        this.startTime = null;
        assert (this.tempFile.exists());
        assert (this.destFile.exists());
    }

    public File getOutputFile() throws IOException {
        if (this.isFinished()) {
            throw new IOException("Chunk finished");
        }
        return this.tempFile;
    }

    public String getOutputPath() throws IOException {
        return this.getOutputFile().getPath();
    }

    public FileChannel getOutputChannel() throws IOException {
        if (this.output == null) {
            this.output = new FileOutputStream(this.getOutputFile()).getChannel();
        }
        return this.output;
    }

    public void finish(long l, long l2) throws IOException {
        this.finish(new Date(l), new Date(l2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish(Date date, Date date2) throws IOException {
        if (this.output != null) {
            this.output.force(true);
            this.output.close();
        }
        if (!checked_overwrites) {
            File file;
            File file2 = File.createTempFile("test1", "tst");
            if (file2.renameTo(file = File.createTempFile("test2", "tst"))) {
                rename_overwrites = true;
            }
            file2.delete();
            file.delete();
            checked_overwrites = true;
        }
        assert (this.tempFile != null);
        this.repository.lock();
        try {
            if (!rename_overwrites) {
                this.destFile.delete();
            }
            if (!this.tempFile.renameTo(this.destFile)) {
                throw new IOException("Could not rename " + this.tempFile + " to " + this.destFile);
            }
        }
        finally {
            this.repository.unlock();
        }
        this.endTime = date2;
        this.startTime = date;
        this.size = this.destFile.length();
        this.logger.debug("Chunk finished: " + this.destFile);
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    private void delete(File file) {
        if (!file.exists()) {
            return;
        }
        if (!file.delete() && file.exists()) {
            file.deleteOnExit();
            this.logger.error("Repository chunk " + file + " could not be deleted");
            return;
        }
        this.logger.debug("Repository chunk " + file + " deleted");
    }

    private void destroy() {
        if (!this.isFinished()) {
            try {
                this.finish(0L, 0L);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.delete(this.tempFile);
        this.delete(this.destFile);
    }

    public synchronized void use() {
        ++this.refCount;
    }

    public synchronized void release() {
        if (--this.refCount == 0) {
            this.destroy();
        }
    }

    public void finalize() {
        while (this.refCount > 0) {
            this.destroy();
        }
    }

    public long getSize() {
        return this.size;
    }

    public boolean isFinished() {
        return this.endTime != null;
    }

    public String toString() {
        if (this.isFinished()) {
            return this.destFile.getPath();
        }
        return this.tempFile.getPath();
    }

    InputStream newInputStream() throws IOException {
        if (!this.isFinished()) {
            throw new IOException("Chunk not finished");
        }
        return new FileInputStream(this.destFile);
    }
}

