/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jrockit.jfr;

import com.oracle.jrockit.jfr.DelgatingDynamicRequestableEvent;
import com.oracle.jrockit.jfr.DurationEvent;
import com.oracle.jrockit.jfr.DynamicEventToken;
import com.oracle.jrockit.jfr.DynamicValue;
import com.oracle.jrockit.jfr.EventToken;
import com.oracle.jrockit.jfr.InstantEvent;
import com.oracle.jrockit.jfr.InvalidEventDefinitionException;
import com.oracle.jrockit.jfr.InvalidValueException;
import com.oracle.jrockit.jfr.RequestDelegate;
import com.oracle.jrockit.jfr.TimedEvent;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import oracle.jrockit.jfr.JFR;
import oracle.jrockit.jfr.StringConstantPool;
import oracle.jrockit.jfr.events.DynamicValueDescriptor;
import oracle.jrockit.jfr.events.EventHandler;
import oracle.jrockit.jfr.events.JavaEventDescriptor;
import oracle.jrockit.jfr.events.ValueDescriptor;

@Deprecated
public final class Producer {
    private final JFR jfr;
    private final String name;
    private final String description;
    private final URI uri;
    private final List<EventToken> tokens = new ArrayList<EventToken>();
    private final List<EventHandler> events = new ArrayList<EventHandler>();
    private int id;
    private boolean unregistered;
    private boolean enabled;
    private final HashMap<String, StringConstantPool> constantPools = new HashMap();
    private static final Map<Class<? extends InstantEvent>, EventToken> globalTokens = new ConcurrentHashMap<Class<? extends InstantEvent>, EventToken>();
    private static final Object globalTokenLock = new Object();
    private static final HashSet<URI> knownURIs = new HashSet();

    static EventToken locateToken(Class<? extends InstantEvent> clazz) {
        EventToken eventToken = globalTokens.get(clazz);
        if (eventToken == null) {
            throw new IllegalArgumentException(clazz.getName() + " is not registered");
        }
        return eventToken;
    }

    public Producer(String string, String string2, URI uRI) {
        if (!uRI.toString().endsWith("/")) {
            try {
                uRI = new URI(uRI.toString() + "/");
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        this.name = string;
        this.description = string2;
        this.jfr = JFR.get();
        this.uri = uRI;
    }

    public Producer(String string, String string2, String string3) throws URISyntaxException {
        this(string, string2, new URI(string3));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void register() {
        if (this.id != 0) {
            throw new IllegalStateException("Already registered.");
        }
        if (this.unregistered) {
            throw new IllegalStateException("Unregistered producer");
        }
        Object object = globalTokenLock;
        synchronized (object) {
            if (knownURIs.contains(this.uri)) {
                throw new IllegalStateException("Producer with URI " + this.uri + " already exists");
            }
            knownURIs.add(this.uri);
        }
        this.id = this.jfr.nextID();
        this.enable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void unregister() throws IllegalStateException {
        if (this.id == 0) {
            throw new IllegalStateException("Not registered");
        }
        if (this.unregistered) {
            throw new IllegalStateException("Already unregistered");
        }
        this.disable();
        try {
            HashSet<EventToken> hashSet = new HashSet<EventToken>(this.events.size());
            hashSet.addAll(this.tokens);
            Object object = globalTokenLock;
            synchronized (object) {
                knownURIs.remove(this.uri);
                Iterator<EventToken> iterator = globalTokens.values().iterator();
                while (iterator.hasNext()) {
                    EventToken eventToken = iterator.next();
                    if (!hashSet.contains(eventToken)) continue;
                    iterator.remove();
                }
            }
        }
        finally {
            this.unregistered = true;
        }
    }

    public synchronized void enable() {
        if (this.id == 0) {
            throw new IllegalStateException("Not registered");
        }
        if (this.unregistered) {
            throw new IllegalStateException("Already unregistered");
        }
        if (this.enabled) {
            return;
        }
        for (StringConstantPool stringConstantPool : this.constantPools.values()) {
            stringConstantPool.enable();
        }
        this.jfr.addProducer(this, this.id, this.events, this.constantPools);
        this.enabled = true;
    }

    public synchronized void disable() {
        if (this.id == 0) {
            throw new IllegalStateException("Not registered");
        }
        if (this.unregistered) {
            throw new IllegalStateException("Already unregistered");
        }
        if (!this.enabled) {
            return;
        }
        this.jfr.removeProducer(this.id);
        for (StringConstantPool stringConstantPool : this.constantPools.values()) {
            stringConstantPool.disable();
        }
        this.enabled = false;
    }

    private void add(EventToken eventToken, EventHandler eventHandler) throws InvalidEventDefinitionException {
        String string = eventToken.getPath();
        for (EventToken eventToken2 : this.tokens) {
            if (!eventToken2.getPath().equals(string)) continue;
            throw new IllegalArgumentException("Event with path " + string + " already exists in this producer");
        }
        this.events.add(eventHandler);
        this.tokens.add(eventToken);
        if (this.enabled) {
            this.jfr.addEventsToRegisteredProducer(this, this.id, Collections.singletonList(eventHandler), this.constantPools);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized EventToken addEvent(Class<? extends InstantEvent> clazz) throws InvalidEventDefinitionException, InvalidValueException {
        if (this.getToken(clazz) != null) {
            throw new IllegalArgumentException("The event class has already been added.");
        }
        int n = this.jfr.nextID();
        JavaEventDescriptor javaEventDescriptor = new JavaEventDescriptor(clazz, this.uri, n);
        EventHandler eventHandler = this.jfr.createHandler(javaEventDescriptor, clazz, this.constantPools);
        EventToken eventToken = new EventToken(eventHandler);
        this.add(eventToken, eventHandler);
        if (n != 0) {
            Object object = globalTokenLock;
            synchronized (object) {
                if (globalTokens.containsKey(clazz)) {
                    throw new IllegalStateException("Class " + clazz + " already registered in another producer");
                }
                globalTokens.put(clazz, eventToken);
            }
        }
        return eventToken;
    }

    private synchronized DynamicEventToken createDynamicEvent(Class<? extends InstantEvent> clazz, String string, String string2, String string3, boolean bl, boolean bl2, RequestDelegate requestDelegate, DynamicValue ... dynamicValueArray) throws InvalidEventDefinitionException {
        ValueDescriptor[] valueDescriptorArray = new DynamicValueDescriptor[dynamicValueArray.length];
        int n = 0;
        for (DynamicValue object2 : dynamicValueArray) {
            ValueDescriptor valueDescriptor = object2.getDescriptor();
            valueDescriptorArray[n] = new DynamicValueDescriptor(valueDescriptor, n);
            ++n;
        }
        int n2 = this.jfr.nextID();
        JavaEventDescriptor javaEventDescriptor = new JavaEventDescriptor(clazz, this.uri, n2, string, string2, string3, bl, bl2, valueDescriptorArray);
        EventHandler eventHandler = this.jfr.createHandler(javaEventDescriptor, Object[].class, this.constantPools);
        DynamicEventToken dynamicEventToken = new DynamicEventToken(eventHandler, requestDelegate);
        this.add(dynamicEventToken, eventHandler);
        return dynamicEventToken;
    }

    public DynamicEventToken createDynamicInstantEvent(String string, String string2, String string3, boolean bl, boolean bl2, DynamicValue ... dynamicValueArray) throws InvalidEventDefinitionException {
        return this.createDynamicEvent(InstantEvent.class, string, string2, string3, bl, bl2, null, dynamicValueArray);
    }

    public DynamicEventToken createDynamicDurationEvent(String string, String string2, String string3, boolean bl, boolean bl2, DynamicValue ... dynamicValueArray) throws InvalidEventDefinitionException {
        return this.createDynamicEvent(DurationEvent.class, string, string2, string3, bl, bl2, null, dynamicValueArray);
    }

    public DynamicEventToken createDynamicTimedEvent(String string, String string2, String string3, boolean bl, boolean bl2, DynamicValue ... dynamicValueArray) throws InvalidEventDefinitionException {
        return this.createDynamicEvent(TimedEvent.class, string, string2, string3, bl, bl2, null, dynamicValueArray);
    }

    public DynamicEventToken createDynamicRequestableEvent(String string, String string2, String string3, boolean bl, boolean bl2, RequestDelegate requestDelegate, DynamicValue ... dynamicValueArray) throws InvalidEventDefinitionException {
        return this.createDynamicEvent(DelgatingDynamicRequestableEvent.class, string, string2, string3, bl, bl2, requestDelegate, dynamicValueArray);
    }

    private EventToken getToken(Class<? extends InstantEvent> clazz) {
        for (EventToken eventToken : this.tokens) {
            if (eventToken.getEventInfo().getDescriptor().getEventClass() != clazz) continue;
            return eventToken;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createConstantPool(Class<?> clazz, String string, int n, int n2, boolean bl) {
        if (clazz != String.class) {
            throw new IllegalArgumentException("Unsupported constant pool type " + clazz);
        }
        Producer producer = this;
        synchronized (producer) {
            if (this.constantPools.containsKey(string)) {
                throw new IllegalArgumentException("Duplicate constant pool " + string);
            }
            StringConstantPool stringConstantPool = new StringConstantPool(this.jfr, this.jfr.nextID(), n2, bl);
            this.constantPools.put(string, stringConstantPool);
            if (this.enabled) {
                stringConstantPool.enable();
            }
        }
    }

    public synchronized EventToken getEventToken(Class<? extends InstantEvent> clazz) {
        EventToken eventToken = this.getToken(clazz);
        if (eventToken == null) {
            throw new IllegalArgumentException(clazz + " not registered");
        }
        return eventToken;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public URI getURI() {
        return this.uri;
    }

    public synchronized boolean isRegistered() {
        return this.id != 0 && !this.unregistered;
    }

    public synchronized boolean isUnregistered() {
        return this.unregistered;
    }

    public synchronized boolean isEnabled() {
        return this.enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        super.finalize();
        Producer producer = this;
        synchronized (producer) {
            if (this.id != 0 && !this.unregistered) {
                this.unregister();
            }
        }
    }
}

