/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webpane.webkit.dom;

import com.sun.webpane.platform.Disposer;
import com.sun.webpane.webkit.JSObject;
import com.sun.webpane.webkit.dom.AttrImpl;
import com.sun.webpane.webkit.dom.CDATASectionImpl;
import com.sun.webpane.webkit.dom.CommentImpl;
import com.sun.webpane.webkit.dom.DocumentFragmentImpl;
import com.sun.webpane.webkit.dom.DocumentImpl;
import com.sun.webpane.webkit.dom.DocumentTypeImpl;
import com.sun.webpane.webkit.dom.ElementImpl;
import com.sun.webpane.webkit.dom.EntityImpl;
import com.sun.webpane.webkit.dom.EntityReferenceImpl;
import com.sun.webpane.webkit.dom.EventImpl;
import com.sun.webpane.webkit.dom.EventListenerImpl;
import com.sun.webpane.webkit.dom.HTMLAnchorElementImpl;
import com.sun.webpane.webkit.dom.HTMLAppletElementImpl;
import com.sun.webpane.webkit.dom.HTMLAreaElementImpl;
import com.sun.webpane.webkit.dom.HTMLBRElementImpl;
import com.sun.webpane.webkit.dom.HTMLBaseElementImpl;
import com.sun.webpane.webkit.dom.HTMLBaseFontElementImpl;
import com.sun.webpane.webkit.dom.HTMLBodyElementImpl;
import com.sun.webpane.webkit.dom.HTMLButtonElementImpl;
import com.sun.webpane.webkit.dom.HTMLDListElementImpl;
import com.sun.webpane.webkit.dom.HTMLDirectoryElementImpl;
import com.sun.webpane.webkit.dom.HTMLDivElementImpl;
import com.sun.webpane.webkit.dom.HTMLDocumentImpl;
import com.sun.webpane.webkit.dom.HTMLElementImpl;
import com.sun.webpane.webkit.dom.HTMLFieldSetElementImpl;
import com.sun.webpane.webkit.dom.HTMLFontElementImpl;
import com.sun.webpane.webkit.dom.HTMLFormElementImpl;
import com.sun.webpane.webkit.dom.HTMLFrameElementImpl;
import com.sun.webpane.webkit.dom.HTMLFrameSetElementImpl;
import com.sun.webpane.webkit.dom.HTMLHRElementImpl;
import com.sun.webpane.webkit.dom.HTMLHeadElementImpl;
import com.sun.webpane.webkit.dom.HTMLHeadingElementImpl;
import com.sun.webpane.webkit.dom.HTMLIFrameElementImpl;
import com.sun.webpane.webkit.dom.HTMLImageElementImpl;
import com.sun.webpane.webkit.dom.HTMLInputElementImpl;
import com.sun.webpane.webkit.dom.HTMLLIElementImpl;
import com.sun.webpane.webkit.dom.HTMLLabelElementImpl;
import com.sun.webpane.webkit.dom.HTMLLegendElementImpl;
import com.sun.webpane.webkit.dom.HTMLLinkElementImpl;
import com.sun.webpane.webkit.dom.HTMLMapElementImpl;
import com.sun.webpane.webkit.dom.HTMLMenuElementImpl;
import com.sun.webpane.webkit.dom.HTMLMetaElementImpl;
import com.sun.webpane.webkit.dom.HTMLModElementImpl;
import com.sun.webpane.webkit.dom.HTMLOListElementImpl;
import com.sun.webpane.webkit.dom.HTMLObjectElementImpl;
import com.sun.webpane.webkit.dom.HTMLOptGroupElementImpl;
import com.sun.webpane.webkit.dom.HTMLOptionElementImpl;
import com.sun.webpane.webkit.dom.HTMLParagraphElementImpl;
import com.sun.webpane.webkit.dom.HTMLParamElementImpl;
import com.sun.webpane.webkit.dom.HTMLPreElementImpl;
import com.sun.webpane.webkit.dom.HTMLQuoteElementImpl;
import com.sun.webpane.webkit.dom.HTMLScriptElementImpl;
import com.sun.webpane.webkit.dom.HTMLSelectElementImpl;
import com.sun.webpane.webkit.dom.HTMLStyleElementImpl;
import com.sun.webpane.webkit.dom.HTMLTableCaptionElementImpl;
import com.sun.webpane.webkit.dom.HTMLTableCellElementImpl;
import com.sun.webpane.webkit.dom.HTMLTableColElementImpl;
import com.sun.webpane.webkit.dom.HTMLTableElementImpl;
import com.sun.webpane.webkit.dom.HTMLTableRowElementImpl;
import com.sun.webpane.webkit.dom.HTMLTableSectionElementImpl;
import com.sun.webpane.webkit.dom.HTMLTextAreaElementImpl;
import com.sun.webpane.webkit.dom.HTMLTitleElementImpl;
import com.sun.webpane.webkit.dom.HTMLUListElementImpl;
import com.sun.webpane.webkit.dom.NamedNodeMapImpl;
import com.sun.webpane.webkit.dom.NodeListImpl;
import com.sun.webpane.webkit.dom.NotationImpl;
import com.sun.webpane.webkit.dom.ProcessingInstructionImpl;
import com.sun.webpane.webkit.dom.TextImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.UserDataHandler;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventException;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;

public class NodeImpl
extends JSObject
implements Node,
EventTarget {
    private static SelfDisposer[] hashTable = new SelfDisposer[64];
    private static int hashCount;
    protected final long peer;
    public static final int ELEMENT_NODE = 1;
    public static final int ATTRIBUTE_NODE = 2;
    public static final int TEXT_NODE = 3;
    public static final int CDATA_SECTION_NODE = 4;
    public static final int ENTITY_REFERENCE_NODE = 5;
    public static final int ENTITY_NODE = 6;
    public static final int PROCESSING_INSTRUCTION_NODE = 7;
    public static final int COMMENT_NODE = 8;
    public static final int DOCUMENT_NODE = 9;
    public static final int DOCUMENT_TYPE_NODE = 10;
    public static final int DOCUMENT_FRAGMENT_NODE = 11;
    public static final int NOTATION_NODE = 12;
    public static final int DOCUMENT_POSITION_DISCONNECTED = 1;
    public static final int DOCUMENT_POSITION_PRECEDING = 2;
    public static final int DOCUMENT_POSITION_FOLLOWING = 4;
    public static final int DOCUMENT_POSITION_CONTAINS = 8;
    public static final int DOCUMENT_POSITION_CONTAINED_BY = 16;
    public static final int DOCUMENT_POSITION_IMPLEMENTATION_SPECIFIC = 32;

    private static int hashPeer(long peer) {
        return (int)(peer ^ 0xFFFFFFFFFFFFFFFFL ^ peer >> 7) & hashTable.length - 1;
    }

    static Node getImpl(long peer, long contextPeer, long rootPeer, long jsPeer) {
        if (peer == 0L) {
            return null;
        }
        int hash = NodeImpl.hashPeer(peer);
        SelfDisposer head = hashTable[hash];
        SelfDisposer prev = null;
        SelfDisposer disposer = head;
        while (disposer != null) {
            SelfDisposer next = disposer.next;
            if (disposer.peer == peer) {
                NodeImpl node = (NodeImpl)disposer.get();
                if (node != null) {
                    NodeImpl.dispose(peer);
                    return node;
                }
                if (prev != null) {
                    prev.next = next;
                    break;
                }
                NodeImpl.hashTable[hash] = next;
                break;
            }
            prev = disposer;
            disposer = next;
        }
        NodeImpl node = (NodeImpl)NodeImpl.createInterface(peer, contextPeer, rootPeer);
        SelfDisposer disposer2 = new SelfDisposer((Object)node, peer);
        disposer2.next = head;
        NodeImpl.hashTable[hash] = disposer2;
        if (3 * hashCount >= 2 * hashTable.length) {
            NodeImpl.rehash();
        }
        ++hashCount;
        node.jsPeer = jsPeer;
        return node;
    }

    private static void rehash() {
        SelfDisposer[] oldTable = hashTable;
        int oldLength = oldTable.length;
        SelfDisposer[] newTable = new SelfDisposer[2 * oldLength];
        hashTable = newTable;
        int i = oldLength;
        while (--i >= 0) {
            SelfDisposer disposer = oldTable[i];
            while (disposer != null) {
                SelfDisposer next = disposer.next;
                int hash = NodeImpl.hashPeer(disposer.peer);
                disposer.next = newTable[hash];
                newTable[hash] = disposer;
                disposer = next;
            }
        }
    }

    @Override
    protected long getJSPeer() {
        if (this.jsPeer == 0L) {
            this.jsPeer = NodeImpl.getJSPeerImpl(this.peer, this.contextPeer, this.rootPeer);
        }
        return this.jsPeer;
    }

    static native long getJSPeerImpl(long var0, long var2, long var4);

    NodeImpl(long peer, long contextPeer, long rootPeer) {
        super(0L, contextPeer, rootPeer);
        this.peer = peer;
    }

    static Node createInterface(long peer, long contextPeer, long rootPeer) {
        if (peer == 0L) {
            return null;
        }
        switch (NodeImpl.getNodeTypeImpl(peer)) {
            case 1: {
                if (!ElementImpl.isHTMLElementImpl(peer)) {
                    return new ElementImpl(peer, contextPeer, rootPeer);
                }
                String tagName = ElementImpl.getTagNameImpl(peer).toUpperCase();
                if ("A".equals(tagName)) {
                    return new HTMLAnchorElementImpl(peer, contextPeer, rootPeer);
                }
                if ("APPLET".equals(tagName)) {
                    return new HTMLAppletElementImpl(peer, contextPeer, rootPeer);
                }
                if ("AREA".equals(tagName)) {
                    return new HTMLAreaElementImpl(peer, contextPeer, rootPeer);
                }
                if ("BASE".equals(tagName)) {
                    return new HTMLBaseElementImpl(peer, contextPeer, rootPeer);
                }
                if ("BASEFONT".equals(tagName)) {
                    return new HTMLBaseFontElementImpl(peer, contextPeer, rootPeer);
                }
                if ("BODY".equals(tagName)) {
                    return new HTMLBodyElementImpl(peer, contextPeer, rootPeer);
                }
                if ("BR".equals(tagName)) {
                    return new HTMLBRElementImpl(peer, contextPeer, rootPeer);
                }
                if ("BUTTON".equals(tagName)) {
                    return new HTMLButtonElementImpl(peer, contextPeer, rootPeer);
                }
                if ("DIR".equals(tagName)) {
                    return new HTMLDirectoryElementImpl(peer, contextPeer, rootPeer);
                }
                if ("DIV".equals(tagName)) {
                    return new HTMLDivElementImpl(peer, contextPeer, rootPeer);
                }
                if ("DL".equals(tagName)) {
                    return new HTMLDListElementImpl(peer, contextPeer, rootPeer);
                }
                if ("FIELDSET".equals(tagName)) {
                    return new HTMLFieldSetElementImpl(peer, contextPeer, rootPeer);
                }
                if ("FONT".equals(tagName)) {
                    return new HTMLFontElementImpl(peer, contextPeer, rootPeer);
                }
                if ("FORM".equals(tagName)) {
                    return new HTMLFormElementImpl(peer, contextPeer, rootPeer);
                }
                if ("FRAME".equals(tagName)) {
                    return new HTMLFrameElementImpl(peer, contextPeer, rootPeer);
                }
                if ("FRAMESET".equals(tagName)) {
                    return new HTMLFrameSetElementImpl(peer, contextPeer, rootPeer);
                }
                if ("HEAD".equals(tagName)) {
                    return new HTMLHeadElementImpl(peer, contextPeer, rootPeer);
                }
                if (tagName.length() == 2 && tagName.charAt(0) == 'H' && tagName.charAt(1) >= '1' && tagName.charAt(1) <= '6') {
                    return new HTMLHeadingElementImpl(peer, contextPeer, rootPeer);
                }
                if ("HR".equals(tagName)) {
                    return new HTMLHRElementImpl(peer, contextPeer, rootPeer);
                }
                if ("IFRAME".equals(tagName)) {
                    return new HTMLIFrameElementImpl(peer, contextPeer, rootPeer);
                }
                if ("IMG".equals(tagName)) {
                    return new HTMLImageElementImpl(peer, contextPeer, rootPeer);
                }
                if ("INPUT".equals(tagName)) {
                    return new HTMLInputElementImpl(peer, contextPeer, rootPeer);
                }
                if ("LABEL".equals(tagName)) {
                    return new HTMLLabelElementImpl(peer, contextPeer, rootPeer);
                }
                if ("LEGEND".equals(tagName)) {
                    return new HTMLLegendElementImpl(peer, contextPeer, rootPeer);
                }
                if ("LI".equals(tagName)) {
                    return new HTMLLIElementImpl(peer, contextPeer, rootPeer);
                }
                if ("LINK".equals(tagName)) {
                    return new HTMLLinkElementImpl(peer, contextPeer, rootPeer);
                }
                if ("MAP".equals(tagName)) {
                    return new HTMLMapElementImpl(peer, contextPeer, rootPeer);
                }
                if ("MENU".equals(tagName)) {
                    return new HTMLMenuElementImpl(peer, contextPeer, rootPeer);
                }
                if ("META".equals(tagName)) {
                    return new HTMLMetaElementImpl(peer, contextPeer, rootPeer);
                }
                if ("INS".equals(tagName) || "DEL".equals(tagName)) {
                    return new HTMLModElementImpl(peer, contextPeer, rootPeer);
                }
                if ("OBJECT".equals(tagName)) {
                    return new HTMLObjectElementImpl(peer, contextPeer, rootPeer);
                }
                if ("OL".equals(tagName)) {
                    return new HTMLOListElementImpl(peer, contextPeer, rootPeer);
                }
                if ("OPTGROUP".equals(tagName)) {
                    return new HTMLOptGroupElementImpl(peer, contextPeer, rootPeer);
                }
                if ("OPTION".equals(tagName)) {
                    return new HTMLOptionElementImpl(peer, contextPeer, rootPeer);
                }
                if ("P".equals(tagName)) {
                    return new HTMLParagraphElementImpl(peer, contextPeer, rootPeer);
                }
                if ("PARAM".equals(tagName)) {
                    return new HTMLParamElementImpl(peer, contextPeer, rootPeer);
                }
                if ("PRE".equals(tagName)) {
                    return new HTMLPreElementImpl(peer, contextPeer, rootPeer);
                }
                if ("Q".equals(tagName)) {
                    return new HTMLQuoteElementImpl(peer, contextPeer, rootPeer);
                }
                if ("SCRIPT".equals(tagName)) {
                    return new HTMLScriptElementImpl(peer, contextPeer, rootPeer);
                }
                if ("SELECT".equals(tagName)) {
                    return new HTMLSelectElementImpl(peer, contextPeer, rootPeer);
                }
                if ("STYLE".equals(tagName)) {
                    return new HTMLStyleElementImpl(peer, contextPeer, rootPeer);
                }
                if ("CAPTION".equals(tagName)) {
                    return new HTMLTableCaptionElementImpl(peer, contextPeer, rootPeer);
                }
                if ("TD".equals(tagName)) {
                    return new HTMLTableCellElementImpl(peer, contextPeer, rootPeer);
                }
                if ("COL".equals(tagName)) {
                    return new HTMLTableColElementImpl(peer, contextPeer, rootPeer);
                }
                if ("TABLE".equals(tagName)) {
                    return new HTMLTableElementImpl(peer, contextPeer, rootPeer);
                }
                if ("TR".equals(tagName)) {
                    return new HTMLTableRowElementImpl(peer, contextPeer, rootPeer);
                }
                if ("THEAD".equals(tagName) || "TFOOT".equals(tagName) || "TBODY".equals(tagName)) {
                    return new HTMLTableSectionElementImpl(peer, contextPeer, rootPeer);
                }
                if ("TEXTAREA".equals(tagName)) {
                    return new HTMLTextAreaElementImpl(peer, contextPeer, rootPeer);
                }
                if ("TITLE".equals(tagName)) {
                    return new HTMLTitleElementImpl(peer, contextPeer, rootPeer);
                }
                if ("UL".equals(tagName)) {
                    return new HTMLUListElementImpl(peer, contextPeer, rootPeer);
                }
                return new HTMLElementImpl(peer, contextPeer, rootPeer);
            }
            case 2: {
                return new AttrImpl(peer, contextPeer, rootPeer);
            }
            case 3: {
                return new TextImpl(peer, contextPeer, rootPeer);
            }
            case 4: {
                return new CDATASectionImpl(peer, contextPeer, rootPeer);
            }
            case 5: {
                return new EntityReferenceImpl(peer, contextPeer, rootPeer);
            }
            case 6: {
                return new EntityImpl(peer, contextPeer, rootPeer);
            }
            case 7: {
                return new ProcessingInstructionImpl(peer, contextPeer, rootPeer);
            }
            case 8: {
                return new CommentImpl(peer, contextPeer, rootPeer);
            }
            case 9: {
                if (DocumentImpl.isHTMLDocumentImpl(peer)) {
                    return new HTMLDocumentImpl(peer, contextPeer, rootPeer);
                }
                return new DocumentImpl(peer, contextPeer, rootPeer);
            }
            case 10: {
                return new DocumentTypeImpl(peer, contextPeer, rootPeer);
            }
            case 11: {
                return new DocumentFragmentImpl(peer, contextPeer, rootPeer);
            }
            case 12: {
                return new NotationImpl(peer, contextPeer, rootPeer);
            }
        }
        return new NodeImpl(peer, contextPeer, rootPeer);
    }

    static Node create(long peer, long contextPeer, long rootPeer) {
        return NodeImpl.getImpl(peer, contextPeer, rootPeer, 0L);
    }

    long getPeer() {
        return this.peer;
    }

    static long getPeer(Node arg) {
        return arg == null ? 0L : ((NodeImpl)arg).getPeer();
    }

    @Override
    public boolean equals(Object that) {
        return that instanceof NodeImpl && this.peer == ((NodeImpl)that).peer;
    }

    @Override
    public int hashCode() {
        long p = this.peer;
        return (int)(p ^ p >> 17);
    }

    private static native void dispose(long var0);

    static Node getImpl(long peer, long contextPeer, long rootPeer) {
        return NodeImpl.create(peer, contextPeer, rootPeer);
    }

    @Override
    public String getNodeName() {
        return NodeImpl.getNodeNameImpl(this.getPeer());
    }

    static native String getNodeNameImpl(long var0);

    @Override
    public String getNodeValue() {
        return NodeImpl.getNodeValueImpl(this.getPeer());
    }

    static native String getNodeValueImpl(long var0);

    @Override
    public void setNodeValue(String value) throws DOMException {
        NodeImpl.setNodeValueImpl(this.getPeer(), value);
    }

    static native void setNodeValueImpl(long var0, String var2);

    @Override
    public short getNodeType() {
        return NodeImpl.getNodeTypeImpl(this.getPeer());
    }

    static native short getNodeTypeImpl(long var0);

    @Override
    public Node getParentNode() {
        return NodeImpl.getImpl(NodeImpl.getParentNodeImpl(this.getPeer()), this.contextPeer, this.rootPeer);
    }

    static native long getParentNodeImpl(long var0);

    @Override
    public NodeList getChildNodes() {
        return NodeListImpl.getImpl(NodeImpl.getChildNodesImpl(this.getPeer()), this.contextPeer, this.rootPeer);
    }

    static native long getChildNodesImpl(long var0);

    @Override
    public Node getFirstChild() {
        return NodeImpl.getImpl(NodeImpl.getFirstChildImpl(this.getPeer()), this.contextPeer, this.rootPeer);
    }

    static native long getFirstChildImpl(long var0);

    @Override
    public Node getLastChild() {
        return NodeImpl.getImpl(NodeImpl.getLastChildImpl(this.getPeer()), this.contextPeer, this.rootPeer);
    }

    static native long getLastChildImpl(long var0);

    @Override
    public Node getPreviousSibling() {
        return NodeImpl.getImpl(NodeImpl.getPreviousSiblingImpl(this.getPeer()), this.contextPeer, this.rootPeer);
    }

    static native long getPreviousSiblingImpl(long var0);

    @Override
    public Node getNextSibling() {
        return NodeImpl.getImpl(NodeImpl.getNextSiblingImpl(this.getPeer()), this.contextPeer, this.rootPeer);
    }

    static native long getNextSiblingImpl(long var0);

    @Override
    public NamedNodeMap getAttributes() {
        return NamedNodeMapImpl.getImpl(NodeImpl.getAttributesImpl(this.getPeer()), this.contextPeer, this.rootPeer);
    }

    static native long getAttributesImpl(long var0);

    @Override
    public Document getOwnerDocument() {
        return DocumentImpl.getImpl(NodeImpl.getOwnerDocumentImpl(this.getPeer()), this.contextPeer, this.rootPeer);
    }

    static native long getOwnerDocumentImpl(long var0);

    @Override
    public String getNamespaceURI() {
        return NodeImpl.getNamespaceURIImpl(this.getPeer());
    }

    static native String getNamespaceURIImpl(long var0);

    @Override
    public String getPrefix() {
        return NodeImpl.getPrefixImpl(this.getPeer());
    }

    static native String getPrefixImpl(long var0);

    @Override
    public void setPrefix(String value) throws DOMException {
        NodeImpl.setPrefixImpl(this.getPeer(), value);
    }

    static native void setPrefixImpl(long var0, String var2);

    @Override
    public String getLocalName() {
        return NodeImpl.getLocalNameImpl(this.getPeer());
    }

    static native String getLocalNameImpl(long var0);

    @Override
    public String getBaseURI() {
        return NodeImpl.getBaseURIImpl(this.getPeer());
    }

    static native String getBaseURIImpl(long var0);

    @Override
    public String getTextContent() {
        return NodeImpl.getTextContentImpl(this.getPeer());
    }

    static native String getTextContentImpl(long var0);

    @Override
    public void setTextContent(String value) throws DOMException {
        NodeImpl.setTextContentImpl(this.getPeer(), value);
    }

    static native void setTextContentImpl(long var0, String var2);

    public Element getParentElement() {
        return ElementImpl.getImpl(NodeImpl.getParentElementImpl(this.getPeer()), this.contextPeer, this.rootPeer);
    }

    static native long getParentElementImpl(long var0);

    @Override
    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        return NodeImpl.getImpl(NodeImpl.insertBeforeImpl(this.getPeer(), NodeImpl.getPeer(newChild), NodeImpl.getPeer(refChild)), this.contextPeer, this.rootPeer);
    }

    static native long insertBeforeImpl(long var0, long var2, long var4);

    @Override
    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        return NodeImpl.getImpl(NodeImpl.replaceChildImpl(this.getPeer(), NodeImpl.getPeer(newChild), NodeImpl.getPeer(oldChild)), this.contextPeer, this.rootPeer);
    }

    static native long replaceChildImpl(long var0, long var2, long var4);

    @Override
    public Node removeChild(Node oldChild) throws DOMException {
        return NodeImpl.getImpl(NodeImpl.removeChildImpl(this.getPeer(), NodeImpl.getPeer(oldChild)), this.contextPeer, this.rootPeer);
    }

    static native long removeChildImpl(long var0, long var2);

    @Override
    public Node appendChild(Node newChild) throws DOMException {
        return NodeImpl.getImpl(NodeImpl.appendChildImpl(this.getPeer(), NodeImpl.getPeer(newChild)), this.contextPeer, this.rootPeer);
    }

    static native long appendChildImpl(long var0, long var2);

    @Override
    public boolean hasChildNodes() {
        return NodeImpl.hasChildNodesImpl(this.getPeer());
    }

    static native boolean hasChildNodesImpl(long var0);

    @Override
    public Node cloneNode(boolean deep) {
        return NodeImpl.getImpl(NodeImpl.cloneNodeImpl(this.getPeer(), deep), this.contextPeer, this.rootPeer);
    }

    static native long cloneNodeImpl(long var0, boolean var2);

    @Override
    public void normalize() {
        NodeImpl.normalizeImpl(this.getPeer());
    }

    static native void normalizeImpl(long var0);

    @Override
    public boolean isSupported(String feature, String version) {
        return NodeImpl.isSupportedImpl(this.getPeer(), feature, version);
    }

    static native boolean isSupportedImpl(long var0, String var2, String var3);

    @Override
    public boolean hasAttributes() {
        return NodeImpl.hasAttributesImpl(this.getPeer());
    }

    static native boolean hasAttributesImpl(long var0);

    @Override
    public boolean isSameNode(Node other) {
        return NodeImpl.isSameNodeImpl(this.getPeer(), NodeImpl.getPeer(other));
    }

    static native boolean isSameNodeImpl(long var0, long var2);

    @Override
    public boolean isEqualNode(Node other) {
        return NodeImpl.isEqualNodeImpl(this.getPeer(), NodeImpl.getPeer(other));
    }

    static native boolean isEqualNodeImpl(long var0, long var2);

    @Override
    public String lookupPrefix(String namespaceURI) {
        return NodeImpl.lookupPrefixImpl(this.getPeer(), namespaceURI);
    }

    static native String lookupPrefixImpl(long var0, String var2);

    @Override
    public boolean isDefaultNamespace(String namespaceURI) {
        return NodeImpl.isDefaultNamespaceImpl(this.getPeer(), namespaceURI);
    }

    static native boolean isDefaultNamespaceImpl(long var0, String var2);

    @Override
    public String lookupNamespaceURI(String prefix) {
        return NodeImpl.lookupNamespaceURIImpl(this.getPeer(), prefix);
    }

    static native String lookupNamespaceURIImpl(long var0, String var2);

    @Override
    public short compareDocumentPosition(Node other) {
        return NodeImpl.compareDocumentPositionImpl(this.getPeer(), NodeImpl.getPeer(other));
    }

    static native short compareDocumentPositionImpl(long var0, long var2);

    public boolean contains(Node other) {
        return NodeImpl.containsImpl(this.getPeer(), NodeImpl.getPeer(other));
    }

    static native boolean containsImpl(long var0, long var2);

    @Override
    public void addEventListener(String type, EventListener listener, boolean useCapture) {
        NodeImpl.addEventListenerImpl(this.getPeer(), type, EventListenerImpl.getPeer(listener, this.contextPeer, this.rootPeer), useCapture);
    }

    static native void addEventListenerImpl(long var0, String var2, long var3, boolean var5);

    @Override
    public void removeEventListener(String type, EventListener listener, boolean useCapture) {
        NodeImpl.removeEventListenerImpl(this.getPeer(), type, EventListenerImpl.getPeer(listener, this.contextPeer, this.rootPeer), useCapture);
    }

    static native void removeEventListenerImpl(long var0, String var2, long var3, boolean var5);

    @Override
    public boolean dispatchEvent(Event event) throws EventException {
        return NodeImpl.dispatchEventImpl(this.getPeer(), EventImpl.getPeer(event));
    }

    static native boolean dispatchEventImpl(long var0, long var2);

    @Override
    public Object getUserData(String key) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Object setUserData(String key, Object data, UserDataHandler handler) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Object getFeature(String feature, String version) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    static class SelfDisposer
    extends Disposer.WeakDisposerRecord {
        private final long peer;
        SelfDisposer next;

        SelfDisposer(Object referent, long _peer) {
            super(referent);
            this.peer = _peer;
        }

        @Override
        public void dispose() {
            int hash = NodeImpl.hashPeer(this.peer);
            SelfDisposer head = hashTable[hash];
            SelfDisposer prev = null;
            SelfDisposer disposer = head;
            while (disposer != null) {
                SelfDisposer next = disposer.next;
                if (disposer.peer == this.peer) {
                    disposer.clear();
                    if (prev != null) {
                        prev.next = next;
                    } else {
                        hashTable[hash] = next;
                    }
                    hashCount--;
                    break;
                }
                prev = disposer;
                disposer = next;
            }
            NodeImpl.dispose(this.peer);
        }
    }
}

