/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jfxmediaimpl;

import com.sun.media.jfxmedia.control.VideoDataBuffer;
import com.sun.media.jfxmedia.control.VideoFormat;
import com.sun.media.jfxmediaimpl.MediaDisposer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.atomic.AtomicInteger;

public class NativeVideoBuffer
implements VideoDataBuffer {
    private long nativePeer;
    private AtomicInteger holdCount = new AtomicInteger(1);
    private NativeVideoBuffer cachedBGRARep;
    private static final boolean DEBUG_DISPOSED_BUFFERS = false;
    private static final VideoBufferDisposer disposer = new VideoBufferDisposer();

    private static native void nativeDisposeBuffer(long var0);

    private native double nativeGetTimestamp(long var1);

    private native ByteBuffer nativeGetBuffer(long var1);

    private native long nativeGetFrameNumber(long var1);

    private native int nativeGetWidth(long var1);

    private native int nativeGetHeight(long var1);

    private native int nativeGetEncodedWidth(long var1);

    private native int nativeGetEncodedHeight(long var1);

    private native int nativeGetFormat(long var1);

    private native boolean nativeHasAlpha(long var1);

    private native int nativeGetPlaneCount(long var1);

    private native int[] nativeGetPlaneOffsets(long var1);

    private native int[] nativeGetPlaneStrides(long var1);

    private native long nativeConvertToFormat(long var1, int var3);

    private native void nativeSetDirty(long var1);

    public static NativeVideoBuffer createVideoBuffer(long nativePeer) {
        NativeVideoBuffer buffer = new NativeVideoBuffer(nativePeer);
        MediaDisposer.addResourceDisposer(buffer, new Long(nativePeer), disposer);
        return buffer;
    }

    private NativeVideoBuffer(long nativePeer) {
        this.nativePeer = nativePeer;
    }

    public void holdFrame() {
        if (0L != this.nativePeer) {
            this.holdCount.incrementAndGet();
        }
    }

    public void releaseFrame() {
        if (0L != this.nativePeer && this.holdCount.decrementAndGet() <= 0) {
            if (null != this.cachedBGRARep) {
                this.cachedBGRARep.releaseFrame();
                this.cachedBGRARep = null;
            }
            MediaDisposer.removeResourceDisposer(new Long(this.nativePeer));
            NativeVideoBuffer.nativeDisposeBuffer(this.nativePeer);
            this.nativePeer = 0L;
        }
    }

    public double getTimestamp() {
        if (0L != this.nativePeer) {
            return this.nativeGetTimestamp(this.nativePeer);
        }
        return 0.0;
    }

    public ByteBuffer getBuffer() {
        if (0L != this.nativePeer) {
            ByteBuffer buffer = this.nativeGetBuffer(this.nativePeer);
            buffer.order(ByteOrder.nativeOrder());
            return buffer;
        }
        return null;
    }

    public long getFrameNumber() {
        if (0L != this.nativePeer) {
            return this.nativeGetFrameNumber(this.nativePeer);
        }
        return 0L;
    }

    public int getWidth() {
        if (0L != this.nativePeer) {
            return this.nativeGetWidth(this.nativePeer);
        }
        return 0;
    }

    public int getHeight() {
        if (0L != this.nativePeer) {
            return this.nativeGetHeight(this.nativePeer);
        }
        return 0;
    }

    public int getEncodedWidth() {
        if (0L != this.nativePeer) {
            return this.nativeGetEncodedWidth(this.nativePeer);
        }
        return 0;
    }

    public int getEncodedHeight() {
        if (0L != this.nativePeer) {
            return this.nativeGetEncodedHeight(this.nativePeer);
        }
        return 0;
    }

    public VideoFormat getFormat() {
        if (0L != this.nativePeer) {
            int formatType = this.nativeGetFormat(this.nativePeer);
            return VideoFormat.formatForType(formatType);
        }
        return null;
    }

    public boolean hasAlpha() {
        if (0L != this.nativePeer) {
            return this.nativeHasAlpha(this.nativePeer);
        }
        return false;
    }

    public int getPlaneCount() {
        if (0L != this.nativePeer) {
            return this.nativeGetPlaneCount(this.nativePeer);
        }
        return 0;
    }

    public int getOffsetForPlane(int planeIndex) {
        if (0L != this.nativePeer) {
            int[] offsets = this.nativeGetPlaneOffsets(this.nativePeer);
            return offsets[planeIndex];
        }
        return 0;
    }

    public int[] getPlaneOffsets() {
        if (0L != this.nativePeer) {
            return this.nativeGetPlaneOffsets(this.nativePeer);
        }
        return null;
    }

    public int getStrideForPlane(int planeIndex) {
        if (0L != this.nativePeer) {
            int[] strides = this.nativeGetPlaneStrides(this.nativePeer);
            return strides[planeIndex];
        }
        return 0;
    }

    public int[] getPlaneStrides() {
        if (0L != this.nativePeer) {
            return this.nativeGetPlaneStrides(this.nativePeer);
        }
        return null;
    }

    public VideoDataBuffer convertToFormat(VideoFormat newFormat) {
        if (0L != this.nativePeer) {
            if (newFormat == VideoFormat.BGRA_PRE && null != this.cachedBGRARep) {
                this.cachedBGRARep.holdFrame();
                return this.cachedBGRARep;
            }
            long newFrame = this.nativeConvertToFormat(this.nativePeer, newFormat.getNativeType());
            if (0L != newFrame) {
                NativeVideoBuffer frame = NativeVideoBuffer.createVideoBuffer(newFrame);
                if (newFormat == VideoFormat.BGRA_PRE) {
                    frame.holdFrame();
                    this.cachedBGRARep = frame;
                }
                return frame;
            }
            return null;
        }
        return null;
    }

    public void setDirty() {
        if (0L != this.nativePeer) {
            this.nativeSetDirty(this.nativePeer);
        }
    }

    public String toString() {
        return "[NativeVideoBuffer peer=" + Long.toHexString(this.nativePeer) + ", format=" + (Object)((Object)this.getFormat()) + ", size=(" + this.getWidth() + "," + this.getHeight() + "), timestamp=" + this.getTimestamp() + "]";
    }

    private static class VideoBufferDisposer
    implements MediaDisposer.ResourceDisposer {
        private VideoBufferDisposer() {
        }

        public void disposeResource(Object resource) {
            if (resource instanceof Long) {
                NativeVideoBuffer.nativeDisposeBuffer((Long)resource);
            }
        }
    }
}

