/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.sg.prism;

import com.sun.javafx.font.PGFont;
import com.sun.javafx.geom.Arc2D;
import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.Path2D;
import com.sun.javafx.geom.PathIterator;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.Shape;
import com.sun.javafx.geom.transform.Affine2D;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.geom.transform.NoninvertibleTransformException;
import com.sun.javafx.sg.GrowableDataBuffer;
import com.sun.javafx.sg.PGCanvas;
import com.sun.javafx.sg.PGShape;
import com.sun.javafx.sg.prism.NGNode;
import com.sun.javafx.sg.prism.NGText;
import com.sun.prism.BasicStroke;
import com.sun.prism.CompositeMode;
import com.sun.prism.Graphics;
import com.sun.prism.Image;
import com.sun.prism.RTTexture;
import com.sun.prism.ResourceFactory;
import com.sun.prism.Texture;
import com.sun.prism.paint.Color;
import com.sun.prism.paint.Paint;
import com.sun.scenario.effect.Blend;
import com.sun.scenario.effect.Effect;
import com.sun.scenario.effect.FilterContext;
import com.sun.scenario.effect.Filterable;
import com.sun.scenario.effect.ImageData;
import com.sun.scenario.effect.impl.prism.PrDrawable;
import com.sun.scenario.effect.impl.prism.PrFilterContext;
import com.sun.scenario.effect.impl.prism.PrTexture;
import java.nio.IntBuffer;
import java.util.LinkedList;
import javafx.geometry.VPos;
import javafx.scene.text.Font;

public class NGCanvas
extends NGNode
implements PGCanvas {
    GrowableDataBuffer<Object> thebuf;
    int tw;
    int th;
    RenderBuf cv = new RenderBuf(InitType.PRESERVE_UPPER_LEFT);
    RenderBuf temp = new RenderBuf(InitType.CLEAR);
    RenderBuf clip = new RenderBuf(InitType.FILL_WHITE);
    Image tmpImage = Image.fromIntArgbPreData(new int[1], 1, 1);
    Blend blender = new MyBlend(Blend.Mode.SRC_OVER, null, null);
    float globalAlpha = 1.0f;
    byte fillRule = 0;
    Blend.Mode blendmode = Blend.Mode.SRC_OVER;
    Paint fillPaint = Color.BLACK;
    Paint strokePaint = Color.BLACK;
    float linewidth = 1.0f;
    int linecap = 2;
    int linejoin = 0;
    float miterlimit = 10.0f;
    BasicStroke stroke = null;
    Path2D path = new Path2D();
    NGText ngtext = new NGText();
    PGFont pgfont = (PGFont)Font.getDefault().impl_getNativeFont();
    int align = 0;
    int baseline = VPos.BASELINE.ordinal();
    Affine2D transform = new Affine2D();
    Affine2D inverseTransform = new Affine2D();
    boolean inversedirty;
    LinkedList<Path2D> clipStack = new LinkedList();
    Effect effect;
    static float[] TEMP_COORDS = new float[6];
    static Arc2D TEMP_ARC = new Arc2D();
    static RectBounds TEMP_RECTBOUNDS = new RectBounds();
    int arctype;
    Shape untransformedPath = new Shape(){

        @Override
        public RectBounds getBounds() {
            if (NGCanvas.this.transform.isTranslateOrIdentity()) {
                RectBounds rectBounds = NGCanvas.this.path.getBounds();
                if (NGCanvas.this.transform.isIdentity()) {
                    return rectBounds;
                }
                float f = (float)NGCanvas.this.transform.getMxt();
                float f2 = (float)NGCanvas.this.transform.getMyt();
                return new RectBounds(rectBounds.getMinX() - f, rectBounds.getMinY() - f2, rectBounds.getMaxX() - f, rectBounds.getMaxY() - f2);
            }
            NGCanvas.TEMP_COORDS[2] = Float.POSITIVE_INFINITY;
            NGCanvas.TEMP_COORDS[0] = Float.POSITIVE_INFINITY;
            NGCanvas.TEMP_COORDS[3] = Float.NEGATIVE_INFINITY;
            NGCanvas.TEMP_COORDS[1] = Float.NEGATIVE_INFINITY;
            Shape.accumulate(TEMP_COORDS, NGCanvas.this.path, NGCanvas.this.getInverseTransform());
            return new RectBounds(TEMP_COORDS[0], TEMP_COORDS[1], TEMP_COORDS[2], TEMP_COORDS[3]);
        }

        @Override
        public boolean contains(float f, float f2) {
            NGCanvas.TEMP_COORDS[0] = f;
            NGCanvas.TEMP_COORDS[1] = f2;
            NGCanvas.this.transform.transform(TEMP_COORDS, 0, TEMP_COORDS, 0, 1);
            f = TEMP_COORDS[0];
            f2 = TEMP_COORDS[1];
            return NGCanvas.this.path.contains(f, f2);
        }

        @Override
        public boolean intersects(float f, float f2, float f3, float f4) {
            if (NGCanvas.this.transform.isTranslateOrIdentity()) {
                f = (float)((double)f + NGCanvas.this.transform.getMxt());
                f2 = (float)((double)f2 + NGCanvas.this.transform.getMyt());
                return NGCanvas.this.path.intersects(f, f2, f3, f4);
            }
            PathIterator pathIterator = NGCanvas.this.path.getPathIterator(NGCanvas.this.getInverseTransform());
            int n = Shape.rectCrossingsForPath(pathIterator, f, f2, f + f3, f2 + f4);
            return n != 0;
        }

        @Override
        public boolean contains(float f, float f2, float f3, float f4) {
            if (NGCanvas.this.transform.isTranslateOrIdentity()) {
                f = (float)((double)f + NGCanvas.this.transform.getMxt());
                f2 = (float)((double)f2 + NGCanvas.this.transform.getMyt());
                return NGCanvas.this.path.contains(f, f2, f3, f4);
            }
            PathIterator pathIterator = NGCanvas.this.path.getPathIterator(NGCanvas.this.getInverseTransform());
            int n = Shape.rectCrossingsForPath(pathIterator, f, f2, f + f3, f2 + f4);
            return n != Integer.MIN_VALUE && n != 0;
        }

        public BaseTransform getCombinedTransform(BaseTransform baseTransform) {
            if (NGCanvas.this.transform.isIdentity()) {
                return baseTransform;
            }
            Affine2D affine2D = NGCanvas.this.getInverseTransform();
            if (baseTransform == null || baseTransform.isIdentity()) {
                return affine2D;
            }
            TEMP_PATH_TX.setTransform(baseTransform);
            TEMP_PATH_TX.concatenate(NGCanvas.this.transform);
            return TEMP_PATH_TX;
        }

        @Override
        public PathIterator getPathIterator(BaseTransform baseTransform) {
            return NGCanvas.this.path.getPathIterator(this.getCombinedTransform(baseTransform));
        }

        @Override
        public PathIterator getPathIterator(BaseTransform baseTransform, float f) {
            return NGCanvas.this.path.getPathIterator(this.getCombinedTransform(baseTransform), f);
        }

        @Override
        public Shape copy() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    };
    private static final int[] prcaps = new int[]{0, 1, 2};
    private static final int[] prjoins = new int[]{0, 1, 2};
    private static final int[] prbases = new int[]{VPos.TOP.ordinal(), VPos.CENTER.ordinal(), VPos.BASELINE.ordinal(), VPos.BOTTOM.ordinal()};
    private static final Affine2D TEMP_TX = new Affine2D();
    private static final Affine2D TEMP_PATH_TX = new Affine2D();

    private Affine2D getInverseTransform() {
        if (this.inversedirty) {
            this.inverseTransform.setTransform(this.transform);
            try {
                this.inverseTransform.invert();
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                this.inverseTransform.setToScale(0.0, 0.0);
            }
            this.inversedirty = false;
        }
        return this.inverseTransform;
    }

    @Override
    protected boolean hasOverlappingContents() {
        return true;
    }

    @Override
    protected void renderContent(Graphics graphics) {
        this.initCanvas(graphics);
        if (this.cv.tex != null) {
            if (this.thebuf != null) {
                this.thebuf.switchToRead();
                this.renderStream(this.thebuf);
                this.thebuf.resetForWrite();
                this.thebuf = null;
            }
            graphics.drawTexture(this.cv.tex, 0.0f, 0.0f, this.tw, this.th);
            this.cv.save(graphics, this.tw, this.th);
        }
        this.cv.g = null;
        this.clip.g = null;
        this.temp.g = null;
    }

    private void initCanvas(Graphics graphics) {
        if (this.tw <= 0 || this.th <= 0) {
            this.cv.dispose();
            return;
        }
        this.cv.validate(graphics, this.tw, this.th);
    }

    private void initClip() {
        if (this.clip.validate(this.cv.g, this.tw, this.th)) {
            for (Path2D path2D : this.clipStack) {
                this.renderClip(path2D);
            }
        }
    }

    private void renderClip(Path2D path2D) {
        this.temp.validate(this.cv.g, this.tw, this.th);
        this.temp.g.setPaint(Color.WHITE);
        this.temp.g.setTransform(BaseTransform.IDENTITY_TRANSFORM);
        this.temp.g.fill(path2D);
        this.blendAthruBintoC(this.temp, Blend.Mode.SRC_IN, this.clip, null, CompositeMode.SRC, this.clip);
    }

    private void applyEffectOnAintoC(Effect effect, Effect effect2, BaseTransform baseTransform, Rectangle rectangle, CompositeMode compositeMode, RenderBuf renderBuf) {
        PrFilterContext prFilterContext = PrFilterContext.getInstance(renderBuf.tex.getAssociatedScreen());
        ImageData imageData = effect2.filter(prFilterContext, baseTransform, rectangle, null, effect);
        Rectangle rectangle2 = imageData.getUntransformedBounds();
        Filterable filterable = imageData.getUntransformedImage();
        Texture texture = ((PrTexture)((Object)filterable)).getTextureObject();
        renderBuf.g.setTransform(imageData.getTransform());
        renderBuf.g.setCompositeMode(compositeMode);
        renderBuf.g.drawTexture(texture, rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
        renderBuf.g.setTransform(BaseTransform.IDENTITY_TRANSFORM);
        renderBuf.g.setCompositeMode(CompositeMode.SRC_OVER);
        imageData.unref();
    }

    private void blendAthruBintoC(RenderBuf renderBuf, Blend.Mode mode, RenderBuf renderBuf2, RectBounds rectBounds, CompositeMode compositeMode, RenderBuf renderBuf3) {
        Rectangle rectangle;
        this.blender.setTopInput(renderBuf.input);
        this.blender.setBottomInput(renderBuf2.input);
        this.blender.setMode(mode);
        if (rectBounds != null) {
            BaseBounds baseBounds = this.transform.transform(rectBounds, TEMP_BOUNDS);
            rectangle = new Rectangle(baseBounds);
        } else {
            rectangle = null;
        }
        this.applyEffectOnAintoC(null, this.blender, BaseTransform.IDENTITY_TRANSFORM, rectangle, compositeMode, renderBuf3);
    }

    private void setupFill(Graphics graphics) {
        graphics.setPaint(this.fillPaint);
    }

    private BasicStroke getStroke() {
        if (this.stroke == null) {
            this.stroke = new BasicStroke(this.linewidth, this.linecap, this.linejoin, this.miterlimit);
        }
        return this.stroke;
    }

    private void setupStroke(Graphics graphics) {
        graphics.setStroke(this.getStroke());
        graphics.setPaint(this.strokePaint);
    }

    private void renderStream(GrowableDataBuffer growableDataBuffer) {
        block35: while (!growableDataBuffer.isEmpty()) {
            byte by = growableDataBuffer.getByte();
            switch (by) {
                case 40: {
                    this.path.reset();
                    continue block35;
                }
                case 41: {
                    this.path.moveTo(growableDataBuffer.getFloat(), growableDataBuffer.getFloat());
                    continue block35;
                }
                case 42: {
                    this.path.lineTo(growableDataBuffer.getFloat(), growableDataBuffer.getFloat());
                    continue block35;
                }
                case 43: {
                    this.path.quadTo(growableDataBuffer.getFloat(), growableDataBuffer.getFloat(), growableDataBuffer.getFloat(), growableDataBuffer.getFloat());
                    continue block35;
                }
                case 44: {
                    this.path.curveTo(growableDataBuffer.getFloat(), growableDataBuffer.getFloat(), growableDataBuffer.getFloat(), growableDataBuffer.getFloat(), growableDataBuffer.getFloat(), growableDataBuffer.getFloat());
                    continue block35;
                }
                case 45: {
                    this.path.closePath();
                    continue block35;
                }
                case 46: {
                    continue block35;
                }
                case 13: {
                    Path2D path2D = (Path2D)growableDataBuffer.getObject();
                    this.initClip();
                    this.renderClip(path2D);
                    this.clipStack.addLast(path2D);
                    continue block35;
                }
                case 14: {
                    this.clip.dispose();
                    this.clipStack.removeLast();
                    continue block35;
                }
                case 15: {
                    byte by2 = growableDataBuffer.getByte();
                    switch (by2) {
                        case 0: {
                            this.arctype = 0;
                            break;
                        }
                        case 1: {
                            this.arctype = 1;
                            break;
                        }
                        case 2: {
                            this.arctype = 2;
                        }
                    }
                    continue block35;
                }
                case 52: {
                    int n = growableDataBuffer.getInt();
                    int n2 = growableDataBuffer.getInt();
                    int n3 = growableDataBuffer.getInt();
                    this.tmpImage.setArgb(0, 0, n3);
                    Graphics graphics = this.cv.g;
                    graphics.setExtraAlpha(1.0f);
                    graphics.setCompositeMode(CompositeMode.SRC);
                    graphics.setTransform(BaseTransform.IDENTITY_TRANSFORM);
                    ResourceFactory resourceFactory = graphics.getResourceFactory();
                    Object object = resourceFactory.getCachedTexture(this.tmpImage, false);
                    graphics.drawTexture((Texture)object, n, n2, 1.0f, 1.0f);
                    continue block35;
                }
                case 53: {
                    int n = growableDataBuffer.getInt();
                    int n4 = growableDataBuffer.getInt();
                    int n5 = growableDataBuffer.getInt();
                    int n6 = growableDataBuffer.getInt();
                    byte[] byArray = (byte[])growableDataBuffer.getObject();
                    Object object = Image.fromByteBgraPreData(byArray, n5, n6);
                    Graphics graphics = this.cv.g;
                    ResourceFactory resourceFactory = graphics.getResourceFactory();
                    Texture texture = resourceFactory.getCachedTexture((Image)object, false);
                    graphics.setTransform(BaseTransform.IDENTITY_TRANSFORM);
                    graphics.setCompositeMode(CompositeMode.SRC);
                    graphics.drawTexture(texture, n, n4, n5, n6);
                    graphics.setCompositeMode(CompositeMode.SRC_OVER);
                    continue block35;
                }
                case 11: {
                    double d = growableDataBuffer.getDouble();
                    double d2 = growableDataBuffer.getDouble();
                    double d3 = growableDataBuffer.getDouble();
                    double d4 = growableDataBuffer.getDouble();
                    double d5 = growableDataBuffer.getDouble();
                    double d6 = growableDataBuffer.getDouble();
                    this.transform.setTransform(d, d4, d2, d5, d3, d6);
                    this.inversedirty = true;
                    continue block35;
                }
                case 0: {
                    this.globalAlpha = growableDataBuffer.getFloat();
                    continue block35;
                }
                case 16: {
                    this.fillRule = growableDataBuffer.getByte();
                    if (this.fillRule == 0) {
                        this.path.setWindingRule(1);
                        continue block35;
                    }
                    this.path.setWindingRule(0);
                    continue block35;
                }
                case 1: {
                    this.blendmode = (Blend.Mode)((Object)growableDataBuffer.getObject());
                    continue block35;
                }
                case 2: {
                    this.fillPaint = (Paint)growableDataBuffer.getObject();
                    continue block35;
                }
                case 3: {
                    this.strokePaint = (Paint)growableDataBuffer.getObject();
                    continue block35;
                }
                case 4: {
                    this.linewidth = growableDataBuffer.getFloat();
                    this.stroke = null;
                    continue block35;
                }
                case 5: {
                    this.linecap = prcaps[growableDataBuffer.getUByte()];
                    this.stroke = null;
                    continue block35;
                }
                case 6: {
                    this.linejoin = prjoins[growableDataBuffer.getUByte()];
                    this.stroke = null;
                    continue block35;
                }
                case 7: {
                    this.miterlimit = growableDataBuffer.getFloat();
                    this.stroke = null;
                    continue block35;
                }
                case 8: {
                    this.pgfont = (PGFont)growableDataBuffer.getObject();
                    continue block35;
                }
                case 9: {
                    this.align = growableDataBuffer.getUByte();
                    continue block35;
                }
                case 10: {
                    this.baseline = prbases[growableDataBuffer.getUByte()];
                    continue block35;
                }
                case 60: {
                    Effect effect = (Effect)growableDataBuffer.getObject();
                    RenderBuf renderBuf = this.clipStack.isEmpty() ? this.cv : this.temp;
                    this.applyEffectOnAintoC(this.cv.input, effect, BaseTransform.IDENTITY_TRANSFORM, null, CompositeMode.SRC, renderBuf);
                    if (renderBuf == this.cv) continue block35;
                    this.blendAthruBintoC(renderBuf, Blend.Mode.SRC_IN, this.clip, null, CompositeMode.SRC, this.cv);
                    continue block35;
                }
                case 12: {
                    this.effect = (Effect)growableDataBuffer.getObject();
                    continue block35;
                }
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 47: 
                case 48: 
                case 50: 
                case 51: {
                    Object object;
                    if (this.effect != null) {
                        growableDataBuffer.save();
                        this.handleRenderOp(by, growableDataBuffer, null, TEMP_RECTBOUNDS);
                        RenderInput renderInput = new RenderInput(by, growableDataBuffer, TEMP_RECTBOUNDS);
                        object = this.clipStack.isEmpty() && this.blendmode == Blend.Mode.SRC_OVER ? this.cv : this.temp;
                        this.applyEffectOnAintoC(renderInput, this.effect, this.transform, null, CompositeMode.SRC, (RenderBuf)object);
                    } else {
                        boolean bl = false;
                        if (!this.clipStack.isEmpty()) {
                            this.initClip();
                            bl = true;
                        }
                        if (this.blendmode != Blend.Mode.SRC_OVER) {
                            bl = true;
                        }
                        if (bl) {
                            this.temp.validate(this.cv.g, this.tw, this.th);
                            object = this.temp.g;
                        } else {
                            object = this.cv.g;
                        }
                        object.setExtraAlpha(this.globalAlpha);
                        object.setTransform(this.transform);
                        this.handleRenderOp(by, growableDataBuffer, (Graphics)object, bl ? TEMP_RECTBOUNDS : null);
                    }
                    if (this.blendmode != Blend.Mode.SRC_OVER) {
                        RenderBuf renderBuf = this.clipStack.isEmpty() ? this.cv : this.temp;
                        this.blendAthruBintoC(this.temp, this.blendmode, this.cv, TEMP_RECTBOUNDS, CompositeMode.SRC_OVER, renderBuf);
                    }
                    if (this.clipStack.isEmpty()) continue block35;
                    this.blendAthruBintoC(this.temp, Blend.Mode.SRC_IN, this.clip, TEMP_RECTBOUNDS, CompositeMode.SRC_OVER, this.cv);
                    continue block35;
                }
            }
            throw new InternalError("Unrecognized PGCanvas token: " + by);
        }
    }

    public void handleRenderOp(int n, GrowableDataBuffer growableDataBuffer, Graphics graphics, RectBounds rectBounds) {
        BasicStroke basicStroke;
        float f;
        boolean bl = false;
        switch (n) {
            case 47: {
                if (rectBounds != null) {
                    Shape.accumulate(TEMP_COORDS, this.untransformedPath, this.transform);
                    rectBounds.setBounds(TEMP_COORDS[0], TEMP_COORDS[1], TEMP_COORDS[2], TEMP_COORDS[3]);
                }
                if (graphics == null) break;
                this.setupFill(graphics);
                graphics.fill(this.untransformedPath);
                break;
            }
            case 48: {
                if (rectBounds != null) {
                    this.getStroke().accumulateShapeBounds(TEMP_COORDS, this.untransformedPath, this.transform);
                    rectBounds.setBounds(TEMP_COORDS[0], TEMP_COORDS[1], TEMP_COORDS[2], TEMP_COORDS[3]);
                }
                if (graphics == null) break;
                this.setupStroke(graphics);
                graphics.draw(this.untransformedPath);
                break;
            }
            case 23: {
                float f2 = growableDataBuffer.getFloat();
                f = growableDataBuffer.getFloat();
                float f3 = growableDataBuffer.getFloat();
                float f4 = growableDataBuffer.getFloat();
                if (rectBounds != null) {
                    rectBounds.setBoundsAndSort(f2, f, f3, f4);
                    bl = true;
                }
                if (graphics == null) break;
                this.setupStroke(graphics);
                graphics.drawLine(f2, f, f3, f4);
                break;
            }
            case 21: 
            case 25: {
                bl = true;
            }
            case 20: 
            case 22: 
            case 24: {
                float f2 = growableDataBuffer.getFloat();
                f = growableDataBuffer.getFloat();
                float f5 = growableDataBuffer.getFloat();
                float f6 = growableDataBuffer.getFloat();
                if (rectBounds != null) {
                    rectBounds.setBounds(f2, f, f2 + f5, f + f6);
                }
                if (graphics == null) break;
                switch (n) {
                    case 20: {
                        this.setupFill(graphics);
                        graphics.fillRect(f2, f, f5, f6);
                        break;
                    }
                    case 24: {
                        this.setupFill(graphics);
                        graphics.fillEllipse(f2, f, f5, f6);
                        break;
                    }
                    case 21: {
                        this.setupStroke(graphics);
                        graphics.drawRect(f2, f, f5, f6);
                        break;
                    }
                    case 25: {
                        this.setupStroke(graphics);
                        graphics.drawEllipse(f2, f, f5, f6);
                        break;
                    }
                    case 22: {
                        graphics.setPaint(Color.TRANSPARENT);
                        graphics.setCompositeMode(CompositeMode.SRC);
                        graphics.fillRect(f2, f, f5, f6);
                        graphics.setCompositeMode(CompositeMode.SRC_OVER);
                    }
                }
                break;
            }
            case 27: {
                bl = true;
            }
            case 26: {
                float f2 = growableDataBuffer.getFloat();
                f = growableDataBuffer.getFloat();
                float f7 = growableDataBuffer.getFloat();
                float f8 = growableDataBuffer.getFloat();
                float f9 = growableDataBuffer.getFloat();
                float f10 = growableDataBuffer.getFloat();
                if (rectBounds != null) {
                    rectBounds.setBounds(f2, f, f2 + f7, f + f8);
                }
                if (graphics == null) break;
                if (n == 26) {
                    this.setupFill(graphics);
                    graphics.fillRoundRect(f2, f, f7, f8, f9, f10);
                    break;
                }
                this.setupStroke(graphics);
                graphics.drawRoundRect(f2, f, f7, f8, f9, f10);
                break;
            }
            case 28: 
            case 29: {
                float f2 = growableDataBuffer.getFloat();
                f = growableDataBuffer.getFloat();
                float f11 = growableDataBuffer.getFloat();
                float f12 = growableDataBuffer.getFloat();
                float f13 = growableDataBuffer.getFloat();
                float f14 = growableDataBuffer.getFloat();
                TEMP_ARC.setArc(f2, f, f11, f12, f13, f14, this.arctype);
                if (n == 28) {
                    if (rectBounds != null) {
                        Shape.accumulate(TEMP_COORDS, TEMP_ARC, this.transform);
                    }
                    if (graphics == null) break;
                    this.setupFill(graphics);
                    graphics.fill(TEMP_ARC);
                    break;
                }
                if (rectBounds != null) {
                    this.getStroke().accumulateShapeBounds(TEMP_COORDS, TEMP_ARC, this.transform);
                }
                if (graphics == null) break;
                this.setupStroke(graphics);
                graphics.draw(TEMP_ARC);
                break;
            }
            case 50: 
            case 51: {
                float f15;
                float f16;
                float f17;
                float f18;
                float f2 = growableDataBuffer.getFloat();
                f = growableDataBuffer.getFloat();
                float f19 = growableDataBuffer.getFloat();
                float f20 = growableDataBuffer.getFloat();
                Image image = (Image)growableDataBuffer.getObject();
                if (n == 50) {
                    f18 = 0.0f;
                    f17 = 0.0f;
                    f16 = image.getWidth();
                    f15 = image.getHeight();
                } else {
                    f17 = growableDataBuffer.getFloat();
                    f18 = growableDataBuffer.getFloat();
                    f16 = growableDataBuffer.getFloat();
                    f15 = growableDataBuffer.getFloat();
                }
                if (rectBounds != null) {
                    rectBounds.setBounds(f2, f, f2 + f19, f + f20);
                }
                if (graphics == null) break;
                ResourceFactory resourceFactory = graphics.getResourceFactory();
                Texture texture = resourceFactory.getCachedTexture(image, false);
                graphics.drawTexture(texture, f2, f, f2 + f19, f + f20, f17, f18, f17 + f16, f18 + f15, 0);
                break;
            }
            case 30: 
            case 31: {
                float f2 = growableDataBuffer.getFloat();
                f = growableDataBuffer.getFloat();
                float f21 = growableDataBuffer.getFloat();
                String string = (String)growableDataBuffer.getObject();
                this.ngtext.setFont(this.pgfont);
                this.ngtext.helper.setTextOrigin(this.baseline);
                this.ngtext.setText(string);
                float f22 = this.ngtext.helper.getLogicalWidth();
                float f23 = 0.0f;
                this.ngtext.helper.setTextAlignment(this.align);
                if (this.align != 0) {
                    if (this.align == 2) {
                        f23 = -f22;
                    } else if (this.align == 1) {
                        f23 = -f22 * 0.5f;
                    }
                }
                if ((double)f21 > 0.0 && f22 > f21) {
                    float f24 = f21 / f22;
                    TEMP_TX.setTransform(this.transform);
                    TEMP_TX.translate(f2 += f23 * f24, f);
                    TEMP_TX.scale(f24, 1.0);
                    f2 = 0.0f;
                    f = 0.0f;
                    graphics.setTransform(TEMP_TX);
                } else {
                    f2 += f23;
                }
                if (n == 30) {
                    this.ngtext.setMode(PGShape.Mode.FILL);
                    this.ngtext.setFillPaint(this.fillPaint);
                    this.ngtext.setDrawPaint(null);
                } else {
                    this.ngtext.setMode(PGShape.Mode.STROKE);
                    BasicStroke basicStroke2 = this.getStroke();
                    if (graphics != null) {
                        graphics.setStroke(basicStroke2);
                    }
                    this.ngtext.setDrawStroke(basicStroke2);
                    this.ngtext.setFillPaint(null);
                    this.ngtext.setDrawPaint(this.strokePaint);
                }
                this.ngtext.setLocation(f2, f);
                if (rectBounds != null) {
                    this.ngtext.helper.computeContentBounds(rectBounds, this.transform);
                }
                if (graphics == null) break;
                this.ngtext.renderContent(graphics);
                break;
            }
            default: {
                throw new InternalError("Unrecognized PGCanvas rendering token: " + n);
            }
        }
        if (bl && rectBounds != null && (basicStroke = this.getStroke()).getType() != 1) {
            f = basicStroke.getLineWidth();
            if (basicStroke.getType() == 0) {
                f /= 2.0f;
            }
            rectBounds.grow(f, f);
        }
    }

    @Override
    public void updateBounds(float f, float f2) {
        this.tw = (int)Math.ceil(f);
        this.th = (int)Math.ceil(f2);
        this.geometryChanged();
    }

    @Override
    public void updateRendering(GrowableDataBuffer growableDataBuffer) {
        this.thebuf = growableDataBuffer;
        this.geometryChanged();
    }

    static class EffectInput
    extends Effect {
        RTTexture tex;

        EffectInput(RTTexture rTTexture) {
            this.tex = rTTexture;
        }

        @Override
        public ImageData filter(FilterContext filterContext, BaseTransform baseTransform, Rectangle rectangle, Object object, Effect effect) {
            PrDrawable prDrawable = PrDrawable.create(filterContext, this.tex);
            Rectangle rectangle2 = new Rectangle(this.tex.getContentWidth(), this.tex.getContentHeight());
            return new ImageData(filterContext, prDrawable, rectangle2);
        }

        @Override
        public Effect.AccelType getAccelType(FilterContext filterContext) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public BaseBounds getBounds(BaseTransform baseTransform, Effect effect) {
            Rectangle rectangle = new Rectangle(this.tex.getContentWidth(), this.tex.getContentHeight());
            return EffectInput.transformBounds(baseTransform, new RectBounds(rectangle));
        }
    }

    static class MyBlend
    extends Blend {
        public MyBlend(Blend.Mode mode, Effect effect, Effect effect2) {
            super(mode, effect, effect2);
        }

        @Override
        public Rectangle getResultBounds(BaseTransform baseTransform, Rectangle rectangle, ImageData ... imageDataArray) {
            Rectangle rectangle2 = super.getResultBounds(baseTransform, rectangle, imageDataArray);
            rectangle2.intersectWith(rectangle);
            return rectangle2;
        }
    }

    class RenderInput
    extends Effect {
        float x;
        float y;
        float w;
        float h;
        int token;
        GrowableDataBuffer<Object> buf;

        public RenderInput(int n, GrowableDataBuffer<Object> growableDataBuffer, RectBounds rectBounds) {
            this.token = n;
            this.buf = growableDataBuffer;
            this.x = rectBounds.getMinX();
            this.y = rectBounds.getMinY();
            this.w = rectBounds.getWidth();
            this.h = rectBounds.getHeight();
        }

        @Override
        public ImageData filter(FilterContext filterContext, BaseTransform baseTransform, Rectangle rectangle, Object object, Effect effect) {
            PrDrawable prDrawable;
            BaseBounds baseBounds = this.getBounds(baseTransform, effect);
            if (rectangle != null) {
                baseBounds.intersectWith(rectangle);
            }
            Rectangle rectangle2 = new Rectangle(baseBounds);
            if (rectangle2.width < 1) {
                rectangle2.width = 1;
            }
            if (rectangle2.height < 1) {
                rectangle2.height = 1;
            }
            if ((prDrawable = (PrDrawable)Effect.getCompatibleImage(filterContext, rectangle2.width, rectangle2.height)) != null) {
                Graphics graphics = prDrawable.createGraphics();
                graphics.setExtraAlpha(NGCanvas.this.globalAlpha);
                graphics.translate(-rectangle2.x, -rectangle2.y);
                if (baseTransform != null) {
                    graphics.transform(baseTransform);
                }
                this.buf.restore();
                NGCanvas.this.handleRenderOp(this.token, this.buf, graphics, null);
            }
            return new ImageData(filterContext, prDrawable, rectangle2);
        }

        @Override
        public Effect.AccelType getAccelType(FilterContext filterContext) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public BaseBounds getBounds(BaseTransform baseTransform, Effect effect) {
            RectBounds rectBounds = new RectBounds(this.x, this.y, this.x + this.w, this.y + this.h);
            return baseTransform.transform(rectBounds, rectBounds);
        }
    }

    private static class PixelData {
        private IntBuffer pixels = null;
        private boolean validPixels = false;
        private int cw;
        private int ch;

        private PixelData(Graphics graphics, int n, int n2) {
            this.cw = n;
            this.ch = n2;
            this.pixels = IntBuffer.allocate(n * n2);
        }

        private void save(Graphics graphics, RTTexture rTTexture) {
            int n = rTTexture.getContentWidth();
            int n2 = rTTexture.getContentHeight();
            if (this.cw < n || this.ch < n2) {
                this.cw = n;
                this.ch = n2;
                this.pixels = IntBuffer.allocate(this.cw * this.ch);
            }
            this.pixels.rewind();
            rTTexture.readPixels(this.pixels);
            this.validPixels = true;
        }

        private void restore(Graphics graphics, int n, int n2) {
            if (this.validPixels) {
                Image image = Image.fromIntArgbPreData(this.pixels, n, n2);
                Texture texture = graphics.getResourceFactory().createTexture(image);
                graphics.drawTexture(texture, 0.0f, 0.0f, n, n2);
                texture.dispose();
                this.validPixels = false;
            }
        }
    }

    static class RenderBuf {
        final InitType init_type;
        RTTexture tex;
        Graphics g;
        EffectInput input;
        private PixelData savedPixelData = null;

        public RenderBuf(InitType initType) {
            this.init_type = initType;
        }

        public void dispose() {
            if (this.tex != null) {
                this.tex.dispose();
            }
            this.tex = null;
            this.g = null;
            this.input = null;
        }

        public boolean validate(Graphics graphics, int n, int n2) {
            int n3;
            int n4 = this.tex == null ? 0 : this.tex.getContentWidth();
            int n5 = n3 = this.tex == null ? 0 : this.tex.getContentHeight();
            if (this.tex == null || n4 < n || n3 < n2) {
                RTTexture rTTexture;
                RTTexture rTTexture2 = this.tex;
                this.tex = rTTexture = graphics.getResourceFactory().createRTTexture(n, n2);
                this.g = rTTexture.createGraphics();
                this.input = new EffectInput(rTTexture);
                if (rTTexture2 != null) {
                    if (this.init_type == InitType.PRESERVE_UPPER_LEFT) {
                        this.g.setCompositeMode(CompositeMode.SRC);
                        if (rTTexture2.createGraphics() == null) {
                            if (this.savedPixelData != null) {
                                this.savedPixelData.restore(this.g, n4, n3);
                            }
                        } else {
                            this.g.drawTexture(rTTexture2, 0.0f, 0.0f, n4, n3);
                        }
                        this.g.setCompositeMode(CompositeMode.SRC_OVER);
                    }
                    rTTexture2.dispose();
                }
                if (this.init_type == InitType.FILL_WHITE) {
                    this.g.setPaint(Color.WHITE);
                    this.g.fillRect(0.0f, 0.0f, n, n2);
                }
                return true;
            }
            if (this.g == null) {
                this.g = this.tex.createGraphics();
                if (this.g == null) {
                    this.tex.dispose();
                    this.tex = graphics.getResourceFactory().createRTTexture(n, n2);
                    this.g = this.tex.createGraphics();
                    this.input = new EffectInput(this.tex);
                    if (this.savedPixelData != null) {
                        this.g.setCompositeMode(CompositeMode.SRC);
                        this.savedPixelData.restore(this.g, n, n2);
                        this.g.setCompositeMode(CompositeMode.SRC_OVER);
                    } else if (this.init_type == InitType.FILL_WHITE) {
                        this.g.setPaint(Color.WHITE);
                        this.g.fillRect(0.0f, 0.0f, n, n2);
                    }
                    return true;
                }
            }
            if (this.init_type == InitType.CLEAR) {
                this.g.setCompositeMode(CompositeMode.CLEAR);
                this.g.fillRect(0.0f, 0.0f, n, n2);
                this.g.setCompositeMode(CompositeMode.SRC_OVER);
            }
            return false;
        }

        private void save(Graphics graphics, int n, int n2) {
            if (this.tex.isVolatile()) {
                if (this.savedPixelData == null) {
                    this.savedPixelData = new PixelData(graphics, n, n2);
                }
                this.savedPixelData.save(graphics, this.tex);
            }
        }
    }

    static enum InitType {
        CLEAR,
        FILL_WHITE,
        PRESERVE_UPPER_LEFT;

    }
}

