/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.css.converters;

import com.sun.javafx.Utils;
import com.sun.javafx.css.FontUnits;
import com.sun.javafx.css.ParsedValue;
import com.sun.javafx.css.Size;
import com.sun.javafx.css.StyleableProperty;
import java.util.Map;
import javafx.scene.text.Font;
import javafx.scene.text.FontPosture;
import javafx.scene.text.FontWeight;

public final class FontConverter
extends com.sun.javafx.css.StyleConverter<ParsedValue[], Font> {
    public static FontConverter getInstance() {
        return Holder.INSTANCE;
    }

    private FontConverter() {
    }

    @Override
    public Font convert(ParsedValue<ParsedValue[], Font> parsedValue, Font font) {
        Object object;
        Object object2;
        ParsedValue[] parsedValueArray = parsedValue.getValue();
        Font font2 = font != null ? font : Font.getDefault();
        String string = parsedValueArray[0] != null ? Utils.stripQuotes((String)parsedValueArray[0].convert(font2)) : font2.getFamily();
        double d = font2.getSize();
        if (parsedValueArray[1] != null) {
            object2 = (ParsedValue)parsedValueArray[1].getValue();
            object = (Size)((ParsedValue)object2).convert(font2);
            d = object.pixels(font2.getSize(), font2);
        }
        object2 = parsedValueArray[2] != null ? (FontWeight)((Object)parsedValueArray[2].convert(font2)) : FontWeight.NORMAL;
        object = parsedValueArray[3] != null ? (FontPosture)((Object)parsedValueArray[3].convert(font2)) : FontPosture.REGULAR;
        Font font3 = Font.font(string, (FontWeight)((Object)object2), (FontPosture)((Object)object), d);
        return font3;
    }

    @Override
    public Font convert(Map<StyleableProperty, Object> map) {
        Font font = Font.getDefault();
        double d = font.getSize();
        String string = font.getFamily();
        FontWeight fontWeight = FontWeight.NORMAL;
        FontPosture fontPosture = FontPosture.REGULAR;
        for (Map.Entry<StyleableProperty, Object> entry : map.entrySet()) {
            Object object = entry.getValue();
            if (object == null) continue;
            String string2 = entry.getKey().getProperty();
            if (string2.endsWith("font-size")) {
                d = ((Number)object).doubleValue();
                continue;
            }
            if (string2.endsWith("font-family")) {
                string = Utils.stripQuotes((String)object);
                continue;
            }
            if (string2.endsWith("font-weight")) {
                fontWeight = (FontWeight)((Object)object);
                continue;
            }
            if (!string2.endsWith("font-style")) continue;
            fontPosture = (FontPosture)((Object)object);
        }
        Font font2 = Font.font(string, fontWeight, fontPosture, d);
        return font2;
    }

    public String toString() {
        return "FontConverter";
    }

    public static final class SizeConverter
    extends com.sun.javafx.css.StyleConverter<ParsedValue<?, Size>, Double> {
        public static SizeConverter getInstance() {
            return Holder.INSTANCE;
        }

        private SizeConverter() {
        }

        @Override
        public Double convert(ParsedValue<ParsedValue<?, Size>, Double> parsedValue, Font font) {
            ParsedValue<?, Size> parsedValue2 = parsedValue.getValue();
            return parsedValue2.convert(font).pixels(font.getSize(), font);
        }

        public String toString() {
            return "Font.SizeConverter";
        }

        private static class Holder {
            static SizeConverter INSTANCE = new SizeConverter();

            private Holder() {
            }
        }
    }

    public static final class WeightConverter
    extends com.sun.javafx.css.StyleConverter<FontUnits.Weight, FontWeight> {
        public static WeightConverter getInstance() {
            return Holder.INSTANCE;
        }

        private WeightConverter() {
        }

        @Override
        public FontWeight convert(ParsedValue<FontUnits.Weight, FontWeight> parsedValue, Font font) {
            FontUnits.Weight weight = parsedValue.getValue();
            if (FontUnits.Weight.INHERIT != weight && FontUnits.Weight.BOLDER != weight && FontUnits.Weight.LIGHTER != weight) {
                return weight.toFontWeight();
            }
            if (font != null) {
                FontWeight fontWeight = FontWeight.NORMAL;
                if (FontUnits.Weight.INHERIT == weight) {
                    return fontWeight;
                }
                if (FontUnits.Weight.BOLDER == weight) {
                    return FontUnits.Weight.toWeight(fontWeight).bolder().toFontWeight();
                }
                if (FontUnits.Weight.LIGHTER == weight) {
                    return FontUnits.Weight.toWeight(fontWeight).lighter().toFontWeight();
                }
                return weight.toFontWeight();
            }
            return weight.toFontWeight();
        }

        public String toString() {
            return "Font.WeightConverter";
        }

        private static class Holder {
            static WeightConverter INSTANCE = new WeightConverter();

            private Holder() {
            }
        }
    }

    public static final class StyleConverter
    extends com.sun.javafx.css.StyleConverter<FontUnits.Style, FontPosture> {
        public static StyleConverter getInstance() {
            return Holder.INSTANCE;
        }

        private StyleConverter() {
        }

        @Override
        public FontPosture convert(ParsedValue<FontUnits.Style, FontPosture> parsedValue, Font font) {
            FontUnits.Style style = parsedValue.getValue();
            if (FontUnits.Style.INHERIT != style) {
                return style.toFontPosture();
            }
            if (font != null) {
                return FontPosture.REGULAR;
            }
            return FontPosture.REGULAR;
        }

        public String toString() {
            return "Font.StyleConverter";
        }

        private static class Holder {
            static StyleConverter INSTANCE = new StyleConverter();

            private Holder() {
            }
        }
    }

    private static class Holder {
        static FontConverter INSTANCE = new FontConverter();

        private Holder() {
        }
    }
}

