/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.uitoolkit.impl.fx.ui;

import com.sun.deploy.trace.Trace;
import com.sun.deploy.ui.AppInfo;
import com.sun.deploy.uitoolkit.impl.fx.ui.FXDialog;
import com.sun.deploy.uitoolkit.impl.fx.ui.UITextArea;
import com.sun.deploy.uitoolkit.impl.fx.ui.resources.ResourceManager;
import java.lang.reflect.Method;
import java.net.URL;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javafx.stage.Stage;

public class FXSSV3Dialog {
    private static int MAIN_TEXT_WIDTH = 380;
    private AppInfo ainfo;
    private String masthead;
    private String mainText;
    private String location;
    private String prompt;
    private String multiPrompt;
    private String multiText;
    private String runText;
    private String updateText;
    private String cancelText;
    private String alwaysText;
    private URL updateURL;
    private String locationURL = "";
    private int userAnswer;
    private FXDialog dialog;
    private Button runButton;
    private Button updateButton;
    private Button cancelButton;
    private CheckBox alwaysCheckbox;
    private CheckBox multiClickCheckBox;
    private static final int MAX_URL_WIDTH = 280;

    public static int showSSV3Dialog(Object owner, AppInfo ainfo, int messageType, String title, String masthead, String mainText, String location, String prompt, String multiPrompt, String multiText, String run, String update, String cancel, String alwaysText, URL updateURL) {
        FXSSV3Dialog dialog = new FXSSV3Dialog(owner, title);
        dialog.ainfo = ainfo;
        dialog.masthead = masthead;
        dialog.mainText = mainText;
        dialog.location = location;
        dialog.prompt = prompt;
        dialog.multiPrompt = multiPrompt;
        dialog.multiText = multiText;
        dialog.runText = run;
        dialog.updateText = update;
        dialog.cancelText = cancel;
        dialog.alwaysText = alwaysText;
        dialog.updateURL = updateURL;
        dialog.initComponents();
        dialog.setVisible(true);
        return dialog.getAnswer();
    }

    private FXSSV3Dialog(Object owner, String title) {
        Stage stage = null;
        if (owner instanceof Stage) {
            stage = (Stage)owner;
        }
        this.dialog = new FXDialog(title, stage, true);
    }

    private void initComponents() {
        try {
            try {
                this.locationURL = this.ainfo.getFrom().toString();
            }
            catch (Exception e) {
                this.locationURL = "";
            }
            this.dialog.setResizable(false);
            this.dialog.setIconifiable(false);
            Pane contentPane = this.createContentPane();
            contentPane.getChildren().add(this.createMastHead());
            contentPane.getChildren().add(this.createMainContent());
            contentPane.getChildren().add(this.createOkCancelPanel());
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private Pane createContentPane() {
        VBox contentPane = new VBox(){

            protected double computePrefHeight(double width) {
                double h = super.computePrefHeight(width);
                return h;
            }
        };
        contentPane.setId("ssv3-content-panel");
        this.dialog.setContentPane(contentPane);
        return contentPane;
    }

    private Node createMastHead() {
        UITextArea text = new UITextArea(this.masthead);
        text.setId("security-masthead-label");
        return text;
    }

    private Pane createMainContent() {
        Pane warningPanel = this.createWarningPanel();
        UITextArea text = new UITextArea(436.0);
        text.setText(this.prompt);
        text.setId("ssv3-prompt");
        BorderPane box = new BorderPane();
        box.setTop(warningPanel);
        box.setBottom(text);
        return box;
    }

    private Pane createWarningPanel() {
        BorderPane border = new BorderPane();
        border.setLeft(this.createShieldIcon());
        VBox box = this.createLocationPanel();
        border.setCenter(box);
        return border;
    }

    private VBox createLocationPanel() {
        VBox box = new VBox();
        Text main = new Text(this.mainText);
        main.setId("ssv3-main-text");
        main.setWrappingWidth(MAIN_TEXT_WIDTH);
        box.getChildren().add(main);
        Label locationLabel = new Label(this.location);
        locationLabel.setText(this.location);
        locationLabel.setId("ssv3-location-label");
        Label url = new Label(this.locationURL);
        url.setTooltip(new Tooltip(this.locationURL));
        url.setMaxWidth(280.0);
        url.setId("ssv3-location-url");
        HBox hBox = new HBox();
        hBox.setId("ssv3-location-label-url");
        hBox.getChildren().add(locationLabel);
        hBox.getChildren().add(url);
        box.getChildren().add(hBox);
        return box;
    }

    private Pane createShieldIcon() {
        Label warningIcon = new Label(null, ResourceManager.getIcon("yellowShield48.image"));
        warningIcon.setId("ssv3-shield");
        VBox box = new VBox();
        box.getChildren().add(warningIcon);
        return box;
    }

    private Pane createOkCancelPanel() {
        HBox decisionPanel = new HBox();
        decisionPanel.getStyleClass().add("security-button-bar");
        this.runButton = new Button(this.runText);
        decisionPanel.getChildren().add(this.runButton);
        this.runButton.setOnAction(new EventHandler<ActionEvent>(){

            @Override
            public void handle(ActionEvent t) {
                FXSSV3Dialog.this.runAction();
            }
        });
        if (this.updateText != null) {
            this.updateButton = new Button(this.updateText);
            this.updateButton.setOnAction(new EventHandler<ActionEvent>(){

                @Override
                public void handle(ActionEvent t) {
                    FXSSV3Dialog.this.updateAction();
                }
            });
            decisionPanel.getChildren().add(this.updateButton);
        }
        this.cancelButton = new Button(this.cancelText);
        this.cancelButton.setOnAction(new EventHandler<ActionEvent>(){

            @Override
            public void handle(ActionEvent e) {
                FXSSV3Dialog.this.userAnswer = 1;
                FXSSV3Dialog.this.closeDialog();
            }
        });
        decisionPanel.getChildren().add(this.cancelButton);
        this.runButton.setDefaultButton(true);
        this.alwaysCheckbox = new CheckBox(this.alwaysText);
        this.alwaysCheckbox.setSelected(false);
        VBox vBox = new VBox();
        this.createMultSelectionBox(vBox);
        vBox.getChildren().add(decisionPanel);
        vBox.getChildren().add(this.alwaysCheckbox);
        return vBox;
    }

    private void createMultSelectionBox(VBox box) {
        if (this.multiPrompt != null && this.multiText != null) {
            this.runButton.setDisable(true);
            Label multiMessage = new Label(this.multiPrompt);
            multiMessage.setId("ssv3-multi-click");
            HBox mb = new HBox();
            mb.getChildren().add(multiMessage);
            box.getChildren().add(mb);
            this.multiClickCheckBox = new CheckBox(this.multiText);
            this.multiClickCheckBox.setId("ssv3-checkbox");
            box.getChildren().add(this.multiClickCheckBox);
            this.multiClickCheckBox.setOnAction(new EventHandler<ActionEvent>(){

                @Override
                public void handle(ActionEvent t) {
                    FXSSV3Dialog.this.runButton.setDisable(!FXSSV3Dialog.this.multiClickCheckBox.isSelected());
                    if (FXSSV3Dialog.this.multiClickCheckBox.isSelected()) {
                        FXSSV3Dialog.this.runButton.requestFocus();
                    } else if (FXSSV3Dialog.this.updateButton != null) {
                        FXSSV3Dialog.this.updateButton.requestFocus();
                    } else if (FXSSV3Dialog.this.cancelButton != null) {
                        FXSSV3Dialog.this.cancelButton.requestFocus();
                    }
                }
            });
        }
    }

    private void runAction() {
        this.userAnswer = this.alwaysCheckbox != null && this.alwaysCheckbox.isSelected() ? 2 : 0;
        this.closeDialog();
    }

    private void updateAction() {
        try {
            Class<?> factory = Class.forName("com.sun.deploy.config.Platform");
            Method m = factory.getMethod("get", new Class[0]);
            Object platform = m.invoke(null, new Object[0]);
            Method showDocument = platform.getClass().getMethod("showDocument", String.class);
            showDocument.invoke(platform, this.updateURL.toString());
        }
        catch (Exception e) {
            Trace.ignored((Throwable)e);
        }
    }

    private void closeDialog() {
        this.setVisible(false);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            final FXDialog dlg = this.dialog;
            this.dialog.centerOnScreen();
            Runnable runner = new Runnable(){

                public void run() {
                    dlg.showAndWait();
                }
            };
            runner.run();
        } else {
            this.dialog.hide();
        }
    }

    private int getAnswer() {
        return this.userAnswer;
    }
}

